/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.internal.BaseTemplate;
import com.github.jknack.handlebars.internal.ParamType;
import com.github.jknack.handlebars.internal.Variable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

abstract class HelperResolver
extends BaseTemplate {
    protected List<Object> params = Collections.emptyList();
    protected Map<String, Object> hash = Collections.emptyMap();
    private int paramSize = 0;
    private int hashSize;
    private static final Object[] PARAMS = new Object[0];

    public HelperResolver(Handlebars handlebars) {
        super(handlebars);
    }

    protected Map<String, Object> hash(Context context) throws IOException {
        if (this.hashSize == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.hash.entrySet()) {
            Object value = entry.getValue();
            value = ParamType.parse(context, value);
            result.put(entry.getKey(), value);
        }
        return result;
    }

    protected Object[] params(Context scope) throws IOException {
        if (this.paramSize <= 1) {
            return PARAMS;
        }
        Object[] values = new Object[this.paramSize - 1];
        for (int i = 1; i < this.paramSize; ++i) {
            Object value = this.params.get(i);
            Object resolved = ParamType.parse(scope, value);
            values[i - 1] = resolved == null && this.handlebars.stringParams() ? value : resolved;
        }
        return values;
    }

    protected Object determineContext(Context context) throws IOException {
        if (this.paramSize == 0) {
            return context.model();
        }
        Object value = this.params.get(0);
        return ParamType.parse(context, value);
    }

    protected Helper<Object> helper(String name) {
        Helper<Object> helper = this.handlebars.helper(name);
        if (helper == null && (this.params.size() > 0 || this.hash.size() > 0)) {
            Helper helperMissing = this.handlebars.helper("helperMissing");
            if (helperMissing == null) {
                throw new HandlebarsException(new IllegalArgumentException("could not find helper: '" + name + "'"));
            }
            helper = helperMissing;
        }
        return helper;
    }

    public HelperResolver hash(Map<String, Object> hash) {
        this.hash = hash == null || hash.size() == 0 ? Collections.emptyMap() : new LinkedHashMap<String, Object>(hash);
        this.hashSize = hash.size();
        return this;
    }

    public HelperResolver params(List<Object> params) {
        this.params = params == null || params.size() == 0 ? Collections.emptyList() : new ArrayList<Object>(params);
        this.paramSize = this.params.size();
        return this;
    }

    protected String paramsToString() {
        if (this.paramSize > 0) {
            StringBuilder buffer = new StringBuilder();
            String sep = " ";
            for (Object param : this.params) {
                if (param instanceof BaseTemplate) {
                    buffer.append(((BaseTemplate)param).text()).append(sep);
                    continue;
                }
                buffer.append(param).append(sep);
            }
            buffer.setLength(buffer.length() - sep.length());
            return buffer.toString();
        }
        return "";
    }

    protected String hashToString() {
        if (this.hashSize > 0) {
            StringBuilder buffer = new StringBuilder();
            String sep = " ";
            for (Map.Entry<String, Object> hash : this.hash.entrySet()) {
                Object hashValue = hash.getValue();
                String hashText = hashValue instanceof Variable ? ((Variable)hashValue).text() : hashValue.toString();
                buffer.append(hash.getKey()).append("=").append(hashText).append(sep);
            }
            buffer.setLength(buffer.length() - sep.length());
            return buffer.toString();
        }
        return "";
    }

    @Override
    protected void collect(Collection<String> result, TagType tagType) {
        for (Object param : this.params) {
            if (!(param instanceof Variable)) continue;
            ((Variable)param).collect(result, tagType);
        }
    }

    @Override
    protected void collectReferenceParameters(Collection<String> result) {
        for (Object param : this.params) {
            if (!(param instanceof Variable)) continue;
            ((Variable)param).collectReferenceParameters(result);
        }
        for (Object param : this.params) {
            if (!ParamType.REFERENCE.apply(param) || ParamType.STRING.apply(param)) continue;
            result.add((String)param);
        }
        for (Object hashValue : this.hash.values()) {
            if (!ParamType.REFERENCE.apply(hashValue) || ParamType.STRING.apply(hashValue)) continue;
            result.add((String)hashValue);
        }
    }
}

