/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class EachHelper
implements Helper<Object> {
    public static final Helper<Object> INSTANCE = new EachHelper();
    public static final String NAME = "each";

    @Override
    public CharSequence apply(Object context, Options options) throws IOException {
        if (context instanceof Iterable) {
            return this.iterableContext((Iterable)context, options);
        }
        if (context != null) {
            return this.hashContext(context, options);
        }
        return options.buffer();
    }

    private CharSequence hashContext(Object it, Options options) throws IOException {
        Iterator<Map.Entry<String, Object>> loop = options.propertySet(it).iterator();
        Context parent = options.context;
        boolean first = true;
        Options.Buffer buffer = options.buffer();
        Template fn = options.fn;
        while (loop.hasNext()) {
            Map.Entry<String, Object> entry = loop.next();
            String key = entry.getKey();
            Context itCtx = Context.newBuilder(parent, entry.getValue()).combine("@key", key).combine("@first", first ? "first" : "").combine("@last", !loop.hasNext() ? "last" : "").build();
            buffer.append(options.apply(fn, itCtx, Arrays.asList(it, key)));
            first = false;
        }
        return buffer;
    }

    private CharSequence iterableContext(Iterable<Object> context, Options options) throws IOException {
        Options.Buffer buffer = options.buffer();
        if (options.isFalsy(context)) {
            buffer.append(options.inverse());
        } else {
            int base;
            Iterator<Object> loop = context.iterator();
            int index = base = ((Integer)options.hash("base", 0)).intValue();
            Context parent = options.context;
            Template fn = options.fn;
            while (loop.hasNext()) {
                Object it = loop.next();
                boolean even = index % 2 == 0;
                Context itCtx = Context.newBuilder(parent, it).combine("@index", index).combine("@first", index == base ? "first" : "").combine("@last", !loop.hasNext() ? "last" : "").combine("@odd", even ? "" : "odd").combine("@even", even ? "even" : "").combine("@index_1", index + 1).build();
                buffer.append(options.apply(fn, itCtx, Arrays.asList(it, index)));
                itCtx.destroy();
                ++index;
            }
        }
        return buffer;
    }
}

