/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.semver;

import com.github.jknack.semver.BaseExpression;
import com.github.jknack.semver.Semver;
import org.apache.commons.lang3.Validate;

class OrExpression
extends BaseExpression {
    private Semver left;
    private Semver right;

    public OrExpression(Semver left, Semver right) {
        this.left = (Semver)Validate.notNull((Object)left, (String)"The left side expression is required.", (Object[])new Object[0]);
        this.right = (Semver)Validate.notNull((Object)right, (String)"The right side expression is required.", (Object[])new Object[0]);
    }

    @Override
    public boolean matches(Semver expr) {
        boolean left = this.left.matches(expr);
        boolean right = this.right.matches(expr);
        return left || right;
    }

    @Override
    public int compareTo(Semver expr) {
        boolean right;
        boolean left = this.left.compareTo(expr) >= 0;
        boolean bl = right = expr.compareTo(this.right) <= 0;
        return left && right ? 0 : (left ? -1 : 1);
    }

    @Override
    public String text() {
        return this.left + " || " + this.right;
    }

    @Override
    public Semver.Type type() {
        return Semver.Type.OR;
    }
}

