/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.semver;

import com.github.jknack.semver.BaseExpression;
import com.github.jknack.semver.PrefixOperator;
import com.github.jknack.semver.Semver;
import com.github.jknack.semver.Version;
import org.apache.commons.lang3.Validate;

abstract class Range
extends BaseExpression
implements PrefixOperator {
    protected Version left;
    protected Version right;

    public Range(Semver expr) {
        this.left = (Version)Validate.notNull((Object)((Version)expr), (String)"The left side expression is required.", (Object[])new Object[0]);
    }

    public Range() {
    }

    public static Range tilde() {
        return new Range(){

            @Override
            public String text() {
                return "~" + this.left;
            }

            @Override
            public Semver.Type type() {
                return Semver.Type.TILDE;
            }
        };
    }

    public static Range x(Semver expr) {
        return new Range(expr){

            @Override
            public String text() {
                return this.left.toString();
            }

            @Override
            public Semver.Type type() {
                return Semver.Type.X_RANGE;
            }
        };
    }

    public static Range range(Version left, Version right) {
        Range range = new Range(){

            @Override
            public String text() {
                return this.left + " - " + this.right;
            }

            @Override
            public Semver.Type type() {
                return Semver.Type.RANGE;
            }
        };
        range.setLeft(left);
        range.setRight(right);
        return range;
    }

    @Override
    public boolean matches(Semver expr) {
        return this.compareTo(expr) == 0;
    }

    @Override
    public int compareTo(Semver expr) {
        boolean right;
        boolean left;
        boolean bl = left = expr.compareTo(this.left) >= 0;
        boolean bl2 = this.right == null ? expr.compareTo(this.left.nextMajor()) < 0 : (right = expr.compareTo(this.right) <= 0);
        return left && right ? 0 : (left ? -1 : 1);
    }

    @Override
    public Semver setExpression(Semver expression) {
        this.setLeft((Version)expression);
        return this;
    }

    public void setLeft(Version left) {
        this.left = left;
    }

    public void setRight(Version right) {
        this.right = right;
    }
}

