/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.semver;

import com.github.jknack.semver.BaseExpression;
import com.github.jknack.semver.PrefixOperator;
import com.github.jknack.semver.Semver;

abstract class RelationalOp
extends BaseExpression
implements PrefixOperator {
    protected Semver expression;

    RelationalOp() {
    }

    @Override
    public Semver setExpression(Semver expr) {
        this.expression = expr;
        return this;
    }

    @Override
    public int compareTo(Semver expr) {
        return expr.compareTo(this.expression);
    }

    public static RelationalOp lt() {
        return new LessThan();
    }

    public static RelationalOp ltEq() {
        return new LessThanEqualsTo();
    }

    public static RelationalOp gt() {
        return new GreaterThan();
    }

    public static RelationalOp gtEq() {
        return new GreatherThanEqualsTo();
    }

    public static RelationalOp eq() {
        return new EqualsTo();
    }

    static class GreatherThanEqualsTo
    extends RelationalOp {
        GreatherThanEqualsTo() {
        }

        @Override
        public boolean matches(Semver expr) {
            return this.compareTo(expr) >= 0;
        }

        @Override
        public String text() {
            return ">=" + this.expression;
        }

        @Override
        public Semver.Type type() {
            return Semver.Type.GT_EQ;
        }
    }

    static class GreaterThan
    extends RelationalOp {
        GreaterThan() {
        }

        @Override
        public boolean matches(Semver expr) {
            return this.compareTo(expr) > 0;
        }

        @Override
        public String text() {
            return ">" + this.expression;
        }

        @Override
        public Semver.Type type() {
            return Semver.Type.GT;
        }
    }

    static class LessThanEqualsTo
    extends RelationalOp {
        LessThanEqualsTo() {
        }

        @Override
        public boolean matches(Semver expr) {
            return this.compareTo(expr) <= 0;
        }

        @Override
        public String text() {
            return "<=" + this.expression;
        }

        @Override
        public Semver.Type type() {
            return Semver.Type.LT_EQ;
        }
    }

    static class LessThan
    extends RelationalOp {
        LessThan() {
        }

        @Override
        public boolean matches(Semver expr) {
            return this.compareTo(expr) < 0;
        }

        @Override
        public String text() {
            return "<" + this.expression;
        }

        @Override
        public Semver.Type type() {
            return Semver.Type.LT;
        }
    }

    static class EqualsTo
    extends RelationalOp {
        EqualsTo() {
        }

        @Override
        public boolean matches(Semver expr) {
            return this.compareTo(expr) == 0;
        }

        @Override
        public String text() {
            return "=" + this.expression;
        }

        @Override
        public Semver.Type type() {
            return Semver.Type.EQ;
        }
    }
}

