/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.semver;

import com.github.jknack.semver.BaseExpression;
import com.github.jknack.semver.SemverParser;
import java.util.Comparator;

public abstract class Semver
implements Comparable<Semver> {
    public static final Semver LATEST = new BaseExpression(){

        @Override
        public boolean matches(Semver expr) {
            return this.text().equals(expr.text());
        }

        @Override
        public int compareTo(Semver expr) {
            return this.matches(expr) ? 0 : 1;
        }

        @Override
        public String text() {
            return "latest";
        }

        @Override
        public Type type() {
            return Type.LATEST;
        }

        @Override
        public boolean isStatic() {
            return false;
        }
    };
    public static final Comparator<String> DESC = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            Semver v1 = Semver.create(o1);
            Semver v2 = Semver.create(o2);
            if (v1 == LATEST) {
                return v2 == LATEST ? 0 : 1;
            }
            if (v2 == LATEST) {
                return -1;
            }
            return -v1.compareTo(v2);
        }
    };
    public static final Semver ANY = new BaseExpression(){

        @Override
        public boolean matches(Semver expr) {
            return true;
        }

        @Override
        public int compareTo(Semver expr) {
            return 0;
        }

        @Override
        public String text() {
            return "*";
        }

        @Override
        public Type type() {
            return Type.ANY;
        }

        @Override
        public boolean isStatic() {
            return true;
        }
    };

    public abstract boolean matches(Semver var1);

    public abstract boolean matches(String var1);

    @Override
    public abstract int compareTo(Semver var1);

    public abstract boolean isStatic();

    public abstract String text();

    public abstract Type type();

    public String toString() {
        return this.text();
    }

    public static Semver create(String version) {
        return new SemverParser(version).parse();
    }

    public static enum Type {
        ANY,
        AND,
        OR,
        RANGE,
        TILDE,
        X_RANGE,
        EQ,
        GT,
        GT_EQ,
        LT,
        LT_EQ,
        URL,
        STATIC,
        LATEST;

    }
}

