/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.semver;

import com.github.jknack.semver.AndExpression;
import com.github.jknack.semver.BaseExpression;
import com.github.jknack.semver.OrExpression;
import com.github.jknack.semver.PrefixOperator;
import com.github.jknack.semver.Range;
import com.github.jknack.semver.RelationalOp;
import com.github.jknack.semver.Semver;
import com.github.jknack.semver.UrlExpression;
import com.github.jknack.semver.Version;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

class SemverParser {
    private static final Matcher PRE_RELEASE_OR_BUILD_NUMBER = new Matcher(){

        @Override
        public boolean match(char ch) {
            return SemverParser.firstOf(new Matcher[]{SemverParser.eq('-'), SemverParser.eq('.'), SemverParser.range('0', '9'), SemverParser.range('a', 'z'), SemverParser.range('A', 'Z')}).match(ch);
        }
    };
    public static final char EOF = '\uffff';
    private String input;
    private int position;

    public SemverParser(String input) {
        this.input = ((String)Validate.notNull((Object)input, (String)"The input is required.", (Object[])new Object[0])).trim();
    }

    public Semver parse() {
        if (this.input.length() == 0) {
            return Semver.ANY;
        }
        return this.expression();
    }

    private PrefixOperator operator() {
        if (this.match('=')) {
            return RelationalOp.eq();
        }
        if (this.match("<=")) {
            return RelationalOp.ltEq();
        }
        if (this.match(">=")) {
            return RelationalOp.gtEq();
        }
        if (this.match("<")) {
            return RelationalOp.lt();
        }
        if (this.match(">")) {
            return RelationalOp.gt();
        }
        if (this.match('~')) {
            return Range.tilde();
        }
        return null;
    }

    private Semver expression() {
        String[] protocols;
        if (this.match('*')) {
            return Semver.ANY;
        }
        for (String protocol : protocols = new String[]{"https", "http", "git+shh", "git+https", "git+http", "git"}) {
            String prefix = protocol + "://";
            if (!this.match(prefix)) continue;
            return new UrlExpression(prefix + this.input.substring(this.position));
        }
        Semver result = this.rangeOrVersion();
        while (!this.eof()) {
            this.ws();
            if (!this.match("||")) continue;
            Semver right = this.rangeOrVersion();
            result = new OrExpression(result, right);
        }
        return result;
    }

    private Semver rangeOrVersion() {
        this.ws();
        Semver result = this.version();
        String ws = this.ws();
        if (!this.extract(2).equals("||") && (this.match('-') || ws.length() > 0)) {
            this.ws();
            Semver right = this.version();
            result = result instanceof Version && right instanceof Version ? Range.range((Version)result, (Version)right) : new AndExpression(result, right);
        }
        this.ws();
        return result;
    }

    private boolean eof() {
        return this.ch() == '\uffff';
    }

    private Semver version() {
        PrefixOperator operator = this.operator();
        this.ws();
        int start = this.position;
        this.match('v');
        int major = this.versionNumber("0-9+, =, <, <=, >, >= or ~", false);
        int minor = 0;
        if (this.match('.')) {
            minor = this.versionNumber("0-9+ or x", true);
        }
        int patch = 0;
        String[] prerelease = new String[]{};
        String[] buildNumber = new String[]{};
        if (this.match('.')) {
            patch = this.versionNumber("0-9+ or x", true);
            prerelease = this.preReleaseOrBuildNumber('-');
            buildNumber = this.preReleaseOrBuildNumber('+');
        }
        int end = this.position;
        String text = this.input.substring(start, end).trim();
        Version version = new Version(text, major, minor, patch);
        version.setPreRelease(prerelease);
        version.setBuildNumber(buildNumber);
        BaseExpression result = text.contains("x") ? Range.x(version) : version;
        return operator == null ? result : operator.setExpression(result);
    }

    private String[] preReleaseOrBuildNumber(char separator) {
        this.match(separator);
        String preRelease = this.match(PRE_RELEASE_OR_BUILD_NUMBER);
        return StringUtils.isEmpty((CharSequence)preRelease) ? new String[]{} : StringUtils.split((String)preRelease, (String)".");
    }

    private int versionNumber(String label, boolean allowX) {
        String digits = this.digits(label);
        if (!allowX && digits.equalsIgnoreCase("x")) {
            throw this.error(label, digits.length());
        }
        return this.toNumber(digits);
    }

    private int toNumber(String digits) {
        return digits.equalsIgnoreCase("x") ? 0 : Integer.parseInt(digits);
    }

    private RuntimeException error(String expected) {
        return this.error(expected, 0);
    }

    private RuntimeException error(String expected, int offset) {
        char ch = this.ch(this.position - offset);
        return new IllegalArgumentException("found: '" + (ch == '\uffff' ? "eof" : Character.valueOf(ch)) + "', expected: '" + expected + "'");
    }

    private String digits(String expected) {
        String match = this.match(new Matcher(){

            @Override
            public boolean match(char ch) {
                return Character.isDigit(ch) || ch == 'x' || ch == 'X';
            }
        });
        if (StringUtils.isEmpty((CharSequence)match)) {
            throw this.error(expected);
        }
        return match;
    }

    private String match(Matcher matcher) {
        char ch = this.ch();
        int start = this.position;
        while (ch != '\uffff' && matcher.match(ch)) {
            this.consume();
            ch = this.ch();
        }
        int end = this.position;
        if (start < end) {
            return this.input.substring(start, end);
        }
        return "";
    }

    private boolean match(char ch) {
        char la = this.ch();
        if (la == ch) {
            this.consume();
            return true;
        }
        return false;
    }

    private String extract(int len) {
        return this.input.substring(this.position, Math.min(len + this.position, this.input.length()));
    }

    private boolean match(String token) {
        String chunk = this.extract(token.length());
        if (token.equals(chunk)) {
            this.consume(token.length());
            return true;
        }
        return false;
    }

    private String ws() {
        return this.match(new Matcher(){

            @Override
            public boolean match(char ch) {
                return Character.isWhitespace(ch);
            }
        });
    }

    private char ch() {
        return this.ch(this.position);
    }

    private char ch(int position) {
        if (position < 0 || position >= this.input.length()) {
            return '\uffff';
        }
        return this.input.charAt(position);
    }

    private void consume() {
        this.consume(1);
    }

    private void consume(int count) {
        for (int i = 0; i < count; ++i) {
            ++this.position;
        }
    }

    private static Matcher range(final char lower, final char upper) {
        return new Matcher(){

            @Override
            public boolean match(char ch) {
                return ch >= lower && ch <= upper;
            }
        };
    }

    private static Matcher eq(final char ch) {
        return new Matcher(){

            @Override
            public boolean match(char candidate) {
                return ch == candidate;
            }
        };
    }

    private static Matcher firstOf(final Matcher ... matchers) {
        return new Matcher(){

            @Override
            public boolean match(char ch) {
                for (Matcher matcher : matchers) {
                    if (!matcher.match(ch)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static abstract class Matcher {
        private Matcher() {
        }

        public abstract boolean match(char var1);
    }
}

