/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.semver;

import com.github.jknack.semver.BaseExpression;
import com.github.jknack.semver.Semver;
import java.util.Arrays;
import java.util.List;

class Version
extends BaseExpression {
    private int major;
    private int minor;
    private int incremental;
    private String text;
    private String[] prerelease = new String[0];
    private String[] buildNumber = new String[0];

    public Version(String text, int major, int minor, int incremental) {
        this.text = text;
        this.major = major;
        this.minor = minor;
        this.incremental = incremental;
    }

    public Version() {
    }

    @Override
    public int compareTo(Semver expr) {
        return this.compareTo((Version)expr);
    }

    @Override
    public int compareTo(Version that) {
        int result = 0;
        if (this == that) {
            return result;
        }
        result = this.major - that.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - that.minor;
        if (result != 0) {
            return result;
        }
        result = this.incremental - that.incremental;
        if (result != 0) {
            return result;
        }
        result = this.compareTo(this.prerelease, that.prerelease, -1);
        if (result != 0) {
            return result;
        }
        result = this.compareTo(this.buildNumber, that.buildNumber, 1);
        return result;
    }

    private int compareTo(String[] left, String[] right, int sign) {
        int result = 0;
        int len = Math.min(left.length, right.length);
        for (int i = 0; result == 0 && i < len; ++i) {
            result = this.isNumber(left[i]) && this.isNumber(right[i]) ? Integer.parseInt(left[i]) - Integer.parseInt(right[i]) : (this.isNumber(left[i]) || this.isNumber(right[i]) ? (this.isNumber(left[i]) ? -1 : 1) : left[i].compareTo(right[i]));
        }
        if (result == 0) {
            result = (left.length - right.length) * sign;
        }
        return result;
    }

    private boolean isNumber(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        return that instanceof Version ? this.compareTo((Version)that) == 0 : false;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    @Override
    public boolean matches(Semver expr) {
        return this.equals(expr);
    }

    public Version nextMajor() {
        int major = this.major;
        int minor = this.minor;
        int incremental = this.incremental;
        List<String> parts = Arrays.asList(this.text.split("\\."));
        int idx = parts.indexOf("x");
        if (idx == 1) {
            ++major;
            minor = 0;
            incremental = 0;
        } else if (idx == 2) {
            ++minor;
            incremental = 0;
        } else if (incremental == 0) {
            minor = 0;
            ++major;
        } else {
            incremental = 0;
            if (minor == 0) {
                ++major;
            } else {
                ++minor;
            }
        }
        return new Version(major + "." + minor + "." + incremental, major, minor, incremental);
    }

    public int getIncremental() {
        return this.incremental;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getText() {
        return this.text;
    }

    public void setOldBuild(int build) {
    }

    public void setIncremental(int incremental) {
        this.incremental = incremental;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public void setTag(String tag) {
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public Semver.Type type() {
        return Semver.Type.STATIC;
    }

    public void setPreRelease(String[] prerelease) {
        this.prerelease = prerelease;
    }

    public void setBuildNumber(String[] buildNumber) {
        this.buildNumber = buildNumber;
    }
}

