/*
 * Decompiled with CFR 0.152.
 */
package com.github.jkutner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class EnvKeyStore {
    private String password;
    private KeyStore keystore;
    private static final String DEFAULT_TYPE = "PKCS12";

    public static EnvKeyStore create(String keyEnvVar, String certEnvVar, String passwordEnvVar) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new EnvKeyStore(System.getenv(keyEnvVar), System.getenv(certEnvVar), System.getenv(passwordEnvVar));
    }

    public static EnvKeyStore create(String trustEnvVar, String passwordEnvVar) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new EnvKeyStore(System.getenv(trustEnvVar), System.getenv(passwordEnvVar));
    }

    public static EnvKeyStore createWithRandomPassword(String keyEnvVar, String certEnvVar) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new EnvKeyStore(System.getenv(keyEnvVar), System.getenv(certEnvVar), new BigInteger(130, new SecureRandom()).toString(32));
    }

    public static EnvKeyStore createWithRandomPassword(String trustEnvVar) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new EnvKeyStore(System.getenv(trustEnvVar), new BigInteger(130, new SecureRandom()).toString(32));
    }

    EnvKeyStore(String key, String cert, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.password = password;
        this.keystore = EnvKeyStore.createKeyStore(new StringReader(key), new StringReader(cert), password);
    }

    EnvKeyStore(String cert, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.password = password;
        this.keystore = EnvKeyStore.createTrustStore(new StringReader(cert));
    }

    public String password() {
        return this.password;
    }

    public KeyStore keyStore() {
        return this.keystore;
    }

    public String type() {
        return DEFAULT_TYPE;
    }

    public InputStream toInputStream() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new ByteArrayInputStream(this.toBytes());
    }

    public byte[] toBytes() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.store(bos);
        bos.close();
        return bos.toByteArray();
    }

    public void store(OutputStream out) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.keystore.store(out, this.password.toCharArray());
    }

    public void store(Path path) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        Files.write(path, this.toBytes(), new OpenOption[0]);
    }

    public File storeTemp() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        File temp = File.createTempFile("env-keystore", this.type().toLowerCase());
        this.store(temp.toPath());
        return temp;
    }

    public void asFile(Consumer<File> c) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        File temp = this.storeTemp();
        c.accept(temp);
        Files.delete(temp.toPath());
    }

    private static KeyStore createKeyStore(Reader keyReader, Reader certReader, String password) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        PEMParser pem = new PEMParser(keyReader);
        PEMKeyPair pemKeyPair = (PEMKeyPair)pem.readObject();
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        KeyPair keyPair = jcaPEMKeyConverter.getKeyPair(pemKeyPair);
        PrivateKey key = keyPair.getPrivate();
        pem.close();
        keyReader.close();
        PEMParser parser = new PEMParser(certReader);
        X509Certificate certificate = EnvKeyStore.parseCert(parser);
        parser.close();
        KeyStore ks = KeyStore.getInstance(DEFAULT_TYPE);
        ks.load(null);
        ks.setKeyEntry("alias", key, password.toCharArray(), new X509Certificate[]{certificate});
        return ks;
    }

    private static KeyStore createTrustStore(Reader certReader) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        X509Certificate certificate;
        PEMParser parser = new PEMParser(certReader);
        KeyStore ks = KeyStore.getInstance(DEFAULT_TYPE);
        ks.load(null);
        int i = 0;
        while ((certificate = EnvKeyStore.parseCert(parser)) != null) {
            ks.setCertificateEntry(String.format("alias%d", i), certificate);
            ++i;
        }
        parser.close();
        return ks;
    }

    private static X509Certificate parseCert(PEMParser parser) throws IOException, CertificateException {
        X509CertificateHolder certHolder = (X509CertificateHolder)parser.readObject();
        if (certHolder == null) {
            return null;
        }
        X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(certHolder);
        return certificate;
    }
}

