/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron;

import com.github.jlangch.aviron.FileSeparator;
import com.github.jlangch.aviron.dto.CommandRunDetails;
import com.github.jlangch.aviron.dto.QuarantineFile;
import com.github.jlangch.aviron.dto.ScanResult;
import com.github.jlangch.aviron.events.QuarantineEvent;
import com.github.jlangch.aviron.events.QuarantineFileAction;
import com.github.jlangch.aviron.ex.AvironException;
import com.github.jlangch.aviron.ex.UnknownCommandException;
import com.github.jlangch.aviron.impl.commands.Command;
import com.github.jlangch.aviron.impl.commands.mgmt.Ping;
import com.github.jlangch.aviron.impl.commands.mgmt.Reload;
import com.github.jlangch.aviron.impl.commands.mgmt.Shutdown;
import com.github.jlangch.aviron.impl.commands.mgmt.Stats;
import com.github.jlangch.aviron.impl.commands.mgmt.Version;
import com.github.jlangch.aviron.impl.commands.mgmt.VersionCommands;
import com.github.jlangch.aviron.impl.commands.scan.ContScan;
import com.github.jlangch.aviron.impl.commands.scan.InStream;
import com.github.jlangch.aviron.impl.commands.scan.MultiScan;
import com.github.jlangch.aviron.impl.commands.scan.Scan;
import com.github.jlangch.aviron.impl.quarantine.Quarantine;
import com.github.jlangch.aviron.impl.server.ServerIO;
import com.github.jlangch.aviron.impl.util.AvironVersion;
import com.github.jlangch.aviron.impl.util.Lazy;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class Client {
    public static final String LOCALHOST = "localhost";
    public static final int DEFAULT_SERVER_PORT = 3310;
    public static final FileSeparator DEFAULT_SERVER_PLATFORM = ServerIO.DEFAULT_SERVER_FILESEPARATOR;
    private final Quarantine quarantine;
    private final ServerIO server;
    private final Lazy<List<String>> memoizedAvCommands = new Lazy<List>(this::loadAvailableCommands);

    private Client(Builder builder) {
        if (builder.serverHostname == null || builder.serverHostname.isEmpty()) {
            throw new IllegalArgumentException("The server hostname must not be null or empty!");
        }
        if (builder.serverPort <= 0) {
            throw new IllegalArgumentException("The server port must not be negative!");
        }
        if (builder.serverFileSeparator == null) {
            throw new IllegalArgumentException("The server file separator must not be null!");
        }
        if (builder.connectionTimeoutMillis < 0) {
            throw new IllegalArgumentException("The connection timeout must not be negative!");
        }
        if (builder.readTimeoutMillis < 0) {
            throw new IllegalArgumentException("The read timeout must not be negative!");
        }
        if (builder.quarantineDir != null) {
            if (!builder.quarantineDir.isDirectory()) {
                throw new IllegalArgumentException("The quarantine directory \u00ab" + builder.quarantineDir + "\u00bb does not exist!");
            }
            if (!builder.quarantineDir.canWrite()) {
                throw new IllegalArgumentException("The quarantine directory \u00ab" + builder.quarantineDir + "\u00bb has no write permission!");
            }
        }
        if (builder.quarantineFileAction != QuarantineFileAction.NONE && builder.quarantineDir == null) {
            throw new IllegalArgumentException("A quarantine directory is required if the QuarantineFileAction is not NONE!");
        }
        this.server = new ServerIO(builder.serverHostname, builder.serverPort, builder.serverFileSeparator, builder.connectionTimeoutMillis, builder.readTimeoutMillis);
        this.quarantine = new Quarantine(builder.quarantineFileAction, builder.quarantineDir, builder.quarantineEventListener);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean ping() {
        return this.sendCommand(new Ping());
    }

    public String clamAvVersion() {
        return this.sendCommand(new Version());
    }

    public String stats() {
        return this.sendCommand(new Stats());
    }

    public void reloadVirusDatabases() {
        this.sendCommand(new Reload());
    }

    public void shutdownServer() {
        this.sendCommand(new Shutdown());
    }

    public ScanResult scan(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("An 'inputStream' must not be null!");
        }
        return this.scan(inputStream, 2048);
    }

    public ScanResult scan(InputStream inputStream, int chunkSize) {
        if (inputStream == null) {
            throw new IllegalArgumentException("An 'inputStream' must not be null!");
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("A 'chunkSize' must be greater than 0");
        }
        return this.sendCommand(new InStream(inputStream, chunkSize));
    }

    public ScanResult scan(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("A 'path' must not be null!");
        }
        ScanResult result = this.scan(path, false);
        this.quarantine.handleQuarantineActions(result);
        return result;
    }

    public ScanResult scan(Path path, boolean continueScan) {
        if (path == null) {
            throw new IllegalArgumentException("A 'path' must not be null!");
        }
        String serverPath = this.server.toServerPath(path);
        ScanResult result = continueScan ? this.sendCommand(new ContScan(serverPath)) : this.sendCommand(new Scan(serverPath));
        this.quarantine.handleQuarantineActions(result);
        return result;
    }

    public ScanResult parallelScan(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("A 'path' must not be null!");
        }
        ScanResult result = this.sendCommand(new MultiScan(this.server.toServerPath(path)));
        this.quarantine.handleQuarantineActions(result);
        return result;
    }

    public boolean isReachable() {
        return this.server.isReachable();
    }

    public boolean isReachable(int timeoutMillis) {
        return this.server.isReachable(timeoutMillis);
    }

    public CommandRunDetails lastCommandRunDetails() {
        return this.server.getLastCommandRunDetails();
    }

    public boolean isQuarantineActive() {
        return this.quarantine.isActive();
    }

    public List<QuarantineFile> listQuarantineFiles() {
        return this.quarantine.isActive() ? this.quarantine.listQuarantineFiles() : new ArrayList();
    }

    public void removeQuarantineFile(QuarantineFile file) {
        if (file == null) {
            throw new IllegalArgumentException("A 'file' must not be null!");
        }
        this.quarantine.removeQuarantineFile(file);
    }

    public void removeAllQuarantineFiles() {
        this.quarantine.removeAllQuarantineFiles();
    }

    public void printQuarantineInfo(PrintStream stream) {
        PrintStream ps = stream == null ? System.out : stream;
        this.quarantine.listQuarantineFiles().forEach(f -> {
            ps.println(f.getQuarantineFileName());
            ps.println("    " + f.getInfectedFile());
            ps.println("    " + f.getVirusListFormatted());
            ps.println("    " + (Object)((Object)f.getAction()));
            ps.println("    " + f.getQuarantinedAt());
            ps.println();
        });
    }

    public void printConfig(PrintStream stream) {
        PrintStream ps = stream == null ? System.out : stream;
        ps.println(this.toString());
    }

    public String version() {
        return AvironVersion.VERSION;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("serverHostname: ");
        sb.append(this.server.getHostname());
        sb.append(System.lineSeparator());
        sb.append("serverPort: ");
        sb.append(this.server.getPort());
        sb.append(System.lineSeparator());
        sb.append("serverFileSeparator: ");
        sb.append((Object)this.server.getFileSeparator());
        sb.append(System.lineSeparator());
        sb.append("connectionTimeoutMillis: ");
        sb.append(this.server.getConnectionTimeoutMillis());
        sb.append(System.lineSeparator());
        sb.append("readTimeoutMillis: ");
        sb.append(this.server.getReadTimeoutMillis());
        sb.append(System.lineSeparator());
        sb.append("quarantineFileAction: ");
        sb.append((Object)this.quarantine.getQuarantineFileAction());
        sb.append(System.lineSeparator());
        sb.append("quarantineDir: ");
        sb.append(this.formatConfig(this.quarantine.getQuarantineDir()));
        sb.append(System.lineSeparator());
        sb.append("quarantineListener: ");
        sb.append(this.formatConfig(this.quarantine.hasListener()));
        return sb.toString();
    }

    private String formatConfig(File f) {
        return f != null ? f.getPath() : "-";
    }

    private String formatConfig(boolean b) {
        return b ? "supplied" : "-";
    }

    private List<String> loadAvailableCommands() {
        return (List)new VersionCommands().send(this.server);
    }

    private <T> T sendCommand(Command<T> command) {
        try {
            if (this.memoizedAvCommands.get().contains(command.getCommandString())) {
                return command.send(this.server);
            }
            throw new UnknownCommandException(command.getCommandString());
        }
        catch (AvironException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new AvironException(String.format("Failed to send command: %s", command.getCommandString()), ex);
        }
    }

    public static class Builder {
        private String serverHostname = "localhost";
        private int serverPort = 3310;
        private FileSeparator serverFileSeparator = FileSeparator.JVM_PLATFORM;
        private int connectionTimeoutMillis = 3000;
        private int readTimeoutMillis = 20000;
        private QuarantineFileAction quarantineFileAction = QuarantineFileAction.NONE;
        private File quarantineDir = null;
        private Consumer<QuarantineEvent> quarantineEventListener;

        public Client build() {
            return new Client(this);
        }

        public Builder serverHostname(String hostname) {
            this.serverHostname = hostname;
            return this;
        }

        public Builder serverPort(int port) {
            this.serverPort = port;
            return this;
        }

        public Builder serverFileSeparator(FileSeparator separator) {
            this.serverFileSeparator = separator;
            return this;
        }

        public Builder connectionTimeout(int timeoutMillis) {
            this.connectionTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder readTimeout(int timeoutMillis) {
            this.readTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder quarantineFileAction(QuarantineFileAction action) {
            this.quarantineFileAction = action == null ? QuarantineFileAction.NONE : action;
            return this;
        }

        public Builder quarantineDir(File quarantineDir) {
            this.quarantineDir = quarantineDir;
            return this;
        }

        public Builder quarantineDir(String quarantineDir) {
            this.quarantineDir = quarantineDir == null ? null : new File(quarantineDir);
            return this;
        }

        public Builder quarantineEventListener(Consumer<QuarantineEvent> listener) {
            this.quarantineEventListener = listener;
            return this;
        }
    }
}

