/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.admin;

import com.github.jlangch.aviron.ex.AvironException;
import com.github.jlangch.aviron.ex.NotRunningException;
import com.github.jlangch.aviron.impl.util.Shell;
import com.github.jlangch.aviron.impl.util.Signal;
import com.github.jlangch.aviron.impl.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;

public class ClamdAdmin {
    public static String getClamdPID() {
        Shell.validateLinuxOrMacOSX("Admin::getClamdPID");
        List<String> pids = Shell.pgrep("clamd");
        return pids.isEmpty() ? null : pids.get(0);
    }

    public static String loadClamdPID(File pidFile) {
        if (pidFile == null) {
            throw new IllegalArgumentException("A pid file must not be null!");
        }
        try {
            if (pidFile.isFile() && pidFile.canRead()) {
                String s = Files.lines(pidFile.toPath(), Charset.defaultCharset()).map(l -> l.trim()).findFirst().orElse(null);
                return s;
            }
            return null;
        }
        catch (Exception ex) {
            throw new AvironException("Failed to load PID from file \u00ab" + pidFile + "\u00bb", ex);
        }
    }

    public static boolean isProcessAlive(String pid) {
        if (StringUtils.isBlank(pid)) {
            throw new IllegalArgumentException("A pid must not be blank!");
        }
        Shell.validateLinuxOrMacOSX("Admin::isProcessAlive");
        return Shell.isProcessAlive(pid);
    }

    public static List<String> getCpulimitPIDs() {
        Shell.validateLinuxOrMacOSX("Admin::getCpulimitPIDs");
        return Shell.pgrep("cpulimit");
    }

    public static void activateClamdCpuLimit(String clamdPID, int limit) {
        Shell.validateLinuxOrMacOSX("Admin::activateClamdCpuLimit");
        if (StringUtils.isBlank(clamdPID)) {
            throw new IllegalArgumentException("No Clamd PID!");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("A limit value must not be negative!");
        }
        try {
            Shell.execCmdBackgroundNohup("cpulimit", "--limit=" + limit, "--pid=" + clamdPID);
        }
        catch (IOException ex) {
            throw new AvironException("Failed to activate a CPU limit on the clamd process", ex);
        }
    }

    public static void deactivateClamdCpuLimit(String clamdPID) {
        Shell.validateLinuxOrMacOSX("Admin::deactivateClamdCpuLimit");
        if (StringUtils.isBlank(clamdPID)) {
            throw new NotRunningException("No Clamd PID!");
        }
        try {
            Shell.execCmd("pkill", "-f", "cpulimit.*" + clamdPID);
        }
        catch (IOException ex) {
            throw new AvironException("Failed to deactivate CPU limit on the clamd process" + clamdPID, ex);
        }
    }

    public static void killClamd() {
        Shell.validateLinuxOrMacOSX("Admin::killClamd");
        String clamdPID = ClamdAdmin.getClamdPID();
        if (!StringUtils.isBlank(clamdPID)) {
            Shell.kill(Signal.SIGTERM, ClamdAdmin.getClamdPID());
        }
    }

    public static int getNrOfCpus() {
        return Runtime.getRuntime().availableProcessors();
    }
}

