/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.admin;

import com.github.jlangch.aviron.admin.ClamdAdmin;
import com.github.jlangch.aviron.admin.DynamicCpuLimit;
import com.github.jlangch.aviron.impl.util.StringUtils;
import java.time.LocalDateTime;
import java.util.Objects;

public class ClamdCpuLimiter {
    private Limit lastSeen = new Limit(null, 100);
    private final DynamicCpuLimit dynamicCpuLimit;

    public ClamdCpuLimiter() {
        this(null);
    }

    public ClamdCpuLimiter(DynamicCpuLimit dynamicCpuLimit) {
        this.dynamicCpuLimit = dynamicCpuLimit == null ? new DynamicCpuLimit() : dynamicCpuLimit;
    }

    public int getLimitForTimestamp(LocalDateTime timestamp) {
        return this.dynamicCpuLimit.computeCpuLimit(timestamp);
    }

    public synchronized int getLastSeenLimit() {
        return this.lastSeen.limit;
    }

    public synchronized boolean activateClamdCpuLimit(String clamdPID, int limit) {
        if (StringUtils.isBlank(clamdPID)) {
            throw new IllegalArgumentException("No Clamd PID!");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("A limit value must not be negative!");
        }
        Limit newLimit = new Limit(clamdPID, limit);
        if (Objects.equals(clamdPID, this.lastSeen.pid) && limit == this.lastSeen.limit) {
            return false;
        }
        this.lastSeen = newLimit;
        ClamdAdmin.deactivateClamdCpuLimit(clamdPID);
        if (limit != 100) {
            ClamdAdmin.activateClamdCpuLimit(clamdPID, limit);
        }
        return true;
    }

    public synchronized boolean activateClamdCpuLimit(String clamdPID) {
        if (StringUtils.isBlank(clamdPID)) {
            throw new IllegalArgumentException("No Clamd PID!");
        }
        int limit = this.dynamicCpuLimit.computeCpuLimit();
        return this.activateClamdCpuLimit(clamdPID, limit);
    }

    public synchronized void deactivateClamdCpuLimit(String clamdPID) {
        if (StringUtils.isBlank(clamdPID)) {
            throw new IllegalArgumentException("No Clamd PID!");
        }
        this.lastSeen = new Limit(null, 100);
        ClamdAdmin.deactivateClamdCpuLimit(clamdPID);
    }

    public String formatProfilesAsTableByHour() {
        return this.dynamicCpuLimit.formatProfilesAsTableByHour();
    }

    public String toString() {
        return this.dynamicCpuLimit.toString();
    }

    private static class Limit {
        private final String pid;
        private final int limit;
        private final LocalDateTime ts;

        public Limit(String pid, int limit) {
            this.pid = pid;
            this.limit = limit;
            this.ts = LocalDateTime.now();
        }

        public String toString() {
            return String.format("pid=%s, limit=%d, ts=%s", this.pid, this.limit, this.ts.toString());
        }
    }
}

