/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.admin;

import com.github.jlangch.aviron.admin.CpuProfileEntry;
import com.github.jlangch.aviron.impl.util.CollectionUtils;
import com.github.jlangch.aviron.impl.util.StringUtils;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CpuProfile {
    private static final CpuProfileEntry off = new CpuProfileEntry(LocalTime.of(0, 0), LocalTime.of(23, 59), 0);
    private final String name;
    private final List<CpuProfileEntry> entries = new ArrayList<CpuProfileEntry>();

    public CpuProfile(String name, List<CpuProfileEntry> entries) {
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException("A name time must not be blank!");
        }
        if (entries == null) {
            throw new IllegalArgumentException("An entries list must not be null!");
        }
        this.validate(entries);
        this.name = name;
        this.entries.addAll(entries);
    }

    public static CpuProfile of(String name, List<String> entries) {
        return new CpuProfile(name, entries.stream().map(e -> CpuProfileEntry.parse(e)).collect(Collectors.toList()));
    }

    public static CpuProfile defaultProfile() {
        return CpuProfile.of("default", CollectionUtils.toList("00:00-23:59 @ 100%"));
    }

    public String getName() {
        return this.name;
    }

    public List<CpuProfileEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public int getLimit(int hour, int minute) {
        return this.getLimit(LocalTime.of(hour, minute));
    }

    public int getLimit(LocalTime time) {
        if (time == null) {
            return off.getLimit();
        }
        return this.entries.stream().filter(e -> e.isWithin(time)).findFirst().orElse(off).getLimit();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.entries.forEach(e -> {
            sb.append(e.toString());
            sb.append(System.lineSeparator());
        });
        return sb.toString();
    }

    private void validate(List<CpuProfileEntry> entries) {
        if (entries.isEmpty()) {
            throw new IllegalArgumentException("An entries list must not be empty!");
        }
        if (entries.size() == 1) {
            return;
        }
        for (int ii = 0; ii < entries.size() - 1; ++ii) {
            if (entries.get(ii).isBefore(entries.get(ii + 1))) continue;
            throw new IllegalArgumentException("The entries are not in ascending order or are overlapping! Check entry: \"" + entries.get(ii + 1) + "\"");
        }
    }
}

