/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.dto;

public class CommandRunDetails {
    private final String command;
    private final String response;
    private final long elapsedMillis;

    public CommandRunDetails(String command, String response, long elapsedMillis) {
        this.command = command.replace(CommandRunDetails.str('\n'), "[n").replace(CommandRunDetails.str('\u0000'), "[0");
        this.response = response;
        this.elapsedMillis = elapsedMillis;
    }

    public String getCommand() {
        return this.command;
    }

    public String getResponse() {
        return this.response;
    }

    public long getElapsedMillis() {
        return this.elapsedMillis;
    }

    public String getElapsedMillisFormatted() {
        if (this.elapsedMillis < 1000L) {
            return String.format("%dms", this.elapsedMillis);
        }
        if (this.elapsedMillis < 60000L) {
            return String.format("%ds %dms", this.elapsedMillis / 1000L, this.elapsedMillis % 1000L);
        }
        long seconds = this.elapsedMillis / 1000L;
        return String.format("%dm %ds", seconds / 60L, seconds % 60L);
    }

    public String toString() {
        return "CommandRunDetails (" + this.getElapsedMillisFormatted() + "):\n" + this.command + "\n\n" + this.response;
    }

    private static String str(char ch) {
        return String.format("%s", Character.valueOf(ch));
    }
}

