/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.dto;

import com.github.jlangch.aviron.events.QuarantineFileAction;
import com.github.jlangch.aviron.ex.QuarantineException;
import com.github.jlangch.aviron.impl.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class QuarantineFile {
    private static String KEY_INFECTED_FILE = "infected-file";
    private static String KEY_VIRUS_LIST = "virus-list";
    private static String KEY_QUARANTINE_ACTION = "quarantine-action";
    private static String KEY_QUARANTINED_AT = "quarantined-at";
    private static String KEY_HASH = "hash";
    private final String quarantineFileName;
    private final File infectedFile;
    private final List<String> virusList = new ArrayList<String>();
    private final QuarantineFileAction action;
    private final LocalDateTime quarantinedAt;
    private final String hash;

    public QuarantineFile(String quarantineFileName, File infectedFile, List<String> virusList, QuarantineFileAction action, LocalDateTime quarantinedAt, String hash) {
        this.quarantineFileName = quarantineFileName;
        this.infectedFile = infectedFile;
        this.virusList.addAll(virusList);
        this.action = action;
        this.quarantinedAt = quarantinedAt;
        this.hash = hash;
    }

    public static QuarantineFile from(File quarantineInfoFile) {
        if (quarantineInfoFile == null) {
            throw new IllegalArgumentException("An 'quarantineInfoFile' must not be null!");
        }
        if (!quarantineInfoFile.getPath().endsWith(".virus")) {
            throw new QuarantineException("The file \u00ab" + quarantineInfoFile + "\u00bb is not a quarantine info file!");
        }
        try {
            String data = new String(Files.readAllBytes(quarantineInfoFile.toPath()), Charset.defaultCharset());
            return QuarantineFile.from(quarantineInfoFile.getName(), data);
        }
        catch (IOException ex) {
            throw new QuarantineException("Failed read quarantine info file \u00ab" + quarantineInfoFile + "\u00bb!");
        }
    }

    public static QuarantineFile from(String quarantineInfoFileName, String quarantineInfoFileData) {
        try {
            String quarantineFile = StringUtils.stripEnd(quarantineInfoFileName, ".virus");
            File infectedFile = null;
            List<String> virusList = new ArrayList<String>();
            QuarantineFileAction action = null;
            LocalDateTime createdAt = null;
            String hash = null;
            for (String line : StringUtils.splitIntoLines(quarantineInfoFileData)) {
                int pos = line.indexOf(61);
                if (pos <= 0) continue;
                String key = line.substring(0, pos);
                String value = line.substring(pos + 1);
                if (key.equals(KEY_INFECTED_FILE)) {
                    infectedFile = new File(value);
                    continue;
                }
                if (key.equals(KEY_VIRUS_LIST)) {
                    virusList = Arrays.asList(value.split(","));
                    continue;
                }
                if (key.equals(KEY_QUARANTINE_ACTION)) {
                    action = QuarantineFileAction.valueOf(value);
                    continue;
                }
                if (key.equals(KEY_QUARANTINED_AT)) {
                    createdAt = LocalDateTime.parse(value);
                    continue;
                }
                if (!key.equals(KEY_HASH)) continue;
                hash = value;
            }
            return new QuarantineFile(quarantineFile, infectedFile, virusList, action, createdAt, hash);
        }
        catch (Exception ex) {
            throw new QuarantineException("Failed to parse quarantine info file \u00ab" + quarantineInfoFileName + "\u00bb. ", ex);
        }
    }

    public String getQuarantineFileName() {
        return this.quarantineFileName;
    }

    public File getInfectedFile() {
        return this.infectedFile;
    }

    public List<String> getVirusList() {
        return Collections.unmodifiableList(this.virusList);
    }

    public String getVirusListFormatted() {
        return this.virusList.stream().collect(Collectors.joining(","));
    }

    public QuarantineFileAction getAction() {
        return this.action;
    }

    public LocalDateTime getQuarantinedAt() {
        return this.quarantinedAt;
    }

    public String getHash() {
        return this.hash;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_INFECTED_FILE);
        sb.append("=");
        sb.append(this.getInfectedFile());
        sb.append(System.lineSeparator());
        sb.append(KEY_VIRUS_LIST);
        sb.append("=");
        sb.append(this.getVirusListFormatted());
        sb.append(System.lineSeparator());
        sb.append(KEY_QUARANTINE_ACTION);
        sb.append("=");
        sb.append(this.getAction().name());
        sb.append(System.lineSeparator());
        sb.append(KEY_QUARANTINED_AT);
        sb.append("=");
        sb.append(this.getQuarantinedAt());
        sb.append(System.lineSeparator());
        sb.append(KEY_HASH);
        sb.append("=");
        sb.append(this.getHash());
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Quarantine File Name: ");
        sb.append(this.getQuarantineFileName());
        sb.append(System.lineSeparator());
        sb.append("Infected File:        ");
        sb.append(this.getInfectedFile());
        sb.append(System.lineSeparator());
        sb.append("Virus Signatures:     ");
        sb.append(this.getVirusListFormatted());
        sb.append(System.lineSeparator());
        sb.append("Quarantine Action:    ");
        sb.append((Object)this.getAction());
        sb.append(System.lineSeparator());
        sb.append("Quarantined At:       ");
        sb.append(this.getQuarantinedAt());
        sb.append(System.lineSeparator());
        sb.append("File Hash:            ");
        sb.append(this.getHash());
        return sb.toString();
    }
}

