/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.events;

import com.github.jlangch.aviron.events.Event;
import com.github.jlangch.aviron.events.QuarantineFileAction;
import com.github.jlangch.aviron.ex.QuarantineFileActionException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class QuarantineEvent
implements Event {
    private final File infectedFile;
    private final List<String> virusList = new ArrayList<String>();
    private final File quarantineFile;
    private final QuarantineFileAction action;
    private final QuarantineFileActionException ex;

    public QuarantineEvent(File infectedFile, List<String> virusList, File quarantineFile, QuarantineFileAction action, QuarantineFileActionException ex) {
        this.infectedFile = infectedFile;
        if (virusList != null) {
            this.virusList.addAll(virusList);
        }
        this.quarantineFile = quarantineFile;
        this.action = action;
        this.ex = ex;
    }

    public File getInfectedFile() {
        return this.infectedFile;
    }

    public List<String> getVirusList() {
        return Collections.unmodifiableList(this.virusList);
    }

    public File getQuarantineFile() {
        return this.quarantineFile;
    }

    public QuarantineFileAction getAction() {
        return this.action;
    }

    public QuarantineFileActionException getException() {
        return this.ex;
    }

    public boolean hasException() {
        return this.ex != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Infected File: ");
        sb.append(this.infectedFile);
        sb.append(System.lineSeparator());
        sb.append("Virus Signatures: ");
        sb.append(this.virusList.stream().collect(Collectors.joining(", ")));
        sb.append(System.lineSeparator());
        sb.append("Quarantine File: ");
        sb.append(this.quarantineFile);
        sb.append(System.lineSeparator());
        sb.append("Quarantine Action: ");
        sb.append((Object)this.action);
        sb.append(System.lineSeparator());
        if (this.ex != null) {
            sb.append("Quarantine Exception: ");
            sb.append(this.ex.getMessage());
        }
        return sb.toString();
    }
}

