/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.examples;

import com.github.jlangch.aviron.Client;
import com.github.jlangch.aviron.FileSeparator;
import com.github.jlangch.aviron.admin.ClamdAdmin;
import com.github.jlangch.aviron.admin.ClamdCpuLimiter;
import com.github.jlangch.aviron.admin.CpuProfile;
import com.github.jlangch.aviron.admin.DynamicCpuLimit;
import com.github.jlangch.aviron.events.QuarantineEvent;
import com.github.jlangch.aviron.events.QuarantineFileAction;
import com.github.jlangch.aviron.impl.util.CollectionUtils;
import com.github.jlangch.aviron.util.FileStoreMgr;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClamdCpuLimiterExample2 {
    private static final int MIN_SCAN_LIMIT_PERCENT = 20;
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private ScheduledExecutorService ses;

    public static void main(String[] args) {
        try {
            new ClamdCpuLimiterExample2().scan();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() throws Exception {
        File filestoreDir = new File("/data/filestore/");
        File quarantineDir = new File("/data/quarantine/");
        Client client = new Client.Builder().serverHostname("localhost").serverFileSeparator(FileSeparator.UNIX).quarantineFileAction(QuarantineFileAction.MOVE).quarantineDir(quarantineDir).quarantineEventListener(this::eventListener).build();
        CpuProfile everyday = CpuProfile.of("weekday", CollectionUtils.toList("00:00-05:59 @ 100%", "06:00-08:59 @  50%", "09:00-17:59 @   0%", "18:00-21:59 @  50%", "22:00-23:59 @ 100%"));
        String clamdPID = ClamdAdmin.getClamdPID();
        ClamdCpuLimiter limiter = new ClamdCpuLimiter(new DynamicCpuLimit(everyday));
        FileStoreMgr fsMgr = new FileStoreMgr(filestoreDir);
        this.initialCpuLimit(limiter, clamdPID);
        try {
            this.ses = Executors.newScheduledThreadPool(1);
            Runnable updateCpuLimitTask = () -> this.updateCpuLimit(limiter, clamdPID);
            this.ses.scheduleAtFixedRate(updateCpuLimitTask, 5L, 5L, TimeUnit.MINUTES);
            while (!this.stop.get()) {
                if (limiter.getLastSeenLimit() >= 20) {
                    File dir = fsMgr.nextDir();
                    System.out.println(client.scan(dir.toPath(), false));
                    continue;
                }
                Thread.sleep(30000L);
            }
        }
        finally {
            this.ses.shutdown();
        }
    }

    private void initialCpuLimit(ClamdCpuLimiter limiter, String clamdPID) {
        limiter.activateClamdCpuLimit(clamdPID);
        System.out.println(String.format("Initial clamd CPU limit: %d%%", limiter.getLastSeenLimit()));
    }

    private void updateCpuLimit(ClamdCpuLimiter limiter, String clamdPID) {
        int lastSeenLimit = limiter.getLastSeenLimit();
        if (limiter.activateClamdCpuLimit(clamdPID)) {
            int newLimit = limiter.getLastSeenLimit();
            System.out.println(String.format("Adjusted clamd CPU limit: %d%% -> %d%%", lastSeenLimit, newLimit));
        }
    }

    private void eventListener(QuarantineEvent event) {
        if (event.getException() != null) {
            System.out.println("Error " + event.getException().getMessage());
        } else {
            System.out.println("File " + event.getInfectedFile() + " moved to quarantine");
        }
    }
}

