/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.examples;

import com.github.jlangch.aviron.Client;
import com.github.jlangch.aviron.FileSeparator;
import com.github.jlangch.aviron.dto.QuarantineFile;
import com.github.jlangch.aviron.events.QuarantineEvent;
import com.github.jlangch.aviron.events.QuarantineFileAction;
import com.github.jlangch.aviron.examples.ScanExample;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Paths;
import java.util.List;

public class ScanQuarantineExample {
    public static void main(String[] args) throws Exception {
        try {
            new ScanExample().scan();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void scan() throws Exception {
        String baseDir = "/data/files/";
        String quarantineDir = "/data/quarantine/";
        Client client = new Client.Builder().serverHostname("localhost").serverFileSeparator(FileSeparator.UNIX).quarantineFileAction(QuarantineFileAction.MOVE).quarantineDir("/data/quarantine/").quarantineEventListener(this::eventListener).build();
        System.out.println("Reachable: " + client.isReachable());
        System.out.println(client.scan(Paths.get("/data/files/", "document.pdf")));
        System.out.println(client.scan(Paths.get("/data/files/", new String[0]), true));
        try (FileInputStream is = new FileInputStream(new File("/data/files/", "document.pdf"));){
            System.out.println(client.scan(is));
        }
        List<QuarantineFile> files = client.listQuarantineFiles();
        System.out.println(String.format("%d quarantined files", files.size()));
        if (!files.isEmpty()) {
            QuarantineFile qf = files.get(0);
            System.out.println(qf);
            client.removeQuarantineFile(qf);
        }
        client.removeAllQuarantineFiles();
    }

    private void eventListener(QuarantineEvent event) {
        if (event.getException() != null) {
            System.out.println("Error " + event.getException().getMessage());
        } else {
            System.out.println("File " + event.getInfectedFile() + " moved to quarantine");
        }
    }
}

