/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.impl.commands.scan;

import com.github.jlangch.aviron.dto.ScanResult;
import com.github.jlangch.aviron.ex.UnknownCommandException;
import com.github.jlangch.aviron.impl.commands.CommandDef;
import com.github.jlangch.aviron.impl.commands.CommandFormat;
import com.github.jlangch.aviron.impl.commands.scan.ScanCommand;
import com.github.jlangch.aviron.impl.server.ServerIO;
import java.io.InputStream;

public class InStream
extends ScanCommand {
    public static final int DEFAULT_CHUNK_SIZE = 2048;
    private final InputStream inputStream;
    private final int chunkSize;

    public InStream(InputStream inputStream) {
        this(inputStream, 2048);
    }

    public InStream(InputStream inputStream, int chunkSize) {
        this.inputStream = inputStream;
        this.chunkSize = chunkSize;
    }

    @Override
    public CommandDef getCommandDef() {
        return new CommandDef("INSTREAM", CommandFormat.NULL_CHAR);
    }

    @Override
    public ScanResult send(ServerIO server) {
        String rawResponse = server.sendCommandWithDataAndReturnResponse(this.rawCommand(), this.inputStream, this.chunkSize);
        String response = this.removeResponseTerminator(rawResponse);
        if ("UNKNOWN COMMAND".equals(response)) {
            throw new UnknownCommandException(this.getCommandString());
        }
        return this.parseResponse(response);
    }
}

