/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.impl.commands.scan;

import com.github.jlangch.aviron.dto.ScanResult;
import com.github.jlangch.aviron.ex.InvalidResponseException;
import com.github.jlangch.aviron.ex.ScanFailureException;
import com.github.jlangch.aviron.impl.commands.Command;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class ScanCommand
extends Command<ScanResult> {
    private static final Pattern RESPONSE_OK = Pattern.compile("(.+) OK$", 1);
    private static final Pattern RESPONSE_VIRUS_FOUND = Pattern.compile("(.+) FOUND$", 9);
    private static final Pattern RESPONSE_ERROR = Pattern.compile("(.+) ERROR", 1);
    private static final Pattern RESPONSE_VIRUS_FOUND_LINE = Pattern.compile("(.+: )?(.+): (.+) FOUND$", 1);

    @Override
    protected ScanResult parseResponse(String responseString) {
        try {
            if (RESPONSE_OK.matcher(responseString).matches()) {
                return ScanResult.ok();
            }
            if (RESPONSE_VIRUS_FOUND.matcher(responseString).find()) {
                Map<String, List<String>> foundViruses = Arrays.stream(responseString.split("\n")).map(RESPONSE_VIRUS_FOUND_LINE::matcher).filter(Matcher::matches).map(matcher -> new AbstractMap.SimpleEntry<String, String>(matcher.group(2), matcher.group(3))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
                return ScanResult.virusFound(foundViruses);
            }
            if (RESPONSE_ERROR.matcher(responseString).matches()) {
                throw new ScanFailureException(responseString);
            }
            throw new InvalidResponseException(responseString);
        }
        catch (IllegalStateException ex) {
            throw new InvalidResponseException(responseString);
        }
    }
}

