/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.impl.filewatcher;

import com.github.jlangch.aviron.events.FileWatchErrorEvent;
import com.github.jlangch.aviron.events.FileWatchEvent;
import com.github.jlangch.aviron.events.FileWatchEventType;
import com.github.jlangch.aviron.events.FileWatchRegisterEvent;
import com.github.jlangch.aviron.events.FileWatchTerminationEvent;
import com.github.jlangch.aviron.ex.FileWatcherException;
import java.io.Closeable;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class FileWatcher
implements Closeable {
    private static final AtomicLong threadCounter = new AtomicLong(1L);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final WatchService ws;
    private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private final Consumer<FileWatchEvent> eventListener;
    private final Consumer<FileWatchRegisterEvent> registerListener;
    private final Consumer<FileWatchErrorEvent> errorListener;
    private final Consumer<FileWatchTerminationEvent> terminationListener;

    public FileWatcher(Path dir, Consumer<FileWatchEvent> eventListener, Consumer<FileWatchRegisterEvent> registerListener, Consumer<FileWatchErrorEvent> errorListener, Consumer<FileWatchTerminationEvent> terminationListener) {
        this.ws = this.createWatchService(dir);
        this.eventListener = eventListener;
        this.registerListener = registerListener;
        this.errorListener = errorListener;
        this.terminationListener = terminationListener;
        this.register(dir);
        this.start(dir);
    }

    public void register(Path dir) {
        if (!dir.toFile().exists()) {
            throw new FileWatcherException("Folder " + dir + " does not exist");
        }
        if (!dir.toFile().isDirectory()) {
            throw new FileWatcherException("Folder " + dir + " is not a directory");
        }
        this.register(this.ws, this.keys, dir, false);
    }

    public void register(List<Path> dirs) {
        dirs.forEach(d -> this.register(this.ws, this.keys, (Path)d, false));
    }

    public List<Path> getRegisteredPaths() {
        return this.keys.values().stream().sorted().collect(Collectors.toList());
    }

    public boolean isRunning() {
        return !this.closed.get();
    }

    @Override
    public void close() {
        this.closed.set(true);
        try {
            this.ws.close();
        }
        catch (Exception ex) {
            throw new FileWatcherException("Failed to close WatchService!", ex);
        }
    }

    private WatchService createWatchService(Path mainDir) {
        if (!mainDir.toFile().exists()) {
            throw new FileWatcherException("Failed to start WatchService! The main folder " + mainDir + " does not exist");
        }
        if (!mainDir.toFile().isDirectory()) {
            throw new FileWatcherException("Failed to start WatchService The main folder " + mainDir + " is not a directory");
        }
        try {
            return mainDir.getFileSystem().newWatchService();
        }
        catch (Exception ex) {
            throw new FileWatcherException("Failed to start WatchService! Folder " + mainDir + ".", ex);
        }
    }

    private void start(Path dir) {
        Runnable runnable = () -> {
            while (!this.closed.get()) {
                try {
                    WatchKey key = this.ws.take();
                    if (key == null) break;
                    Path dirPath = this.keys.get(key);
                    if (dirPath == null) continue;
                    key.pollEvents().stream().filter(e -> e.kind() != StandardWatchEventKinds.OVERFLOW).forEach(e -> {
                        FileWatchEventType type;
                        Path p = (Path)e.context();
                        Path absPath = dirPath.resolve(p);
                        if (absPath.toFile().isDirectory() && e.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                            this.register(this.ws, this.keys, absPath, true);
                        }
                        if ((type = this.convertEvent(e.kind())) != null) {
                            this.safeRun(() -> this.eventListener.accept(new FileWatchEvent(absPath, type)));
                        }
                    });
                    key.reset();
                }
                catch (ClosedWatchServiceException ex) {
                    break;
                }
                catch (InterruptedException ex) {
                }
                catch (Exception ex) {
                    if (this.errorListener == null) continue;
                    this.safeRun(() -> this.errorListener.accept(new FileWatchErrorEvent(dir, ex)));
                }
            }
            if (!this.closed.get()) {
                try {
                    this.ws.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.terminationListener != null) {
                this.safeRun(() -> this.terminationListener.accept(new FileWatchTerminationEvent(dir)));
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.setName("aviron-filewatcher-" + threadCounter.getAndIncrement());
        thread.start();
    }

    private FileWatchEventType convertEvent(WatchEvent.Kind<?> kind) {
        if (kind == null) {
            return null;
        }
        switch (kind.name()) {
            case "ENTRY_CREATE": {
                return FileWatchEventType.CREATED;
            }
            case "ENTRY_DELETE": {
                return FileWatchEventType.DELETED;
            }
            case "ENTRY_MODIFY": {
                return FileWatchEventType.MODIFIED;
            }
            case "OVERFLOW": {
                return FileWatchEventType.OVERFLOW;
            }
        }
        return null;
    }

    private void register(WatchService ws, Map<WatchKey, Path> keys, Path dir, boolean audit) {
        block3: {
            try {
                WatchKey dirKey = dir.register(ws, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}, new WatchEvent.Modifier[0]);
                keys.put(dirKey, dir);
                if (audit && this.registerListener != null) {
                    this.safeRun(() -> this.registerListener.accept(new FileWatchRegisterEvent(dir)));
                }
            }
            catch (Exception e) {
                if (this.errorListener == null) break block3;
                this.safeRun(() -> this.errorListener.accept(new FileWatchErrorEvent(dir, e)));
            }
        }
    }

    private void safeRun(Runnable r) {
        try {
            r.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

