/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.impl.filewatcher;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class FileWatcherQueue {
    public static int MIN_SIZE = 5;
    private final int maxSize;
    private final LinkedList<File> queue = new LinkedList();

    public FileWatcherQueue(int maxSize) {
        this.maxSize = Math.max(MIN_SIZE, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(File file) {
        if (file != null) {
            LinkedList<File> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.removeIf(it -> it.equals(file));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(File file) {
        if (file != null) {
            LinkedList<File> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.removeIf(it -> it.equals(file));
                while (this.queue.size() >= this.maxSize) {
                    this.queue.removeFirst();
                }
                this.queue.add(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File pop() {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.isEmpty() ? null : this.queue.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> pop(int n) {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            ArrayList<File> files = new ArrayList<File>(n);
            for (int ii = 0; ii < n && !this.queue.isEmpty(); ++ii) {
                files.add(this.queue.removeFirst());
            }
            return files;
        }
    }
}

