/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.impl.filewatcher;

import com.github.jlangch.aviron.events.FileWatchErrorEvent;
import com.github.jlangch.aviron.events.FileWatchEvent;
import com.github.jlangch.aviron.events.FileWatchRegisterEvent;
import com.github.jlangch.aviron.events.FileWatchTerminationEvent;
import com.github.jlangch.aviron.impl.filewatcher.FileWatcher;
import com.github.jlangch.aviron.impl.filewatcher.FileWatcherQueue;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

public class RealtimeFileWatcher {
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Path mainDir;
    private final List<Path> secondaryDirs = new ArrayList<Path>();
    private final Predicate<FileWatchEvent> scanApprover;
    private AtomicReference<FileWatcher> watcher = new AtomicReference();
    private AtomicReference<FileWatcherQueue> fileWatcherQueue = new AtomicReference();

    public RealtimeFileWatcher(Path mainDir, List<Path> secondaryDirs, Predicate<FileWatchEvent> scanApprover) {
        if (mainDir == null) {
            throw new IllegalArgumentException("A 'mainDir' must not be null!");
        }
        if (!Files.isDirectory(mainDir, new LinkOption[0])) {
            throw new IllegalArgumentException("The realtime scanner 'mainDir' is not an existing directory!");
        }
        this.mainDir = mainDir;
        if (secondaryDirs != null) {
            this.secondaryDirs.addAll(secondaryDirs);
        }
        this.scanApprover = scanApprover;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public synchronized void start() {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.fileWatcherQueue.set(new FileWatcherQueue(5000));
                this.watcher.set(new FileWatcher(this.mainDir, this::fileWatchEventListener, this::registerEventListener, this::errorEventListener, this::terminationEventListener));
            }
            catch (Exception ex) {
                this.running.set(false);
                throw ex;
            }
            this.watcher.get().register(this.secondaryDirs);
        }
    }

    public synchronized void stop() {
        FileWatcher fw;
        if (this.running.compareAndSet(true, false) && (fw = this.watcher.get()) != null && fw.isRunning()) {
            fw.close();
        }
    }

    public List<File> popNextFiles(int n) {
        FileWatcherQueue queue = this.fileWatcherQueue.get();
        return queue != null ? queue.pop(n) : new ArrayList();
    }

    private void fileWatchEventListener(FileWatchEvent event) {
        FileWatcherQueue queue = this.fileWatcherQueue.get();
        switch (event.getType()) {
            case CREATED: 
            case MODIFIED: {
                try {
                    if (this.scanApprover != null && !this.scanApprover.test(event)) break;
                    queue.push(event.getPath().toFile());
                }
                catch (Exception exception) {}
                break;
            }
            case DELETED: {
                queue.remove(event.getPath().toFile());
                break;
            }
            case OVERFLOW: {
                break;
            }
        }
    }

    private void registerEventListener(FileWatchRegisterEvent event) {
    }

    private void errorEventListener(FileWatchErrorEvent event) {
    }

    private void terminationEventListener(FileWatchTerminationEvent event) {
    }
}

