/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.impl.filewatcher;

import com.github.jlangch.aviron.Client;
import com.github.jlangch.aviron.dto.ScanResult;
import com.github.jlangch.aviron.events.FileWatchErrorEvent;
import com.github.jlangch.aviron.events.FileWatchEvent;
import com.github.jlangch.aviron.events.FileWatchRegisterEvent;
import com.github.jlangch.aviron.events.FileWatchTerminationEvent;
import com.github.jlangch.aviron.events.RealtimeScanEvent;
import com.github.jlangch.aviron.impl.filewatcher.FileWatcher;
import com.github.jlangch.aviron.impl.filewatcher.FileWatcherQueue;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class RealtimeScanner {
    private static final int BATCH_SIZE = 300;
    private static final AtomicLong threadCounter = new AtomicLong(1L);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Client client;
    private final Path mainDir;
    private final List<Path> secondaryDirs = new ArrayList<Path>();
    private final Predicate<FileWatchEvent> scanApprover;
    private final Consumer<RealtimeScanEvent> scanListener;
    private final int sleepTimeOnIdle;
    private AtomicReference<FileWatcher> watcher = new AtomicReference();
    private AtomicReference<FileWatcherQueue> fileWatcherQueue = new AtomicReference();

    public RealtimeScanner(Client client, Path mainDir, List<Path> secondaryDirs, Predicate<FileWatchEvent> scanApprover, Consumer<RealtimeScanEvent> scanListener, int sleepTimeOnIdle) {
        if (client == null) {
            throw new IllegalArgumentException("A 'client' must not be null!");
        }
        if (mainDir == null) {
            throw new IllegalArgumentException("A 'mainDir' must not be null!");
        }
        if (!Files.isDirectory(mainDir, new LinkOption[0])) {
            throw new IllegalArgumentException("The realtime scanner 'mainDir' is not an existing directory!");
        }
        this.client = client;
        this.mainDir = mainDir;
        if (secondaryDirs != null) {
            this.secondaryDirs.addAll(secondaryDirs);
        }
        this.scanApprover = scanApprover;
        this.scanListener = scanListener;
        this.sleepTimeOnIdle = Math.max(1, sleepTimeOnIdle);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public synchronized void start() {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.fileWatcherQueue.set(new FileWatcherQueue(5000));
                this.watcher.set(new FileWatcher(this.mainDir, this::fileWatchEventListener, this::registerEventListener, this::errorEventListener, this::terminationEventListener));
            }
            catch (Exception ex) {
                this.running.set(false);
                throw ex;
            }
            this.watcher.get().register(this.secondaryDirs);
            Runnable runnable = () -> {
                while (this.running.get()) {
                    try {
                        FileWatcherQueue queue = this.fileWatcherQueue.get();
                        if (queue != null) {
                            int ii;
                            for (ii = 0; ii < 300 && this.running.get(); ++ii) {
                                File file = queue.pop();
                                if (!file.isFile()) continue;
                                Path path = file.toPath();
                                ScanResult result = this.client.scan(path);
                                if (this.scanListener == null) continue;
                                this.safeRun(() -> this.scanListener.accept(new RealtimeScanEvent(path, result)));
                            }
                            if (!queue.isEmpty()) continue;
                            for (ii = 0; ii < this.sleepTimeOnIdle && this.running.get(); ++ii) {
                                this.sleep(1);
                            }
                            continue;
                        }
                        this.sleep(2);
                    }
                    catch (Exception ex) {
                        this.sleep(2);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName("aviron-rtscan-" + threadCounter.getAndIncrement());
            thread.start();
        }
    }

    public synchronized void stop() {
        FileWatcher fw;
        if (this.running.compareAndSet(true, false) && (fw = this.watcher.get()) != null && fw.isRunning()) {
            fw.close();
        }
    }

    private void fileWatchEventListener(FileWatchEvent event) {
        FileWatcherQueue queue = this.fileWatcherQueue.get();
        switch (event.getType()) {
            case CREATED: 
            case MODIFIED: {
                try {
                    if (this.scanApprover != null && !this.scanApprover.test(event)) break;
                    queue.push(event.getPath().toFile());
                }
                catch (Exception exception) {}
                break;
            }
            case DELETED: {
                queue.remove(event.getPath().toFile());
                break;
            }
            case OVERFLOW: {
                break;
            }
        }
    }

    private void registerEventListener(FileWatchRegisterEvent event) {
    }

    private void errorEventListener(FileWatchErrorEvent event) {
    }

    private void terminationEventListener(FileWatchTerminationEvent event) {
    }

    private void sleep(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeRun(Runnable r) {
        try {
            r.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

