/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.impl.server;

import com.github.jlangch.aviron.FileSeparator;
import com.github.jlangch.aviron.dto.CommandRunDetails;
import com.github.jlangch.aviron.ex.CommunicationException;
import com.github.jlangch.aviron.impl.server.IntegerByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;

public class ServerIO {
    public static final String LOCALHOST = "localhost";
    public static final int DEFAULT_SERVER_PORT = 3310;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 3000;
    public static final int DEFAULT_READ_TIMEOUT = 20000;
    public static final FileSeparator DEFAULT_SERVER_FILESEPARATOR = FileSeparator.JVM_PLATFORM;
    private final InetSocketAddress server;
    private final FileSeparator serverFileSeparator;
    private final int connectionTimeout;
    private final int readTimeout;
    private CommandRunDetails lastCommandRunDetails;

    public ServerIO(String serverHostname, FileSeparator serverPlatform) {
        this(serverHostname, 3310, serverPlatform);
    }

    public ServerIO(String serverHostname, int serverPort, FileSeparator serverFileSeparator) {
        this(serverHostname, serverPort, serverFileSeparator, 3000, 20000);
    }

    public ServerIO(String serverHostname, int serverPort, FileSeparator serverFileSeparator, int connectionTimeoutMillis, int readTimeoutMillis) {
        this.server = new InetSocketAddress(serverHostname, serverPort);
        this.serverFileSeparator = serverFileSeparator;
        this.connectionTimeout = connectionTimeoutMillis;
        this.readTimeout = readTimeoutMillis;
    }

    public String getHostname() {
        return this.server.getHostName();
    }

    public int getPort() {
        return this.server.getPort();
    }

    public FileSeparator getFileSeparator() {
        return this.serverFileSeparator;
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeout;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeout;
    }

    public String toServerPath(Path path) {
        return this.serverFileSeparator.toServerPath(path);
    }

    public CommandRunDetails getLastCommandRunDetails() {
        return this.lastCommandRunDetails;
    }

    public boolean isReachable() {
        return this.isReachable(this.connectionTimeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isReachable(int timeoutMillis) {
        try (SocketChannel socketChannel = SelectorProvider.provider().openSocketChannel();){
            socketChannel.configureBlocking(true);
            socketChannel.socket().connect(this.server, timeoutMillis);
            boolean bl = true;
            return bl;
        }
        catch (ConnectException | SocketTimeoutException ex) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sendCommandAndReturnResponse(String rawCommand) {
        long start = System.currentTimeMillis();
        try (SocketChannel socketChannel = SocketChannel.open(this.server);){
            if (this.readTimeout > 0) {
                socketChannel.socket().setSoTimeout(this.readTimeout);
            }
            ByteBuffer command = ByteBuffer.wrap(rawCommand.getBytes(StandardCharsets.UTF_8));
            socketChannel.write(command);
            String response = this.readResponse(socketChannel);
            long elapsed = System.currentTimeMillis() - start;
            this.lastCommandRunDetails = new CommandRunDetails(rawCommand, response, elapsed);
            String string = response;
            return string;
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sendCommandWithDataAndReturnResponse(String rawCommand, InputStream inputStream, int chunkSize) {
        long start = System.currentTimeMillis();
        try (SocketChannel socketChannel = SocketChannel.open(this.server);){
            int readBytes;
            if (this.readTimeout > 0) {
                socketChannel.socket().setSoTimeout(this.readTimeout);
            }
            ByteBuffer command = ByteBuffer.wrap(rawCommand.getBytes(StandardCharsets.UTF_8));
            socketChannel.write(command);
            IntegerByteBuffer chunkSizeBuffer = new IntegerByteBuffer();
            byte[] data = new byte[chunkSize];
            while ((readBytes = inputStream.read(data)) != -1) {
                chunkSizeBuffer.putInt(readBytes);
                socketChannel.write(chunkSizeBuffer.getByteBuffer());
                socketChannel.write(ByteBuffer.wrap(data, 0, readBytes));
            }
            chunkSizeBuffer.putInt(0);
            socketChannel.write(chunkSizeBuffer.getByteBuffer());
            String response = this.readResponse(socketChannel);
            long elapsed = System.currentTimeMillis() - start;
            this.lastCommandRunDetails = new CommandRunDetails(rawCommand, response, elapsed);
            String string = response;
            return string;
        }
        catch (IOException ex) {
            throw new CommunicationException(ex);
        }
    }

    private String readResponse(SocketChannel socketChannel) throws IOException {
        ByteBuffer readBuffer = ByteBuffer.allocate(32);
        byte[] responseBytes = new byte[]{};
        int readSize = socketChannel.read(readBuffer);
        while (readSize > -1) {
            byte[] readArray = Arrays.copyOf(readBuffer.array(), readSize);
            byte[] combined = new byte[responseBytes.length + readArray.length];
            System.arraycopy(responseBytes, 0, combined, 0, responseBytes.length);
            System.arraycopy(readArray, 0, combined, responseBytes.length, readArray.length);
            responseBytes = combined;
            readBuffer.clear();
            readSize = socketChannel.read(readBuffer);
        }
        return new String(responseBytes, StandardCharsets.UTF_8);
    }
}

