/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.impl.test;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;

public class TempFS {
    private final File root = this.createTempDir();
    private final File quarantineDir;
    private final File scanDir = new File(this.root, "scan");

    public TempFS() {
        this.quarantineDir = new File(this.root, "quarantine");
        this.scanDir.mkdir();
        this.quarantineDir.mkdir();
    }

    public int countScanFiles() {
        return this.scanDir.list().length;
    }

    public int countQuarantineFiles() {
        return this.quarantineDir.list().length;
    }

    public File createScanSubDir(String name) {
        File dir = new File(this.scanDir, name);
        dir.mkdir();
        return dir;
    }

    public File createScanFile(String name, String data) {
        return this.createFile(this.scanDir, name, data);
    }

    public File createQuarantineFile(String name, String data) {
        return this.createFile(this.quarantineDir, name, data);
    }

    public File getRoot() {
        return this.root;
    }

    public File getQuarantineDir() {
        return this.quarantineDir;
    }

    public File getScanDir() {
        return this.scanDir;
    }

    public void remove() {
        try {
            Files.walk(this.root.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to remove tempFS", ex);
        }
    }

    private File createFile(File dir, String name, String data) {
        File file = new File(dir, name);
        try {
            Files.write(file.toPath(), this.toBytes(data), new OpenOption[0]);
            return file;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create file", ex);
        }
    }

    private File createTempDir() {
        try {
            return Files.createTempDirectory("quarantine_", new FileAttribute[0]).toFile();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create tempFS", ex);
        }
    }

    private byte[] toBytes(String text) {
        return text.getBytes(Charset.defaultCharset());
    }
}

