/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.impl.util;

public class OS {
    public static OsType type() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            return OsType.Windows;
        }
        if (osName.startsWith("mac os x")) {
            return OsType.MacOSX;
        }
        if (osName.startsWith("linux")) {
            return OsType.Linux;
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return OsType.Unix;
        }
        return OsType.Unknown;
    }

    public static boolean isMacOSX() {
        return OsType.MacOSX == OS.type();
    }

    public static boolean isLinux() {
        return OsType.Linux == OS.type();
    }

    public static boolean isWindows() {
        return OsType.Windows == OS.type();
    }

    public static enum OsType {
        MacOSX,
        Unix,
        Linux,
        Windows,
        Unknown;

    }
}

