/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.impl.util;

import com.github.jlangch.aviron.ex.AvironException;
import com.github.jlangch.aviron.impl.util.OS;
import com.github.jlangch.aviron.impl.util.ShellBackgroundResult;
import com.github.jlangch.aviron.impl.util.ShellResult;
import com.github.jlangch.aviron.impl.util.Signal;
import com.github.jlangch.aviron.impl.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Shell {
    public static ShellResult execCmd(String ... command) throws IOException {
        String cmdFormatted = String.join((CharSequence)" ", Arrays.asList(command));
        try {
            Process proc = Runtime.getRuntime().exec(command);
            return Shell.getShellResult(proc);
        }
        catch (Exception ex) {
            throw new AvironException("Failed to run command: " + cmdFormatted, ex);
        }
    }

    public static ShellBackgroundResult execCmdBackground(String ... command) throws IOException {
        Shell.validateLinuxOrMacOSX("Shell::execCmdBackground");
        String cmdFormatted = String.join((CharSequence)" ", Arrays.asList(command));
        try {
            String cmd = cmdFormatted + " &";
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            if (proc.isAlive()) {
                return new ShellBackgroundResult(new ShellResult(null, null, 0), null);
            }
            return new ShellBackgroundResult(new ShellResult(null, null, proc.exitValue()), null);
        }
        catch (Exception ex) {
            throw new AvironException("Failed to run command: /bin/sh -c \"" + cmdFormatted + "/", ex);
        }
    }

    public static ShellBackgroundResult execCmdBackgroundNohup(String ... command) throws IOException {
        Shell.validateLinuxOrMacOSX("Shell::execCmdNohup");
        String cmdFormatted = String.join((CharSequence)" ", Arrays.asList(command));
        try {
            File nohup = File.createTempFile("nohup-", ".out");
            nohup.deleteOnExit();
            String cmd = "nohup " + cmdFormatted + " </dev/null &>" + nohup.getAbsolutePath() + " &";
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            if (proc.isAlive()) {
                return new ShellBackgroundResult(new ShellResult(null, null, 0), nohup);
            }
            return new ShellBackgroundResult(new ShellResult(Shell.slurp(nohup), null, proc.exitValue()), nohup);
        }
        catch (Exception ex) {
            throw new AvironException("Failed to run command: /bin/sh -c \"" + cmdFormatted + "/", ex);
        }
    }

    public static boolean isProcessAlive(String pid) {
        Shell.validateLinuxOrMacOSX("Shell::isProcessAlive");
        try {
            return Shell.execCmd("ps", "-p", pid).isZeroExitCode();
        }
        catch (IOException ex) {
            throw new AvironException("Failed to check if the process with the PID " + pid + " is alive!", ex);
        }
    }

    public static List<String> pgrep(String process) {
        Shell.validateLinuxOrMacOSX("Shell::pgrep");
        try {
            ShellResult r = Shell.execCmd("pgrep", "-x", process);
            return r.isZeroExitCode() ? r.getStdoutLines().stream().filter(s -> !StringUtils.isBlank(s)).collect(Collectors.toList()) : new ArrayList<String>();
        }
        catch (IOException ex) {
            throw new AvironException("Failed to get " + process + " PIDs", ex);
        }
    }

    public static void kill(Signal signal, String pid) {
        Shell.validateLinuxOrMacOSX("Shell::kill");
        if (!StringUtils.isBlank(pid)) {
            try {
                ShellResult r = Shell.execCmd("kill", "-" + signal.signal(), pid);
                if (!r.isZeroExitCode()) {
                    throw new AvironException("Failed to kill process (" + pid + ").\n\nExit code: " + r.getExitCode() + "\nError msg: " + r.getStderr());
                }
            }
            catch (IOException ex) {
                throw new AvironException("Failed to kill the process " + pid, ex);
            }
        }
    }

    public static void validateLinuxOrMacOSX(String fnName) {
        if (!OS.isLinux() && !OS.isMacOSX()) {
            throw new AvironException(fnName + " is available for Linux and MacOS only!");
        }
    }

    private static String slurp(InputStream is) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String string = br.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private static String slurp(File f) throws IOException {
        try {
            return new String(Files.readAllBytes(f.toPath()), Charset.defaultCharset());
        }
        catch (Exception ex) {
            return "\u00bb\u00bb\u00bb Error reading data from file: " + f.getPath();
        }
    }

    private static ShellResult getShellResult(Process proc) throws IOException, InterruptedException {
        int exitCode = proc.waitFor();
        String stdout = Shell.slurp(proc.getInputStream());
        String stderr = Shell.slurp(proc.getErrorStream());
        return new ShellResult(stdout, stderr, exitCode);
    }
}

