/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.impl.util;

import com.github.jlangch.aviron.ex.AvironException;
import com.github.jlangch.aviron.impl.util.ShellResult;
import com.github.jlangch.aviron.impl.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;

public class ShellBackgroundResult {
    private final ShellResult startResult;
    private final File nohupFile;

    public ShellBackgroundResult(ShellResult startResult, File nohupFile) {
        this.startResult = startResult;
        this.nohupFile = nohupFile;
    }

    public ShellResult getStartResult() {
        return this.startResult;
    }

    public File getNohupFile() {
        return this.nohupFile;
    }

    public String getNohupFileText() {
        if (this.nohupFile.isFile()) {
            try {
                return new String(Files.readAllBytes(this.nohupFile.toPath()), Charset.forName("UTF-8"));
            }
            catch (IOException ex) {
                throw new AvironException("Faile to read nohup file", ex);
            }
        }
        return null;
    }

    public String toString() {
        if (this.nohupFile.isFile()) {
            StringBuilder sb = new StringBuilder(this.startResult.toString());
            String nohup = StringUtils.trimToNull(this.getNohupFileText());
            if (nohup == null) {
                sb.append(System.lineSeparator());
                sb.append("[nohup]   empty");
                sb.append(System.lineSeparator());
            } else {
                sb.append(System.lineSeparator());
                sb.append("[nohup]");
                sb.append(System.lineSeparator());
                sb.append(nohup);
            }
            return sb.toString();
        }
        return this.startResult.toString();
    }
}

