/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.aviron.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class FileStoreMgr {
    private final File rootDir;
    private int lastDirIdx = -1;
    private final List<File> subDirs = new ArrayList<File>();

    public FileStoreMgr(File rootDir) {
        this.rootDir = rootDir;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public File nextDir() {
        if (this.subDirs.isEmpty()) {
            this.refresh();
        }
        if (this.subDirs.isEmpty()) {
            return null;
        }
        int dirIdx = this.lastDirIdx + 1;
        if (dirIdx >= this.subDirs.size()) {
            this.refresh();
            if (this.subDirs.isEmpty()) {
                return null;
            }
            dirIdx = 0;
        }
        this.lastDirIdx = dirIdx;
        return this.subDirs.get(dirIdx);
    }

    public void refresh() {
        this.subDirs.clear();
        this.subDirs.addAll(this.dirs());
        this.lastDirIdx = -1;
    }

    public String getLastDirName() {
        return this.lastDirIdx < 0 || this.lastDirIdx >= this.subDirs.size() - 1 ? null : this.subDirs.get(this.lastDirIdx).getName();
    }

    public void restoreLastDirName(String name) {
        this.lastDirIdx = this.getIndexOf(name);
    }

    private int getIndexOf(String name) {
        for (int ii = 0; ii < this.subDirs.size(); ++ii) {
            if (!this.subDirs.get(ii).getName().equals(name)) continue;
            return ii;
        }
        return -1;
    }

    private List<File> dirs() {
        return Arrays.stream(this.rootDir.listFiles()).filter(f -> f.isDirectory()).sorted().collect(Collectors.toList());
    }
}

