/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.PreCompiled;
import com.github.jlangch.venice.ValueException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.JavaInterceptor;
import java.util.Map;

public class Venice {
    private final JavaInterceptor interceptor;

    public Venice() {
        this(null);
    }

    public Venice(JavaInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public PreCompiled precompile(String scriptName, String script) {
        if (StringUtil.isBlank(scriptName)) {
            throw new IllegalArgumentException("A 'scriptName' must not be blank");
        }
        if (StringUtil.isBlank(script)) {
            throw new IllegalArgumentException("A 'script' must not be blank");
        }
        VeniceInterpreter venice = new VeniceInterpreter();
        return new PreCompiled(scriptName, venice.READ(script, scriptName), this.createEnv(venice, null));
    }

    public Object eval(PreCompiled precompiled) {
        if (precompiled == null) {
            throw new IllegalArgumentException("A 'precompiled' script must not be null");
        }
        return this.eval(precompiled, null);
    }

    public Object eval(PreCompiled precompiled, Map<String, Object> params) {
        if (precompiled == null) {
            throw new IllegalArgumentException("A 'precompiled' script must not be null");
        }
        try {
            JavaInterop.register(this.interceptor);
            VeniceInterpreter venice = new VeniceInterpreter();
            Env env = this.addParams(new Env(precompiled.getEnv()), params);
            VncVal result = venice.EVAL((VncVal)precompiled.getPrecompiled(), env);
            Object object = JavaInteropUtil.convertToJavaObject(result);
            return object;
        }
        catch (ValueException ex) {
            VncVal val = ex.getValue();
            throw new VncException(Types.isVncString(val) ? ((VncString)val).getValue() : val.toString());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            JavaInterop.unregister();
        }
    }

    public Object eval(String script) {
        if (StringUtil.isBlank(script)) {
            throw new IllegalArgumentException("A 'script' must not be blank");
        }
        return this.eval(null, script, null);
    }

    public Object eval(String script, Map<String, Object> params) {
        if (StringUtil.isBlank(script)) {
            throw new IllegalArgumentException("A 'script' must not be blank");
        }
        return this.eval(null, script, params);
    }

    public Object eval(String scriptName, String script, Map<String, Object> params) {
        if (StringUtil.isBlank(script)) {
            throw new IllegalArgumentException("A 'script' must not be blank");
        }
        try {
            JavaInterop.register(this.interceptor);
            VeniceInterpreter venice = new VeniceInterpreter();
            Env env = this.createEnv(venice, params);
            VncVal result = venice.RE(script, scriptName, env);
            Object object = JavaInteropUtil.convertToJavaObject(result);
            return object;
        }
        catch (ValueException ex) {
            VncVal val = ex.getValue();
            throw new VncException(Types.isVncString(val) ? ((VncString)val).getValue() : val.toString());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            JavaInterop.unregister();
        }
    }

    public static String getVersion() {
        return "0.6.0";
    }

    public void enableJavaInteropReflectionCache(boolean enable) {
        ReflectionAccessor.enableCache(enable);
    }

    public boolean isJavaInteropReflectionCacheEnabled() {
        return ReflectionAccessor.isCacheEnabled();
    }

    private Env createEnv(VeniceInterpreter venice, Map<String, Object> params) {
        Env env = venice.createEnv();
        this.addParams(env, params);
        return env;
    }

    private Env addParams(Env env, Map<String, Object> params) {
        if (params != null) {
            params.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                VncVal malVal = JavaInteropUtil.convertToVncVal(val);
                if (malVal != null) {
                    VncSymbol symbol = new VncSymbol(key);
                    if (env.find(symbol) != null) {
                        throw new VncException(String.format("A parameter with the name '%' already exists", symbol.getName()));
                    }
                    env.set(symbol, malVal);
                }
            });
        }
        return env;
    }
}

