/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.ClassPathResource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ModuleLoader {
    private static final Map<String, String> modules = new HashMap<String, String>();
    private static final Set<String> validModules = new HashSet<String>(Arrays.asList("core", "json", "protocol"));

    public static String load(String module) {
        if (!validModules.contains(module)) {
            throw new VncException(String.format("The Venice core module '%s' does not exist", module));
        }
        String name = module + ".venice";
        try {
            return modules.computeIfAbsent(name, k -> new ClassPathResource("com/github/jlangch/venice/" + k).getResourceAsString("UTF-8"));
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load Venice core module '%s'", name), ex);
        }
    }
}

