/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.impl.javainterop.JavaImports;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;

public class JavaInteropFn
extends VncFunction {
    private final JavaImports javaImports;

    private JavaInteropFn(JavaImports javaImports) {
        super(".");
        this.javaImports = javaImports;
        this.setArgLists("(. classname :new args)", "(. object method args)", "(. classname :class)", "(. object :class)");
        this.setDoc("Java interop. Calls a constructor or an object method. The function is sandboxed");
        this.setExamples("(. :java.lang.Math :PI)", "(. :java.lang.Long :new 10)", "(. (. :java.lang.Long :new 10) :toString)", "(. :java.lang.Math :min 10 20)", "(. :java.lang.Math :class)", "(. \"java.lang.Math\" :class)", "(. (. :java.io.File :new \"/temp\") :class)");
    }

    public static JavaInteropFn create(JavaImports javaImports) {
        return new JavaInteropFn(javaImports);
    }

    @Override
    public VncVal apply(VncList args) {
        JavaInterop.getInterceptor().checkBlackListedVeniceFunction(".", args);
        return JavaInteropUtil.applyJavaAccess(args, this.javaImports);
    }
}

