/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncVal;
import java.math.BigDecimal;

public class VncLong
extends VncVal {
    private final Long value;

    public VncLong(Long v) {
        this.value = v;
    }

    public VncLong(Integer v) {
        this.value = v.longValue();
    }

    @Override
    public VncLong copy() {
        VncLong v = new VncLong(this.value);
        v.setMeta(this.getMeta());
        return v;
    }

    public Long getValue() {
        return this.value;
    }

    public VncLong add(VncVal other) {
        if (other instanceof VncLong) {
            return new VncLong(this.value + ((VncLong)other).getValue());
        }
        if (other instanceof VncDouble) {
            return new VncLong(this.value + ((VncDouble)other).getValue().longValue());
        }
        if (other instanceof VncBigDecimal) {
            return new VncLong(this.value + ((VncBigDecimal)other).getValue().longValue());
        }
        throw new VncException(String.format("Function '+' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncLong subtract(VncVal other) {
        if (other instanceof VncLong) {
            return new VncLong(this.value - ((VncLong)other).getValue());
        }
        if (other instanceof VncDouble) {
            return new VncLong(this.value - ((VncDouble)other).getValue().longValue());
        }
        if (other instanceof VncBigDecimal) {
            return new VncLong(this.value - ((VncBigDecimal)other).getValue().longValue());
        }
        throw new VncException(String.format("Function '-' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncLong multiply(VncVal other) {
        if (other instanceof VncLong) {
            return new VncLong(this.value * ((VncLong)other).getValue());
        }
        if (other instanceof VncDouble) {
            return new VncLong(this.value * ((VncDouble)other).getValue().longValue());
        }
        if (other instanceof VncBigDecimal) {
            return new VncLong(this.value * ((VncBigDecimal)other).getValue().longValue());
        }
        throw new VncException(String.format("Function '*' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncLong divide(VncVal other) {
        if (other instanceof VncLong) {
            return new VncLong(this.value / ((VncLong)other).getValue());
        }
        if (other instanceof VncDouble) {
            return new VncLong(this.value / ((VncDouble)other).getValue().longValue());
        }
        if (other instanceof VncBigDecimal) {
            return new VncLong(this.value / ((VncBigDecimal)other).getValue().longValue());
        }
        throw new VncException(String.format("Function '/' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncLong inc() {
        return new VncLong(this.value + 1L);
    }

    public VncLong dec() {
        return new VncLong(this.value - 1L);
    }

    public VncConstant lt(VncVal other) {
        if (other instanceof VncLong) {
            return this.value < ((VncLong)other).getValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncDouble) {
            return (double)this.value.longValue() < ((VncDouble)other).getValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncBigDecimal) {
            return new BigDecimal(this.value).compareTo(((VncBigDecimal)other).getValue()) < 0 ? Constants.True : Constants.False;
        }
        throw new VncException(String.format("Function '<' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncConstant lte(VncVal other) {
        if (other instanceof VncLong) {
            return this.value <= ((VncLong)other).getValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncDouble) {
            return (double)this.value.longValue() <= ((VncDouble)other).getValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncBigDecimal) {
            return new BigDecimal(this.value).compareTo(((VncBigDecimal)other).getValue()) <= 0 ? Constants.True : Constants.False;
        }
        throw new VncException(String.format("Function '<=' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncConstant gt(VncVal other) {
        if (other instanceof VncLong) {
            return this.value > ((VncLong)other).getValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncDouble) {
            return (double)this.value.longValue() > ((VncDouble)other).getValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncBigDecimal) {
            return new BigDecimal(this.value).compareTo(((VncBigDecimal)other).getValue()) > 0 ? Constants.True : Constants.False;
        }
        throw new VncException(String.format("Function '>' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncConstant gte(VncVal other) {
        if (other instanceof VncLong) {
            return this.value >= ((VncLong)other).getValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncDouble) {
            return (double)this.value.longValue() >= ((VncDouble)other).getValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncBigDecimal) {
            return new BigDecimal(this.value).compareTo(((VncBigDecimal)other).getValue()) >= 0 ? Constants.True : Constants.False;
        }
        throw new VncException(String.format("Function '>=' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncDouble toDouble() {
        return new VncDouble((double)this.value);
    }

    public VncBigDecimal toDecimal() {
        return new VncBigDecimal(new BigDecimal(this.value));
    }

    @Override
    public int compareTo(VncVal o) {
        return Types.isVncLong(o) ? this.getValue().compareTo(((VncLong)o).getValue()) : 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncLong other = (VncLong)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString();
    }
}

