/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.ValueException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Doc;
import com.github.jlangch.venice.impl.ErrorMessage;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Reader;
import com.github.jlangch.venice.impl.Readline;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncJavaMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaObject;
import com.github.jlangch.venice.impl.types.collections.VncJavaSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncSortedMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class CoreFunctions {
    public static VncFunction doc = new VncFunction("doc"){
        {
            this.setArgLists("(doc name)");
            this.setDoc("Returns the documentation for the function/macro with the given name");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("doc", args, 1);
            return new VncString(Doc.getDoc(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction throw_ex = new VncFunction("throw"){
        {
            this.setArgLists("(throw)", "(throw x)");
            this.setDoc("Throws exception with passed value x");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                throw new ValueException(Constants.Nil);
            }
            if (Types.isVncJavaObject(args.nth(0))) {
                Object obj = ((VncJavaObject)args.nth(0)).getDelegate();
                if (obj instanceof RuntimeException) {
                    throw (RuntimeException)obj;
                }
                if (obj instanceof Exception) {
                    throw new RuntimeException((Exception)obj);
                }
                throw new RuntimeException(obj.toString());
            }
            throw new ValueException(args.nth(0));
        }
    };
    public static VncFunction nil_Q = new VncFunction("nil?"){
        {
            this.setArgLists("(nil? x)");
            this.setDoc("Returns true if x is nil, false otherwise");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("nil?", args, 1);
            return args.nth(0) == Constants.Nil ? Constants.True : Constants.False;
        }
    };
    public static VncFunction some_Q = new VncFunction("some?"){
        {
            this.setArgLists("(some? x)");
            this.setDoc("Returns true if x is not nil, false otherwise");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("nil?", args, 1);
            return args.nth(0) == Constants.Nil ? Constants.False : Constants.True;
        }
    };
    public static VncFunction true_Q = new VncFunction("true?"){
        {
            this.setArgLists("(true? x)");
            this.setDoc("Returns true if x is true, false otherwise");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("true?", args, 1);
            return args.nth(0) == Constants.True ? Constants.True : Constants.False;
        }
    };
    public static VncFunction false_Q = new VncFunction("false?"){
        {
            this.setArgLists("(false? x)");
            this.setDoc("Returns true if x is false, false otherwise");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("false?", args, 1);
            return args.nth(0) == Constants.False ? Constants.True : Constants.False;
        }
    };
    public static VncFunction boolean_Q = new VncFunction("boolean?"){
        {
            this.setArgLists("(boolean? n)");
            this.setDoc("Returns true if n is a boolean");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("boolean?", args, 1);
            return args.nth(0) == Constants.True || args.nth(0) == Constants.False ? Constants.True : Constants.False;
        }
    };
    public static VncFunction long_Q = new VncFunction("long?"){
        {
            this.setArgLists("(long? n)");
            this.setDoc("Returns true if n is a long");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("long?", args, 1);
            return Types.isVncLong(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction double_Q = new VncFunction("double?"){
        {
            this.setArgLists("(double? n)");
            this.setDoc("Returns true if n is a double");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("double?", args, 1);
            return Types.isVncDouble(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction decimal_Q = new VncFunction("decimal?"){
        {
            this.setArgLists("(decimal? n)");
            this.setDoc("Returns true if n is a decimal");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("decimal?", args, 1);
            return Types.isVncBigDecimal(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction number_Q = new VncFunction("number?"){
        {
            this.setArgLists("(number? n)");
            this.setDoc("Returns true if n is a number (long, double, or decimal)");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("number?", args, 1);
            return Types.isVncLong(args.nth(0)) || Types.isVncDouble(args.nth(0)) || Types.isVncBigDecimal(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction bytebuf_Q = new VncFunction("bytebuf?"){
        {
            this.setArgLists("(bytebuf? x)");
            this.setDoc("Returns true if x is a bytebuf");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("bytebuf?", args, 1);
            return Types.isVncByteBuffer(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction string_Q = new VncFunction("string?"){
        {
            this.setArgLists("(string? x)");
            this.setDoc("Returns true if x is a string");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("string?", args, 1);
            if (args.nth(0) instanceof VncKeyword) {
                return Constants.False;
            }
            if (args.nth(0) instanceof VncString) {
                return Constants.True;
            }
            return Constants.False;
        }
    };
    public static VncFunction symbol = new VncFunction("symbol"){
        {
            this.setArgLists("(symbol name)");
            this.setDoc("Returns a symbol from the given name");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("symbol", args, 1);
            return new VncSymbol((VncString)args.nth(0));
        }
    };
    public static VncFunction symbol_Q = new VncFunction("symbol?"){
        {
            this.setArgLists("(symbol? x)");
            this.setDoc("Returns true if x is a symbol");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("symbol?", args, 1);
            return Types.isVncSymbol(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction keyword = new VncFunction("keyword"){
        {
            this.setArgLists("(keyword name)");
            this.setDoc("Returns a keyword from the given name");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("keyword", args, 1);
            if (Types.isVncKeyword(args.nth(0))) {
                return args.nth(0);
            }
            if (Types.isVncString(args.nth(0))) {
                return new VncKeyword(((VncString)args.nth(0)).getValue());
            }
            throw new VncException(String.format("Function 'keyword' does not allow %s name. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction keyword_Q = new VncFunction("keyword?"){
        {
            this.setArgLists("(keyword? x)");
            this.setDoc("Returns true if x is a keyword");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("keyword?", args, 1);
            return Types.isVncKeyword(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction fn_Q = new VncFunction("fn?"){
        {
            this.setArgLists("(fn? x)");
            this.setDoc("Returns true if x is a function");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("fn?", args, 1);
            if (!Types.isVncFunction(args.nth(0))) {
                return Constants.False;
            }
            return ((VncFunction)args.nth(0)).isMacro() ? Constants.False : Constants.True;
        }
    };
    public static VncFunction macro_Q = new VncFunction("macro?"){
        {
            this.setArgLists("(macro? x)");
            this.setDoc("Returns true if x is a macro");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("macro?", args, 1);
            if (!Types.isVncFunction(args.nth(0))) {
                return Constants.False;
            }
            return ((VncFunction)args.nth(0)).isMacro() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction pr_str = new VncFunction("pr-str"){
        {
            this.setArgLists("(pr_str & xs)");
            this.setDoc("With no args, returns the empty string. With one arg x, returns x.toString(). With more than one arg, returns the concatenation of the str values of the args with delimiter ' '.");
        }

        @Override
        public VncVal apply(VncList args) {
            return args.isEmpty() ? new VncString("") : new VncString(args.getList().stream().map(v -> Printer._pr_str(v, true)).collect(Collectors.joining(" ")));
        }
    };
    public static VncFunction str = new VncFunction("str"){
        {
            this.setArgLists("(str & xs)");
            this.setDoc("With no args, returns the empty string. With one arg x, returns x.toString(). (str nil) returns the empty string. With more than one arg, returns the concatenation of the str values of the args.");
        }

        @Override
        public VncVal apply(VncList args) {
            return args.isEmpty() ? new VncString("") : new VncString(args.getList().stream().filter(v -> v != Constants.Nil).map(v -> Printer._pr_str(v, false)).collect(Collectors.joining("")));
        }
    };
    public static VncFunction prn = new VncFunction("prn"){
        {
            this.setArgLists("(prn & xs)");
            this.setDoc("Prints to stdout, with no args, prints the empty string. With one arg x, prints x.toString(). With more than one arg, prints the concatenation of the str values of the args with delimiter ' '.The function is sandboxed.");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().checkBlackListedVeniceFunction("prn", args);
            System.out.print(args.isEmpty() ? new VncString("") : new VncString(args.getList().stream().map(v -> Printer._pr_str(v, true)).collect(Collectors.joining(" "))));
            return Constants.Nil;
        }
    };
    public static VncFunction println = new VncFunction("println"){
        {
            this.setArgLists("(println & xs)");
            this.setDoc("Prints to stdout with a tailing linefeed, with no args, prints the empty string. With one arg x, prints x.toString(). With more than one arg, prints the concatenation of the str values of the args with delimiter ' '.The function is sandboxed.");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().checkBlackListedVeniceFunction("println", args);
            System.out.println(args.isEmpty() ? new VncString("") : new VncString(args.getList().stream().map(v -> Printer._pr_str(v, true)).collect(Collectors.joining(" "))));
            return Constants.Nil;
        }
    };
    public static VncFunction readline = new VncFunction("readline"){
        {
            this.setArgLists("(readline prompt)");
            this.setDoc("Reads the next line from stdin. The function is sandboxed");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().checkBlackListedVeniceFunction("readline", args);
            String prompt = Coerce.toVncString(args.nth(0)).getValue();
            try {
                return new VncString(Readline.readline(prompt));
            }
            catch (IOException ex) {
                throw new ValueException(new VncString(ex.getMessage()), (Throwable)ex);
            }
            catch (EofException e) {
                return Constants.Nil;
            }
        }
    };
    public static VncFunction read_string = new VncFunction("read-string"){
        {
            this.setArgLists("(read-string x)");
            this.setDoc("Reads from x");
        }

        @Override
        public VncVal apply(VncList args) {
            try {
                CoreFunctions.assertArity("read-string", args, 1);
                return Reader.read_str(Coerce.toVncString(args.nth(0)).getValue(), null);
            }
            catch (ContinueException c) {
                return Constants.Nil;
            }
        }
    };
    public static VncFunction slurp = new VncFunction("slurp"){
        {
            this.setArgLists("(slurp file & options)");
            this.setDoc("Returns the file's content as text (string) or binary (bytebuf). Defaults to binary=false and encoding=UTF-8. Options: :encoding \"UTF-8\" :binary true/false. ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().checkBlackListedVeniceFunction("slurp", args);
            try {
                File file;
                if (Types.isVncString(args.nth(0))) {
                    file = new File(((VncString)args.nth(0)).getValue());
                } else if (CoreFunctions.isJavaIoFile(args.nth(0))) {
                    file = (File)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                } else {
                    throw new VncException(String.format("Function 'slurp' does not allow %s as f. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
                }
                VncHashMap options = new VncHashMap(args.slice(1));
                VncVal binary = options.get(new VncKeyword("binary"));
                if (binary == Constants.True) {
                    byte[] data = Files.readAllBytes(file.toPath());
                    return new VncByteBuffer(ByteBuffer.wrap(data));
                }
                VncVal encVal = options.get(new VncKeyword("encoding"));
                String encoding = encVal == Constants.Nil ? "UTF-8" : Coerce.toVncString(encVal).getValue();
                byte[] data = Files.readAllBytes(file.toPath());
                return new VncString(new String(data, encoding));
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction spit = new VncFunction("spit"){
        {
            this.setArgLists("(spit f content & options)");
            this.setDoc("Opens f, writes content, and then closes f. Defaults to append=true and encoding=UTF-8. Options: :append true/false, :encoding \"UTF-8\"");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().checkBlackListedVeniceFunction("spit", args);
            try {
                byte[] data;
                String encoding;
                File file;
                if (Types.isVncString(args.nth(0))) {
                    file = new File(((VncString)args.nth(0)).getValue());
                } else if (CoreFunctions.isJavaIoFile(args.nth(0))) {
                    file = (File)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                } else {
                    throw new VncException(String.format("Function 'spit' does not allow %s as f. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
                }
                VncVal content = args.nth(1);
                VncHashMap options = new VncHashMap(args.slice(2));
                VncVal append = options.get(new VncKeyword("append"));
                VncVal encVal = options.get(new VncKeyword("encoding"));
                String string = encoding = encVal == Constants.Nil ? "UTF-8" : ((VncString)encVal).getValue();
                if (Types.isVncString(content)) {
                    data = ((VncString)content).getValue().getBytes(encoding);
                } else if (Types.isVncByteBuffer(content)) {
                    data = ((VncByteBuffer)content).getValue().array();
                } else {
                    throw new VncException(String.format("Function 'spit' does not allow %s as content. %s", Types.getClassName(content), ErrorMessage.buildErrLocation(args)));
                }
                ArrayList<StandardOpenOption> openOptions = new ArrayList<StandardOpenOption>();
                openOptions.add(StandardOpenOption.CREATE);
                openOptions.add(StandardOpenOption.WRITE);
                if (append != Constants.False) {
                    openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
                }
                Files.write(file.toPath(), data, openOptions.toArray(new OpenOption[0]));
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction loadCoreModule = new VncFunction("load-core-module"){

        @Override
        public VncVal apply(VncList args) {
            try {
                CoreFunctions.assertArity("load-core-module", args, 1);
                VncVal name = args.first();
                if (Types.isVncString(name)) {
                    String module = ModuleLoader.load(((VncString)args.first()).getValue());
                    return new VncString(module);
                }
                if (Types.isVncSymbol(name)) {
                    String module = ModuleLoader.load(((VncSymbol)args.first()).getName());
                    return new VncString(module);
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction decimalScale = new VncFunction("dec/scale"){
        {
            this.setArgLists("(dec/scale x scale rounding-mode)");
            this.setDoc("Scales a decimal. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("dec/scale", args, 3);
            VncVal arg = args.nth(0);
            VncLong scale = Coerce.toVncLong(args.nth(1));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode((VncString)args.nth(2));
            if (Types.isVncBigDecimal(arg)) {
                BigDecimal val = ((VncBigDecimal)arg).getValue();
                return new VncBigDecimal(val.setScale(scale.getValue().intValue(), roundingMode));
            }
            throw new VncException(String.format("Function 'dec/scale' does not allow %s as operand 1. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction decimalAdd = new VncFunction("dec/add"){
        {
            this.setArgLists("(dec/add x y scale rounding-mode)");
            this.setDoc("Adds two decimals and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("dec/add", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.nth(0));
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.nth(1));
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().add(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction decimalSubtract = new VncFunction("dec/sub"){
        {
            this.setArgLists("(dec/sub x y scale rounding-mode)");
            this.setDoc("Subtract y from x and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("dec/sub", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.nth(0));
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.nth(1));
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().subtract(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction decimalMultiply = new VncFunction("dec/mul"){
        {
            this.setArgLists("(dec/mul x y scale rounding-mode)");
            this.setDoc("Multiplies two decimals and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("dec/mul", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.nth(0));
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.nth(1));
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().multiply(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction decimalDivide = new VncFunction("dec/div"){
        {
            this.setArgLists("(dec/div x y scale rounding-mode)");
            this.setDoc("Divides x by y and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("dec/div", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.nth(0));
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.nth(1));
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().divide(op2.getValue(), scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction add = new VncFunction("+"){
        {
            this.setArgLists("(+)", "(+ x)", "(+ x y)", "(+ x y & more)");
            this.setDoc("Returns the sum of the numbers. (+) returns 0.");
            this.setExamples("(+)", "(+ 1)", "(+ 1 2)", "(+ 1 2 3 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                return new VncLong(0);
            }
            if (args.size() == 1) {
                return args.nth(0);
            }
            VncVal first = args.nth(0);
            VncList rest = args.slice(1);
            if (Types.isVncLong(first)) {
                VncLong val = (VncLong)first;
                for (VncVal v : rest.getList()) {
                    val = val.add(v);
                }
                return val;
            }
            if (Types.isVncDouble(first)) {
                VncDouble val = (VncDouble)first;
                for (VncVal v : rest.getList()) {
                    val = val.add(v);
                }
                return val;
            }
            if (Types.isVncBigDecimal(first)) {
                VncBigDecimal val = (VncBigDecimal)first;
                for (VncVal v : rest.getList()) {
                    val = val.add(v);
                }
                return val;
            }
            throw new VncException(String.format("Invalid argument type %s while calling function '+'. %s", Types.getClassName(first), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction subtract = new VncFunction("-"){
        {
            this.setArgLists("(- x)", "(- x y)", "(- x y & more)");
            this.setDoc("If one number is supplied, returns the negation, else subtracts the numbers from x and returns the result.");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                throw new ArityException(args, 0, "-");
            }
            if (args.size() == 1) {
                VncVal first = args.nth(0);
                if (Types.isVncLong(first)) {
                    return ((VncLong)first).multiply(new VncLong(-1L));
                }
                if (Types.isVncDouble(first)) {
                    return ((VncDouble)first).multiply(new VncDouble(-1.0));
                }
                if (Types.isVncBigDecimal(first)) {
                    return ((VncBigDecimal)first).multiply(new VncBigDecimal(new BigDecimal("-1.0")));
                }
                return first;
            }
            VncVal first = args.nth(0);
            VncList rest = args.slice(1);
            if (Types.isVncLong(first)) {
                VncLong val = (VncLong)first;
                for (VncVal v : rest.getList()) {
                    val = val.subtract(v);
                }
                return val;
            }
            if (Types.isVncDouble(first)) {
                VncDouble val = (VncDouble)first;
                for (VncVal v : rest.getList()) {
                    val = val.subtract(v);
                }
                return val;
            }
            if (Types.isVncBigDecimal(first)) {
                VncBigDecimal val = (VncBigDecimal)first;
                for (VncVal v : rest.getList()) {
                    val = val.subtract(v);
                }
                return val;
            }
            throw new VncException(String.format("Invalid argument type %s while calling function '-'. %s", Types.getClassName(first), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction multiply = new VncFunction("*"){
        {
            this.setArgLists("(*)", "(* x)", "(* x y)", "(* x y & more)");
            this.setDoc("Returns the product of numbers. (*) returns 1");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                return new VncLong(1);
            }
            if (args.size() == 1) {
                return args.nth(0);
            }
            VncVal first = args.nth(0);
            VncList rest = args.slice(1);
            if (Types.isVncLong(first)) {
                VncLong val = (VncLong)first;
                for (VncVal v : rest.getList()) {
                    val = val.multiply(v);
                }
                return val;
            }
            if (Types.isVncDouble(first)) {
                VncDouble val = (VncDouble)first;
                for (VncVal v : rest.getList()) {
                    val = val.multiply(v);
                }
                return val;
            }
            if (Types.isVncBigDecimal(first)) {
                VncBigDecimal val = (VncBigDecimal)first;
                for (VncVal v : rest.getList()) {
                    val = val.multiply(v);
                }
                return val;
            }
            throw new VncException(String.format("Invalid argument type %s while calling function '*'. %s", Types.getClassName(first), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction divide = new VncFunction("/"){
        {
            this.setArgLists("(/ x)", "(/ x y)", "(/ x y & more)");
            this.setDoc("If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators.");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                throw new ArityException(args, 0, "/");
            }
            if (args.size() == 1) {
                VncVal first = args.nth(0);
                if (Types.isVncLong(first)) {
                    return new VncLong(1L).divide((VncLong)first);
                }
                if (Types.isVncDouble(first)) {
                    return new VncDouble(1.0).divide((VncDouble)first);
                }
                if (Types.isVncBigDecimal(first)) {
                    return new VncBigDecimal(BigDecimal.ONE).divide((VncBigDecimal)first);
                }
                return first;
            }
            VncVal first = args.nth(0);
            VncList rest = args.slice(1);
            if (Types.isVncLong(first)) {
                VncLong val = (VncLong)first;
                for (VncVal v : rest.getList()) {
                    val = val.divide(v);
                }
                return val;
            }
            if (Types.isVncDouble(first)) {
                VncDouble val = (VncDouble)first;
                for (VncVal v : rest.getList()) {
                    val = val.divide(v);
                }
                return val;
            }
            if (Types.isVncBigDecimal(first)) {
                VncBigDecimal val = (VncBigDecimal)first;
                for (VncVal v : rest.getList()) {
                    val = val.divide(v);
                }
                return val;
            }
            throw new VncException(String.format("Invalid argument type %s while calling function '/'. %s", Types.getClassName(first), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction modulo = new VncFunction("mod"){
        {
            this.setArgLists("(mod n d)");
            this.setDoc("Modulus of n and d.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("abs", args, 2);
            if (!Types.isVncLong(args.nth(0))) {
                throw new VncException(String.format("Function 'mod' does not allow %s as numerator. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            if (!Types.isVncLong(args.nth(1))) {
                throw new VncException(String.format("Function 'mod' does not allow %s as denominator. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
            }
            return new VncLong(((VncLong)args.nth(0)).getValue() % ((VncLong)args.nth(1)).getValue());
        }
    };
    public static VncFunction inc = new VncFunction("inc"){
        {
            this.setArgLists("(inc x)");
            this.setDoc("Increments the number x");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("inc", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncLong(arg)) {
                return ((VncLong)arg).inc();
            }
            if (Types.isVncDouble(arg)) {
                return ((VncDouble)arg).inc();
            }
            if (Types.isVncBigDecimal(arg)) {
                return ((VncBigDecimal)arg).inc();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'inc'. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction dec = new VncFunction("dec"){
        {
            this.setArgLists("(dec x)");
            this.setDoc("Decrements the number x");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("dec", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncLong(arg)) {
                return ((VncLong)arg).dec();
            }
            if (Types.isVncDouble(arg)) {
                return ((VncDouble)arg).dec();
            }
            if (Types.isVncBigDecimal(arg)) {
                return ((VncBigDecimal)arg).dec();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'dec'. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction max = new VncFunction("max"){
        {
            this.setArgLists("(max x)", "(max x y)", "(max x y & more)");
            this.setDoc("Returns the greatest of the values");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal op1;
            if (args.isEmpty()) {
                throw new ArityException(args, 0, "max");
            }
            VncVal max = op1 = args.nth(0);
            for (VncVal op : args.rest().getList()) {
                if (Types.isVncLong(max)) {
                    max = ((VncLong)max).gte(op) == Constants.True ? max : op;
                    continue;
                }
                if (Types.isVncDouble(max)) {
                    max = ((VncDouble)max).gte(op) == Constants.True ? max : op;
                    continue;
                }
                if (Types.isVncBigDecimal(max)) {
                    max = ((VncBigDecimal)max).gte(op) == Constants.True ? max : op;
                    continue;
                }
                throw new VncException(String.format("Function 'max' does not allow %s as operand 1. %s", Types.getClassName(max), ErrorMessage.buildErrLocation(args)));
            }
            return max;
        }
    };
    public static VncFunction min = new VncFunction("min"){
        {
            this.setArgLists("(min x)", "(min x y)", "(min x y & more)");
            this.setDoc("Returns the smallest of the values");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal op1;
            if (args.isEmpty()) {
                throw new ArityException(args, 0, "min");
            }
            VncVal min = op1 = args.nth(0);
            for (VncVal op : args.rest().getList()) {
                if (Types.isVncLong(min)) {
                    min = ((VncLong)min).lte(op) == Constants.True ? min : op;
                    continue;
                }
                if (Types.isVncDouble(min)) {
                    min = ((VncDouble)min).lte(op) == Constants.True ? min : op;
                    continue;
                }
                if (Types.isVncBigDecimal(min)) {
                    min = ((VncBigDecimal)min).lte(op) == Constants.True ? min : op;
                    continue;
                }
                throw new VncException(String.format("Function 'min' does not allow %s as operand 1. %s", Types.getClassName(min), ErrorMessage.buildErrLocation(args)));
            }
            return min;
        }
    };
    public static VncFunction abs = new VncFunction("abs"){
        {
            this.setArgLists("(abs x)");
            this.setDoc("Returns the absolute value of the number");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("abs", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncLong(arg)) {
                return new VncLong(Math.abs(((VncLong)arg).getValue()));
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(Math.abs(((VncDouble)arg).getValue()));
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(((VncBigDecimal)arg).getValue().abs());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'abs'. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction rand_long = new VncFunction("rand-long"){
        {
            this.setArgLists("(rand-long)", "(rand-long max)");
            this.setDoc("Without argument returns a random long between 0 and MAX_LONG. Without argument max returns a random long between 0 and max exclusive.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("rand-long", args, 0, 1);
            if (args.isEmpty()) {
                return new VncLong(Math.abs(random.nextLong()));
            }
            long max = Coerce.toVncLong(args.first()).getValue();
            if (max < 2L) {
                throw new VncException("Function 'rand-long' does not allow negative max values");
            }
            return new VncLong(Math.abs(random.nextLong()) % max);
        }
    };
    public static VncFunction rand_double = new VncFunction("rand-double"){
        {
            this.setArgLists("(rand-double)", "(rand-double max)");
            this.setDoc("Without argument returns a double long between 0.0 and 1.0. Without argument max returns a random long between 0.0 and max.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("rand-double", args, 0, 1);
            if (args.isEmpty()) {
                return new VncDouble(random.nextDouble());
            }
            double max = Coerce.toVncDouble(args.first()).getValue();
            if (max < 0.0) {
                throw new VncException(String.format("Function 'rand-double' does not allow negative max values. %s", ErrorMessage.buildErrLocation(args)));
            }
            return new VncDouble(random.nextDouble() * max);
        }
    };
    public static VncFunction equal_Q = new VncFunction("=="){
        {
            this.setArgLists("(== x y)");
            this.setDoc("Returns true if both operands have the equivalent type");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("==", args, 2);
            return Types._equal_Q(args.nth(0), args.nth(1)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction not_equal_Q = new VncFunction("!="){
        {
            this.setArgLists("(!= x y)");
            this.setDoc("Returns true if both operands do not have the equivalent type");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("!=", args, 2);
            return Types._equal_Q(args.nth(0), args.nth(1)) ? Constants.False : Constants.True;
        }
    };
    public static VncFunction match_Q = new VncFunction("match"){
        {
            this.setArgLists("(match s regex)");
            this.setDoc("Returns true if the string s matches the regular expression regex");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("match", args, 2);
            if (!Types.isVncString(args.nth(0))) {
                throw new VncException(String.format("Invalid first argument type %s while calling function 'match'. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            if (!Types.isVncString(args.nth(1))) {
                throw new VncException(String.format("Invalid second argument type %s while calling function 'match'. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
            }
            return Types._match_Q(args.nth(0), args.nth(1)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction match_not_Q = new VncFunction("match-not"){
        {
            this.setArgLists("(match-not s regex)");
            this.setDoc("Returns true if the string s does not match the regular expression regex");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("match-not", args, 2);
            if (!Types.isVncString(args.nth(0))) {
                throw new VncException(String.format("Invalid first argument type %s while calling function 'match-not'. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            if (!Types.isVncString(args.nth(1))) {
                throw new VncException(String.format("Invalid second argument type %s while calling function 'match-not'. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
            }
            return Types._match_Q(args.nth(0), args.nth(1)) ? Constants.False : Constants.True;
        }
    };
    public static VncFunction lt = new VncFunction("<"){
        {
            this.setArgLists("(< x y)");
            this.setDoc("Returns true if x is smaller than y");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("<", args, 2);
            VncVal op1 = args.nth(0);
            VncVal op2 = args.nth(1);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).lt(op2);
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).lt(op2);
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).lt(op2);
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '<' with operand 1 of type %s does not allow %s as operand 2. %s", Types.getClassName(op1), Types.getClassName(op2), ErrorMessage.buildErrLocation(args)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) < 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '<' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction lte = new VncFunction("<="){
        {
            this.setArgLists("(<= x y)");
            this.setDoc("Returns true if x is smaller or equal to y");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("<=", args, 2);
            VncVal op1 = args.nth(0);
            VncVal op2 = args.nth(1);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).lte(op2);
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).lte(op2);
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).lte(op2);
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '<=' with operand 1 of type %s does not allow %s as operand 2. %s", Types.getClassName(op1), Types.getClassName(op2), ErrorMessage.buildErrLocation(args)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) <= 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '<=' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction gt = new VncFunction(">"){
        {
            this.setArgLists("(> x y)");
            this.setDoc("Returns true if x is greater than y");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity(">", args, 2);
            VncVal op1 = args.nth(0);
            VncVal op2 = args.nth(1);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).gt(op2);
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).gt(op2);
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).gt(op2);
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '>' with operand 1 of type %s does not allow %s as operand 2. %s", Types.getClassName(op1), Types.getClassName(op2), ErrorMessage.buildErrLocation(args)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) > 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '>' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction gte = new VncFunction(">="){
        {
            this.setArgLists("(>= x y)");
            this.setDoc("Returns true if x is greater or equal to y");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity(">=", args, 2);
            VncVal op1 = args.nth(0);
            VncVal op2 = args.nth(1);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).gte(op2);
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).gte(op2);
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).gte(op2);
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '>=' with operand 1 of type %s does not allow %s as operand 2. %s", Types.getClassName(op1), Types.getClassName(op2), ErrorMessage.buildErrLocation(args)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) >= 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '>=' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction zero_Q = new VncFunction("zero?"){
        {
            this.setArgLists("(zero? x)");
            this.setDoc("Returns true if x zero else false");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("zero?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() == 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).getValue() == 0.0 ? Constants.True : Constants.False;
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) == 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'zero' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction pos_Q = new VncFunction("pos?"){
        {
            this.setArgLists("(pos? x)");
            this.setDoc("Returns true if x greater than zero else false");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("pos?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() > 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).getValue() > 0.0 ? Constants.True : Constants.False;
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) > 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'pos' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction neg_Q = new VncFunction("neg?"){
        {
            this.setArgLists("(neg? x)");
            this.setDoc("Returns true if x smaller than zero else false");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("neg?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() < 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).getValue() < 0.0 ? Constants.True : Constants.False;
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) < 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'plus' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction even_Q = new VncFunction("even?"){
        {
            this.setArgLists("(even? n)");
            this.setDoc("Returns true if n is even, throws an exception if n is not an integer");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("even?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() % 2L == 0L ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'even' does not allow %s as operand. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction odd_Q = new VncFunction("odd?"){
        {
            this.setArgLists("(odd? n)");
            this.setDoc("Returns true if n is odd, throws an exception if n is not an integer");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("odd?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() % 2L == 1L ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'odd' does not allow %s as operand. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction time_ms = new VncFunction("time-ms"){
        {
            this.setArgLists("(time-ms)");
            this.setDoc("Returns the current time in milliseconds");
            this.setExamples("(time-ms)");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("time_ms", args, 0);
            return new VncLong(System.currentTimeMillis());
        }
    };
    public static VncFunction time_ns = new VncFunction("time-ns"){
        {
            this.setArgLists("(time-ns)");
            this.setDoc("Returns the current value of the running Java Virtual Machine's high-resolution time source, in nanoseconds.");
            this.setExamples("(time-ns)");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("time_ns", args, 0);
            return new VncLong(System.nanoTime());
        }
    };
    public static VncFunction boolean_cast = new VncFunction("boolean"){
        {
            this.setArgLists("(boolean x)");
            this.setDoc("Converts to boolean. Everything except 'false' and 'nil' is true in boolean context.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("boolean", args, 1);
            VncVal arg = args.nth(0);
            if (arg == Constants.Nil) {
                return Constants.False;
            }
            if (arg == Constants.False) {
                return Constants.False;
            }
            return Constants.True;
        }
    };
    public static VncFunction long_cast = new VncFunction("long"){
        {
            this.setArgLists("(long x)");
            this.setDoc("Converts to long");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("long", args, 1);
            VncVal op1 = args.nth(0);
            if (op1 == Constants.Nil) {
                return new VncLong(0);
            }
            if (op1 == Constants.False) {
                return new VncLong(0);
            }
            if (op1 == Constants.True) {
                return new VncLong(1);
            }
            if (Types.isVncLong(op1)) {
                return op1;
            }
            if (Types.isVncDouble(op1)) {
                return new VncLong(((VncDouble)op1).getValue().longValue());
            }
            if (Types.isVncBigDecimal(op1)) {
                return new VncLong(((VncBigDecimal)op1).getValue().longValue());
            }
            if (Types.isVncString(op1)) {
                String s = ((VncString)op1).getValue();
                try {
                    return new VncLong(Long.parseLong(s));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'long': the string %s can not be converted to a long. %s", s, ErrorMessage.buildErrLocation(args)));
                }
            }
            throw new VncException(String.format("Function 'long' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction double_cast = new VncFunction("double"){
        {
            this.setArgLists("(double x)");
            this.setDoc("Converts to double");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("double", args, 1);
            VncVal op1 = args.nth(0);
            if (op1 == Constants.Nil) {
                return new VncDouble(0.0);
            }
            if (op1 == Constants.False) {
                return new VncDouble(0.0);
            }
            if (op1 == Constants.True) {
                return new VncDouble(1.0);
            }
            if (Types.isVncLong(op1)) {
                return new VncDouble(((VncLong)op1).getValue().doubleValue());
            }
            if (Types.isVncDouble(op1)) {
                return op1;
            }
            if (Types.isVncBigDecimal(op1)) {
                return new VncDouble(((VncBigDecimal)op1).getValue().doubleValue());
            }
            if (Types.isVncString(op1)) {
                String s = ((VncString)op1).getValue();
                try {
                    return new VncDouble(Double.parseDouble(s));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'double': the string %s can not be converted to a double. %s", s, ErrorMessage.buildErrLocation(args)));
                }
            }
            throw new VncException(String.format("Function 'double' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction decimal_cast = new VncFunction("decimal"){
        {
            this.setArgLists("(decimal x) (decimal x scale rounding-mode)");
            this.setDoc("Converts to decimal. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            RoundingMode roundingMode;
            CoreFunctions.assertArity("decimal", args, 1, 3);
            if (args.isEmpty()) {
                return new VncBigDecimal(BigDecimal.ZERO);
            }
            VncVal arg = args.nth(0);
            VncLong scale = args.size() < 3 ? null : Coerce.toVncLong(args.nth(1));
            RoundingMode roundingMode2 = roundingMode = args.size() < 3 ? null : VncBigDecimal.toRoundingMode((VncString)args.nth(2));
            if (arg == Constants.Nil) {
                BigDecimal dec = BigDecimal.ZERO;
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (arg == Constants.False) {
                BigDecimal dec = BigDecimal.ZERO;
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (arg == Constants.True) {
                BigDecimal dec = BigDecimal.ONE;
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (Types.isVncString(arg)) {
                BigDecimal dec = new BigDecimal(((VncString)arg).getValue());
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (Types.isVncLong(arg)) {
                BigDecimal dec = new BigDecimal(((VncLong)arg).getValue());
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (Types.isVncDouble(arg)) {
                BigDecimal dec = VncBigDecimal.toDecimal((VncDouble)arg).getValue();
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (Types.isVncBigDecimal(arg)) {
                BigDecimal dec = ((VncBigDecimal)arg).getValue();
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            throw new VncException(String.format("Function 'decimal' does not allow %s as operand 1. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction bytebuf_cast = new VncFunction("bytebuf"){
        {
            this.setArgLists("(bytebuf x)");
            this.setDoc("Converts to bytebuf. x can be a bytebuf, a list/vector of longs, or a string");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("bytebuf", args, 0, 1);
            if (args.isEmpty()) {
                return new VncByteBuffer(ByteBuffer.wrap(new byte[0]));
            }
            VncVal arg = args.nth(0);
            if (Types.isVncString(arg)) {
                try {
                    return new VncByteBuffer(ByteBuffer.wrap(((VncString)arg).getValue().getBytes("UTF-8")));
                }
                catch (Exception ex) {
                    throw new VncException("Failed to coerce string to bytebuf", ex);
                }
            }
            if (Types.isVncByteBuffer(arg)) {
                return ((VncByteBuffer)arg).copy();
            }
            if (Types.isVncList(arg)) {
                if (!((VncList)arg).getList().stream().allMatch(v -> Types.isVncLong(v))) {
                    throw new VncException(String.format("Function 'bytebuf' a list as argument must contains long values. %s", ErrorMessage.buildErrLocation(args)));
                }
                List<VncVal> list = ((VncList)arg).getList();
                byte[] buf = new byte[list.size()];
                for (int ii = 0; ii < list.size(); ++ii) {
                    buf[ii] = (byte)((VncLong)list.get(ii)).getValue().longValue();
                }
                return new VncByteBuffer(ByteBuffer.wrap(buf));
            }
            throw new VncException(String.format("Function 'bytebuf' does not allow %s as argument. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction new_list = new VncFunction("list"){
        {
            this.setArgLists("(list & items)");
            this.setDoc("Creates a new list containing the items.");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncJavaList(args.nth(0))) {
                return ((VncJavaList)args.nth(0)).toVncList();
            }
            if (args.size() == 1 && Types.isVncJavaSet(args.nth(0))) {
                return ((VncJavaSet)args.nth(0)).toVncList();
            }
            if (args.size() == 1 && Types.isVncSet(args.nth(0))) {
                return ((VncSet)args.nth(0)).toVncList();
            }
            if (args.size() == 1 && Types.isVncString(args.nth(0))) {
                return ((VncString)args.nth(0)).toVncList();
            }
            if (args.size() == 1 && Types.isVncByteBuffer(args.nth(0))) {
                return ((VncByteBuffer)args.nth(0)).toVncList();
            }
            return new VncList(args.getList());
        }
    };
    public static VncFunction list_Q = new VncFunction("list?"){
        {
            this.setArgLists("(list? obj)");
            this.setDoc("Returns true if obj is a list");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("list?", args, 1);
            return CoreFunctions.list_Q(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction new_vector = new VncFunction("vector"){
        {
            this.setArgLists("(vector & items)");
            this.setDoc("Creates a new vector containing the items.");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncJavaList(args.nth(0))) {
                return ((VncJavaList)args.nth(0)).toVncVector();
            }
            if (args.size() == 1 && Types.isVncJavaSet(args.nth(0))) {
                return ((VncJavaSet)args.nth(0)).toVncVector();
            }
            if (args.size() == 1 && Types.isVncSet(args.nth(0))) {
                return ((VncSet)args.nth(0)).toVncVector();
            }
            return new VncVector(args.getList());
        }
    };
    public static VncFunction vector_Q = new VncFunction("vector?"){
        {
            this.setArgLists("(vector? obj)");
            this.setDoc("Returns true if obj is a vector");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("vector?", args, 1);
            return CoreFunctions.vector_Q(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction subvec = new VncFunction("subvec"){
        {
            this.setArgLists("(subvec v start) (subvec v start end)");
            this.setDoc("Returns a vector of the items in vector from start (inclusive) to end (exclusive). If end is not supplied, defaults to (count vector)");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("subvec", args, 2, 3);
            VncVector vec = Coerce.toVncVector(args.nth(0));
            VncLong from = Coerce.toVncLong(args.nth(1));
            VncLong to = args.size() > 2 ? Coerce.toVncLong(args.nth(2)) : null;
            return new VncVector(to == null ? vec.getList().subList(from.getValue().intValue(), vec.size()) : vec.getList().subList(from.getValue().intValue(), to.getValue().intValue()));
        }
    };
    public static VncFunction subbytebuf = new VncFunction("subbytebuf"){
        {
            this.setArgLists("(subbytebuf x start) (subbytebuf x start end)");
            this.setDoc("Returns a byte buffer of the items in buffer from start (inclusive) to end (exclusive). If end is not supplied, defaults to (count bytebuffer)");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("subbytebuf", args, 2, 3);
            byte[] buf = Coerce.toVncByteBuffer(args.nth(0)).getValue().array();
            VncLong from = Coerce.toVncLong(args.nth(1));
            VncLong to = args.size() > 2 ? Coerce.toVncLong(args.nth(2)) : null;
            return new VncByteBuffer(to == null ? ByteBuffer.wrap(Arrays.copyOfRange(buf, from.getValue().intValue(), buf.length)) : ByteBuffer.wrap(Arrays.copyOfRange(buf, from.getValue().intValue(), to.getValue().intValue())));
        }
    };
    public static VncFunction new_set = new VncFunction("set"){
        {
            this.setArgLists("(set & items)");
            this.setDoc("Creates a new set containing the items.");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncJavaSet(args.nth(0))) {
                return ((VncJavaSet)args.nth(0)).toVncSet();
            }
            if (args.size() == 1 && Types.isVncJavaList(args.nth(0))) {
                return ((VncJavaList)args.nth(0)).toVncSet();
            }
            if (args.size() == 1 && Types.isVncList(args.nth(0))) {
                return ((VncList)args.nth(0)).toVncSet();
            }
            return new VncSet(args);
        }
    };
    public static VncFunction set_Q = new VncFunction("set?"){
        {
            this.setArgLists("(set? obj)");
            this.setDoc("Returns true if obj is a set");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("set?", args, 1);
            return Types.isVncSet(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction new_hash_map = new VncFunction("hash-map"){
        {
            this.setArgLists("(hash-map & keyvals)");
            this.setDoc("Creates a new hash map containing the items.");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncJavaMap(args.nth(0))) {
                return ((VncJavaMap)args.nth(0)).toVncHashMap();
            }
            if (args.size() == 1 && Types.isVncJavaObject(args.nth(0))) {
                return ((VncJavaObject)args.nth(0)).toVncMap();
            }
            return new VncHashMap(args);
        }
    };
    public static VncFunction new_ordered_map = new VncFunction("ordered-map"){
        {
            this.setArgLists("(ordered-map & keyvals)");
            this.setDoc("Creates a new ordered map containing the items.");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncJavaMap(args.nth(0))) {
                return ((VncJavaMap)args.nth(0)).toVncOrderedMap();
            }
            return new VncOrderedMap(args);
        }
    };
    public static VncFunction new_sorted_map = new VncFunction("sorted-map"){
        {
            this.setArgLists("(sorted-map & keyvals)");
            this.setDoc("Creates a new sorted map containing the items.");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncJavaMap(args.nth(0))) {
                return ((VncJavaMap)args.nth(0)).toVncSortedMap();
            }
            return new VncSortedMap(args);
        }
    };
    public static VncFunction map_Q = new VncFunction("map?"){
        {
            this.setArgLists("(map? obj)");
            this.setDoc("Returns true if obj is a map");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("map?", args, 1);
            return Types.isVncMap(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction hash_map_Q = new VncFunction("hash-map?"){
        {
            this.setArgLists("(hash-map? obj)");
            this.setDoc("Returns true if obj is a hash map");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("hash-map?", args, 1);
            return Types.isVncHashMap(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction ordered_map_Q = new VncFunction("ordered-map?"){
        {
            this.setArgLists("(ordered-map? obj)");
            this.setDoc("Returns true if obj is an ordered map");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("ordered-map?", args, 1);
            return Types.isVncOrderedMap(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction sorted_map_Q = new VncFunction("sorted-map?"){
        {
            this.setArgLists("(sorted-map? obj)");
            this.setDoc("Returns true if obj is a sorted map");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("sorted-map?", args, 1);
            return Types.isVncSortedMap(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction contains_Q = new VncFunction("contains?"){
        {
            this.setArgLists("(contains? coll key)");
            this.setDoc("Returns true if key is present in the given collection, otherwise returns false.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("contains?", args, 2);
            VncVal coll = args.nth(0);
            VncVal key = args.nth(1);
            if (Types.isVncMap(coll)) {
                VncMap mhm = (VncMap)coll;
                Map<VncVal, VncVal> hm = mhm.getMap();
                return hm.containsKey(key) ? Constants.True : Constants.False;
            }
            if (Types.isVncVector(coll)) {
                VncVector v = (VncVector)coll;
                VncLong k = (VncLong)key;
                return v.size() > k.getValue().intValue() ? Constants.True : Constants.False;
            }
            if (Types.isVncSet(coll)) {
                VncSet s = (VncSet)coll;
                return s.getSet().contains(key) ? Constants.True : Constants.False;
            }
            if (Types.isVncString(coll)) {
                VncString s = (VncString)coll;
                VncLong k = (VncLong)key;
                return s.getValue().length() > k.getValue().intValue() ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'contains?' does not allow %s as coll. %s", Types.getClassName(coll), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction assoc = new VncFunction("assoc"){
        {
            this.setArgLists("(assoc coll key val)", "(assoc coll key val & kvs)");
            this.setDoc("When applied to a map, returns a new map of the same type, that contains the mapping of key(s) to val(s). When applied to a vector, returns a new vector that contains val at index. Note - index must be <= (count vector).");
        }

        @Override
        public VncVal apply(VncList args) {
            if (Types.isVncMap(args.nth(0))) {
                VncMap hm = (VncMap)args.nth(0);
                VncMap new_hm = hm.copy();
                new_hm.assoc(args.slice(1));
                return new_hm;
            }
            if (Types.isVncVector(args.nth(0))) {
                VncVector vec = ((VncVector)args.nth(0)).copy();
                VncList keyvals = args.slice(1);
                for (int ii = 0; ii < keyvals.size(); ii += 2) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    VncVal val = keyvals.nth(ii + 1);
                    if (vec.size() > key.getValue().intValue()) {
                        vec.getList().set(key.getValue().intValue(), val);
                        continue;
                    }
                    vec.addAtEnd(val);
                }
                return vec;
            }
            if (Types.isVncString(args.nth(0))) {
                String s = ((VncString)args.nth(0)).getValue();
                VncList keyvals = args.slice(1);
                for (int ii = 0; ii < keyvals.size(); ii += 2) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    VncString val = Coerce.toVncString(keyvals.nth(ii + 1));
                    int idx = key.getValue().intValue();
                    if (s.length() > idx) {
                        if (idx == 0) {
                            s = "" + val.getValue().charAt(0) + s.substring(1);
                            continue;
                        }
                        if (idx == s.length() - 1) {
                            s = s.substring(0, idx) + val.getValue().charAt(0);
                            continue;
                        }
                        s = s.substring(0, idx) + val.getValue().charAt(0) + s.substring(idx + 1);
                        continue;
                    }
                    s = s + val.getValue().charAt(0);
                }
                return new VncString(s);
            }
            throw new VncException(String.format("Function 'assoc' does not allow %s as coll. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction dissoc = new VncFunction("dissoc"){
        {
            this.setArgLists("(dissoc coll key)", "(dissoc coll key & ks)");
            this.setDoc("Returns a new coll of the same type, that does not contain a mapping for key(s)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (Types.isVncMap(args.nth(0))) {
                VncMap hm = (VncMap)args.nth(0);
                VncMap new_hm = hm.copy();
                new_hm.dissoc(args.slice(1));
                return new_hm;
            }
            if (Types.isVncVector(args.nth(0))) {
                VncVector vec = ((VncVector)args.nth(0)).copy();
                VncList keyvals = args.slice(1);
                for (int ii = 0; ii < keyvals.size(); ++ii) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    if (vec.size() <= key.getValue().intValue()) continue;
                    vec.getList().remove(key.getValue().intValue());
                }
                return vec;
            }
            if (Types.isVncString(args.nth(0))) {
                String s = ((VncString)args.nth(0)).getValue();
                VncList keyvals = args.slice(1);
                for (int ii = 0; ii < keyvals.size(); ++ii) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    int idx = key.getValue().intValue();
                    if (s.length() <= idx) continue;
                    s = idx == 0 ? s.substring(1) : (idx == s.length() - 1 ? s.substring(0, idx) : s.substring(0, idx) + s.substring(idx + 1));
                }
                return new VncString(s);
            }
            throw new VncException(String.format("Function 'dissoc' does not allow %s as coll. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction get = new VncFunction("get"){
        {
            this.setArgLists("(get map key)", "(get map key not-found)");
            this.setDoc("Returns the value mapped to key, not-found or nil if key not present.");
            this.setExamples("(get {:a 1 :b 2} :b)", ";; keywords act like functions on maps \n(:b {:a 1 :b 2})");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("get", args, 2, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            VncMap mhm = Coerce.toVncMap(args.nth(0));
            VncVal key = args.nth(1);
            VncConstant key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
            VncVal value = mhm.get(key);
            return value != Constants.Nil ? value : key_not_found;
        }
    };
    public static VncFunction find = new VncFunction("find"){
        {
            this.setArgLists("(find map key)");
            this.setDoc("Returns the map entry for key, or nil if key not present.");
            this.setExamples("(find {:a 1 :b 2} :b)", "(find {:a 1 :b 2} :z)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal key;
            CoreFunctions.assertArity("find", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            VncMap mhm = Coerce.toVncMap(args.nth(0));
            VncVal value = mhm.get(key = args.nth(1));
            return value == Constants.Nil ? Constants.Nil : new VncVector(key, value);
        }
    };
    public static VncFunction key = new VncFunction("key"){
        {
            this.setArgLists("(key e)");
            this.setDoc("Returns the key of the map entry.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("key", args, 1);
            VncList entry = Coerce.toVncList(args.nth(0));
            return entry.first();
        }
    };
    public static VncFunction keys = new VncFunction("keys"){
        {
            this.setArgLists("(keys map)");
            this.setDoc("Returns a collection of the map's keys.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("keys", args, 1);
            VncMap mhm = Coerce.toVncMap(args.nth(0));
            Map<VncVal, VncVal> hm = mhm.getMap();
            VncList key_lst = new VncList(new VncVal[0]);
            for (VncVal key : hm.keySet()) {
                key_lst.addAtEnd(key);
            }
            return key_lst;
        }
    };
    public static VncFunction val = new VncFunction("val"){
        {
            this.setArgLists("(val e)");
            this.setDoc("Returns the val of the map entry.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("val", args, 1);
            VncList entry = Coerce.toVncList(args.nth(0));
            return entry.second();
        }
    };
    public static VncFunction vals = new VncFunction("vals"){
        {
            this.setArgLists("(vals map)");
            this.setDoc("Returns a collection of the map's values.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("vals", args, 1);
            VncMap mhm = Coerce.toVncMap(args.nth(0));
            Map<VncVal, VncVal> hm = mhm.getMap();
            VncList val_lst = new VncList(new VncVal[0]);
            for (VncVal val : hm.values()) {
                val_lst.addAtEnd(val);
            }
            return val_lst;
        }
    };
    public static VncFunction into = new VncFunction("into"){
        {
            this.setArgLists("(into to-coll from-coll)");
            this.setDoc("Returns a new coll consisting of to-coll with all of the items offrom-coll conjoined.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("into", args, 2);
            VncVal to = args.nth(0);
            VncVal from = args.nth(1);
            if (Types.isVncVector(to)) {
                if (Types.isVncSet(from)) {
                    ((VncSet)from).getList().forEach(v -> ((VncVector)to).addAtEnd((VncVal)v));
                } else if (Types.isVncList(from)) {
                    ((VncList)from).getList().forEach(v -> ((VncVector)to).addAtEnd((VncVal)v));
                } else if (Types.isVncMap(from)) {
                    ((VncMap)from).toVncList().getList().forEach(v -> ((VncVector)to).addAtEnd((VncVal)v));
                }
            } else if (Types.isVncList(to)) {
                if (Types.isVncSet(from)) {
                    ((VncSet)from).getList().forEach(v -> ((VncList)to).addAtStart((VncVal)v));
                } else if (Types.isVncList(from)) {
                    ((VncList)from).getList().forEach(v -> ((VncList)to).addAtStart((VncVal)v));
                } else if (Types.isVncMap(from)) {
                    ((VncMap)from).toVncList().getList().forEach(v -> ((VncVector)to).addAtStart((VncVal)v));
                }
            } else if (Types.isVncMap(to)) {
                if (Types.isVncList(from)) {
                    ((VncList)from).getList().forEach(it -> {
                        if (Types.isVncList(it)) {
                            ((VncMap)to).assoc((VncList)it);
                        } else if (Types.isVncMap(it)) {
                            ((VncMap)to).getMap().putAll(((VncMap)it).getMap());
                        }
                    });
                } else if (Types.isVncMap(from)) {
                    ((VncMap)to).getMap().putAll(((VncMap)from).getMap());
                }
            }
            return to;
        }
    };
    public static VncFunction seq_Q = new VncFunction("seq?"){
        {
            this.setArgLists("(seq? obj)");
            this.setDoc("Returns true if obj is a sequential collection");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("seq?", args, 1);
            return Types.isVncList(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction coll_Q = new VncFunction("coll?"){
        {
            this.setArgLists("(coll? obj)");
            this.setDoc("Returns true if obj is a collection");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("seq?", args, 1);
            return Types.isVncCollection(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction count = new VncFunction("count"){
        {
            this.setArgLists("(count coll)");
            this.setDoc("Returns the number of items in the collection. (count nil) returns 0. Also works on strings, and Java Collections");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("count", args, 1);
            VncVal arg = args.nth(0);
            if (arg == Constants.Nil) {
                return new VncLong(0L);
            }
            if (Types.isVncString(arg)) {
                return new VncLong(((VncString)arg).getValue().length());
            }
            if (Types.isVncByteBuffer(arg)) {
                return new VncLong(((VncByteBuffer)arg).size());
            }
            if (Types.isVncList(arg)) {
                return new VncLong(((VncList)arg).size());
            }
            if (Types.isVncSet(arg)) {
                return new VncLong(((VncSet)arg).size());
            }
            if (Types.isVncMap(arg)) {
                return new VncLong(((VncMap)arg).size());
            }
            if (Types.isVncJavaList(arg)) {
                return new VncLong(((VncJavaList)arg).size());
            }
            if (Types.isVncJavaSet(arg)) {
                return new VncLong(((VncJavaSet)arg).size());
            }
            if (Types.isVncJavaMap(arg)) {
                return new VncLong(((VncJavaMap)arg).size());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'count'. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction empty_Q = new VncFunction("empty?"){
        {
            this.setArgLists("(empty? x)");
            this.setDoc("Returns true if x is empty");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("empty?", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return Constants.True;
            }
            if (exp instanceof VncString && ((VncString)exp).getValue().isEmpty()) {
                return Constants.True;
            }
            if (exp instanceof VncCollection && ((VncCollection)exp).isEmpty()) {
                return Constants.True;
            }
            if (exp instanceof VncByteBuffer && ((VncByteBuffer)exp).size() == 0) {
                return Constants.True;
            }
            return Constants.False;
        }
    };
    public static VncFunction not_empty_Q = new VncFunction("not-empty?"){
        {
            this.setArgLists("(not-empty? x)");
            this.setDoc("Returns true if x is not empty");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("not-empty?", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return Constants.False;
            }
            if (exp instanceof VncString && ((VncString)exp).getValue().isEmpty()) {
                return Constants.False;
            }
            if (exp instanceof VncCollection && ((VncCollection)exp).isEmpty()) {
                return Constants.False;
            }
            if (exp instanceof VncByteBuffer && ((VncByteBuffer)exp).size() != 0) {
                return Constants.True;
            }
            return Constants.True;
        }
    };
    public static VncFunction cons = new VncFunction("cons"){
        {
            this.setArgLists("(cons x coll)");
            this.setDoc("Returns a new collection where x is the first element and coll is\nthe rest");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("cons", args, 2);
            if (Types.isVncList(args.nth(1))) {
                VncList list = new VncList(new VncVal[0]);
                list.addAtStart(args.nth(0));
                list.addAtEnd((VncList)args.nth(1));
                return list;
            }
            if (Types.isVncMap(args.nth(1)) && Types.isVncMap(args.nth(0))) {
                VncMap map = ((VncMap)args.nth(1)).copy();
                map.getMap().putAll(((VncMap)args.nth(0)).getMap());
                return map;
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'cons'. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction concat = new VncFunction("concat"){
        {
            this.setArgLists("(concat coll)", "(concat coll & colls)");
            this.setDoc("Returns a collection of the concatenation of the elements in the supplied colls.");
        }

        @Override
        public VncVal apply(VncList args) {
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            args.getList().forEach(val -> {
                if (val != Constants.Nil) {
                    if (Types.isVncString(val)) {
                        String str = ((VncString)val).getValue();
                        for (char ch : str.toCharArray()) {
                            result.add(new VncString(String.valueOf(ch)));
                        }
                    } else if (Types.isVncList(val)) {
                        result.addAll(((VncList)val).getList());
                    } else if (Types.isVncSet(val)) {
                        result.addAll(((VncSet)val).getList());
                    } else if (Types.isVncMap(val)) {
                        result.addAll(((VncMap)val).toVncList().getList());
                    } else if (Types.isVncJavaList(val)) {
                        result.addAll(((VncJavaList)val).toVncList().getList());
                    } else if (Types.isVncJavaSet(val)) {
                        result.addAll(((VncJavaSet)val).toVncList().getList());
                    } else if (Types.isVncJavaMap(val)) {
                        result.addAll(((VncJavaMap)val).toVncList().getList());
                    } else {
                        throw new VncException(String.format("Invalid argument type %s while calling function 'concat'. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(args)));
                    }
                }
            });
            return new VncList(result);
        }
    };
    public static VncFunction interleave = new VncFunction("interleave"){
        {
            this.setArgLists("(interleave c1 c2)", "(interleave c1 c2 & colls)");
            this.setDoc("Returns a collection of the first item in each coll, then the second etc.");
            this.setExamples("(interleave [:a :b :c] [1 2])");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertMinArity("interleave", args, 2);
            int len = Coerce.toVncList(args.first()).size();
            ArrayList<VncList> lists = new ArrayList<VncList>();
            for (int ii = 0; ii < args.size(); ++ii) {
                VncList l = Coerce.toVncList(args.nth(ii));
                lists.add(l);
                len = Math.min(len, l.size());
            }
            VncList result = new VncList(new VncVal[0]);
            for (int nn = 0; nn < len; ++nn) {
                VncList item = new VncList(new VncVal[0]);
                for (int ii = 0; ii < lists.size(); ++ii) {
                    item.addAtEnd(((VncList)lists.get(ii)).nth(nn));
                }
                result.addAtEnd(item);
            }
            return result;
        }
    };
    public static VncFunction interpose = new VncFunction("interpose"){
        {
            this.setArgLists("(interpose sep coll)");
            this.setDoc("Returns a collection of the elements of coll separated by sep.");
            this.setExamples("(interpose \", \" [1 2 3])", "(apply str (interpose \", \" [1 2 3]))");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("interpose", args, 2);
            VncVal sep = args.first();
            VncList coll = Coerce.toVncList(args.second());
            VncList result = new VncList(new VncVal[0]);
            if (!coll.isEmpty()) {
                result.addAtEnd(coll.first());
                coll.rest().forEach(v -> {
                    result.addAtEnd(sep);
                    result.addAtEnd((VncVal)v);
                });
            }
            return result;
        }
    };
    public static VncFunction first = new VncFunction("first"){
        {
            this.setArgLists("(first coll)");
            this.setDoc("Returns the first element of coll.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("first", args, 1);
            VncVal val = args.nth(0);
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).first();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).first();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'first'. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction second = new VncFunction("second"){
        {
            this.setArgLists("(second coll)");
            this.setDoc("Returns the second element of coll.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("second", args, 1);
            VncVal val = args.nth(0);
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).second();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).second();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'second'. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction nth = new VncFunction("nth"){
        {
            this.setArgLists("(nth coll idx)");
            this.setDoc("Returns the nth element of coll.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("nth", args, 2);
            int idx = Coerce.toVncLong(args.nth(1)).getValue().intValue();
            VncVal val = args.nth(0);
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).nth(idx);
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).nth(idx);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'nth'. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction last = new VncFunction("last"){
        {
            this.setArgLists("(last coll)");
            this.setDoc("Returns the last element of coll.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("last", args, 1);
            VncVal val = args.nth(0);
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).last();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).last();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'last'. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction rest = new VncFunction("rest"){
        {
            this.setArgLists("(rest coll)");
            this.setDoc("Returns a collection with second to list element");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("rest", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            if (Types.isVncList(exp)) {
                return ((VncList)exp).rest();
            }
            return ((VncVector)exp).rest();
        }
    };
    public static VncFunction nfirst = new VncFunction("nfirst"){
        {
            this.setArgLists("(nfirst coll n)");
            this.setDoc("Returns a collection of the first n items");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("nfirst", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            if (Types.isVncVector(args.nth(0))) {
                VncVector vec = Coerce.toVncVector(args.nth(0));
                int n = Math.max(0, Math.min(vec.size(), Coerce.toVncLong(args.nth(1)).getValue().intValue()));
                return vec.isEmpty() ? new VncVector(new VncVal[0]) : new VncVector(vec.getList().subList(0, n));
            }
            if (Types.isVncList(args.nth(0))) {
                VncList list = Coerce.toVncList(args.nth(0));
                int n = Math.max(0, Math.min(list.size(), Coerce.toVncLong(args.nth(1)).getValue().intValue()));
                return list.isEmpty() ? new VncList(new VncVal[0]) : new VncList(list.getList().subList(0, n));
            }
            throw new VncException(String.format("nfirst: type %s not supported. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args.nth(0))));
        }
    };
    public static VncFunction nlast = new VncFunction("nlast"){
        {
            this.setArgLists("(nlast coll n)");
            this.setDoc("Returns a collection of the last n items");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("nlast", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            if (Types.isVncVector(args.nth(0))) {
                VncVector vec = Coerce.toVncVector(args.nth(0));
                int n = Math.max(0, Math.min(vec.size(), Coerce.toVncLong(args.nth(1)).getValue().intValue()));
                return vec.isEmpty() ? new VncVector(new VncVal[0]) : new VncVector(vec.getList().subList(vec.size() - n, vec.size()));
            }
            if (Types.isVncList(args.nth(0))) {
                VncList list = Coerce.toVncList(args.nth(0));
                int n = Math.max(0, Math.min(list.size(), Coerce.toVncLong(args.nth(1)).getValue().intValue()));
                return list.isEmpty() ? new VncList(new VncVal[0]) : new VncList(list.getList().subList(list.size() - n, list.size()));
            }
            throw new VncException(String.format("nlast: type %s not supported. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args.nth(0))));
        }
    };
    public static VncFunction distinct = new VncFunction("distinct"){
        {
            this.setArgLists("(distinct coll)");
            this.setDoc("Returns a collection with all duplicates removed");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("distinct", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            VncList result = ((VncList)args.nth(0)).empty();
            result.getList().addAll(Coerce.toVncList(args.nth(0)).getList().stream().distinct().collect(Collectors.toList()));
            return result;
        }
    };
    public static VncFunction dedupe = new VncFunction("dedupe"){
        {
            this.setArgLists("(dedupe coll)");
            this.setDoc("Returns a collection with all consecutive duplicates removed");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("dedupe", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            VncList result = ((VncList)args.nth(0)).empty();
            VncVal seen = null;
            for (VncVal val : Coerce.toVncList(args.nth(0)).getList()) {
                if (seen != null && val.equals(seen)) continue;
                result.addAtEnd(val);
                seen = val;
            }
            return result;
        }
    };
    public static VncFunction partition = new VncFunction("partition"){
        {
            this.setArgLists("(partition n coll)", "(partition n step coll)", "(partition n step padcoll coll)");
            this.setDoc("Returns a collection of lists of n items each, at offsets step apart. If step is not supplied, defaults to n, i.e. the partitions do not overlap. If a padcoll collection is supplied, use its elements as necessary to complete last partition upto n items. In case there are not enough padding elements, return a partition with less than n items.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("partition", args, 2, 3, 4);
            int n = Coerce.toVncLong(args.nth(0)).getValue().intValue();
            int step = args.size() > 2 ? Coerce.toVncLong(args.nth(1)).getValue().intValue() : n;
            ArrayList padcoll = args.size() > 3 ? Coerce.toVncList(args.nth(2)).getList() : new ArrayList();
            List<VncVal> coll = Coerce.toVncList(args.nth(args.size() - 1)).getList();
            if (n <= 0) {
                throw new VncException(String.format("partition: n must be a positive number. %s", ErrorMessage.buildErrLocation(args.nth(0))));
            }
            if (step <= 0) {
                throw new VncException(String.format("partition: step must be a positive number. %s", ErrorMessage.buildErrLocation(args.nth(0))));
            }
            ArrayList<List<VncVal>> splits = new ArrayList<List<VncVal>>();
            for (int ii = 0; ii < coll.size(); ii += step) {
                splits.add(coll.subList(ii, Math.min(ii + step, coll.size())));
            }
            VncList result = new VncList(new VncVal[0]);
            for (List list : splits) {
                if (n == list.size()) {
                    result.addList(new VncList(list));
                    continue;
                }
                if (n < list.size()) {
                    result.addList(new VncList(list.subList(0, n)));
                    continue;
                }
                ArrayList<VncVal> split_ = new ArrayList<VncVal>(list);
                for (int ii = 0; ii < n - list.size() && ii < padcoll.size(); ++ii) {
                    split_.add((VncVal)padcoll.get(ii));
                }
                result.addList(new VncList(split_));
            }
            return result;
        }
    };
    public static VncFunction coalesce = new VncFunction("coalesce"){
        {
            this.setArgLists("(coalesce args*)");
            this.setDoc("Returns the first non nil arg");
        }

        @Override
        public VncVal apply(VncList args) {
            return args.getList().stream().filter(v -> v != Constants.Nil).findFirst().orElse(Constants.Nil);
        }
    };
    public static VncFunction emptyToNil = new VncFunction("empty-to-nil"){
        {
            this.setArgLists("(empty-to-nil x)");
            this.setDoc("Returns nil if x is empty");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("empty-to-nil", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncString(arg)) {
                return ((VncString)arg).getValue().isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncVector(arg)) {
                return ((VncVector)arg).isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncList(arg)) {
                return ((VncList)arg).isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncMap(arg)) {
                return ((VncMap)arg).isEmpty() ? Constants.Nil : arg;
            }
            return arg;
        }
    };
    public static VncFunction className = new VncFunction("class"){
        {
            this.setArgLists("(class x)");
            this.setDoc("Returns the class of x");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("class", args, 1);
            return Types.getClassName(args.nth(0));
        }
    };
    public static VncFunction pop = new VncFunction("pop"){
        {
            this.setArgLists("(pop coll)");
            this.setDoc("For a list, returns a new list without the first item, for a vector, returns a new vector without the last item.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("pop", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            VncList ml = Coerce.toVncList(exp);
            if (Types.isVncVector(ml)) {
                return ml.size() < 2 ? new VncVector(new VncVal[0]) : ((VncVector)ml).slice(0, ml.size() - 1);
            }
            return ml.isEmpty() ? new VncList(new VncVal[0]) : ml.slice(1);
        }
    };
    public static VncFunction peek = new VncFunction("peek"){
        {
            this.setArgLists("(peek coll)");
            this.setDoc("For a list, same as first, for a vector, same as last");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("peek", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return Constants.Nil;
            }
            VncList ml = Coerce.toVncList(exp);
            if (Types.isVncVector(ml)) {
                return ml.isEmpty() ? Constants.Nil : ((VncVector)ml).nth(ml.size() - 1);
            }
            return ml.isEmpty() ? Constants.Nil : ml.nth(0);
        }
    };
    public static VncFunction take_while = new VncFunction("take-while"){
        {
            this.setArgLists("(take-while predicate coll)");
            this.setDoc("Returns a list of successive items from coll while (predicate item) returns logical true.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("take-while", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            for (int i = 0; i < coll.size(); ++i) {
                VncVal take = (VncVal)predicate.apply(new VncList(coll.nth(i)));
                if (take != Constants.False) continue;
                return coll.slice(0, i);
            }
            return coll;
        }
    };
    public static VncFunction take = new VncFunction("take"){
        {
            this.setArgLists("(take n coll)");
            this.setDoc("Returns a collection of the first n items in coll, or all items if there are fewer than n.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("take", args, 2);
            VncLong n = Coerce.toVncLong(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            return coll.slice(0, (int)Math.min(n.getValue(), (long)coll.size()));
        }
    };
    public static VncFunction drop_while = new VncFunction("drop-while"){
        {
            this.setArgLists("(drop-while predicate coll)");
            this.setDoc("Returns a list of the items in coll starting from the first item for which (predicate item) returns logical false.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("drop-while", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            for (int i = 0; i < coll.size(); ++i) {
                VncVal take = (VncVal)predicate.apply(new VncList(coll.nth(i)));
                if (take != Constants.False) continue;
                return coll.slice(i);
            }
            return coll.empty();
        }
    };
    public static VncFunction drop = new VncFunction("drop"){
        {
            this.setArgLists("(drop n coll)");
            this.setDoc("Returns a collection of all but the first n items in coll");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("drop", args, 2);
            VncLong n = Coerce.toVncLong(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            return coll.slice((int)Math.min(n.getValue() + 1L, (long)coll.size()));
        }
    };
    public static VncFunction flatten = new VncFunction("flatten"){
        {
            this.setArgLists("(flatten coll)");
            this.setDoc("Takes any nested combination of collections (lists, vectors, etc.) and returns their contents as a single, flat sequence. (flatten nil) returns an empty list.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("flatten", args, 1);
            VncList coll = Coerce.toVncList(args.nth(0));
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            CoreFunctions.flatten(coll, result);
            return Types.isVncVector(coll) ? new VncVector(result) : new VncList(result);
        }
    };
    public static VncFunction reverse = new VncFunction("reverse"){
        {
            this.setArgLists("(reverse coll)");
            this.setDoc("Returns a collection of the items in coll in reverse order");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("reverse", args, 1);
            VncList coll = Coerce.toVncList(args.nth(0));
            VncList result = coll.empty();
            for (int ii = coll.size() - 1; ii >= 0; --ii) {
                result.addAtEnd(coll.nth(ii));
            }
            return result;
        }
    };
    public static VncFunction sort = new VncFunction("sort"){
        {
            this.setArgLists("(sort coll)", "(sort compfn coll)");
            this.setDoc("Returns a sorted list of the items in coll. If no compare function compfn is supplied, uses the natural compare. The compare function takes two arguments and returns -1, 0, or 1");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("sort", args, 1, 2);
            if (args.size() == 1) {
                VncVal coll = args.nth(0);
                if (Types.isVncVector(coll)) {
                    return new VncVector(((VncVector)coll).getList().stream().sorted().collect(Collectors.toList()));
                }
                if (Types.isVncList(coll)) {
                    return new VncList(((VncList)coll).getList().stream().sorted().collect(Collectors.toList()));
                }
                if (Types.isVncMap(coll)) {
                    return new VncList(((VncMap)coll).toVncList().getList().stream().sorted().collect(Collectors.toList()));
                }
                throw new VncException(String.format("sort: collection type not supported. %s", ErrorMessage.buildErrLocation(args)));
            }
            if (args.size() == 2) {
                VncFunction compfn = Coerce.toVncFunction(args.nth(0));
                VncVal coll = args.nth(1);
                if (Types.isVncVector(coll)) {
                    return new VncVector(((VncVector)coll).getList().stream().sorted((x, y) -> ((VncLong)compfn.apply(new VncList((VncVal)x, (VncVal)y))).getValue().intValue()).collect(Collectors.toList()));
                }
                if (Types.isVncList(coll)) {
                    return new VncList(((VncList)coll).getList().stream().sorted((x, y) -> ((VncLong)compfn.apply(new VncList((VncVal)x, (VncVal)y))).getValue().intValue()).collect(Collectors.toList()));
                }
                if (Types.isVncMap(coll)) {
                    return new VncList(((VncMap)coll).toVncList().getList().stream().sorted((x, y) -> ((VncLong)compfn.apply(new VncList((VncVal)x, (VncVal)y))).getValue().intValue()).collect(Collectors.toList()));
                }
                throw new VncException(String.format("sort: collection type not supported. %s", ErrorMessage.buildErrLocation(args)));
            }
            throw new VncException(String.format("sort: args not supported. %s", ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction sort_by = new VncFunction("sort-by"){
        {
            this.setArgLists("(sort-by keyfn coll)", "(sort-by keyfn compfn coll)");
            this.setDoc("Returns a sorted sequence of the items in coll, where the sort order is determined by comparing (keyfn item).  If no comparator is supplied, uses compare.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("sort-by", args, 2, 3);
            if (args.size() == 2) {
                VncFunction keyfn = Coerce.toVncFunction(args.nth(0));
                VncVal coll = args.nth(1);
                if (Types.isVncVector(coll)) {
                    return new VncVector(((VncVector)coll).getList().stream().sorted((x, y) -> ((VncVal)keyfn.apply(new VncList((VncVal)x))).compareTo((VncVal)keyfn.apply(new VncList((VncVal)y)))).collect(Collectors.toList()));
                }
                if (Types.isVncList(coll)) {
                    return new VncList(((VncList)coll).getList().stream().sorted((x, y) -> ((VncVal)keyfn.apply(new VncList((VncVal)x))).compareTo((VncVal)keyfn.apply(new VncList((VncVal)y)))).collect(Collectors.toList()));
                }
                if (Types.isVncMap(coll)) {
                    return new VncList(((VncMap)coll).toVncList().getList().stream().sorted((x, y) -> ((VncVal)keyfn.apply(new VncList((VncVal)x))).compareTo((VncVal)keyfn.apply(new VncList((VncVal)y)))).collect(Collectors.toList()));
                }
                throw new VncException(String.format("sort-by: collection type not supported. %s", ErrorMessage.buildErrLocation(args)));
            }
            if (args.size() == 3) {
                VncFunction keyfn = Coerce.toVncFunction(args.nth(0));
                VncFunction compfn = Coerce.toVncFunction(args.nth(1));
                VncVal coll = args.nth(2);
                if (Types.isVncVector(coll)) {
                    return new VncVector(((VncVector)coll).getList().stream().sorted((x, y) -> Coerce.toVncLong((VncVal)compfn.apply(new VncList((VncVal)keyfn.apply(new VncList((VncVal)x)), (VncVal)keyfn.apply(new VncList((VncVal)y))))).getValue().intValue()).collect(Collectors.toList()));
                }
                if (Types.isVncList(coll)) {
                    return new VncList(((VncList)coll).getList().stream().sorted((x, y) -> Coerce.toVncLong((VncVal)compfn.apply(new VncList((VncVal)keyfn.apply(new VncList((VncVal)x)), (VncVal)keyfn.apply(new VncList((VncVal)y))))).getValue().intValue()).collect(Collectors.toList()));
                }
                if (Types.isVncMap(coll)) {
                    return new VncList(((VncMap)coll).toVncList().getList().stream().sorted((x, y) -> Coerce.toVncLong((VncVal)compfn.apply(new VncList((VncVal)keyfn.apply(new VncList((VncVal)x)), (VncVal)keyfn.apply(new VncList((VncVal)y))))).getValue().intValue()).collect(Collectors.toList()));
                }
                throw new VncException(String.format("sort-by: collection type not supported. %s", ErrorMessage.buildErrLocation(args)));
            }
            throw new VncException(String.format("sort-by: args not supported. %s", ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction group_by = new VncFunction("group-by"){
        {
            this.setArgLists("(group-by f coll)");
            this.setDoc("Returns a map of the elements of coll keyed by the result of f on each element. The value at each key will be a vector of the corresponding elements, in the order they appeared in coll.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("group-by", args, 2);
            VncFunction fn = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            VncOrderedMap map = new VncOrderedMap(new VncVal[0]);
            coll.getList().stream().forEach(v -> {
                VncVal key = (VncVal)fn.apply(new VncList((VncVal)v));
                VncList val = Coerce.toVncList(map.getMap().get(key));
                if (val == null) {
                    map.getMap().put(key, new VncVector((VncVal)v));
                } else {
                    map.getMap().put(key, val.addAtEnd((VncVal)v));
                }
            });
            return map;
        }
    };
    public static VncFunction apply = new VncFunction("apply"){
        {
            this.setArgLists("(apply f args* coll)");
            this.setDoc("Applies f to all arguments composed of args and coll");
        }

        @Override
        public VncVal apply(VncList args) {
            VncFunction fn = Coerce.toVncFunction(args.nth(0));
            VncList fn_args = args.slice(1, args.size() - 1);
            List<VncVal> tailArgs = Coerce.toVncList(args.last()).getList();
            fn_args.getList().addAll(tailArgs);
            return (VncVal)fn.apply(fn_args);
        }
    };
    public static VncFunction comp = new VncFunction("comp"){
        {
            this.setArgLists("(comp f*)");
            this.setDoc("Takes a set of functions and returns a fn that is the composition of those fns. The returned fn takes a variable number of args, applies the rightmost of fns to the args, the next fn (right-to-left) to the result, etc. ");
            this.setExamples("(filter (comp not zero?) [0 1 0 2 0 3 0 4])", "(do \n   (def fifth (comp first rest rest rest rest)) \n   (fifth [1 2 3 4 5]))");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertMinArity("comp", args, 1);
            final List fns = args.getList().stream().map(v -> Coerce.toVncFunction(v)).collect(Collectors.toList());
            return new VncFunction(){

                @Override
                public VncVal apply(VncList args) {
                    VncList args_ = args;
                    VncVal result = Constants.Nil;
                    for (int ii = fns.size() - 1; ii >= 0; --ii) {
                        VncFunction fn = (VncFunction)fns.get(ii);
                        result = (VncVal)fn.apply(args_);
                        args_ = new VncList(result);
                    }
                    return result;
                }
            };
        }
    };
    public static VncFunction partial = new VncFunction("partial"){
        {
            this.setArgLists("(partial f args*)");
            this.setDoc("Takes a function f and fewer than the normal arguments to f, and returns a fn that takes a variable number of additional args. When called, the returned function calls f with args + additional args.");
            this.setExamples("(do \n   (def hundred-times (partial * 100)) \n   (hundred-times 5))");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertMinArity("partial", args, 2);
            final VncFunction fn = Coerce.toVncFunction(args.first());
            final VncList fnArgs = args.slice(1);
            return new VncFunction(){

                @Override
                public VncVal apply(VncList args) {
                    return (VncVal)fn.apply(fnArgs.addAtEnd(args));
                }
            };
        }
    };
    public static VncFunction map = new VncFunction("map"){
        {
            this.setArgLists("(map f coll colls*)");
            this.setDoc("Applys f to the set of first items of each coll, followed by applying f to the set of second items in each coll, until any one of the colls is exhausted.  Any remaining items in other colls are ignored. ");
        }

        @Override
        public VncVal apply(VncList args) {
            VncFunction fn = Coerce.toVncFunction(args.nth(0));
            VncList lists = args.slice(1);
            VncList result = new VncList(new VncVal[0]);
            int index = 0;
            boolean hasMore = true;
            while (hasMore) {
                VncList fnArgs = new VncList(new VncVal[0]);
                for (int ii = 0; ii < lists.size(); ++ii) {
                    VncList nthList = Coerce.toVncList(lists.nth(ii));
                    if (nthList.size() <= index) {
                        hasMore = false;
                        break;
                    }
                    fnArgs.addAtEnd(nthList.nth(index));
                }
                if (!hasMore) continue;
                result.getList().add((VncVal)fn.apply(fnArgs));
                ++index;
            }
            return result;
        }
    };
    public static VncFunction mapcat = new VncFunction("mapcat"){
        {
            this.setArgLists("(mapcat fn & colls)");
            this.setDoc("Returns the result of applying concat to the result of applying map to fn and colls. Thus function fn should return a collection.");
        }

        @Override
        public VncVal apply(VncList args) {
            return (VncVal)concat.apply(Coerce.toVncList((VncVal)map.apply(args)));
        }
    };
    public static VncFunction filter = new VncFunction("filter"){
        {
            this.setArgLists("(filter predicate coll)");
            this.setDoc("Returns a collection of the items in coll for which (predicate item) returns logical true. ");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("filter", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            VncList result = coll.empty();
            for (int i = 0; i < coll.size(); ++i) {
                VncVal val = coll.nth(i);
                VncVal keep = (VncVal)predicate.apply(new VncList(val));
                if (keep == Constants.False || keep == Constants.Nil) continue;
                result.getList().add(val);
            }
            return result;
        }
    };
    public static VncFunction remove = new VncFunction("remove"){
        {
            this.setArgLists("(remove predicate coll)");
            this.setDoc("Returns a collection of the items in coll for which (predicate item) returns logical false. ");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("remove", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            VncList result = coll.empty();
            for (int i = 0; i < coll.size(); ++i) {
                VncVal val = coll.nth(i);
                VncVal keep = (VncVal)predicate.apply(new VncList(val));
                if (keep != Constants.False) continue;
                result.getList().add(val);
            }
            return result;
        }
    };
    public static VncFunction reduce = new VncFunction("reduce"){
        {
            this.setArgLists("(reduce f coll)", "(reduce f val coll)");
            this.setDoc("f should be a function of 2 arguments. If val is not supplied, returns the result of applying f to the first 2 items in coll, then applying f to that result and the 3rd item, etc. If coll contains no items, f must accept no arguments as well, and reduce returns the result of calling f with no arguments.  If coll has only 1 item, it is returned and f is not called.  If val is supplied, returns the result of applying f to val and the first item in coll, then applying f to that result and the 2nd item, etc. If coll contains no items, returns val and f is not called.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("reduce", args, 2, 3);
            boolean twoArguments = args.size() < 3;
            VncFunction reduceFn = Coerce.toVncFunction(args.nth(0));
            if (twoArguments) {
                List<VncVal> coll = Coerce.toVncList(args.nth(1)).getList();
                if (coll.isEmpty()) {
                    return (VncVal)reduceFn.apply(new VncList(new VncVal[0]));
                }
                VncVal value = coll.get(0);
                for (int ii = 1; ii < coll.size(); ++ii) {
                    value = (VncVal)reduceFn.apply(new VncList(value, coll.get(ii)));
                }
                return value;
            }
            List<VncVal> coll = Coerce.toVncList(args.nth(2)).getList();
            if (coll.isEmpty()) {
                return args.nth(1);
            }
            if (coll.size() == 1) {
                return (VncVal)reduceFn.apply(new VncList(args.nth(1), coll.get(0)));
            }
            VncVal value = args.nth(1);
            for (int ii = 0; ii < coll.size(); ++ii) {
                value = (VncVal)reduceFn.apply(new VncList(value, coll.get(ii)));
            }
            return value;
        }
    };
    public static VncFunction reduce_kv = new VncFunction("reduce-kv"){
        {
            this.setArgLists("(reduce-kv f init coll))");
            this.setDoc("Reduces an associative collection. f should be a function of 3 arguments. Returns the result of applying f to init, the first key and the first value in coll, then applying f to that result and the 2nd key and value, etc. If coll contains no entries, returns init and f is not called. Note that reduce-kv is supported on vectors, where the keys will be the ordinals.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("reduce-kv", args, 3);
            VncFunction reduceFn = Coerce.toVncFunction(args.nth(0));
            Set<Map.Entry<VncVal, VncVal>> values = Coerce.toVncHashMap(args.nth(2)).entries();
            VncMap value = (VncMap)args.nth(1);
            if (values.isEmpty()) {
                return value;
            }
            for (Map.Entry<VncVal, VncVal> entry : values) {
                VncVal key = entry.getKey();
                VncVal val = entry.getValue();
                value = Coerce.toVncMap((VncVal)reduceFn.apply(new VncList(value, key, val)));
            }
            return value;
        }
    };
    public static VncFunction conj = new VncFunction("conj"){
        {
            this.setArgLists("(conj coll x)", "(conj coll x & xs)");
            this.setDoc("Returns a new collection with the x, xs 'added'. (conj nil item) returns (item).  The 'addition' may happen at different 'places' depending on the concrete type.");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.nth(0) instanceof VncVector) {
                VncVector new_seq = new VncVector(new VncVal[0]);
                VncList src_seq = (VncList)args.nth(0);
                new_seq.getList().addAll(src_seq.getList());
                for (int i = 1; i < args.size(); ++i) {
                    new_seq.addAtEnd(args.nth(i));
                }
                return new_seq;
            }
            if (args.nth(0) instanceof VncList) {
                VncList new_seq = new VncList(new VncVal[0]);
                VncList src_seq = (VncList)args.nth(0);
                new_seq.getList().addAll(src_seq.getList());
                for (int i = 1; i < args.size(); ++i) {
                    new_seq.addAtStart(args.nth(i));
                }
                return new_seq;
            }
            if (args.nth(0) instanceof VncMap) {
                VncMap src_map = (VncMap)args.nth(0);
                VncMap new_map = src_map.copy();
                if (Types.isVncVector(args.nth(1)) && ((VncVector)args.nth(1)).size() == 2) {
                    return new_map.assoc(new VncList(((VncVector)args.nth(1)).nth(0), ((VncVector)args.nth(1)).nth(1)));
                }
                if (Types.isVncMap(args.nth(1))) {
                    new_map.getMap().putAll(((VncMap)args.nth(1)).getMap());
                    return new_map;
                }
                throw new VncException(String.format("Invalid x %s while calling function 'conj'. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
            }
            throw new VncException(String.format("Invalid coll %s while calling function 'conj'. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction seq = new VncFunction("seq"){
        {
            this.setArgLists("(seq coll)");
            this.setDoc("Returns a seq on the collection. If the collection is empty, returns nil.  (seq nil) returns nil. seq also works on Strings.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("seq", args, 1);
            VncVal val = args.nth(0);
            if (Types.isVncMap(val)) {
                if (((VncMap)val).isEmpty()) {
                    return Constants.Nil;
                }
                return new VncList(((VncMap)val).entries().stream().map(e -> new VncVector((VncVal)e.getKey(), (VncVal)e.getValue())).collect(Collectors.toList()));
            }
            if (Types.isVncVector(val)) {
                if (((VncVector)val).isEmpty()) {
                    return Constants.Nil;
                }
                return new VncList(((VncVector)val).getList());
            }
            if (Types.isVncList(val)) {
                if (((VncList)val).isEmpty()) {
                    return Constants.Nil;
                }
                return val;
            }
            if (Types.isVncString(val)) {
                String s = ((VncString)val).getValue();
                if (s.length() == 0) {
                    return Constants.Nil;
                }
                ArrayList<VncVal> lst = new ArrayList<VncVal>();
                for (char c : s.toCharArray()) {
                    lst.add(new VncString(String.valueOf(c)));
                }
                return new VncList(lst);
            }
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            throw new VncException(String.format("seq: called on non-sequence. %s", ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction range = new VncFunction("range"){
        {
            this.setArgLists("(range end)", "(range start end)", "(range start end step)");
            this.setDoc("Returns a collection of numbers from start (inclusive) to end (exclusive), by step, where start defaults to 0 and step defaults to 1. When start is equal to end, returns empty list.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("range", args, 1, 2, 3);
            VncVal start = new VncLong(0);
            VncVal end = new VncLong(0);
            VncVal step = new VncLong(1);
            switch (args.size()) {
                case 1: {
                    end = args.nth(0);
                    break;
                }
                case 2: {
                    start = args.nth(0);
                    end = args.nth(1);
                    break;
                }
                case 3: {
                    start = args.nth(0);
                    end = args.nth(1);
                    step = args.nth(2);
                }
            }
            if (!Types.isVncNumber(start)) {
                throw new VncException(String.format("range: start value must be a number. %s", ErrorMessage.buildErrLocation(args)));
            }
            if (!Types.isVncNumber(end)) {
                throw new VncException(String.format("range: end value must be a number. %s", ErrorMessage.buildErrLocation(args)));
            }
            if (!Types.isVncNumber(step)) {
                throw new VncException(String.format("range: step value must be a number. %s", ErrorMessage.buildErrLocation(args)));
            }
            ArrayList<VncVal> values = new ArrayList<VncVal>();
            if (zero_Q.apply(new VncList(step)) == Constants.True) {
                throw new VncException(String.format("range: a step value must not be 0. %s", ErrorMessage.buildErrLocation(args)));
            }
            if (pos_Q.apply(new VncList(step)) == Constants.True) {
                if (lt.apply(new VncList(end, start)) == Constants.True) {
                    throw new VncException(String.format("range positive step: end must not be lower than start. %s", ErrorMessage.buildErrLocation(args)));
                }
                VncVal val = start;
                while (lt.apply(new VncList(val, end)) == Constants.True) {
                    values.add(val);
                    val = (VncVal)add.apply(new VncList(val, step));
                }
            } else {
                if (gt.apply(new VncList(end, start)) == Constants.True) {
                    throw new VncException(String.format("range negative step: end must not be greater than start. %s", ErrorMessage.buildErrLocation(args)));
                }
                VncVal val = start;
                while (gt.apply(new VncList(val, end)) == Constants.True) {
                    values.add(val);
                    val = (VncVal)add.apply(new VncList(val, step));
                }
            }
            return new VncList(values);
        }
    };
    public static VncFunction repeat = new VncFunction("repeat"){
        {
            this.setArgLists("(repeat n x)");
            this.setDoc("Returns a collection with the value x repeated n times");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("repeat", args, 2);
            if (!Types.isVncLong(args.nth(0))) {
                throw new VncException("repeat: the count must be a long");
            }
            long repeat = ((VncLong)args.nth(0)).getValue();
            if (repeat < 0L) {
                throw new VncException(String.format("repeat: a count n must be grater or equal to 0. %s", ErrorMessage.buildErrLocation(args)));
            }
            VncVal val = args.nth(1);
            ArrayList<VncVal> values = new ArrayList<VncVal>();
            int ii = 0;
            while ((long)ii < repeat) {
                values.add(val.copy());
                ++ii;
            }
            return new VncList(values);
        }
    };
    public static VncFunction meta = new VncFunction("meta"){
        {
            this.setArgLists("(meta obj)");
            this.setDoc("Returns the metadata of obj, returns nil if there is no metadata.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("meta", args, 1);
            return args.nth(0).getMeta();
        }
    };
    public static VncFunction with_meta = new VncFunction("with-meta"){
        {
            this.setArgLists("(with-meta obj m)");
            this.setDoc("Returns a copy of the object obj, with a map m as its metadata.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("meta", args, 2);
            if (!Types.isVncMap(args.nth(1))) {
                throw new VncException(String.format("with-meta: the meta data for the object must be a map. %s", ErrorMessage.buildErrLocation(args)));
            }
            VncVal new_obj = args.nth(0).copy();
            new_obj.setMeta(args.nth(1));
            return new_obj;
        }
    };
    public static VncFunction vary_meta = new VncFunction("vary-meta"){
        {
            this.setArgLists("(vary-meta obj f & args)");
            this.setDoc("Returns a copy of the object obj, with (apply f (meta obj) args) as its metadata.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertMinArity("vary-meta", args, 2);
            if (!Types.isVncFunction(args.nth(1))) {
                throw new VncException(String.format("var-meta requires a function as second argument. %s", ErrorMessage.buildErrLocation(args)));
            }
            VncVal meta = args.nth(0).getMeta();
            VncFunction fn = (VncFunction)args.nth(1);
            VncList fnArgs = args.slice(2);
            fnArgs.addAtStart(meta == Constants.Nil ? new VncHashMap(new VncVal[0]) : meta);
            VncVal new_obj = args.nth(0).copy();
            new_obj.setMeta((VncVal)fn.apply(fnArgs));
            return new_obj;
        }
    };
    public static VncFunction new_atom = new VncFunction("atom"){
        {
            this.setArgLists("(atom x)");
            this.setDoc("Creates an atom with the initial value x");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("atom", args, 1);
            return new VncAtom(args.nth(0));
        }
    };
    public static VncFunction atom_Q = new VncFunction("atom?"){
        {
            this.setArgLists("(atom? x)");
            this.setDoc("Returns true if x is an atom, otherwise false");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("atom?", args, 1);
            return Types.isVncAtom(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction deref = new VncFunction("deref"){
        {
            this.setArgLists("(deref atom)");
            this.setDoc("Dereferences an atom, returns its value");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("deref", args, 1);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            return atm.deref();
        }
    };
    public static VncFunction reset_BANG = new VncFunction("reset!"){
        {
            this.setArgLists("(reset! atom newval)");
            this.setDoc("Sets the value of atom to newval without regard for the current value. Returns newval.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("reset!", args, 2);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            return atm.reset(args.nth(1));
        }
    };
    public static VncFunction swap_BANG = new VncFunction("swap!"){
        {
            this.setArgLists("(swap! atom f & args)");
            this.setDoc("Atomically swaps the value of atom to be: (apply f current-value-of-atom args). Note that f may be called multiple times, and thus should be free of side effects.  Returns the value that was swapped in.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertMinArity("swap!", args, 2);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            VncFunction fn = Coerce.toVncFunction(args.nth(1));
            VncList swapArgs = args.slice(2);
            return atm.swap(fn, swapArgs);
        }
    };
    public static VncFunction compare_and_set_BANG = new VncFunction("compare-and-set!"){
        {
            this.setArgLists("(compare-and-set! atom oldval newval)");
            this.setDoc("Atomically sets the value of atom to newval if and only if the current value of the atom is identical to oldval. Returns true if set happened, else false");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("compare-and-set!", args, 3);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            return atm.compare_and_set(args.nth(1), args.nth(2));
        }
    };
    public static VncFunction io_file = new VncFunction("io/file"){
        {
            this.setArgLists("(io/file path) (io/file parent child)");
            this.setDoc("Returns a java.io.File. path, parent, and child can be a string or java.io.File");
        }

        @Override
        public VncVal apply(VncList args) {
            File parentFile;
            CoreFunctions.assertArity("io/file", args, 1, 2);
            if (args.size() == 1) {
                VncVal path = args.nth(0);
                if (Types.isVncString(path)) {
                    return new VncJavaObject(new File(((VncString)path).getValue()));
                }
                if (CoreFunctions.isJavaIoFile(path)) {
                    return path;
                }
                throw new VncException(String.format("Function 'io/file' does not allow %s as path. %s", Types.getClassName(path), ErrorMessage.buildErrLocation(args)));
            }
            VncVal parent = args.nth(0);
            VncVal child = args.nth(1);
            if (Types.isVncString(parent)) {
                parentFile = new File(((VncString)parent).getValue());
            } else if (CoreFunctions.isJavaIoFile(parent)) {
                parentFile = (File)((VncJavaObject)parent).getDelegate();
            } else {
                throw new VncException(String.format("Function 'io/file' does not allow %s as parent. %s", Types.getClassName(parent), ErrorMessage.buildErrLocation(args)));
            }
            if (Types.isVncString(child)) {
                return new VncJavaObject(new File(parentFile, ((VncString)child).getValue()));
            }
            throw new VncException(String.format("Function 'io/file' does not allow %s as child. %s", Types.getClassName(child), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction io_file_Q = new VncFunction("io/file?"){
        {
            this.setArgLists("(io/file? x)");
            this.setDoc("Returns true if x is a java.io.File.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("io/file?", args, 1);
            VncVal path = args.nth(0);
            return CoreFunctions.isJavaIoFile(path) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction io_exists_file_Q = new VncFunction("io/exists-file?"){
        {
            this.setArgLists("(io/exists-file? x)");
            this.setDoc("Returns true if the file x exists. x must be a java.io.File.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("io/exists-file?", args, 1);
            if (!CoreFunctions.isJavaIoFile(args.nth(0))) {
                throw new VncException(String.format("Function 'io/exists-file?' does not allow %s as x. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            File file = (File)((VncJavaObject)args.nth(0)).getDelegate();
            return file.isFile() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction io_exists_dir_Q = new VncFunction("io/exists-dir?"){
        {
            this.setArgLists("(io/exists-dir? x)");
            this.setDoc("Returns true if the file x exists and is a directory. x must be a java.io.File.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("io/exists-dir?", args, 1);
            if (!CoreFunctions.isJavaIoFile(args.nth(0))) {
                throw new VncException(String.format("Function 'io/exists-dir?' does not allow %s as x. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            File file = (File)((VncJavaObject)args.nth(0)).getDelegate();
            return file.isDirectory() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction io_delete_file = new VncFunction("io/delete-file"){
        {
            this.setArgLists("(io/delete-file x)");
            this.setDoc("Deletes a file. x must be a java.io.File.");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().checkBlackListedVeniceFunction("io/delete-file", args);
            CoreFunctions.assertArity("io/delete-file", args, 1);
            if (!CoreFunctions.isJavaIoFile(args.nth(0))) {
                throw new VncException(String.format("Function 'io/delete-file' does not allow %s as x. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            File file = (File)((VncJavaObject)args.nth(0)).getDelegate();
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to delete file %s", file.getPath()), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_list_files = new VncFunction("io/list-files"){
        {
            this.setArgLists("(io/list-files dir filterFn?)");
            this.setDoc("Lists files in a directory. dir must be a java.io.File. filterFn is an optional filter that filters the files found");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().checkBlackListedVeniceFunction("io/list-files", args);
            CoreFunctions.assertArity("io/list-files", args, 1, 2);
            if (!CoreFunctions.isJavaIoFile(args.nth(0))) {
                throw new VncException(String.format("Function 'io/list-files' does not allow %s as x. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            File file = (File)((VncJavaObject)args.nth(0)).getDelegate();
            try {
                VncFunction filterFn = args.size() == 2 ? Coerce.toVncFunction(args.nth(1)) : null;
                VncList files = new VncList(new VncVal[0]);
                for (File f : file.listFiles()) {
                    VncConstant result;
                    VncVal vncVal = result = filterFn == null ? Constants.True : (VncVal)filterFn.apply(new VncList(new VncJavaObject(f)));
                    if (result != Constants.True) continue;
                    files.addAtEnd(new VncJavaObject(f));
                }
                return files;
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to list files %s. %s", file.getPath(), ErrorMessage.buildErrLocation(args)), ex);
            }
        }
    };
    public static VncFunction io_copy_file = new VncFunction("io/copy-file"){
        {
            this.setArgLists("(io/copy input output)");
            this.setDoc("Copies input to output. Returns nil or throws IOException. Input and output must be a java.io.File.");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().checkBlackListedVeniceFunction("io/copy-file", args);
            CoreFunctions.assertArity("io/copy-file", args, 2);
            if (!CoreFunctions.isJavaIoFile(args.nth(0))) {
                throw new VncException(String.format("Function 'io/delete-file' does not allow %s as input. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            if (!CoreFunctions.isJavaIoFile(args.nth(1))) {
                throw new VncException(String.format("Function 'io/delete-file' does not allow %s as output. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
            }
            File from = (File)((VncJavaObject)args.nth(0)).getDelegate();
            File to = (File)((VncJavaObject)args.nth(1)).getDelegate();
            try {
                Files.copy(from.toPath(), to.toPath(), new CopyOption[0]);
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to copy file %s to %s. %s", from.getPath(), to.getPath(), ErrorMessage.buildErrLocation(args)), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_tmp_dir = new VncFunction("io/tmp-dir"){
        {
            this.setArgLists("(io/tmp-dir)");
            this.setDoc("Returns the tmp dir as a java.io.File.");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().checkBlackListedVeniceFunction("io/tmp-dir", args);
            CoreFunctions.assertArity("io/tmp-dir", args, 0);
            return new VncJavaObject(new File(System.getProperty("java.io.tmpdir")));
        }
    };
    public static VncFunction io_user_dir = new VncFunction("io/user-dir"){
        {
            this.setArgLists("(io/user-dir)");
            this.setDoc("Returns the user dir (current working dir) as a java.io.File.");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().checkBlackListedVeniceFunction("io/user-dir", args);
            CoreFunctions.assertArity("io/user-dir", args, 0);
            return new VncJavaObject(new File(System.getProperty("user.dir")));
        }
    };
    public static VncFunction str_starts_with = new VncFunction("str/starts-with?"){
        {
            this.setArgLists("(str/starts-with? s substr)");
            this.setDoc("True if s starts with substr.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/starts-with?", args, 2);
            if (args.nth(0) == Constants.Nil || args.nth(1) == Constants.Nil) {
                return Constants.False;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            VncString prefix = Coerce.toVncString(args.nth(1));
            return string.getValue().startsWith(prefix.getValue()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction str_ends_with = new VncFunction("str/ends-with?"){
        {
            this.setArgLists("(str/ends-with? s substr)");
            this.setDoc("True if s ends with substr.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/ends-with?", args, 2);
            if (args.nth(0) == Constants.Nil || args.nth(1) == Constants.Nil) {
                return Constants.False;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            VncString suffix = Coerce.toVncString(args.nth(1));
            return string.getValue().endsWith(suffix.getValue()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction str_contains = new VncFunction("str/contains?"){
        {
            this.setArgLists("(str/contains? s substr)");
            this.setDoc("True if s contains with substr.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/contains?", args, 2);
            if (args.nth(0) == Constants.Nil || args.nth(1) == Constants.Nil) {
                return Constants.False;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            VncString text = Coerce.toVncString(args.nth(1));
            return string.getValue().contains(text.getValue()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction str_trim = new VncFunction("str/trim"){
        {
            this.setArgLists("(str/trim s substr)");
            this.setDoc("Trims leading and trailing spaces from s.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/trim", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(Coerce.toVncString(args.nth(0)).getValue().trim());
        }
    };
    public static VncFunction str_trim_to_nil = new VncFunction("str/trim-to-nil"){
        {
            this.setArgLists("(str/trim-to-nil s substr)");
            this.setDoc("Trims leading and trailing spaces from s. Returns nil if the rewsulting string is empry");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/trim-to-nil", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String str = Coerce.toVncString(args.nth(0)).getValue().trim();
            return str.isEmpty() ? Constants.Nil : new VncString(str);
        }
    };
    public static VncFunction str_index_of = new VncFunction("str/index-of"){
        {
            this.setArgLists("(str/index-of s value)", "(str/index-of s value from-index)");
            this.setDoc("Return index of value (string or char) in s, optionally searching forward from from-index. Return nil if value not found.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/index-of", args, 2, 3);
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            if (args.size() == 3) {
                int startPos = Coerce.toVncLong(args.nth(2)).getValue().intValue();
                int pos = text.indexOf(searchString, startPos);
                return pos < 0 ? Constants.Nil : new VncLong(pos);
            }
            int pos = text.indexOf(searchString);
            return pos < 0 ? Constants.Nil : new VncLong(pos);
        }
    };
    public static VncFunction str_last_index_of = new VncFunction("str/last-index-of"){
        {
            this.setArgLists("(str/last-index-of s value)", "(str/last-index-of s value from-index)");
            this.setDoc("Return last index of value (string or char) in s, optionally\nsearching backward from from-index. Return nil if value not found.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/last-index-of", args, 2, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            if (args.size() > 2) {
                int startPos = Coerce.toVncLong(args.nth(2)).getValue().intValue();
                int pos = text.lastIndexOf(searchString, startPos);
                return pos < 0 ? Constants.Nil : new VncLong(pos);
            }
            int pos = text.lastIndexOf(searchString);
            return pos < 0 ? Constants.Nil : new VncLong(pos);
        }
    };
    public static VncFunction str_replace_first = new VncFunction("str/replace-first"){
        {
            this.setArgLists("(str/replace-first s search replacement)");
            this.setDoc("Replaces the first occurrance of search in s");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/replace-first", args, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            String replacement = Coerce.toVncString(args.nth(2)).getValue();
            if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null) {
                return args.nth(0);
            }
            int pos = text.indexOf(searchString);
            return pos >= 0 ? new VncString(text.substring(0, pos) + replacement + text.substring(pos + replacement.length())) : args.nth(0);
        }
    };
    public static VncFunction str_replace_last = new VncFunction("str/replace-last"){
        {
            this.setArgLists("(str/replace-last s search replacement)");
            this.setDoc("Replaces the last occurrance of search in s");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/replace-last", args, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            String replacement = Coerce.toVncString(args.nth(2)).getValue();
            if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null) {
                return args.nth(0);
            }
            int pos = text.lastIndexOf(searchString);
            return pos >= 0 ? new VncString(text.substring(0, pos) + replacement + text.substring(pos + replacement.length())) : args.nth(0);
        }
    };
    public static VncFunction str_replace_all = new VncFunction("str/replace-all"){
        {
            this.setArgLists("(str/replace-all s search replacement)");
            this.setDoc("Replaces the all occurrances of search in s");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/replace-all", args, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            String replacement = Coerce.toVncString(args.nth(2)).getValue();
            if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null) {
                return args.nth(0);
            }
            String searchText = text;
            int start = 0;
            int end = searchText.indexOf(searchString, start);
            if (end == -1) {
                return args.nth(0);
            }
            int replLength = searchString.length();
            StringBuilder buf = new StringBuilder();
            while (end != -1) {
                buf.append(text, start, end).append(replacement);
                start = end + replLength;
                end = searchText.indexOf(searchString, start);
            }
            buf.append(text, start, text.length());
            return new VncString(buf.toString());
        }
    };
    public static VncFunction str_lower_case = new VncFunction("str/lower-case"){
        {
            this.setArgLists("(str/lower-case s)");
            this.setDoc("Converts s to lowercase");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/lower-case", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            return new VncString(string.getValue().toLowerCase());
        }
    };
    public static VncFunction str_upper_case = new VncFunction("str/upper-case"){
        {
            this.setArgLists("(str/upper-case s)");
            this.setDoc("Converts s to uppercase");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/upper-case", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            return new VncString(string.getValue().toUpperCase());
        }
    };
    public static VncFunction str_join = new VncFunction("str/join"){
        {
            this.setArgLists("(str/join coll)", "(str/join separator coll)");
            this.setDoc("Joins all elements in coll separated by an optional separator.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/join", args, 1, 2);
            VncList strings = Coerce.toVncList(args.nth(0));
            VncString delim = Coerce.toVncString(args.nth(1));
            return new VncString(strings.size() > 0 ? strings.getList().stream().map(v -> Types.isVncString(v) ? ((VncString)v).getValue() : v.toString()).collect(Collectors.joining(delim.getValue())) : "");
        }
    };
    public static VncFunction str_subs = new VncFunction("str/subs"){
        {
            this.setArgLists("(str/subs s start)", "(str/subs s start end)");
            this.setDoc("Returns the substring of s beginning at start inclusive, and ending at end (defaults to length of string), exclusive.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/subs", args, 2, 3);
            VncString string = Coerce.toVncString(args.nth(0));
            VncLong from = Coerce.toVncLong(args.nth(1));
            VncLong to = args.size() > 2 ? (VncLong)args.nth(2) : null;
            return new VncString(to == null ? string.getValue().substring(from.getValue().intValue()) : string.getValue().substring(from.getValue().intValue(), to.getValue().intValue()));
        }
    };
    public static VncFunction str_split = new VncFunction("str/split"){
        {
            this.setArgLists("(str/split s regex)");
            this.setDoc("Splits string on a regular expression.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/split", args, 2);
            VncString string = Coerce.toVncString(args.nth(0));
            VncString regex = Coerce.toVncString(args.nth(1));
            return new VncList(Arrays.asList(string.getValue().split(regex.getValue())).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
        }
    };
    public static VncFunction str_split_lines = new VncFunction("str/split-lines"){
        {
            this.setArgLists("(str/split-lines s)");
            this.setDoc("Splits s into lines.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/split-lines", args, 1);
            return args.nth(0) == Constants.Nil ? new VncList(new VncVal[0]) : new VncList(StringUtil.splitIntoLines(Coerce.toVncString(args.nth(0)).getValue()).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
        }
    };
    public static VncFunction str_format = new VncFunction("str/format"){
        {
            this.setArgLists("(str/format s format args*)");
            this.setDoc("Returns a formatted string using the specified format string and arguments.");
        }

        @Override
        public VncVal apply(VncList args) {
            VncString fmt = (VncString)args.nth(0);
            List fmtArgs = args.slice(1).getList().stream().map(v -> JavaInteropUtil.convertToJavaObject(v)).collect(Collectors.toList());
            return new VncString(String.format(fmt.getValue(), fmtArgs.toArray()));
        }
    };
    public static VncFunction str_truncate = new VncFunction("str/truncate"){
        {
            this.setArgLists("(str/truncate s maxlen marker)");
            this.setDoc("Truncates a string to the max lenght maxlen and adds the marker to the end if the string needs to be truncated");
            this.setExamples("(str/truncate \"abcdefghij\" 20 \"...\")", "(str/truncate \"abcdefghij\" 9 \"...\")", "(str/truncate \"abcdefghij\" 4 \"...\")");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/truncate", args, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.truncate(Coerce.toVncString(args.nth(0)).getValue(), Coerce.toVncLong(args.nth(1)).getValue().intValue(), Coerce.toVncString(args.nth(2)).getValue()));
        }
    };
    public static VncFunction str_strip_start = new VncFunction("str/strip-start"){
        {
            this.setArgLists("(str/strip-start s substr)");
            this.setDoc("Removes a substr only if it is at the beginning of a s, otherwise returns s.");
            this.setExamples("(str/strip-start \"abcdef\" \"abc\")", "(str/strip-start \"abcdef\" \"def\")");
        }

        @Override
        public VncVal apply(VncList args) {
            String substr;
            CoreFunctions.assertArity("str/strip-start", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.nth(0)).getValue();
            return new VncString(s.startsWith(substr = Coerce.toVncString(args.nth(1)).getValue()) ? s.substring(substr.length()) : s);
        }
    };
    public static VncFunction str_strip_end = new VncFunction("str/strip-end"){
        {
            this.setArgLists("(str/strip-end s substr)");
            this.setDoc("Removes a substr only if it is at the end of a s, otherwise returns s.");
            this.setExamples("(str/strip-end \"abcdef\" \"def\")", "(str/strip-end \"abcdef\" \"abc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            String substr;
            CoreFunctions.assertArity("str/strip-end", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.nth(0)).getValue();
            return new VncString(s.endsWith(substr = Coerce.toVncString(args.nth(1)).getValue()) ? s.substring(0, s.length() - substr.length()) : s);
        }
    };
    public static VncFunction str_strip_indent = new VncFunction("str/strip-indent"){
        {
            this.setArgLists("(str/strip-indent s)");
            this.setDoc("Strip the indent of a multi-line string. The first line's leading whitespaces define the indent.");
            this.setExamples("(str/strip-indent \"  line1\n    line2\n    line3\")");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/strip-indent", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.stripIndent(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction str_strip_margin = new VncFunction("str/strip-margin"){
        {
            this.setArgLists("(str/strip-margin s)");
            this.setDoc("Strips leading whitespaces upto and including the margin '|' from each line in a multi-line string.");
            this.setExamples("(str/strip-margin \"line1\n  |  line2\n  |  line3\")");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/strip-margin", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.stripMargin(Coerce.toVncString(args.first()).getValue(), '|'));
        }
    };
    public static VncFunction str_repeat = new VncFunction("str/repeat"){
        {
            this.setArgLists("(str/repeat s n)", "(str/repeat s n sep)");
            this.setDoc("Repeats s n times with an optional separator.");
            this.setExamples("(str/repeat \"abc\" 0)", "(str/repeat \"abc\" 3)", "(str/repeat \"abc\" 3 \"-\")");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("str/repeat", args, 2, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.nth(0)).getValue();
            int times = Coerce.toVncLong(args.nth(1)).getValue().intValue();
            String sep = args.size() == 3 ? Coerce.toVncString(args.nth(2)).getValue() : "";
            StringBuilder sb = new StringBuilder();
            for (int ii = 0; ii < times; ++ii) {
                if (ii > 0) {
                    sb.append(sep);
                }
                sb.append(s);
            }
            return new VncString(sb.toString());
        }
    };
    public static VncFunction version = new VncFunction("version"){
        {
            this.setArgLists("(version)");
            this.setDoc("Returns the version.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("version", args, 0);
            return new VncString("0.6.1");
        }
    };
    public static VncFunction gensym = new VncFunction("gensym"){
        {
            this.setArgLists("(gensym)", "(gensym prefix)");
            this.setDoc("Generates a symbol.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("gensym", args, 0, 1);
            String prefix = args.isEmpty() ? "G__" : (Types.isVncSymbol(args.nth(0)) ? Coerce.toVncSymbol(args.nth(0)).getName() : Coerce.toVncString(args.nth(0)).getValue());
            return new VncSymbol(prefix + String.valueOf(gensymValue.incrementAndGet()));
        }
    };
    public static VncFunction uuid = new VncFunction("uuid"){
        {
            this.setArgLists("(uuid)");
            this.setDoc("Generates a UUID.");
        }

        @Override
        public VncVal apply(VncList args) {
            CoreFunctions.assertArity("uuid", args, 0);
            return new VncString(UUID.randomUUID().toString());
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("doc", (VncVal)doc).put("throw", (VncVal)throw_ex).put("nil?", (VncVal)nil_Q).put("some?", (VncVal)some_Q).put("true?", (VncVal)true_Q).put("false?", (VncVal)false_Q).put("boolean?", (VncVal)boolean_Q).put("long?", (VncVal)long_Q).put("double?", (VncVal)double_Q).put("decimal?", (VncVal)decimal_Q).put("number?", (VncVal)number_Q).put("bytebuf?", (VncVal)bytebuf_Q).put("string?", (VncVal)string_Q).put("symbol", (VncVal)symbol).put("symbol?", (VncVal)symbol_Q).put("keyword", (VncVal)keyword).put("keyword?", (VncVal)keyword_Q).put("fn?", (VncVal)fn_Q).put("macro?", (VncVal)macro_Q).put("pr-str", (VncVal)pr_str).put("str", (VncVal)str).put("prn", (VncVal)prn).put("println", (VncVal)println).put("readline", (VncVal)readline).put("read-string", (VncVal)read_string).put("slurp", (VncVal)slurp).put("spit", (VncVal)spit).put("==", (VncVal)equal_Q).put("!=", (VncVal)not_equal_Q).put("<", (VncVal)lt).put("<=", (VncVal)lte).put(">", (VncVal)gt).put(">=", (VncVal)gte).put("match", (VncVal)match_Q).put("match-not", (VncVal)match_not_Q).put("dec/scale", (VncVal)decimalScale).put("dec/add", (VncVal)decimalAdd).put("dec/sub", (VncVal)decimalSubtract).put("dec/mul", (VncVal)decimalMultiply).put("dec/div", (VncVal)decimalDivide).put("+", (VncVal)add).put("-", (VncVal)subtract).put("*", (VncVal)multiply).put("/", (VncVal)divide).put("mod", (VncVal)modulo).put("inc", (VncVal)inc).put("dec", (VncVal)dec).put("abs", (VncVal)abs).put("min", (VncVal)min).put("max", (VncVal)max).put("boolean", (VncVal)boolean_cast).put("long", (VncVal)long_cast).put("double", (VncVal)double_cast).put("decimal", (VncVal)decimal_cast).put("bytebuf", (VncVal)bytebuf_cast).put("zero?", (VncVal)zero_Q).put("pos?", (VncVal)pos_Q).put("neg?", (VncVal)neg_Q).put("even?", (VncVal)even_Q).put("odd?", (VncVal)odd_Q).put("time-ms", (VncVal)time_ms).put("time-ns", (VncVal)time_ns).put("rand-long", (VncVal)rand_long).put("rand-double", (VncVal)rand_double).put("list", (VncVal)new_list).put("list?", (VncVal)list_Q).put("vector", (VncVal)new_vector).put("vector?", (VncVal)vector_Q).put("set?", (VncVal)set_Q).put("map?", (VncVal)map_Q).put("hash-map?", (VncVal)hash_map_Q).put("ordered-map?", (VncVal)ordered_map_Q).put("sorted-map?", (VncVal)sorted_map_Q).put("set", (VncVal)new_set).put("hash-map", (VncVal)new_hash_map).put("ordered-map", (VncVal)new_ordered_map).put("sorted-map", (VncVal)new_sorted_map).put("assoc", (VncVal)assoc).put("dissoc", (VncVal)dissoc).put("contains?", (VncVal)contains_Q).put("find", (VncVal)find).put("get", (VncVal)get).put("key", (VncVal)key).put("keys", (VncVal)keys).put("val", (VncVal)val).put("vals", (VncVal)vals).put("subvec", (VncVal)subvec).put("subbytebuf", (VncVal)subbytebuf).put("into", (VncVal)into).put("seq?", (VncVal)seq_Q).put("coll?", (VncVal)coll_Q).put("cons", (VncVal)cons).put("co", (VncVal)cons).put("concat", (VncVal)concat).put("interpose", (VncVal)interpose).put("interleave", (VncVal)interleave).put("mapcat", (VncVal)mapcat).put("nth", (VncVal)nth).put("first", (VncVal)first).put("second", (VncVal)second).put("last", (VncVal)last).put("rest", (VncVal)rest).put("nfirst", (VncVal)nfirst).put("nlast", (VncVal)nlast).put("empty-to-nil", (VncVal)emptyToNil).put("pop", (VncVal)pop).put("peek", (VncVal)peek).put("empty?", (VncVal)empty_Q).put("not-empty?", (VncVal)not_empty_Q).put("count", (VncVal)count).put("apply", (VncVal)apply).put("comp", (VncVal)comp).put("partial", (VncVal)partial).put("map", (VncVal)map).put("filter", (VncVal)filter).put("distinct", (VncVal)distinct).put("dedupe", (VncVal)dedupe).put("partition", (VncVal)partition).put("remove", (VncVal)remove).put("reduce", (VncVal)reduce).put("reduce-kv", (VncVal)reduce_kv).put("take", (VncVal)take).put("take-while", (VncVal)take_while).put("drop", (VncVal)drop).put("drop-while", (VncVal)drop_while).put("flatten", (VncVal)flatten).put("reverse", (VncVal)reverse).put("group-by", (VncVal)group_by).put("sort", (VncVal)sort).put("sort-by", (VncVal)sort_by).put("conj", (VncVal)conj).put("seq", (VncVal)seq).put("range", (VncVal)range).put("repeat", (VncVal)repeat).put("meta", (VncVal)meta).put("with-meta", (VncVal)with_meta).put("vary-meta", (VncVal)vary_meta).put("atom", (VncVal)new_atom).put("atom?", (VncVal)atom_Q).put("deref", (VncVal)deref).put("reset!", (VncVal)reset_BANG).put("swap!", (VncVal)swap_BANG).put("compare-and-set!", (VncVal)compare_and_set_BANG).put("coalesce", (VncVal)coalesce).put("gensym", (VncVal)gensym).put("uuid", (VncVal)uuid).put("version", (VncVal)version).put("io/file", (VncVal)io_file).put("io/file?", (VncVal)io_file_Q).put("io/exists-file?", (VncVal)io_exists_file_Q).put("io/exists-dir?", (VncVal)io_exists_dir_Q).put("io/list-files", (VncVal)io_list_files).put("io/delete-file", (VncVal)io_delete_file).put("io/copy-file", (VncVal)io_copy_file).put("io/tmp-dir", (VncVal)io_tmp_dir).put("io/user-dir", (VncVal)io_user_dir).put("str/starts-with?", (VncVal)str_starts_with).put("str/ends-with?", (VncVal)str_ends_with).put("str/contains?", (VncVal)str_contains).put("str/trim", (VncVal)str_trim).put("str/trim-to-nil", (VncVal)str_trim_to_nil).put("str/index-of", (VncVal)str_index_of).put("str/last-index-of", (VncVal)str_last_index_of).put("str/replace-first", (VncVal)str_replace_first).put("str/replace-last", (VncVal)str_replace_last).put("str/replace-all", (VncVal)str_replace_all).put("str/lower-case", (VncVal)str_lower_case).put("str/upper-case", (VncVal)str_upper_case).put("str/join", (VncVal)str_join).put("str/subs", (VncVal)str_subs).put("str/split", (VncVal)str_split).put("str/split-lines", (VncVal)str_split_lines).put("str/format", (VncVal)str_format).put("str/truncate", (VncVal)str_truncate).put("str/strip-start", (VncVal)str_strip_start).put("str/strip-end", (VncVal)str_strip_end).put("str/strip-indent", (VncVal)str_strip_indent).put("str/strip-margin", (VncVal)str_strip_margin).put("str/repeat", (VncVal)str_repeat).put("class", (VncVal)className).put("load-core-module", (VncVal)loadCoreModule).toMap();
    private static final AtomicLong gensymValue = new AtomicLong(0L);
    private static final Random random = new Random();

    public static boolean list_Q(VncVal mv) {
        return mv.getClass().equals(VncList.class);
    }

    public static boolean vector_Q(VncVal mv) {
        return mv.getClass().equals(VncVector.class);
    }

    public static Set<String> getAllIoFunctions() {
        return new HashSet<String>(Arrays.asList("prn", "println", "readline", "slurp", "spit", "load-file", "io/exists-file?", "io/exists-dir?", "io/list-files", "io/delete-file", "io/copy-file", "io/tmp-dir", "io/user-dir"));
    }

    private static void flatten(VncVal value, List<VncVal> result) {
        if (Types.isVncList(value)) {
            ((VncList)value).getList().forEach(v -> CoreFunctions.flatten(v, result));
        } else if (Types.isVncHashMap(value)) {
            ((VncHashMap)value).entries().forEach(e -> {
                result.add((VncVal)e.getKey());
                CoreFunctions.flatten((VncVal)e.getValue(), result);
            });
        } else {
            result.add(value);
        }
    }

    public static void assertArity(String fnName, VncList args, int ... expectedArities) {
        int arity = args.size();
        for (int a : expectedArities) {
            if (a != arity) continue;
            return;
        }
        throw new ArityException(args, arity, fnName);
    }

    private static void assertMinArity(String fnName, VncList args, int minArity) {
        int arity = args.size();
        if (arity < minArity) {
            throw new ArityException(args, arity, fnName);
        }
    }

    private static boolean isJavaIoFile(VncVal val) {
        return Types.isVncJavaObject(val) && ((VncJavaObject)val).getDelegate() instanceof File;
    }
}

