/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Binding;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.ArrayList;
import java.util.List;

public class Destructuring {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Binding> destructure(VncVal symVal, VncVal bindVal) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        if (Types.isVncSymbol(symVal)) {
            bindings.add(new Binding((VncSymbol)symVal, bindVal));
            return bindings;
        }
        if (!Types.isVncList(symVal)) throw new VncException(String.format("Invalid destructuring sym value type %s. Expected symbol.", Types.getClassName(symVal)));
        if (Types.isVncList(bindVal)) {
            List<VncVal> symbols = ((VncList)symVal).getList();
            List<VncVal> values = ((VncList)bindVal).getList();
            for (int ii = 0; ii < symbols.size(); ++ii) {
                VncSymbol sym;
                if (Destructuring.isIgnoreBindingSymbol(symbols.get(ii))) continue;
                if (Destructuring.isElisionSymbol(symbols.get(ii))) {
                    sym = (VncSymbol)symbols.get(ii + 1);
                    VncConstant vncConstant = ii <= values.size() ? ((VncList)bindVal).slice(ii) : Constants.Nil;
                    bindings.add(new Binding(sym, vncConstant));
                    return bindings;
                }
                if (Types.isVncSymbol(symbols.get(ii))) {
                    sym = (VncSymbol)symbols.get(ii);
                    VncConstant vncConstant = ii < values.size() ? values.get(ii) : Constants.Nil;
                    bindings.add(new Binding(sym, vncConstant));
                    continue;
                }
                if (!Types.isVncList(symbols.get(ii))) continue;
                VncVal syms = symbols.get(ii);
                VncConstant vncConstant = ii < values.size() ? values.get(ii) : Constants.Nil;
                bindings.addAll(Destructuring.destructure(syms, vncConstant));
            }
            return bindings;
        }
        if (!Types.isVncString(bindVal)) throw new VncException(String.format("Invalid destructuring bind value type %s. Expected list, vector, or string.", Types.getClassName(bindVal)));
        List<VncVal> symbols = ((VncList)symVal).getList();
        List<VncVal> values = ((VncString)bindVal).toVncList().getList();
        for (int ii = 0; ii < symbols.size(); ++ii) {
            VncSymbol sym;
            if (Destructuring.isIgnoreBindingSymbol(symbols.get(ii))) continue;
            if (Destructuring.isElisionSymbol(symbols.get(ii))) {
                sym = (VncSymbol)symbols.get(ii + 1);
                VncList vncList = ((VncString)bindVal).toVncList().slice(ii);
                bindings.add(new Binding(sym, vncList));
                return bindings;
            }
            sym = (VncSymbol)symbols.get(ii);
            VncConstant vncConstant = ii < values.size() ? values.get(ii) : Constants.Nil;
            bindings.add(new Binding(sym, vncConstant));
        }
        return bindings;
    }

    private static boolean isElisionSymbol(VncVal val) {
        return Types.isVncSymbol(val) && ((VncSymbol)val).getName().equals("&");
    }

    private static boolean isIgnoreBindingSymbol(VncVal val) {
        return Types.isVncSymbol(val) && ((VncSymbol)val).getName().equals("_");
    }
}

