/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.CoreFunctions;
import com.github.jlangch.venice.impl.CoreMacroDefs;
import com.github.jlangch.venice.impl.MacroDef;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class Doc {
    private static final Map<String, VncFunction> functions = new HashMap<String, VncFunction>();
    private static final Map<String, MacroDef> macros = new HashMap<String, MacroDef>();

    public static String getDoc(String name) {
        VncFunction func = functions.get(name);
        if (func != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(func.getArgLists().getList().stream().map(s -> Doc.toString(s)).collect(Collectors.joining(", ")));
            sb.append("\n");
            sb.append(Doc.toString(func.getDoc()));
            return sb.toString();
        }
        MacroDef macro = macros.get(name);
        if (macro != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(macro.getSignatures().stream().collect(Collectors.joining(", ")));
            sb.append("\n");
            sb.append(macro.getDescription());
            return sb.toString();
        }
        return "<no documentation available>";
    }

    private static String toString(VncVal val) {
        return val == Constants.Nil ? "" : ((VncString)val).getValue();
    }

    static {
        CoreFunctions.ns.values().forEach(f -> functions.put(((VncFunction)f).getName(), (VncFunction)f));
        CoreMacroDefs.getMacros().forEach(m -> macros.put(m.getName(), (MacroDef)m));
    }
}

