/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.CoreFunctions;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Reader;
import com.github.jlangch.venice.impl.RecursionPoint;
import com.github.jlangch.venice.impl.javainterop.JavaImports;
import com.github.jlangch.venice.impl.javainterop.JavaInteropFn;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;

public class VeniceInterpreter {
    private final JavaImports javaImports = new JavaImports();

    public VncVal READ(String script, String filename) {
        return Reader.read_str(script, filename);
    }

    public static boolean is_pair(VncVal x) {
        return x instanceof VncList && !((VncList)x).isEmpty();
    }

    public static VncVal quasiquote(VncVal ast) {
        VncVal a00;
        if (!VeniceInterpreter.is_pair(ast)) {
            return new VncList(new VncSymbol("quote"), ast);
        }
        VncVal a0 = Coerce.toVncList(ast).nth(0);
        if (a0 instanceof VncSymbol && Coerce.toVncSymbol(a0).getName().equals("unquote")) {
            return ((VncList)ast).nth(1);
        }
        if (VeniceInterpreter.is_pair(a0) && (a00 = Coerce.toVncList(a0).nth(0)) instanceof VncSymbol && ((VncSymbol)a00).getName().equals("splice-unquote")) {
            return new VncList(new VncSymbol("concat"), Coerce.toVncList(a0).nth(1), VeniceInterpreter.quasiquote(((VncList)ast).rest()));
        }
        return new VncList(new VncSymbol("cons"), VeniceInterpreter.quasiquote(a0), VeniceInterpreter.quasiquote(((VncList)ast).rest()));
    }

    public boolean is_macro_call(VncVal ast, Env env) {
        VncVal fn;
        VncSymbol macroName;
        VncVal a0;
        return Types.isVncList(ast) && !((VncList)ast).isEmpty() && Types.isVncSymbol(a0 = Coerce.toVncList(ast).nth(0)) && env.find(macroName = (VncSymbol)a0) != null && Types.isVncFunction(fn = env.get(macroName)) && ((VncFunction)fn).isMacro();
    }

    public VncVal macroexpand(VncVal ast, Env env) {
        while (this.is_macro_call(ast, env)) {
            VncSymbol macroName = Coerce.toVncSymbol(Coerce.toVncList(ast).nth(0));
            VncFunction macroFn = Coerce.toVncFunction(env.get(macroName));
            VncList macroFnArgs = Coerce.toVncList(ast).rest();
            ast = (VncVal)macroFn.apply(macroFnArgs);
        }
        return ast;
    }

    public VncVal eval_ast(VncVal ast, Env env) {
        if (ast instanceof VncSymbol) {
            return env.get((VncSymbol)ast);
        }
        if (ast instanceof VncList) {
            VncList old_lst = (VncList)ast;
            VncList new_lst = old_lst.empty();
            new_lst.setMeta(old_lst.getMeta().copy());
            old_lst.forEach(mv -> new_lst.addAtEnd(this.EVAL((VncVal)mv, env)));
            return new_lst;
        }
        if (ast instanceof VncMap) {
            VncMap old_map = (VncMap)ast;
            VncMap new_map = (VncMap)old_map.empty();
            new_map.setMeta(old_map.getMeta().copy());
            ((VncMap)ast).getMap().entrySet().forEach(entry -> new_map.getMap().put((VncVal)entry.getKey(), this.EVAL((VncVal)entry.getValue(), env)));
            return new_map;
        }
        return ast;
    }

    public VncVal EVAL(VncVal orig_ast, Env env) {
        VncList el;
        block55: {
            VncFunction f;
            RecursionPoint recursionPoint = null;
            block39: while (true) {
                String a0sym;
                if (!orig_ast.isList()) {
                    return this.eval_ast(orig_ast, env);
                }
                VncVal expanded = this.macroexpand(orig_ast, env);
                if (!expanded.isList()) {
                    return this.eval_ast(expanded, env);
                }
                VncList ast = (VncList)expanded;
                if (ast.isEmpty()) {
                    return ast;
                }
                VncVal a0 = ast.nth(0);
                switch (a0sym = a0 instanceof VncSymbol ? ((VncSymbol)a0).getName() : "__<*fn*>__") {
                    case "def": {
                        boolean hasMeta = ast.size() > 3;
                        VncHashMap defMeta = hasMeta ? (VncHashMap)this.EVAL(ast.nth(1), env) : new VncHashMap(new VncVal[0]);
                        VncSymbol defName = Coerce.toVncSymbol(ast.nth(hasMeta ? 2 : 1));
                        VncVal defVal = ast.nth(hasMeta ? 3 : 2);
                        VncVal res = this.EVAL(defVal, env);
                        env.set(defName, MetaUtil.addDefMeta(res, defMeta));
                        return res;
                    }
                    case "eval": {
                        orig_ast = Coerce.toVncList(this.eval_ast(ast.slice(1), env)).last();
                        continue block39;
                    }
                    case "let": {
                        env = new Env(env);
                        VncList bindings = Coerce.toVncList(ast.nth(1));
                        VncVal expressions = ast.slice(2);
                        for (int i = 0; i < bindings.size(); i += 2) {
                            VncVal sym = bindings.nth(i);
                            VncVal val = this.EVAL(bindings.nth(i + 1), env);
                            Env _env = env;
                            Destructuring.destructure(sym, val).forEach(b -> _env.set(b.sym, b.val));
                        }
                        if (((VncList)expressions).isEmpty()) {
                            orig_ast = Constants.Nil;
                            continue block39;
                        }
                        this.eval_ast(((VncList)expressions).slice(0, ((VncList)expressions).size() - 1), env);
                        orig_ast = ((VncList)expressions).last();
                        continue block39;
                    }
                    case "loop": {
                        env = new Env(env);
                        VncList bindings = Coerce.toVncList(ast.nth(1));
                        VncVal expressions = ast.nth(2);
                        VncList bindingNames = new VncList(new VncVal[0]);
                        for (int i = 0; i < bindings.size(); i += 2) {
                            VncVal sym = bindings.nth(i);
                            VncVal val = this.EVAL(bindings.nth(i + 1), env);
                            Env _env = env;
                            Destructuring.destructure(sym, val).forEach(b -> {
                                _env.set(b.sym, b.val);
                                bindingNames.addAtEnd(b.sym);
                            });
                        }
                        recursionPoint = new RecursionPoint(bindingNames, expressions, env);
                        orig_ast = expressions;
                        continue block39;
                    }
                    case "recur": {
                        VncList recur_values = new VncList(new VncVal[0]);
                        for (int i = 1; i < ast.size(); ++i) {
                            recur_values.addAtEnd(this.EVAL(ast.nth(i), env));
                        }
                        VncList recur_bindingNames = recursionPoint.getLoopBindingNames();
                        Env recur_env = recursionPoint.getLoopEnv();
                        for (int i = 0; i < recur_bindingNames.size(); ++i) {
                            VncSymbol key = Coerce.toVncSymbol(recur_bindingNames.nth(i));
                            recur_env.set(key, recur_values.nth(i));
                        }
                        orig_ast = recursionPoint.getLoopExpressions();
                        env = recur_env;
                        continue block39;
                    }
                    case "quote": {
                        return ast.nth(1);
                    }
                    case "quasiquote": {
                        orig_ast = VeniceInterpreter.quasiquote(ast.nth(1));
                        continue block39;
                    }
                    case "defmacro": {
                        boolean hasMeta = ast.size() > 4;
                        VncHashMap defMeta = hasMeta ? (VncMap)this.EVAL(ast.nth(1), env) : new VncHashMap(new VncVal[0]);
                        VncVal macroName = ast.nth(hasMeta ? 2 : 1);
                        VncVal macroParams = Coerce.toVncList(ast.nth(hasMeta ? 3 : 2));
                        VncVal macroFnAst = ast.nth(hasMeta ? 4 : 3);
                        String sMacroName = Types.isVncSymbol(macroName) ? ((VncSymbol)macroName).getName() : ((VncString)macroName).getValue();
                        final Env _env = env;
                        VncFunction macroFn = new VncFunction(sMacroName, macroFnAst, env, (VncList)macroParams, (VncList)macroParams, macroFnAst){
                            final /* synthetic */ VncList val$macroParams;
                            final /* synthetic */ VncVal val$macroFnAst;
                            {
                                this.val$macroParams = vncList;
                                this.val$macroFnAst = vncVal;
                                super(name, ast, env, params);
                            }

                            @Override
                            public VncVal apply(VncList args) {
                                Env localEnv = new Env(_env);
                                Destructuring.destructure(this.val$macroParams, args).forEach(b -> localEnv.set(b.sym, b.val));
                                VncVal result = VeniceInterpreter.this.EVAL(this.val$macroFnAst, localEnv);
                                return result;
                            }
                        };
                        macroFn.setMacro();
                        env.set((VncSymbol)macroName, MetaUtil.addDefMeta(macroFn, defMeta));
                        return macroFn;
                    }
                    case "macroexpand": {
                        VncVal a1 = ast.nth(1);
                        return this.macroexpand(a1, env);
                    }
                    case "try": {
                        VncVal result;
                        VncVal macroParams;
                        try {
                            VncVal a1 = this.EVAL(ast.nth(1), env);
                            return a1;
                        }
                        catch (Throwable t) {
                            if (ast.size() > 2) {
                                VncList catchBlock = this.findFirstCatchBlock(ast.slice(2));
                                if (catchBlock != null) {
                                    result = this.eval_ast(catchBlock.slice(1), env);
                                    macroParams = Coerce.toVncList(result).first();
                                    return macroParams;
                                }
                                result = Constants.Nil;
                                return result;
                            }
                            throw t;
                        }
                        finally {
                            VncList finallyBlock;
                            if (ast.size() > 2 && (finallyBlock = this.findFirstFinallyBlock(ast.slice(2))) != null) {
                                result = this.eval_ast(finallyBlock.slice(1), env);
                                return Coerce.toVncList(result).first();
                            }
                        }
                    }
                    case "do": {
                        if (ast.size() < 2) {
                            orig_ast = Constants.Nil;
                            continue block39;
                        }
                        VncList head_exprs = ast.slice(1, ast.size() - 1);
                        this.eval_ast(head_exprs, env);
                        orig_ast = ast.last();
                        continue block39;
                    }
                    case "if": {
                        VncVal condArg = ast.nth(1);
                        VncVal cond = this.EVAL(condArg, env);
                        if (cond == Constants.Nil || cond == Constants.False) {
                            if (ast.size() > 3) {
                                orig_ast = ast.nth(3);
                                continue block39;
                            }
                            return Constants.Nil;
                        }
                        orig_ast = ast.nth(2);
                        continue block39;
                    }
                    case "fn": {
                        final VncList fnParams = Coerce.toVncList(ast.nth(1));
                        final VncVal fnAst = ast.nth(2);
                        final Env cur_env = env;
                        return new VncFunction(fnAst, env, fnParams){

                            @Override
                            public VncVal apply(VncList args) {
                                Env localEnv = new Env(cur_env);
                                Destructuring.destructure(fnParams, args).forEach(b -> localEnv.set(b.sym, b.val));
                                return VeniceInterpreter.this.EVAL(fnAst, localEnv);
                            }
                        };
                    }
                    case "import": {
                        ast.slice(1).forEach(clazz -> this.javaImports.add(Coerce.toVncString(clazz).getValue()));
                        return Constants.Nil;
                    }
                }
                el = Coerce.toVncList(this.eval_ast(ast, env));
                if (!Types.isVncFunction(el.nth(0))) break block55;
                f = (VncFunction)el.nth(0);
                VncVal fnast = f.getAst();
                if (fnast == null) break;
                orig_ast = fnast;
                env = f.genEnv(el.slice(1));
            }
            VncList fnArgs = el.rest();
            MetaUtil.copyTokenPos(el, fnArgs);
            return (VncVal)f.apply(fnArgs);
        }
        if (Types.isVncKeyword(el.nth(0))) {
            VncKeyword k = (VncKeyword)el.nth(0);
            VncList fnArgs = el.rest();
            MetaUtil.copyTokenPos(el, fnArgs);
            return k.apply(fnArgs);
        }
        throw new VncException(String.format("Not a function or keyword: '%s'", this.PRINT(el.nth(0))));
    }

    public String PRINT(VncVal exp) {
        return Printer._pr_str(exp, true);
    }

    public VncVal RE(String script, String filename, Env env) {
        VncVal ast = this.READ(script, filename);
        return this.EVAL(ast, env);
    }

    public Env createEnv() {
        Env env = new Env(null);
        CoreFunctions.ns.keySet().forEach(key -> env.set(Types.isVncSymbol(key) ? (VncSymbol)key : ((VncString)key).toSymbol(), CoreFunctions.ns.get(key)));
        env.set(new VncSymbol("."), JavaInteropFn.create(this.javaImports));
        env.set(new VncSymbol("*VERSION*"), new VncString("0.6.1"));
        this.RE("(eval " + ModuleLoader.load("core") + ")", "core.venice", env);
        return env;
    }

    private VncList findFirstCatchBlock(VncList blocks) {
        for (int ii = 0; ii < blocks.size(); ++ii) {
            VncList block = (VncList)blocks.nth(ii);
            VncSymbol sym = (VncSymbol)block.nth(0);
            if (!sym.getName().equals("catch")) continue;
            return block;
        }
        return null;
    }

    private VncList findFirstFinallyBlock(VncList blocks) {
        for (int ii = 0; ii < blocks.size(); ++ii) {
            VncList block = Coerce.toVncList(blocks.nth(ii));
            VncSymbol sym = Coerce.toVncSymbol(block.nth(0));
            if (!sym.getName().equals("finally")) continue;
            return block;
        }
        return null;
    }
}

