/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncJavaMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaObject;
import com.github.jlangch.venice.impl.types.collections.VncJavaSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncSortedMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.Map;

public class Types {
    public static boolean isVncAtom(VncVal val) {
        return val != null && val instanceof VncAtom;
    }

    public static boolean isVncString(VncVal val) {
        return val != null && val instanceof VncString;
    }

    public static boolean isVncKeyword(String s) {
        return s.length() != 0 && s.charAt(0) == Constants.KEYWORD_PREFIX;
    }

    public static boolean isVncKeyword(VncVal val) {
        return val != null && val instanceof VncKeyword;
    }

    public static boolean isVncSymbol(VncVal val) {
        return val != null && val instanceof VncSymbol;
    }

    public static boolean isVncLong(VncVal val) {
        return val != null && val instanceof VncLong;
    }

    public static boolean isVncDouble(VncVal val) {
        return val != null && val instanceof VncDouble;
    }

    public static boolean isVncBigDecimal(VncVal val) {
        return val != null && val instanceof VncBigDecimal;
    }

    public static boolean isVncNumber(VncVal val) {
        return val != null && (Types.isVncLong(val) || Types.isVncDouble(val) || Types.isVncBigDecimal(val));
    }

    public static boolean isVncByteBuffer(VncVal val) {
        return val != null && val instanceof VncByteBuffer;
    }

    public static boolean isVncCollection(VncVal val) {
        return val != null && val instanceof VncCollection;
    }

    public static boolean isVncSet(VncVal val) {
        return val != null && val instanceof VncSet;
    }

    public static boolean isVncList(VncVal val) {
        return val != null && val instanceof VncList;
    }

    public static boolean isVncVector(VncVal val) {
        return val != null && val instanceof VncVector;
    }

    public static boolean isVncMap(VncVal val) {
        return val != null && val instanceof VncMap;
    }

    public static boolean isVncHashMap(VncVal val) {
        return val != null && val instanceof VncHashMap;
    }

    public static boolean isVncOrderedMap(VncVal val) {
        return val != null && val instanceof VncOrderedMap;
    }

    public static boolean isVncSortedMap(VncVal val) {
        return val != null && val instanceof VncSortedMap;
    }

    public static boolean isVncFunction(VncVal val) {
        return val != null && val instanceof VncFunction;
    }

    public static boolean isVncFunctionOrKeyword(VncVal val) {
        return val != null && (val instanceof VncFunction || val instanceof VncKeyword);
    }

    public static boolean isVncJavaObject(VncVal val) {
        return val != null && val instanceof VncJavaObject;
    }

    public static boolean isVncJavaList(VncVal val) {
        return val != null && val instanceof VncJavaList;
    }

    public static boolean isVncJavaSet(VncVal val) {
        return val != null && val instanceof VncJavaSet;
    }

    public static boolean isVncJavaMap(VncVal val) {
        return val != null && val instanceof VncJavaMap;
    }

    public static VncString getClassName(VncVal val) {
        if (val == Constants.Nil) {
            return new VncString("venice.Nil");
        }
        if (val == Constants.True || val == Constants.False) {
            return new VncString("venice.Boolean");
        }
        if (Types.isVncAtom(val)) {
            return new VncString("venice.Atom");
        }
        if (Types.isVncLong(val)) {
            return new VncString("venice.Long");
        }
        if (Types.isVncDouble(val)) {
            return new VncString("venice.Double");
        }
        if (Types.isVncBigDecimal(val)) {
            return new VncString("venice.Decimal");
        }
        if (Types.isVncByteBuffer(val)) {
            return new VncString("venice.ByteBuffer");
        }
        if (Types.isVncFunction(val)) {
            return new VncString("venice.Function");
        }
        if (Types.isVncString(val)) {
            return new VncString("venice.String");
        }
        if (Types.isVncSymbol(val)) {
            return new VncString("venice.Symbol");
        }
        if (Types.isVncSet(val)) {
            return new VncString("venice.Set");
        }
        if (Types.isVncVector(val)) {
            return new VncString("venice.Vector");
        }
        if (Types.isVncList(val)) {
            return new VncString("venice.List");
        }
        if (Types.isVncHashMap(val)) {
            return new VncString("venice.HashMap");
        }
        if (Types.isVncOrderedMap(val)) {
            return new VncString("venice.OrderedMap");
        }
        if (Types.isVncSortedMap(val)) {
            return new VncString("venice.SortedMap");
        }
        if (Types.isVncJavaObject(val)) {
            return new VncString("venice.JavaObject(" + ((IVncJavaObject)((Object)val)).getDelegate().getClass().getName() + ")");
        }
        if (Types.isVncJavaSet(val)) {
            return new VncString("venice.JavaSet(" + ((IVncJavaObject)((Object)val)).getDelegate().getClass().getName() + ")");
        }
        if (Types.isVncJavaList(val)) {
            return new VncString("venice.JavaList(" + ((IVncJavaObject)((Object)val)).getDelegate().getClass().getName() + ")");
        }
        if (Types.isVncJavaMap(val)) {
            return new VncString("venice.JavaMap(" + ((IVncJavaObject)((Object)val)).getDelegate().getClass().getName() + ")");
        }
        if (Types.isVncMap(val)) {
            return new VncString("venice.Map");
        }
        return new VncString(val.getClass().getName());
    }

    public static boolean _equal_Q(VncVal a, VncVal b) {
        Class<?> otb;
        Class<?> ota = a.getClass();
        if (!(ota == (otb = b.getClass()) || a instanceof VncString && b instanceof VncString || a instanceof VncList && b instanceof VncList)) {
            return false;
        }
        if (a instanceof VncConstant) {
            return (VncConstant)a == (VncConstant)b;
        }
        if (a instanceof VncLong) {
            return ((VncLong)a).getValue().equals(((VncLong)b).getValue());
        }
        if (a instanceof VncDouble) {
            return ((VncDouble)a).getValue().equals(((VncDouble)b).getValue());
        }
        if (a instanceof VncBigDecimal) {
            return ((VncBigDecimal)a).getValue().equals(((VncBigDecimal)b).getValue());
        }
        if (a instanceof VncSymbol) {
            return ((VncSymbol)a).getName().equals(((VncSymbol)b).getName());
        }
        if (a instanceof VncString) {
            return ((VncString)a).getValue().equals(((VncString)b).getValue());
        }
        if (a instanceof VncList) {
            if (((VncList)a).size() != ((VncList)b).size()) {
                return false;
            }
            Integer i = 0;
            while (i < ((VncList)a).size()) {
                if (!Types._equal_Q(((VncList)a).nth(i), ((VncList)b).nth(i))) {
                    return false;
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return true;
        }
        if (a instanceof VncSet) {
            if (((VncSet)a).size() != ((VncSet)b).size()) {
                return false;
            }
            return ((VncSet)a).getList().stream().allMatch(v -> ((VncSet)b).contains((VncVal)v));
        }
        if (a instanceof VncMap) {
            if (((VncMap)a).getMap().size() != ((VncMap)b).getMap().size()) {
                return false;
            }
            VncMap mhm = (VncMap)a;
            Map<VncVal, VncVal> hm = mhm.getMap();
            for (VncVal k : hm.keySet()) {
                VncVal valA = ((VncMap)a).getMap().get(k);
                VncVal valB = ((VncMap)b).getMap().get(k);
                if (valA == null && valB == null) {
                    return true;
                }
                if (valA != null && valB != null) {
                    if (Types._equal_Q(valA, valB)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        if (a instanceof VncJavaList) {
            return a.equals(b);
        }
        if (a instanceof VncJavaSet) {
            return a.equals(b);
        }
        if (a instanceof VncJavaMap) {
            return a.equals(b);
        }
        return a.equals(b);
    }

    public static boolean _match_Q(VncVal a, VncVal b) {
        if (a instanceof VncString) {
            return ((VncString)a).getValue().matches(((VncString)b).getValue());
        }
        return false;
    }
}

