/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class VncBigDecimal
extends VncVal {
    private final BigDecimal value;

    public VncBigDecimal(BigDecimal v) {
        this.value = v;
    }

    @Override
    public VncBigDecimal copy() {
        VncBigDecimal v = new VncBigDecimal(this.value);
        v.setMeta(this.getMeta());
        return v;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public VncBigDecimal add(VncVal other) {
        if (other instanceof VncLong) {
            return new VncBigDecimal(this.value.add(VncBigDecimal.toDecimal((VncLong)other).getValue()));
        }
        if (other instanceof VncDouble) {
            return new VncBigDecimal(this.value.add(VncBigDecimal.toDecimal((VncDouble)other).getValue()));
        }
        if (other instanceof VncBigDecimal) {
            return new VncBigDecimal(this.value.add(((VncBigDecimal)other).getValue()));
        }
        throw new VncException(String.format("Function '+' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncBigDecimal subtract(VncVal other) {
        if (other instanceof VncLong) {
            return new VncBigDecimal(this.value.subtract(VncBigDecimal.toDecimal((VncLong)other).getValue()));
        }
        if (other instanceof VncDouble) {
            return new VncBigDecimal(this.value.subtract(VncBigDecimal.toDecimal((VncDouble)other).getValue()));
        }
        if (other instanceof VncBigDecimal) {
            return new VncBigDecimal(this.value.subtract(((VncBigDecimal)other).getValue()));
        }
        throw new VncException(String.format("Function '-' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncBigDecimal multiply(VncVal other) {
        if (other instanceof VncLong) {
            return new VncBigDecimal(this.value.multiply(VncBigDecimal.toDecimal((VncLong)other).getValue()));
        }
        if (other instanceof VncDouble) {
            return new VncBigDecimal(this.value.multiply(VncBigDecimal.toDecimal((VncDouble)other).getValue()));
        }
        if (other instanceof VncBigDecimal) {
            return new VncBigDecimal(this.value.multiply(((VncBigDecimal)other).getValue()));
        }
        throw new VncException(String.format("Function '*' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncBigDecimal divide(VncVal other) {
        if (other instanceof VncLong) {
            return new VncBigDecimal(this.value.divide(VncBigDecimal.toDecimal((VncLong)other).getValue(), 16, RoundingMode.HALF_UP));
        }
        if (other instanceof VncDouble) {
            return new VncBigDecimal(this.value.divide(VncBigDecimal.toDecimal((VncDouble)other).getValue(), 16, RoundingMode.HALF_UP));
        }
        if (other instanceof VncBigDecimal) {
            return new VncBigDecimal(this.value.divide(((VncBigDecimal)other).getValue(), 16, RoundingMode.HALF_UP));
        }
        throw new VncException(String.format("Function '/' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncBigDecimal inc() {
        return new VncBigDecimal(this.value.add(new BigDecimal(1)));
    }

    public VncBigDecimal dec() {
        return new VncBigDecimal(this.value.subtract(new BigDecimal(1)));
    }

    public VncConstant lt(VncVal other) {
        if (other instanceof VncLong) {
            return this.value.compareTo(VncBigDecimal.toDecimal((VncLong)other).getValue()) < 0 ? Constants.True : Constants.False;
        }
        if (other instanceof VncDouble) {
            return this.value.compareTo(VncBigDecimal.toDecimal((VncDouble)other).getValue()) < 0 ? Constants.True : Constants.False;
        }
        if (other instanceof VncBigDecimal) {
            return this.value.compareTo(((VncBigDecimal)other).getValue()) < 0 ? Constants.True : Constants.False;
        }
        throw new VncException(String.format("Function '<' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncConstant lte(VncVal other) {
        if (other instanceof VncLong) {
            return this.value.compareTo(VncBigDecimal.toDecimal((VncLong)other).getValue()) <= 0 ? Constants.True : Constants.False;
        }
        if (other instanceof VncDouble) {
            return this.value.compareTo(VncBigDecimal.toDecimal((VncDouble)other).getValue()) <= 0 ? Constants.True : Constants.False;
        }
        if (other instanceof VncBigDecimal) {
            return this.value.compareTo(((VncBigDecimal)other).getValue()) <= 0 ? Constants.True : Constants.False;
        }
        throw new VncException(String.format("Function '<=' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncConstant gt(VncVal other) {
        if (other instanceof VncLong) {
            return this.value.compareTo(VncBigDecimal.toDecimal((VncLong)other).getValue()) > 0 ? Constants.True : Constants.False;
        }
        if (other instanceof VncDouble) {
            return this.value.compareTo(VncBigDecimal.toDecimal((VncDouble)other).getValue()) > 0 ? Constants.True : Constants.False;
        }
        if (other instanceof VncBigDecimal) {
            return this.value.compareTo(((VncBigDecimal)other).getValue()) > 0 ? Constants.True : Constants.False;
        }
        throw new VncException(String.format("Function '>' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncConstant gte(VncVal other) {
        if (other instanceof VncLong) {
            return this.value.compareTo(VncBigDecimal.toDecimal((VncLong)other).getValue()) >= 0 ? Constants.True : Constants.False;
        }
        if (other instanceof VncDouble) {
            return this.value.compareTo(VncBigDecimal.toDecimal((VncDouble)other).getValue()) >= 0 ? Constants.True : Constants.False;
        }
        if (other instanceof VncBigDecimal) {
            return this.value.compareTo(((VncBigDecimal)other).getValue()) >= 0 ? Constants.True : Constants.False;
        }
        throw new VncException(String.format("Function '>=' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncLong toLong() {
        return new VncLong(this.value.longValue());
    }

    public VncDouble toDouble() {
        return new VncDouble(this.value.doubleValue());
    }

    public static VncBigDecimal toDecimal(VncLong val) {
        return new VncBigDecimal(new BigDecimal(val.getValue()));
    }

    public static VncBigDecimal toDecimal(VncDouble val) {
        return new VncBigDecimal(new BigDecimal(val.getValue()));
    }

    public static RoundingMode toRoundingMode(VncString val) {
        return RoundingMode.valueOf(RoundingMode.class, val.getValue());
    }

    @Override
    public int compareTo(VncVal o) {
        return Types.isVncDouble(o) ? this.getValue().compareTo(((VncBigDecimal)o).getValue()) : 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncBigDecimal other = (VncBigDecimal)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString();
    }
}

