/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;

public class ClassPathResource {
    private final String path;
    private final ClassLoader classLoader;
    private final Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, null, null);
    }

    public ClassPathResource(String path, Class<?> clazz) {
        this(path, clazz, null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        this(path, null, classLoader);
    }

    public ClassPathResource(String path, Class<?> clazz, ClassLoader classLoader) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("A 'path' must not be blank");
        }
        this.path = path;
        this.clazz = clazz;
        this.classLoader = classLoader;
    }

    public InputStream getInputStream() {
        InputStream is = null;
        if (this.clazz != null) {
            is = this.clazz.getResourceAsStream(this.path);
        } else if (this.classLoader != null) {
            is = this.classLoader.getResourceAsStream(this.path);
        }
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.path);
        }
        if (is == null) {
            is = ClassLoader.getSystemClassLoader().getResourceAsStream(this.path);
        }
        if (is == null) {
            is = ClassLoader.getSystemResourceAsStream(this.path);
        }
        return is;
    }

    public URL getResource() {
        URL url = null;
        if (this.clazz != null) {
            url = this.clazz.getResource(this.path);
        } else if (this.classLoader != null) {
            url = this.classLoader.getResource(this.path);
        }
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(this.path);
        }
        if (url == null) {
            url = ClassLoader.getSystemClassLoader().getResource(this.path);
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getResourceAsBinary() {
        try (InputStream is = this.getInputStream();){
            byte[] byArray = is == null ? null : ClassPathResource.toByteArray(this.getInputStream());
            return byArray;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed to load classpath resource '%s'", this.path), ex);
        }
    }

    public ByteBuffer getResourceAsByteBuffer() {
        byte[] data = this.getResourceAsBinary();
        return data == null ? null : ByteBuffer.wrap(data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getResourceAsString(String charsetName) {
        try (InputStream is = this.getInputStream();){
            String string = is == null ? null : new String(ClassPathResource.toByteArray(this.getInputStream()), charsetName);
            return string;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed to load classpath resource '%s'", this.path), ex);
        }
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int n;
            byte[] buffer = new byte[16384];
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }
}

