/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.javainterop.IInvoker;
import com.github.jlangch.venice.javainterop.JavaInterceptor;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class JavaSandboxRecorder
extends JavaInterceptor {
    private final PrintWriter writer;

    public JavaSandboxRecorder(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    public JavaSandboxRecorder(OutputStream os) {
        this.writer = new PrintWriter(os);
    }

    public JavaSandboxRecorder() {
        this.writer = new PrintWriter(System.out);
    }

    @Override
    public Object onInvokeInstanceMethod(IInvoker invoker, Object receiver, String method, Object ... args) {
        this.format("%s:%s(%s)", this.type(receiver), method, this.arguments(args));
        return super.onInvokeInstanceMethod(invoker, receiver, method, args);
    }

    @Override
    public Object onInvokeStaticMethod(IInvoker invoker, Class<?> receiver, String method, Object ... args) {
        this.format("%s:%s(%s)", this.type(receiver), method, this.arguments(args));
        return super.onInvokeStaticMethod(invoker, receiver, method, args);
    }

    @Override
    public Object onInvokeConstructor(IInvoker invoker, Class<?> receiver, Object ... args) {
        this.format("new %s(%s)", this.type(receiver), this.arguments(args));
        return super.onInvokeConstructor(invoker, receiver, args);
    }

    @Override
    public Object onGetBeanProperty(IInvoker invoker, Object receiver, String property) {
        this.format("%s.!%s", this.type(receiver), property);
        return super.onGetBeanProperty(invoker, receiver, property);
    }

    @Override
    public Object onSetBeanProperty(IInvoker invoker, Object receiver, String property, Object value) {
        this.format("%s.!%s=%s", this.type(receiver), property, this.type(value));
        return super.onSetBeanProperty(invoker, receiver, property, value);
    }

    @Override
    public Object onGetStaticField(IInvoker invoker, Class<?> receiver, String fieldName) {
        this.format("%s.@%s", this.type(receiver), fieldName);
        return super.onGetStaticField(invoker, receiver, fieldName);
    }

    @Override
    public Object onGetInstanceField(IInvoker invoker, Object receiver, String fieldName) {
        this.format("%s.%s", this.type(receiver), fieldName);
        return super.onGetInstanceField(invoker, receiver, fieldName);
    }

    private void format(String fmt, Object ... args) {
        this.writer.println(String.format(fmt, args));
        this.writer.flush();
    }

    private String type(Object o) {
        return o == null ? "null" : (this.isClass(o) ? this.type((Class)o) : this.type(o.getClass()));
    }

    private String type(Class<?> c) {
        if (c.isArray()) {
            return this.type(c.getComponentType()) + "[]";
        }
        String className = c.getName();
        return className.startsWith("java.lang.") ? className.substring("java.lang.".length()) : className;
    }

    private String arguments(Object ... args) {
        StringBuilder b = new StringBuilder();
        for (Object o : args) {
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(this.type(o));
        }
        return b.toString();
    }

    private boolean isClass(Object o) {
        return o instanceof Class;
    }
}

