/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicBoolean;

public class Protocol {
    private final int MAX_PROTOCOL_SIZE = 0x1400000;
    private final boolean decorateWithTimestamp;
    private final StringBuilder sb = new StringBuilder();
    private final AtomicBoolean debugOn = new AtomicBoolean(false);
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final DateTimeFormatter dtFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public Protocol() {
        this(true);
    }

    public Protocol(boolean decorateWithTimestamp) {
        this.decorateWithTimestamp = decorateWithTimestamp;
    }

    public void enable(boolean enable) {
        this.enabled.set(enable);
    }

    public void debugOn() {
        this.debugOn.set(true);
    }

    public void debugOff() {
        this.debugOn.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        StringBuilder stringBuilder = this.sb;
        synchronized (stringBuilder) {
            this.sb.setLength(0);
        }
    }

    public void log(Level level, String text) {
        this.log(level, text, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Level level, String text, Exception ex) {
        if (this.isEnabled() && (text != null || ex != null) && (this.safeLevel(level) != Level.DEBUG || this.debugOn.get())) {
            StringBuilder m = new StringBuilder();
            m.append(this.getPrefix(this.safeLevel(level)));
            if (text != null) {
                m.append(this.filter(text)).append('\n');
            }
            if (ex != null) {
                m.append(this.getExceptionStackTrace(ex)).append('\n');
            }
            StringBuilder stringBuilder = this.sb;
            synchronized (stringBuilder) {
                if (this.sb.length() + m.length() < 0x1400000) {
                    this.sb.append((CharSequence)m);
                }
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        StringBuilder stringBuilder = this.sb;
        synchronized (stringBuilder) {
            return this.sb.length() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = this.sb;
        synchronized (stringBuilder) {
            return this.sb.toString();
        }
    }

    private String filter(String text) {
        return text.replace("\r", "").replace("\n", "\n" + this.leftPad("", this.decorateWithTimestamp ? 31 : 7));
    }

    private String getPrefix(Level level) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.decorateWithTimestamp) {
            sb.append(LocalDateTime.now().format(this.dtFormatter)).append("|");
        }
        sb.append(this.getLevelString(level));
        sb.append("] ");
        return sb.toString();
    }

    private String getExceptionStackTrace(Exception ex) {
        if (ex instanceof SecurityException) {
            return this.getSafeExceptionStackTrace(ex);
        }
        return this.getStackTrace(ex);
    }

    private String getSafeExceptionStackTrace(Exception ex) {
        StringBuilder msg = new StringBuilder();
        msg.append(this.getSafeExceptionMessage(ex));
        for (Throwable th = ex.getCause(); th != null; th = th.getCause()) {
            msg.append("\nCaused by: ").append(this.getSafeExceptionMessage(ex));
        }
        return msg.toString();
    }

    private String getSafeExceptionMessage(Throwable ex) {
        StringBuilder msg = new StringBuilder();
        msg.append(ex.getClass());
        if (ex.getMessage() != null) {
            msg.append(": ").append(ex.getMessage());
        }
        return msg.toString();
    }

    private String getLevelString(Level level) {
        switch (level) {
            case DEBUG: {
                return "DEBG";
            }
            case INFO: {
                return "INFO";
            }
            case WARN: {
                return "WARN";
            }
            case ALERT: {
                return "ALRT";
            }
        }
        return "INFO";
    }

    private String leftPad(String text, int width) {
        if (text.length() >= width) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        for (int ii = text.length(); ii < width; ++ii) {
            sb.append(' ');
        }
        sb.append(text);
        return sb.toString();
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private Level safeLevel(Level level) {
        return level == null ? Level.DEBUG : level;
    }

    private static enum Level {
        DEBUG,
        INFO,
        WARN,
        ALERT;

    }
}

