/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Binding;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.ArrayList;
import java.util.List;

public class Destructuring {
    public static List<Binding> destructure(VncVal symVal, VncVal bindVal) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        if (Types.isVncSymbol(symVal)) {
            bindings.add(new Binding((VncSymbol)symVal, bindVal));
        } else if (Types.isVncList(symVal)) {
            Destructuring.sequential_destructure((VncList)symVal, bindVal, bindings);
        } else if (Types.isVncMap(symVal)) {
            Destructuring.associative_destructure((VncMap)symVal, bindVal, bindings);
        } else {
            throw new VncException(String.format("Invalid destructuring sym value type %s. Expected symbol. %s", Types.getClassName(symVal), ErrorMessage.buildErrLocation(symVal)));
        }
        return bindings;
    }

    private static void sequential_destructure(VncList symVal, VncVal bindVal, List<Binding> bindings) {
        if (Types.isVncList(bindVal)) {
            List<VncVal> symbols = symVal.getList();
            List<Object> values = bindVal == Constants.Nil ? new ArrayList() : ((VncList)bindVal).getList();
            for (int ii = 0; ii < symbols.size(); ++ii) {
                VncVal syms;
                VncConstant val;
                VncSymbol sym;
                if (Destructuring.isIgnoreBindingSymbol(symbols.get(ii))) continue;
                if (Destructuring.isElisionSymbol(symbols.get(ii))) {
                    sym = (VncSymbol)symbols.get(ii + 1);
                    val = ii <= values.size() ? ((VncList)bindVal).slice(ii) : Constants.Nil;
                    bindings.add(new Binding(sym, val));
                    break;
                }
                if (Destructuring.isAsKeyword(symbols.get(ii))) {
                    sym = (VncSymbol)symbols.get(ii + 1);
                    bindings.add(new Binding(sym, bindVal));
                    break;
                }
                if (Types.isVncSymbol(symbols.get(ii))) {
                    sym = (VncSymbol)symbols.get(ii);
                    val = ii < values.size() ? (VncVal)values.get(ii) : Constants.Nil;
                    bindings.add(new Binding(sym, val));
                    continue;
                }
                if (Types.isVncList(symbols.get(ii))) {
                    syms = symbols.get(ii);
                    val = ii < values.size() ? (VncVal)values.get(ii) : Constants.Nil;
                    bindings.addAll(Destructuring.destructure(syms, val));
                    continue;
                }
                if (!Types.isVncMap(symbols.get(ii))) continue;
                syms = (VncMap)symbols.get(ii);
                val = ii < values.size() ? (VncVal)values.get(ii) : Constants.Nil;
                Destructuring.associative_destructure((VncMap)syms, val, bindings);
            }
        } else if (Types.isVncString(bindVal)) {
            List<VncVal> symbols = symVal.getList();
            List<Object> values = bindVal == Constants.Nil ? new ArrayList() : ((VncString)bindVal).toVncList().getList();
            for (int ii = 0; ii < symbols.size(); ++ii) {
                VncVal val;
                VncSymbol sym;
                if (Destructuring.isIgnoreBindingSymbol(symbols.get(ii))) continue;
                if (Destructuring.isElisionSymbol(symbols.get(ii))) {
                    sym = (VncSymbol)symbols.get(ii + 1);
                    val = ((VncString)bindVal).toVncList().slice(ii);
                    bindings.add(new Binding(sym, val));
                    break;
                }
                sym = (VncSymbol)symbols.get(ii);
                val = ii < values.size() ? (VncVal)values.get(ii) : Constants.Nil;
                bindings.add(new Binding(sym, val));
            }
        } else {
            throw new VncException(String.format("Invalid destructuring bind value type %s. Expected list, vector, or string. %s", Types.getClassName(bindVal), ErrorMessage.buildErrLocation(bindVal)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void associative_destructure(VncMap symVal, VncVal bindVal, List<Binding> bindings) {
        VncVal as;
        VncVal symbols;
        if (bindVal != Constants.Nil && !Types.isVncMap(bindVal)) {
            throw new VncException(String.format("Invalid associative destructuring bind value type %s. Expected map. %s", Types.getClassName(bindVal), ErrorMessage.buildErrLocation(bindVal)));
        }
        ArrayList<Binding> local_bindings = new ArrayList<Binding>();
        if (symVal.get(new VncKeyword(":keys")) != Constants.Nil) {
            symbols = symVal.get(new VncKeyword(":keys"));
            if (!Types.isVncVector(symbols)) throw new VncException(String.format("Invalid associative destructuring with :keys symbol type %s. Expected vector. %s", Types.getClassName(symbols), ErrorMessage.buildErrLocation(symbols)));
            ((VncVector)symbols).forEach(sym -> {
                VncSymbol s = (VncSymbol)sym;
                VncConstant v = bindVal == Constants.Nil ? Constants.Nil : ((VncMap)bindVal).get(new VncKeyword(s.getName()));
                local_bindings.add(new Binding(s, v));
            });
        } else if (symVal.get(new VncKeyword(":syms")) != Constants.Nil) {
            symbols = symVal.get(new VncKeyword(":syms"));
            if (!Types.isVncVector(symbols)) throw new VncException(String.format("Invalid associative destructuring with :syms symbol type %s. Expected vector. %s", Types.getClassName(symbols), ErrorMessage.buildErrLocation(symbols)));
            ((VncVector)symbols).forEach(sym -> {
                VncSymbol s = (VncSymbol)sym;
                VncConstant v = bindVal == Constants.Nil ? Constants.Nil : ((VncMap)bindVal).get(s);
                local_bindings.add(new Binding(s, v));
            });
        } else {
            if (symVal.get(new VncKeyword(":strs")) == Constants.Nil) throw new VncException(String.format("Invalid associative destructuring. Expected :keys, :syms, or :strs symbol definition. %s", Types.getClassName(symVal), ErrorMessage.buildErrLocation(symVal)));
            symbols = symVal.get(new VncKeyword(":strs"));
            if (!Types.isVncVector(symbols)) throw new VncException(String.format("Invalid associative destructuring with :strs symbol type %s. Expected vector. %s", Types.getClassName(symbols), ErrorMessage.buildErrLocation(symbols)));
            ((VncVector)symbols).forEach(sym -> {
                VncSymbol s = (VncSymbol)sym;
                VncConstant v = bindVal == Constants.Nil ? Constants.Nil : ((VncMap)bindVal).get(new VncString(s.getName()));
                local_bindings.add(new Binding(s, v));
            });
        }
        VncVal orVal = symVal.get(new VncKeyword(":or"));
        if (orVal != Constants.Nil && Types.isVncMap(orVal)) {
            ((VncMap)orVal).entries().forEach(e -> {
                for (int ii = 0; ii < local_bindings.size(); ++ii) {
                    Binding b = (Binding)local_bindings.get(ii);
                    if (!b.sym.equals((VncSymbol)e.getKey()) || b.val != Constants.Nil) continue;
                    local_bindings.set(ii, new Binding(b.sym, (VncVal)e.getValue()));
                }
            });
        }
        if ((as = symVal.get(new VncKeyword(":as"))) != Constants.Nil && Types.isVncSymbol(as)) {
            local_bindings.add(new Binding((VncSymbol)as, bindVal));
        }
        bindings.addAll(local_bindings);
    }

    private static boolean isAsKeyword(VncVal val) {
        return Types.isVncKeyword(val) && ((VncKeyword)val).getValue().equals("as");
    }

    private static boolean isElisionSymbol(VncVal val) {
        return Types.isVncSymbol(val) && ((VncSymbol)val).getName().equals("&");
    }

    private static boolean isIgnoreBindingSymbol(VncVal val) {
        return Types.isVncSymbol(val) && ((VncSymbol)val).getName().equals("_");
    }
}

