/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Env {
    private final Env outer;
    private final int level;
    private final Map<String, VncVal> data = new HashMap<String, VncVal>();

    public Env() {
        this.outer = null;
        this.level = 0;
    }

    public Env(Env outer) {
        this.outer = outer;
        this.level = outer == null ? 0 : outer.level() + 1;
    }

    public Env find(VncSymbol key) {
        if (this.data.containsKey(key.getName())) {
            return this;
        }
        if (this.outer != null) {
            return this.outer.find(key);
        }
        return null;
    }

    public VncVal get(VncSymbol key) {
        Env e = this.find(key);
        if (e == null) {
            throw new VncException("Symbol '" + key.getName() + "' not found");
        }
        return e.data.get(key.getName());
    }

    public int level() {
        return this.level;
    }

    public Env set(VncSymbol key, VncVal value) {
        this.data.put(key.getName(), value);
        return this;
    }

    public Set<Map.Entry<String, VncVal>> getEntries() {
        return this.data.entrySet();
    }

    public String toString() {
        return String.format("%d: %s", this.level, this.data);
    }
}

