/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.ValueException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Reader;
import com.github.jlangch.venice.impl.Readline;
import com.github.jlangch.venice.impl.functions.Calc;
import com.github.jlangch.venice.impl.functions.Doc;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncJavaMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaObject;
import com.github.jlangch.venice.impl.types.collections.VncJavaSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncSortedMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class CoreFunctions {
    public static VncFunction doc = new VncFunction("doc"){
        {
            this.setArgLists("(doc name)");
            this.setDoc("Returns the documentation for the function/macro with the given name");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("doc", args, 1);
            return new VncString(Doc.getDoc(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction throw_ex = new VncFunction("throw"){
        {
            this.setArgLists("(throw)", "(throw x)");
            this.setDoc("Throws exception with passed value x");
            this.setExamples("(try\n   (throw 100)\n   (catch :java.lang.Exception ex\n          (do (+ 1 2) -1)))", "(try\n   (throw 100)\n   (catch :java.lang.Exception ex\n          (do (+ 1 2) -1))\n   (finally (println \"finally\")))");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                throw new ValueException(Constants.Nil);
            }
            if (Types.isVncJavaObject(args.nth(0))) {
                Object obj = ((VncJavaObject)args.nth(0)).getDelegate();
                if (obj instanceof RuntimeException) {
                    throw (RuntimeException)obj;
                }
                if (obj instanceof Exception) {
                    throw new RuntimeException((Exception)obj);
                }
                throw new RuntimeException(obj.toString());
            }
            throw new ValueException(args.nth(0));
        }
    };
    public static VncFunction nil_Q = new VncFunction("nil?"){
        {
            this.setArgLists("(nil? x)");
            this.setDoc("Returns true if x is nil, false otherwise");
            this.setExamples("(nil? nil)", "(nil? 0)", "(nil? false)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nil?", args, 1);
            return args.nth(0) == Constants.Nil ? Constants.True : Constants.False;
        }
    };
    public static VncFunction some_Q = new VncFunction("some?"){
        {
            this.setArgLists("(some? x)");
            this.setDoc("Returns true if x is not nil, false otherwise");
            this.setExamples("(some? nil)", "(some? 0)", "(some? 4.0)", "(some? false)", "(some? [])", "(some? {})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("some?", args, 1);
            return args.nth(0) == Constants.Nil ? Constants.False : Constants.True;
        }
    };
    public static VncFunction true_Q = new VncFunction("true?"){
        {
            this.setArgLists("(true? x)");
            this.setDoc("Returns true if x is true, false otherwise");
            this.setExamples("(true? true)", "(true? false)", "(true? nil)", "(true? 0)", "(true? (== 1 1))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("true?", args, 1);
            return args.nth(0) == Constants.True ? Constants.True : Constants.False;
        }
    };
    public static VncFunction false_Q = new VncFunction("false?"){
        {
            this.setArgLists("(false? x)");
            this.setDoc("Returns true if x is false, false otherwise");
            this.setExamples("(false? true)", "(false? false)", "(false? nil)", "(false? 0)", "(false? (== 1 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("false?", args, 1);
            return args.nth(0) == Constants.False ? Constants.True : Constants.False;
        }
    };
    public static VncFunction boolean_Q = new VncFunction("boolean?"){
        {
            this.setArgLists("(boolean? n)");
            this.setDoc("Returns true if n is a boolean");
            this.setExamples("(boolean? true)", "(boolean? false)", "(boolean? nil)", "(boolean? 0)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("boolean?", args, 1);
            return args.nth(0) == Constants.True || args.nth(0) == Constants.False ? Constants.True : Constants.False;
        }
    };
    public static VncFunction long_Q = new VncFunction("long?"){
        {
            this.setArgLists("(long? n)");
            this.setDoc("Returns true if n is a long");
            this.setExamples("(long? 4)", "(long? 3.1)", "(long? true)", "(long? nil)", "(long? {})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("long?", args, 1);
            return Types.isVncLong(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction double_Q = new VncFunction("double?"){
        {
            this.setArgLists("(double? n)");
            this.setDoc("Returns true if n is a double");
            this.setExamples("(double? 4.0)", "(double? 3)", "(double? true)", "(double? nil)", "(double? {})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("double?", args, 1);
            return Types.isVncDouble(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction decimal_Q = new VncFunction("decimal?"){
        {
            this.setArgLists("(decimal? n)");
            this.setDoc("Returns true if n is a decimal");
            this.setExamples("(decimal? 4.0M)", "(decimal? 4.0)", "(decimal? 3)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("decimal?", args, 1);
            return Types.isVncBigDecimal(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction number_Q = new VncFunction("number?"){
        {
            this.setArgLists("(number? n)");
            this.setDoc("Returns true if n is a number (long, double, or decimal)");
            this.setExamples("(number? 4.0M)", "(number? 4.0)", "(number? 3)", "(number? true)", "(number? \"a\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("number?", args, 1);
            return Types.isVncLong(args.nth(0)) || Types.isVncDouble(args.nth(0)) || Types.isVncBigDecimal(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction string_Q = new VncFunction("string?"){
        {
            this.setArgLists("(string? x)");
            this.setDoc("Returns true if x is a string");
            this.setExamples("(bytebuf? (bytebuf [1 2]))", "(bytebuf? [1 2])", "(bytebuf? nil)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("string?", args, 1);
            if (args.nth(0) instanceof VncKeyword) {
                return Constants.False;
            }
            if (args.nth(0) instanceof VncString) {
                return Constants.True;
            }
            return Constants.False;
        }
    };
    public static VncFunction symbol = new VncFunction("symbol"){
        {
            this.setArgLists("(symbol name)");
            this.setDoc("Returns a symbol from the given name");
            this.setExamples("(symbol \"a\")", "(symbol 'a)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("symbol", args, 1);
            if (Types.isVncSymbol(args.nth(0))) {
                return args.nth(0);
            }
            if (Types.isVncString(args.nth(0))) {
                return new VncSymbol((VncString)args.nth(0));
            }
            throw new VncException(String.format("Function 'symbol' does not allow %s name. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction symbol_Q = new VncFunction("symbol?"){
        {
            this.setArgLists("(symbol? x)");
            this.setDoc("Returns true if x is a symbol");
            this.setExamples("(symbol? (symbol \"a\"))", "(symbol? 'a)", "(symbol? nil)", "(symbol? :a)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("symbol?", args, 1);
            return Types.isVncSymbol(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction keyword = new VncFunction("keyword"){
        {
            this.setArgLists("(keyword name)");
            this.setDoc("Returns a keyword from the given name");
            this.setExamples("(keyword \"a\")", "(keyword :a)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keyword", args, 1);
            if (Types.isVncKeyword(args.nth(0))) {
                return args.nth(0);
            }
            if (Types.isVncString(args.nth(0))) {
                return new VncKeyword(((VncString)args.nth(0)).getValue());
            }
            throw new VncException(String.format("Function 'keyword' does not allow %s name. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction keyword_Q = new VncFunction("keyword?"){
        {
            this.setArgLists("(keyword? x)");
            this.setDoc("Returns true if x is a keyword");
            this.setExamples("(keyword? (keyword \"a\"))", "(keyword? :a)", "(keyword? nil)", "(keyword? 'a)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keyword?", args, 1);
            return Types.isVncKeyword(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction fn_Q = new VncFunction("fn?"){
        {
            this.setArgLists("(fn? x)");
            this.setDoc("Returns true if x is a function");
            this.setExamples("(do \n   (def sum (fn [x] (+ 1 x)))\n   (fn? sum))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("fn?", args, 1);
            if (!Types.isVncFunction(args.nth(0))) {
                return Constants.False;
            }
            return ((VncFunction)args.nth(0)).isMacro() ? Constants.False : Constants.True;
        }
    };
    public static VncFunction macro_Q = new VncFunction("macro?"){
        {
            this.setArgLists("(macro? x)");
            this.setDoc("Returns true if x is a macro");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("macro?", args, 1);
            if (!Types.isVncFunction(args.nth(0))) {
                return Constants.False;
            }
            return ((VncFunction)args.nth(0)).isMacro() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction pr_str = new VncFunction("pr-str"){
        {
            this.setArgLists("(pr-str & xs)");
            this.setDoc("With no args, returns the empty string. With one arg x, returns x.toString(). With more than one arg, returns the concatenation of the str values of the args with delimiter ' '.");
            this.setExamples("(pr-str )", "(pr-str 1 2 3)");
        }

        @Override
        public VncVal apply(VncList args) {
            return args.isEmpty() ? new VncString("") : new VncString(args.getList().stream().map(v -> Printer._pr_str(v, true)).collect(Collectors.joining(" ")));
        }
    };
    public static VncFunction str = new VncFunction("str"){
        {
            this.setArgLists("(str & xs)");
            this.setDoc("With no args, returns the empty string. With one arg x, returns x.toString(). (str nil) returns the empty string. With more than one arg, returns the concatenation of the str values of the args.");
            this.setExamples("(str )", "(str 1 2 3)");
        }

        @Override
        public VncVal apply(VncList args) {
            return args.isEmpty() ? new VncString("") : new VncString(args.getList().stream().filter(v -> v != Constants.Nil).map(v -> Printer._pr_str(v, false)).collect(Collectors.joining("")));
        }
    };
    public static VncFunction readline = new VncFunction("readline"){
        {
            this.setArgLists("(readline prompt)");
            this.setDoc("Reads the next line from stdin. The function is sandboxed");
        }

        @Override
        public VncVal apply(VncList args) {
            String prompt = Coerce.toVncString(args.nth(0)).getValue();
            try {
                return new VncString(Readline.readline(prompt));
            }
            catch (IOException ex) {
                throw new ValueException(new VncString(ex.getMessage()), (Throwable)ex);
            }
            catch (EofException e) {
                return Constants.Nil;
            }
        }
    };
    public static VncFunction read_string = new VncFunction("read-string"){
        {
            this.setArgLists("(read-string x)");
            this.setDoc("Reads from x");
        }

        @Override
        public VncVal apply(VncList args) {
            try {
                FunctionsUtil.assertArity("read-string", args, 1);
                return Reader.read_str(Coerce.toVncString(args.nth(0)).getValue(), null);
            }
            catch (ContinueException c) {
                return Constants.Nil;
            }
        }
    };
    public static VncFunction loadCoreModule = new VncFunction("load-core-module"){

        @Override
        public VncVal apply(VncList args) {
            try {
                FunctionsUtil.assertArity("load-core-module", args, 1);
                VncVal name = args.first();
                if (Types.isVncString(name)) {
                    String module = ModuleLoader.load(((VncString)args.first()).getValue());
                    return new VncString(module);
                }
                if (Types.isVncSymbol(name)) {
                    String module = ModuleLoader.load(((VncSymbol)args.first()).getName());
                    return new VncString(module);
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction loadClasspathVenice = new VncFunction("load-classpath-venice"){

        @Override
        public VncVal apply(VncList args) {
            try {
                FunctionsUtil.assertArity("load-classpath-venice", args, 1);
                VncVal name = args.first();
                if (Types.isVncString(name)) {
                    String res = ModuleLoader.loadVeniceResource(((VncString)args.first()).getValue());
                    return new VncString(res);
                }
                if (Types.isVncSymbol(name)) {
                    String res = ModuleLoader.loadVeniceResource(((VncSymbol)args.first()).getName());
                    return new VncString(res);
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction decimalScale = new VncFunction("dec/scale"){
        {
            this.setArgLists("(dec/scale x scale rounding-mode)");
            this.setDoc("Scales a decimal. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
            this.setExamples("(dec/scale 2.44697M 0 :HALF_UP)", "(dec/scale 2.44697M 1 :HALF_UP)", "(dec/scale 2.44697M 2 :HALF_UP)", "(dec/scale 2.44697M 3 :HALF_UP)", "(dec/scale 2.44697M 10 :HALF_UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/scale", args, 3);
            VncVal arg = args.nth(0);
            VncLong scale = Coerce.toVncLong(args.nth(1));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode((VncString)args.nth(2));
            if (Types.isVncBigDecimal(arg)) {
                BigDecimal val = ((VncBigDecimal)arg).getValue();
                return new VncBigDecimal(val.setScale(scale.getValue().intValue(), roundingMode));
            }
            throw new VncException(String.format("Function 'dec/scale' does not allow %s as operand 1. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction decimalAdd = new VncFunction("dec/add"){
        {
            this.setArgLists("(dec/add x y scale rounding-mode)");
            this.setDoc("Adds two decimals and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
            this.setExamples("(dec/add 2.44697M 1.79882M 3 :HALF_UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/add", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.nth(0));
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.nth(1));
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().add(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction decimalSubtract = new VncFunction("dec/sub"){
        {
            this.setArgLists("(dec/sub x y scale rounding-mode)");
            this.setDoc("Subtract y from x and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
            this.setExamples("(dec/sub 2.44697M 1.79882M 3 :HALF_UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/sub", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.nth(0));
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.nth(1));
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().subtract(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction decimalMultiply = new VncFunction("dec/mul"){
        {
            this.setArgLists("(dec/mul x y scale rounding-mode)");
            this.setDoc("Multiplies two decimals and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
            this.setExamples("(dec/mul 2.44697M 1.79882M 5 :HALF_UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/mul", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.nth(0));
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.nth(1));
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().multiply(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction decimalDivide = new VncFunction("dec/div"){
        {
            this.setArgLists("(dec/div x y scale rounding-mode)");
            this.setDoc("Divides x by y and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
            this.setExamples("(dec/div 2.44697M 1.79882M 5 :HALF_UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/div", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.nth(0));
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.nth(1));
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().divide(op2.getValue(), scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction add = new VncFunction("+"){
        {
            this.setArgLists("(+)", "(+ x)", "(+ x y)", "(+ x y & more)");
            this.setDoc("Returns the sum of the numbers. (+) returns 0.");
            this.setExamples("(+)", "(+ 1)", "(+ 1 2)", "(+ 1 2 3 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                return new VncLong(0);
            }
            if (args.size() == 1) {
                return args.nth(0);
            }
            VncVal val = args.first();
            for (VncVal v : args.slice(1).getList()) {
                val = Calc.add(val, v);
            }
            return val;
        }
    };
    public static VncFunction subtract = new VncFunction("-"){
        {
            this.setArgLists("(- x)", "(- x y)", "(- x y & more)");
            this.setDoc("If one number is supplied, returns the negation, else subtracts the numbers from x and returns the result.");
            this.setExamples("(- 4)", "(- 8 3 -2 -1)", "(- 8 2.5)", "(- 8 1.5M)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                throw new ArityException(args, 0, "-");
            }
            if (args.size() == 1) {
                VncVal first = args.nth(0);
                if (Types.isVncLong(first)) {
                    return Calc.mul(first, new VncLong(-1L));
                }
                if (Types.isVncDouble(first)) {
                    return Calc.mul(first, new VncDouble(-1.0));
                }
                if (Types.isVncBigDecimal(first)) {
                    return Calc.mul(first, new VncBigDecimal(new BigDecimal("-1.0")));
                }
                return first;
            }
            VncVal val = args.first();
            for (VncVal v : args.slice(1).getList()) {
                val = Calc.sub(val, v);
            }
            return val;
        }
    };
    public static VncFunction multiply = new VncFunction("*"){
        {
            this.setArgLists("(*)", "(* x)", "(* x y)", "(* x y & more)");
            this.setDoc("Returns the product of numbers. (*) returns 1");
            this.setExamples("(*)", "(* 4)", "(* 4 3)", "(* 4 3 2)", "(* 6.0 2)", "(* 6 1.5M)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                return new VncLong(1);
            }
            if (args.size() == 1) {
                return args.nth(0);
            }
            VncVal val = args.first();
            for (VncVal v : args.slice(1).getList()) {
                val = Calc.mul(val, v);
            }
            return val;
        }
    };
    public static VncFunction divide = new VncFunction("/"){
        {
            this.setArgLists("(/ x)", "(/ x y)", "(/ x y & more)");
            this.setDoc("If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators.");
            this.setExamples("(/ 2.0)", "(/ 12 2 3)", "(/ 12 3)", "(/ 6.0 2)", "(/ 6 1.5M)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                throw new ArityException(args, 0, "/");
            }
            if (args.size() == 1) {
                VncVal first = args.nth(0);
                if (Types.isVncLong(first)) {
                    return Calc.div(new VncLong(1L), first);
                }
                if (Types.isVncDouble(first)) {
                    return Calc.div(new VncDouble(1.0), first);
                }
                if (Types.isVncBigDecimal(first)) {
                    return Calc.div(new VncBigDecimal(BigDecimal.ONE), first);
                }
                return first;
            }
            VncVal val = args.first();
            for (VncVal v : args.slice(1).getList()) {
                val = Calc.div(val, v);
            }
            return val;
        }
    };
    public static VncFunction modulo = new VncFunction("mod"){
        {
            this.setArgLists("(mod n d)");
            this.setDoc("Modulus of n and d.");
            this.setExamples("(mod 10 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("abs", args, 2);
            if (!Types.isVncLong(args.nth(0))) {
                throw new VncException(String.format("Function 'mod' does not allow %s as numerator. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            if (!Types.isVncLong(args.nth(1))) {
                throw new VncException(String.format("Function 'mod' does not allow %s as denominator. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
            }
            return new VncLong(((VncLong)args.nth(0)).getValue() % ((VncLong)args.nth(1)).getValue());
        }
    };
    public static VncFunction inc = new VncFunction("inc"){
        {
            this.setArgLists("(inc x)");
            this.setDoc("Increments the number x");
            this.setExamples("(inc 10)", "(inc 10.1)", "(inc 10.12M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("inc", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncLong(arg)) {
                return ((VncLong)arg).inc();
            }
            if (Types.isVncDouble(arg)) {
                return ((VncDouble)arg).inc();
            }
            if (Types.isVncBigDecimal(arg)) {
                return ((VncBigDecimal)arg).inc();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'inc'. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction dec = new VncFunction("dec"){
        {
            this.setArgLists("(dec x)");
            this.setDoc("Decrements the number x");
            this.setExamples("(dec 10)", "(dec 10.1)", "(dec 10.12M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncLong(arg)) {
                return ((VncLong)arg).dec();
            }
            if (Types.isVncDouble(arg)) {
                return ((VncDouble)arg).dec();
            }
            if (Types.isVncBigDecimal(arg)) {
                return ((VncBigDecimal)arg).dec();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'dec'. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction max = new VncFunction("max"){
        {
            this.setArgLists("(max x)", "(max x y)", "(max x y & more)");
            this.setDoc("Returns the greatest of the values");
            this.setExamples("(max 1)", "(max 1 2)", "(max 4 3 2 1)", "(max 1.0)", "(max 1.0 2.0)", "(max 4.0 3.0 2.0 1.0)", "(max 1.0M)", "(max 1.0M 2.0M)", "(max 4.0M 3.0M 2.0M 1.0M)", "(max 1.0M 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal op1;
            if (args.isEmpty()) {
                throw new ArityException(args, 0, "max");
            }
            VncVal max = op1 = args.nth(0);
            for (VncVal op : args.rest().getList()) {
                if (Types.isVncLong(max)) {
                    max = ((VncLong)max).gte(op) == Constants.True ? max : op;
                    continue;
                }
                if (Types.isVncDouble(max)) {
                    max = ((VncDouble)max).gte(op) == Constants.True ? max : op;
                    continue;
                }
                if (Types.isVncBigDecimal(max)) {
                    max = ((VncBigDecimal)max).gte(op) == Constants.True ? max : op;
                    continue;
                }
                throw new VncException(String.format("Function 'max' does not allow %s as operand 1. %s", Types.getClassName(max), ErrorMessage.buildErrLocation(args)));
            }
            return max;
        }
    };
    public static VncFunction min = new VncFunction("min"){
        {
            this.setArgLists("(min x)", "(min x y)", "(min x y & more)");
            this.setDoc("Returns the smallest of the values");
            this.setExamples("(min 1)", "(min 1 2)", "(min 4 3 2 1)", "(min 1.0)", "(min 1.0 2.0)", "(min 4.0 3.0 2.0 1.0)", "(min 1.0M)", "(min 1.0M 2.0M)", "(min 4.0M 3.0M 2.0M 1.0M)", "(min 1.0M 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal op1;
            if (args.isEmpty()) {
                throw new ArityException(args, 0, "min");
            }
            VncVal min = op1 = args.nth(0);
            for (VncVal op : args.rest().getList()) {
                if (Types.isVncLong(min)) {
                    min = ((VncLong)min).lte(op) == Constants.True ? min : op;
                    continue;
                }
                if (Types.isVncDouble(min)) {
                    min = ((VncDouble)min).lte(op) == Constants.True ? min : op;
                    continue;
                }
                if (Types.isVncBigDecimal(min)) {
                    min = ((VncBigDecimal)min).lte(op) == Constants.True ? min : op;
                    continue;
                }
                throw new VncException(String.format("Function 'min' does not allow %s as operand 1. %s", Types.getClassName(min), ErrorMessage.buildErrLocation(args)));
            }
            return min;
        }
    };
    public static VncFunction abs = new VncFunction("abs"){
        {
            this.setArgLists("(abs x)");
            this.setDoc("Returns the absolute value of the number");
            this.setExamples("(abs 10)", "(abs -10)", "(abs -10.1)", "(abs -10.12M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("abs", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncLong(arg)) {
                return new VncLong(Math.abs(((VncLong)arg).getValue()));
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(Math.abs(((VncDouble)arg).getValue()));
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(((VncBigDecimal)arg).getValue().abs());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'abs'. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction rand_long = new VncFunction("rand-long"){
        {
            this.setArgLists("(rand-long)", "(rand-long max)");
            this.setDoc("Without argument returns a random long between 0 and MAX_LONG. Without argument max returns a random long between 0 and max exclusive.");
            this.setExamples("(rand-long)", "(rand-long 100)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rand-long", args, 0, 1);
            if (args.isEmpty()) {
                return new VncLong(Math.abs(random.nextLong()));
            }
            long max = Coerce.toVncLong(args.first()).getValue();
            if (max < 2L) {
                throw new VncException("Function 'rand-long' does not allow negative max values");
            }
            return new VncLong(Math.abs(random.nextLong()) % max);
        }
    };
    public static VncFunction rand_double = new VncFunction("rand-double"){
        {
            this.setArgLists("(rand-double)", "(rand-double max)");
            this.setDoc("Without argument returns a double between 0.0 and 1.0. Without argument max returns a random double between 0.0 and max.");
            this.setExamples("(rand-double)", "(rand-double 100.0)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rand-double", args, 0, 1);
            if (args.isEmpty()) {
                return new VncDouble(random.nextDouble());
            }
            double max = Coerce.toVncDouble(args.first()).getValue();
            if (max < 0.0) {
                throw new VncException(String.format("Function 'rand-double' does not allow negative max values. %s", ErrorMessage.buildErrLocation(args)));
            }
            return new VncDouble(random.nextDouble() * max);
        }
    };
    public static VncFunction rand_gaussian = new VncFunction("rand-gaussian"){
        {
            this.setArgLists("(rand-gaussian)", "(rand-gaussian mean stddev)");
            this.setDoc("Without argument returns a Gaussion distributed double value with mean 0.0 and standard deviation 1.0. With argument mean and stddev returns a Gaussion distributed double value with the given mean and standard deviation.");
            this.setExamples("(rand-gaussian)", "(rand-gaussian 0.0 5.0)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rand-gaussian", args, 0, 2);
            if (args.isEmpty()) {
                return new VncDouble(random.nextGaussian());
            }
            double mean = Coerce.toVncDouble(args.first()).getValue();
            double stddev = Coerce.toVncDouble(args.second()).getValue();
            return new VncDouble(mean + stddev * random.nextGaussian());
        }
    };
    public static VncFunction equal_Q = new VncFunction("=="){
        {
            this.setArgLists("(== x y)");
            this.setDoc("Returns true if both operands have the equivalent type");
            this.setExamples("(== 0 0)", "(== 0 1)", "(== 0 0.0)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("==", args, 2);
            return Types._equal_Q(args.nth(0), args.nth(1)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction not_equal_Q = new VncFunction("!="){
        {
            this.setArgLists("(!= x y)");
            this.setDoc("Returns true if both operands do not have the equivalent type");
            this.setExamples("(!= 0 1)", "(!= 0 0)", "(!= 0 0.0)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("!=", args, 2);
            return Types._equal_Q(args.nth(0), args.nth(1)) ? Constants.False : Constants.True;
        }
    };
    public static VncFunction match_Q = new VncFunction("match"){
        {
            this.setArgLists("(match s regex)");
            this.setDoc("Returns true if the string s matches the regular expression regex");
            this.setExamples("(match \"1234\" \"[0-9]+\")", "(match \"1234ss\" \"[0-9]+\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("match", args, 2);
            if (!Types.isVncString(args.nth(0))) {
                throw new VncException(String.format("Invalid first argument type %s while calling function 'match'. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            if (!Types.isVncString(args.nth(1))) {
                throw new VncException(String.format("Invalid second argument type %s while calling function 'match'. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
            }
            return Types._match_Q(args.nth(0), args.nth(1)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction match_not_Q = new VncFunction("match-not"){
        {
            this.setArgLists("(match-not s regex)");
            this.setDoc("Returns true if the string s does not match the regular expression regex");
            this.setExamples("(match-not \"1234\" \"[0-9]+\")", "(match-not \"1234ss\" \"[0-9]+\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("match-not", args, 2);
            if (!Types.isVncString(args.nth(0))) {
                throw new VncException(String.format("Invalid first argument type %s while calling function 'match-not'. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
            }
            if (!Types.isVncString(args.nth(1))) {
                throw new VncException(String.format("Invalid second argument type %s while calling function 'match-not'. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
            }
            return Types._match_Q(args.nth(0), args.nth(1)) ? Constants.False : Constants.True;
        }
    };
    public static VncFunction lt = new VncFunction("<"){
        {
            this.setArgLists("(< x y)");
            this.setDoc("Returns true if x is smaller than y");
            this.setExamples("(< 2 3)", "(< 2 3.0)", "(< 2 3.0M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("<", args, 2);
            VncVal op1 = args.nth(0);
            VncVal op2 = args.nth(1);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).lt(op2);
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).lt(op2);
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).lt(op2);
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '<' with operand 1 of type %s does not allow %s as operand 2. %s", Types.getClassName(op1), Types.getClassName(op2), ErrorMessage.buildErrLocation(args)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) < 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '<' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction lte = new VncFunction("<="){
        {
            this.setArgLists("(<= x y)");
            this.setDoc("Returns true if x is smaller or equal to y");
            this.setExamples("(<= 2 3)", "(<= 3 3)", "(<= 2 3.0)", "(<= 2 3.0M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("<=", args, 2);
            VncVal op1 = args.nth(0);
            VncVal op2 = args.nth(1);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).lte(op2);
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).lte(op2);
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).lte(op2);
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '<=' with operand 1 of type %s does not allow %s as operand 2. %s", Types.getClassName(op1), Types.getClassName(op2), ErrorMessage.buildErrLocation(args)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) <= 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '<=' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction gt = new VncFunction(">"){
        {
            this.setArgLists("(> x y)");
            this.setDoc("Returns true if x is greater than y");
            this.setExamples("(> 3 2)", "(> 3 3)", "(> 3.0 2)", "(> 3.0M 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity(">", args, 2);
            VncVal op1 = args.nth(0);
            VncVal op2 = args.nth(1);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).gt(op2);
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).gt(op2);
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).gt(op2);
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '>' with operand 1 of type %s does not allow %s as operand 2. %s", Types.getClassName(op1), Types.getClassName(op2), ErrorMessage.buildErrLocation(args)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) > 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '>' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction gte = new VncFunction(">="){
        {
            this.setArgLists("(>= x y)");
            this.setDoc("Returns true if x is greater or equal to y");
            this.setExamples("(>= 3 2)", "(>= 3 3)", "(>= 3.0 2)", "(>= 3.0M 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity(">=", args, 2);
            VncVal op1 = args.nth(0);
            VncVal op2 = args.nth(1);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).gte(op2);
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).gte(op2);
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).gte(op2);
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '>=' with operand 1 of type %s does not allow %s as operand 2. %s", Types.getClassName(op1), Types.getClassName(op2), ErrorMessage.buildErrLocation(args)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) >= 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '>=' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction zero_Q = new VncFunction("zero?"){
        {
            this.setArgLists("(zero? x)");
            this.setDoc("Returns true if x zero else false");
            this.setExamples("(zero? 0)", "(zero? 2)", "(zero? 0.0)", "(zero? 0.0M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("zero?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() == 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).getValue() == 0.0 ? Constants.True : Constants.False;
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) == 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'zero' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction pos_Q = new VncFunction("pos?"){
        {
            this.setArgLists("(pos? x)");
            this.setDoc("Returns true if x greater than zero else false");
            this.setExamples("(pos? 3)", "(pos? -3)", "(pos? 3.2)", "(pos? 3.2M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("pos?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() > 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).getValue() > 0.0 ? Constants.True : Constants.False;
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) > 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'pos' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction neg_Q = new VncFunction("neg?"){
        {
            this.setArgLists("(neg? x)");
            this.setDoc("Returns true if x smaller than zero else false");
            this.setExamples("(neg? -3)", "(neg? 3)", "(neg? -3.2)", "(neg? -3.2M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("neg?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() < 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).getValue() < 0.0 ? Constants.True : Constants.False;
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) < 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'plus' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction even_Q = new VncFunction("even?"){
        {
            this.setArgLists("(even? n)");
            this.setDoc("Returns true if n is even, throws an exception if n is not an integer");
            this.setExamples("(odd? 4)", "(odd? 3)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("even?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() % 2L == 0L ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'even' does not allow %s as operand. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction odd_Q = new VncFunction("odd?"){
        {
            this.setArgLists("(odd? n)");
            this.setDoc("Returns true if n is odd, throws an exception if n is not an integer");
            this.setExamples("(odd? 3)", "(odd? 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("odd?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() % 2L == 1L ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'odd' does not allow %s as operand. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction boolean_cast = new VncFunction("boolean"){
        {
            this.setArgLists("(boolean x)");
            this.setDoc("Converts to boolean. Everything except 'false' and 'nil' is true in boolean context.");
            this.setExamples("(boolean false)", "(boolean true)", "(boolean nil)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("boolean", args, 1);
            VncVal arg = args.nth(0);
            if (arg == Constants.Nil) {
                return Constants.False;
            }
            if (arg == Constants.False) {
                return Constants.False;
            }
            return Constants.True;
        }
    };
    public static VncFunction long_cast = new VncFunction("long"){
        {
            this.setArgLists("(long x)");
            this.setDoc("Converts to long");
            this.setExamples("(long 1)", "(long nil)", "(long false)", "(long true)", "(long 1.2)", "(long 1.2M)", "(long \"1.2\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("long", args, 1);
            VncVal op1 = args.nth(0);
            if (op1 == Constants.Nil) {
                return new VncLong(0);
            }
            if (op1 == Constants.False) {
                return new VncLong(0);
            }
            if (op1 == Constants.True) {
                return new VncLong(1);
            }
            if (Types.isVncLong(op1)) {
                return op1;
            }
            if (Types.isVncDouble(op1)) {
                return new VncLong(((VncDouble)op1).getValue().longValue());
            }
            if (Types.isVncBigDecimal(op1)) {
                return new VncLong(((VncBigDecimal)op1).getValue().longValue());
            }
            if (Types.isVncString(op1)) {
                String s = ((VncString)op1).getValue();
                try {
                    return new VncLong(Long.parseLong(s));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'long': the string %s can not be converted to a long. %s", s, ErrorMessage.buildErrLocation(args)));
                }
            }
            throw new VncException(String.format("Function 'long' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction double_cast = new VncFunction("double"){
        {
            this.setArgLists("(double x)");
            this.setDoc("Converts to double");
            this.setExamples("(double 1)", "(double nil)", "(double false)", "(double true)", "(double 1.2)", "(double 1.2M)", "(double \"1.2\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("double", args, 1);
            VncVal op1 = args.nth(0);
            if (op1 == Constants.Nil) {
                return new VncDouble(0.0);
            }
            if (op1 == Constants.False) {
                return new VncDouble(0.0);
            }
            if (op1 == Constants.True) {
                return new VncDouble(1.0);
            }
            if (Types.isVncLong(op1)) {
                return new VncDouble(((VncLong)op1).getValue().doubleValue());
            }
            if (Types.isVncDouble(op1)) {
                return op1;
            }
            if (Types.isVncBigDecimal(op1)) {
                return new VncDouble(((VncBigDecimal)op1).getValue().doubleValue());
            }
            if (Types.isVncString(op1)) {
                String s = ((VncString)op1).getValue();
                try {
                    return new VncDouble(Double.parseDouble(s));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'double': the string %s can not be converted to a double. %s", s, ErrorMessage.buildErrLocation(args)));
                }
            }
            throw new VncException(String.format("Function 'double' does not allow %s as operand 1. %s", Types.getClassName(op1), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction decimal_cast = new VncFunction("decimal"){
        {
            this.setArgLists("(decimal x) (decimal x scale rounding-mode)");
            this.setDoc("Converts to decimal. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
            this.setExamples("(decimal 2)", "(decimal 2 3 :HALF_UP)", "(decimal 2.5787 3 :HALF_UP)", "(decimal \"2.5787\" 3 :HALF_UP)", "(decimal nil)");
        }

        @Override
        public VncVal apply(VncList args) {
            RoundingMode roundingMode;
            FunctionsUtil.assertArity("decimal", args, 1, 3);
            if (args.isEmpty()) {
                return new VncBigDecimal(BigDecimal.ZERO);
            }
            VncVal arg = args.nth(0);
            VncLong scale = args.size() < 3 ? null : Coerce.toVncLong(args.nth(1));
            RoundingMode roundingMode2 = roundingMode = args.size() < 3 ? null : VncBigDecimal.toRoundingMode((VncString)args.nth(2));
            if (arg == Constants.Nil) {
                BigDecimal dec = BigDecimal.ZERO;
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (arg == Constants.False) {
                BigDecimal dec = BigDecimal.ZERO;
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (arg == Constants.True) {
                BigDecimal dec = BigDecimal.ONE;
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (Types.isVncString(arg)) {
                BigDecimal dec = new BigDecimal(((VncString)arg).getValue());
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (Types.isVncLong(arg)) {
                BigDecimal dec = new BigDecimal(((VncLong)arg).getValue());
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (Types.isVncDouble(arg)) {
                BigDecimal dec = VncBigDecimal.toDecimal((VncDouble)arg).getValue();
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (Types.isVncBigDecimal(arg)) {
                BigDecimal dec = ((VncBigDecimal)arg).getValue();
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            throw new VncException(String.format("Function 'decimal' does not allow %s as operand 1. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction new_list = new VncFunction("list"){
        {
            this.setArgLists("(list & items)");
            this.setDoc("Creates a new list containing the items.");
            this.setExamples("(list )", "(list 1 2 3)", "(list 1 2 3 [:a :b])");
        }

        @Override
        public VncVal apply(VncList args) {
            return new VncList(args.getList());
        }
    };
    public static VncFunction list_Q = new VncFunction("list?"){
        {
            this.setArgLists("(list? obj)");
            this.setDoc("Returns true if obj is a list");
            this.setExamples("(list? (list 1 2))", "(list? '(1 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("list?", args, 1);
            return CoreFunctions.list_Q(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction new_vector = new VncFunction("vector"){
        {
            this.setArgLists("(vector & items)");
            this.setDoc("Creates a new vector containing the items.");
            this.setExamples("(vector )", "(vector 1 2 3)", "(vector 1 2 3 [:a :b])");
        }

        @Override
        public VncVal apply(VncList args) {
            return new VncVector(args.getList());
        }
    };
    public static VncFunction vector_Q = new VncFunction("vector?"){
        {
            this.setArgLists("(vector? obj)");
            this.setDoc("Returns true if obj is a vector");
            this.setExamples("(vector? (vector 1 2))", "(vector? [1 2])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("vector?", args, 1);
            return CoreFunctions.vector_Q(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction subvec = new VncFunction("subvec"){
        {
            this.setArgLists("(subvec v start) (subvec v start end)");
            this.setDoc("Returns a vector of the items in vector from start (inclusive) to end (exclusive). If end is not supplied, defaults to (count vector)");
            this.setExamples("(subvec [1 2 3 4 5 6] 2)", "(subvec [1 2 3 4 5 6] 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("subvec", args, 2, 3);
            VncVector vec = Coerce.toVncVector(args.nth(0));
            VncLong from = Coerce.toVncLong(args.nth(1));
            VncLong to = args.size() > 2 ? Coerce.toVncLong(args.nth(2)) : null;
            return new VncVector(to == null ? vec.getList().subList(from.getValue().intValue(), vec.size()) : vec.getList().subList(from.getValue().intValue(), to.getValue().intValue()));
        }
    };
    public static VncFunction bytebuf_Q = new VncFunction("bytebuf?"){
        {
            this.setArgLists("(bytebuf? x)");
            this.setDoc("Returns true if x is a bytebuf");
            this.setExamples("(bytebuf? (bytebuf [1 2]))", "(bytebuf? [1 2])", "(bytebuf? nil)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("bytebuf?", args, 1);
            return Types.isVncByteBuffer(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction bytebuf_cast = new VncFunction("bytebuf"){
        {
            this.setArgLists("(bytebuf x)");
            this.setDoc("Converts to bytebuf. x can be a bytebuf, a list/vector of longs, or a string");
            this.setExamples("(bytebuf [0 1 2])", "(bytebuf '(0 1 2))", "(bytebuf \"abc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("bytebuf", args, 0, 1);
            if (args.isEmpty()) {
                return new VncByteBuffer(ByteBuffer.wrap(new byte[0]));
            }
            VncVal arg = args.nth(0);
            if (Types.isVncString(arg)) {
                try {
                    return new VncByteBuffer(ByteBuffer.wrap(((VncString)arg).getValue().getBytes("UTF-8")));
                }
                catch (Exception ex) {
                    throw new VncException("Failed to coerce string to bytebuf", ex);
                }
            }
            if (Types.isVncJavaObject(arg)) {
                Object delegate = ((VncJavaObject)arg).getDelegate();
                if (delegate.getClass() == byte[].class) {
                    return new VncByteBuffer(ByteBuffer.wrap((byte[])delegate));
                }
                if (delegate instanceof ByteBuffer) {
                    return new VncByteBuffer((ByteBuffer)delegate);
                }
            } else {
                if (Types.isVncByteBuffer(arg)) {
                    return ((VncByteBuffer)arg).copy();
                }
                if (Types.isVncList(arg)) {
                    if (!((VncList)arg).getList().stream().allMatch(v -> Types.isVncLong(v))) {
                        throw new VncException(String.format("Function 'bytebuf' a list as argument must contains long values. %s", ErrorMessage.buildErrLocation(args)));
                    }
                    List<VncVal> list = ((VncList)arg).getList();
                    byte[] buf = new byte[list.size()];
                    for (int ii = 0; ii < list.size(); ++ii) {
                        buf[ii] = (byte)((VncLong)list.get(ii)).getValue().longValue();
                    }
                    return new VncByteBuffer(ByteBuffer.wrap(buf));
                }
            }
            throw new VncException(String.format("Function 'bytebuf' does not allow %s as argument. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction bytebuf_from_string = new VncFunction("bytebuf-from-string"){
        {
            this.setArgLists("(bytebuf-from-string s encoding)");
            this.setDoc("Converts a string to a bytebuf using an optional encoding. The encoding defaults to UTF-8");
            this.setExamples("(bytebuf-from-string \"abcdef\" :UTF-8)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal encVal;
            FunctionsUtil.assertArity("bytebuf-from-string", args, 1, 2);
            String s = Coerce.toVncString(args.first()).getValue();
            VncVal vncVal = encVal = args.size() == 2 ? args.second() : Constants.Nil;
            String encoding = encVal == Constants.Nil ? "UTF-8" : (Types.isVncKeyword(encVal) ? Coerce.toVncKeyword(encVal).getValue() : Coerce.toVncString(encVal).getValue());
            try {
                return new VncByteBuffer(ByteBuffer.wrap(s.getBytes(encoding)));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to convert string to bytebuffer. %s", ErrorMessage.buildErrLocation(args)));
            }
        }
    };
    public static VncFunction bytebuf_to_string = new VncFunction("bytebuf-to-string"){
        {
            this.setArgLists("(bytebuf-to-string buf encoding)");
            this.setDoc("Converts a bytebuf to a string using an optional encoding. The encoding defaults to UTF-8");
            this.setExamples("(bytebuf-to-string (bytebuf [97 98 99]) :UTF-8)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal encVal;
            FunctionsUtil.assertArity("bytebuf-to-string", args, 1, 2);
            ByteBuffer buf = Coerce.toVncByteBuffer(args.first()).getValue();
            VncVal vncVal = encVal = args.size() == 2 ? args.second() : Constants.Nil;
            String encoding = encVal == Constants.Nil ? "UTF-8" : (Types.isVncKeyword(encVal) ? Coerce.toVncKeyword(encVal).getValue() : Coerce.toVncString(encVal).getValue());
            try {
                return new VncString(new String(buf.array(), encoding));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to convert bytebuffer to string. %s", ErrorMessage.buildErrLocation(args)));
            }
        }
    };
    public static VncFunction bytebuf_sub = new VncFunction("bytebuf-sub"){
        {
            this.setArgLists("(bytebuf-sub x start) (bytebuf-sub x start end)");
            this.setDoc("Returns a byte buffer of the items in buffer from start (inclusive) to end (exclusive). If end is not supplied, defaults to (count bytebuffer)");
            this.setExamples("(bytebuf-sub (bytebuf [1 2 3 4 5 6]) 2)", "(bytebuf-sub (bytebuf [1 2 3 4 5 6]) 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("bytebuf-sub", args, 2, 3);
            byte[] buf = Coerce.toVncByteBuffer(args.nth(0)).getValue().array();
            VncLong from = Coerce.toVncLong(args.nth(1));
            VncLong to = args.size() > 2 ? Coerce.toVncLong(args.nth(2)) : null;
            return new VncByteBuffer(to == null ? ByteBuffer.wrap(Arrays.copyOfRange(buf, from.getValue().intValue(), buf.length)) : ByteBuffer.wrap(Arrays.copyOfRange(buf, from.getValue().intValue(), to.getValue().intValue())));
        }
    };
    public static VncFunction new_set = new VncFunction("set"){
        {
            this.setArgLists("(set & items)");
            this.setDoc("Creates a new set containing the items.");
            this.setExamples("(set )", "(set nil)", "(set 1)", "(set 1 2 3)", "(set [1 2] 3)");
        }

        @Override
        public VncVal apply(VncList args) {
            return new VncSet(args);
        }
    };
    public static VncFunction set_Q = new VncFunction("set?"){
        {
            this.setArgLists("(set? obj)");
            this.setDoc("Returns true if obj is a set");
            this.setExamples("(set? (set 1))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("set?", args, 1);
            return Types.isVncSet(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction difference = new VncFunction("difference"){
        {
            this.setArgLists("(difference s1)", "(difference s1 s2)", "(difference s1 s2 & sets)");
            this.setDoc("Return a set that is the first set without elements of the remaining sets");
            this.setExamples("(difference (set 1 2 3))", "(difference (set 1 2) (set 2 3))", "(difference (set 1 2) (set 1) (set 1 4) (set 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("difference", args, 1);
            Set<VncVal> set = Coerce.toVncSet(args.first()).getSet();
            for (int ii = 1; ii < args.size(); ++ii) {
                set.removeAll(Coerce.toVncSet(args.nth(ii)).getSet());
            }
            return new VncSet(set);
        }
    };
    public static VncFunction union = new VncFunction("union"){
        {
            this.setArgLists("(union s1)", "(union s1 s2)", "(union s1 s2 & sets)");
            this.setDoc("Return a set that is the union of the input sets");
            this.setExamples("(union (set 1 2 3))", "(union (set 1 2) (set 2 3))", "(union (set 1 2 3) (set 1 2) (set 1 4) (set 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("union", args, 1);
            Set<VncVal> set = Coerce.toVncSet(args.first()).getSet();
            for (int ii = 1; ii < args.size(); ++ii) {
                set.addAll(Coerce.toVncSet(args.nth(ii)).getSet());
            }
            return new VncSet(set);
        }
    };
    public static VncFunction intersection = new VncFunction("intersection"){
        {
            this.setArgLists("(intersection s1)", "(intersection s1 s2)", "(intersection s1 s2 & sets)");
            this.setDoc("Return a set that is the intersection of the input sets");
            this.setExamples("(intersection (set 1))", "(intersection (set 1 2) (set 2 3))", "(intersection (set 1 2) (set 3 4))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("intersection", args, 1);
            HashSet<VncVal> intersection = new HashSet<VncVal>();
            Set<VncVal> first = Coerce.toVncSet(args.first()).getSet();
            first.forEach(v -> {
                boolean intersect = true;
                for (int ii = 1; ii < args.size(); ++ii) {
                    if (Coerce.toVncSet(args.nth(ii)).getSet().contains(v)) continue;
                    intersect = false;
                    break;
                }
                if (intersect) {
                    intersection.add((VncVal)v);
                }
            });
            return new VncSet(intersection);
        }
    };
    public static VncFunction new_hash_map = new VncFunction("hash-map"){
        {
            this.setArgLists("(hash-map & keyvals)", "(hash-map map)");
            this.setDoc("Creates a new hash map containing the items.");
            this.setExamples("(hash-map :a 1 :b 2)", "(hash-map (sorted-map :a 1 :b 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.nth(0))) {
                return new VncHashMap(((VncMap)args.nth(0)).getMap());
            }
            if (args.size() == 1 && Types.isVncJavaObject(args.nth(0))) {
                return ((VncJavaObject)args.nth(0)).toVncMap();
            }
            return new VncHashMap(args);
        }
    };
    public static VncFunction new_ordered_map = new VncFunction("ordered-map"){
        {
            this.setArgLists("(ordered-map & keyvals)", "(ordered-map map)");
            this.setDoc("Creates a new ordered map containing the items.");
            this.setExamples("(ordered-map :a 1 :b 2)", "(ordered-map (hash-map :a 1 :b 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.nth(0))) {
                return new VncOrderedMap(((VncMap)args.nth(0)).getMap());
            }
            return new VncOrderedMap(args);
        }
    };
    public static VncFunction new_sorted_map = new VncFunction("sorted-map"){
        {
            this.setArgLists("(sorted-map & keyvals)", "(sorted-map map)");
            this.setDoc("Creates a new sorted map containing the items.");
            this.setExamples("(sorted-map :a 1 :b 2)", "(sorted-map (hash-map :a 1 :b 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.nth(0))) {
                return new VncSortedMap(((VncMap)args.nth(0)).getMap());
            }
            return new VncSortedMap(args);
        }
    };
    public static VncFunction map_Q = new VncFunction("map?"){
        {
            this.setArgLists("(map? obj)");
            this.setDoc("Returns true if obj is a map");
            this.setExamples("(map? {:a 1 :b 2})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("map?", args, 1);
            return Types.isVncMap(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction hash_map_Q = new VncFunction("hash-map?"){
        {
            this.setArgLists("(hash-map? obj)");
            this.setDoc("Returns true if obj is a hash map");
            this.setExamples("(hash-map? (hash-map :a 1 :b 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("hash-map?", args, 1);
            return Types.isVncHashMap(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction ordered_map_Q = new VncFunction("ordered-map?"){
        {
            this.setArgLists("(ordered-map? obj)");
            this.setDoc("Returns true if obj is an ordered map");
            this.setExamples("(ordered-map? (ordered-map :a 1 :b 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("ordered-map?", args, 1);
            return Types.isVncOrderedMap(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction sorted_map_Q = new VncFunction("sorted-map?"){
        {
            this.setArgLists("(sorted-map? obj)");
            this.setDoc("Returns true if obj is a sorted map");
            this.setExamples("(sorted-map? (sorted-map :a 1 :b 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sorted-map?", args, 1);
            return Types.isVncSortedMap(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction contains_Q = new VncFunction("contains?"){
        {
            this.setArgLists("(contains? coll key)");
            this.setDoc("Returns true if key is present in the given collection, otherwise returns false.");
            this.setExamples("(contains? {:a 1 :b 2} :a)", "(contains? [10 11 12] 1)", "(contains? [10 11 12] 5)", "(contains? \"abc\" 1)", "(contains? \"abc\" 5)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("contains?", args, 2);
            VncVal coll = args.nth(0);
            VncVal key = args.nth(1);
            if (Types.isVncMap(coll)) {
                VncMap mhm = (VncMap)coll;
                Map<VncVal, VncVal> hm = mhm.getMap();
                return hm.containsKey(key) ? Constants.True : Constants.False;
            }
            if (Types.isVncVector(coll)) {
                VncVector v = (VncVector)coll;
                VncLong k = (VncLong)key;
                return v.size() > k.getValue().intValue() ? Constants.True : Constants.False;
            }
            if (Types.isVncSet(coll)) {
                VncSet s = (VncSet)coll;
                return s.getSet().contains(key) ? Constants.True : Constants.False;
            }
            if (Types.isVncString(coll)) {
                VncString s = (VncString)coll;
                VncLong k = (VncLong)key;
                return s.getValue().length() > k.getValue().intValue() ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'contains?' does not allow %s as coll. %s", Types.getClassName(coll), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction assoc = new VncFunction("assoc"){
        {
            this.setArgLists("(assoc coll key val)", "(assoc coll key val & kvs)");
            this.setDoc("When applied to a map, returns a new map of the same type, that contains the mapping of key(s) to val(s). When applied to a vector, returns a new vector that contains val at index. Note - index must be <= (count vector).");
            this.setExamples("(assoc {} :a 1 :b 2)", "(assoc nil :a 1 :b 2)", "(assoc [1 2 3] 0 10)", "(assoc [1 2 3] 3 10)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.nth(0) == Constants.Nil) {
                VncHashMap new_hm = new VncHashMap(new VncVal[0]);
                ((VncMap)new_hm).assoc(args.slice(1));
                return new_hm;
            }
            if (Types.isVncMap(args.nth(0))) {
                VncMap hm = (VncMap)args.nth(0);
                VncMap new_hm = hm.copy();
                new_hm.assoc(args.slice(1));
                return new_hm;
            }
            if (Types.isVncVector(args.nth(0))) {
                VncVector vec = ((VncVector)args.nth(0)).copy();
                VncList keyvals = args.slice(1);
                for (int ii = 0; ii < keyvals.size(); ii += 2) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    VncVal val = keyvals.nth(ii + 1);
                    if (vec.size() > key.getValue().intValue()) {
                        vec.getList().set(key.getValue().intValue(), val);
                        continue;
                    }
                    vec.addAtEnd(val);
                }
                return vec;
            }
            if (Types.isVncString(args.nth(0))) {
                String s = ((VncString)args.nth(0)).getValue();
                VncList keyvals = args.slice(1);
                for (int ii = 0; ii < keyvals.size(); ii += 2) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    VncString val = Coerce.toVncString(keyvals.nth(ii + 1));
                    int idx = key.getValue().intValue();
                    if (s.length() > idx) {
                        if (idx == 0) {
                            s = "" + val.getValue().charAt(0) + s.substring(1);
                            continue;
                        }
                        if (idx == s.length() - 1) {
                            s = s.substring(0, idx) + val.getValue().charAt(0);
                            continue;
                        }
                        s = s.substring(0, idx) + val.getValue().charAt(0) + s.substring(idx + 1);
                        continue;
                    }
                    s = s + val.getValue().charAt(0);
                }
                return new VncString(s);
            }
            if (Types.isVncThreadLocal(args.nth(0))) {
                VncThreadLocal th = (VncThreadLocal)args.nth(0);
                th.assoc(args.slice(1));
                return th;
            }
            throw new VncException(String.format("Function 'assoc' does not allow %s as collection. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction assoc_in = new VncFunction("assoc-in"){
        {
            this.setArgLists("(assoc-in m ks v)");
            this.setDoc("Associates a value in a nested associative structure, where ks is a sequence of keys and v is the new value and returns a new nested structure. If any levels do not exist, hash-maps or vectors will be created.");
            this.setExamples("(do\n   (def users [{:name \"James\" :age 26}  {:name \"John\" :age 43}])\n   (assoc-in users [1 :age] 44))", "(do\n   (def users [{:name \"James\" :age 26}  {:name \"John\" :age 43}])\n   (assoc-in users [2] {:name \"Jack\" :age 19}) )");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("assoc-in", args, 3);
            VncCollection coll_copy = Coerce.toVncCollection(args.nth(0)).copy();
            VncList keys = Coerce.toVncList(args.nth(1));
            VncVal new_val = args.nth(2);
            VncCollection coll = coll_copy;
            while (!keys.isEmpty()) {
                VncVal key = keys.first();
                keys = keys.rest();
                if (Types.isVncMap(coll)) {
                    VncVal val = ((VncMap)coll).get(key);
                    if (val == Constants.Nil) {
                        if (keys.isEmpty()) {
                            ((VncMap)coll).assoc(key, new_val);
                            continue;
                        }
                        VncHashMap newMap = new VncHashMap(new VncVal[0]);
                        ((VncMap)coll).assoc(key, newMap);
                        coll = newMap;
                        continue;
                    }
                    if (keys.isEmpty()) {
                        ((VncMap)coll).assoc(key, new_val);
                        continue;
                    }
                    if (!Types.isVncCollection(val)) break;
                    coll = (VncCollection)val;
                    continue;
                }
                if (!Types.isVncLong(key)) break;
                int idx = ((VncLong)key).getValue().intValue();
                int len = ((VncList)coll).size();
                if (idx < 0 || idx > len) {
                    throw new VncException(String.format("Function 'assoc-in' index %d out of bounds. %s", idx, ErrorMessage.buildErrLocation(args)));
                }
                if (idx < len) {
                    if (keys.isEmpty()) {
                        ((VncList)coll).getList().set(idx, new_val);
                        break;
                    }
                    VncVal val = ((VncList)coll).nth(idx);
                    if (!Types.isVncCollection(val)) break;
                    coll = (VncCollection)val;
                    continue;
                }
                ((VncList)coll).addAtEnd(new_val);
                break;
            }
            return coll_copy;
        }
    };
    public static VncFunction dissoc = new VncFunction("dissoc"){
        {
            this.setArgLists("(dissoc coll key)", "(dissoc coll key & ks)");
            this.setDoc("Returns a new coll of the same type, that does not contain a mapping for key(s)");
            this.setExamples("(dissoc {:a 1 :b 2 :c 3} :b)", "(dissoc {:a 1 :b 2 :c 3} :c :b)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (Types.isVncMap(args.nth(0))) {
                VncMap hm = (VncMap)args.nth(0);
                VncMap new_hm = hm.copy();
                new_hm.dissoc(args.slice(1));
                return new_hm;
            }
            if (Types.isVncVector(args.nth(0))) {
                VncVector vec = ((VncVector)args.nth(0)).copy();
                VncList keyvals = args.slice(1);
                for (int ii = 0; ii < keyvals.size(); ++ii) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    if (vec.size() <= key.getValue().intValue()) continue;
                    vec.getList().remove(key.getValue().intValue());
                }
                return vec;
            }
            if (Types.isVncString(args.nth(0))) {
                String s = ((VncString)args.nth(0)).getValue();
                VncList keyvals = args.slice(1);
                for (int ii = 0; ii < keyvals.size(); ++ii) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    int idx = key.getValue().intValue();
                    if (s.length() <= idx) continue;
                    s = idx == 0 ? s.substring(1) : (idx == s.length() - 1 ? s.substring(0, idx) : s.substring(0, idx) + s.substring(idx + 1));
                }
                return new VncString(s);
            }
            if (Types.isVncThreadLocal(args.nth(0))) {
                VncThreadLocal th = (VncThreadLocal)args.nth(0);
                th.dissoc(args.slice(1));
                return th;
            }
            throw new VncException(String.format("Function 'dissoc' does not allow %s as coll. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction get = new VncFunction("get"){
        {
            this.setArgLists("(get map key)", "(get map key not-found)");
            this.setDoc("Returns the value mapped to key, not-found or nil if key not present.");
            this.setExamples("(get {:a 1 :b 2} :b)", ";; keywords act like functions on maps \n(:b {:a 1 :b 2})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("get", args, 2, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncMap(args.nth(0))) {
                VncMap mhm = Coerce.toVncMap(args.nth(0));
                VncVal key = args.nth(1);
                VncConstant key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
                VncVal value = mhm.get(key);
                return value != Constants.Nil ? value : key_not_found;
            }
            if (Types.isVncThreadLocal(args.nth(0))) {
                VncThreadLocal th = Coerce.toVncThreadLocal(args.nth(0));
                VncKeyword key = Coerce.toVncKeyword(args.nth(1));
                VncConstant key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
                VncVal value = th.get(key);
                return value != Constants.Nil ? value : key_not_found;
            }
            throw new VncException(String.format("Function 'get' does not allow %s as collection. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction get_in = new VncFunction("get-in"){
        {
            this.setArgLists("(get-in m ks)", "(get-in m ks not-found)");
            this.setDoc("Returns the value in a nested associative structure, where ks is a sequence of keys. Returns nil if the key is not present, or the not-found value if supplied.");
            this.setExamples("(get-in {:a 1 :b {:c 2 :d 3}} [:b :c])", "(get-in [:a :b :c] [0])", "(get-in [:a :b [:c :d :e]] [2 1])", "(get-in {:a 1 :b {:c [4 5 6]}} [:b :c 1])");
        }

        @Override
        public VncVal apply(VncList args) {
            VncConstant key_not_found;
            FunctionsUtil.assertArity("get-in", args, 2, 3);
            VncCollection coll = Coerce.toVncCollection(args.nth(0));
            VncList keys = Coerce.toVncList(args.nth(1));
            VncVal vncVal = key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
            while (!keys.isEmpty()) {
                VncVal key = keys.first();
                keys = keys.rest();
                if (Types.isVncMap(coll)) {
                    VncVal val = ((VncMap)coll).get(key);
                    if (val == Constants.Nil) {
                        return key_not_found;
                    }
                    if (keys.isEmpty()) {
                        return val;
                    }
                    if (Types.isVncCollection(val)) {
                        coll = (VncCollection)val;
                        continue;
                    }
                    return key_not_found;
                }
                if (Types.isVncLong(key)) {
                    int index = ((VncLong)key).getValue().intValue();
                    VncVal val = ((VncList)coll).nthOrDefault(index, Constants.Nil);
                    if (val == Constants.Nil) {
                        return key_not_found;
                    }
                    if (keys.isEmpty()) {
                        return val;
                    }
                    if (Types.isVncCollection(val)) {
                        coll = (VncCollection)val;
                        continue;
                    }
                    return key_not_found;
                }
                return key_not_found;
            }
            return key_not_found;
        }
    };
    public static VncFunction find = new VncFunction("find"){
        {
            this.setArgLists("(find map key)");
            this.setDoc("Returns the map entry for key, or nil if key not present.");
            this.setExamples("(find {:a 1 :b 2} :b)", "(find {:a 1 :b 2} :z)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal key;
            FunctionsUtil.assertArity("find", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            VncMap mhm = Coerce.toVncMap(args.nth(0));
            VncVal value = mhm.get(key = args.nth(1));
            return value == Constants.Nil ? Constants.Nil : new VncVector(key, value);
        }
    };
    public static VncFunction key = new VncFunction("key"){
        {
            this.setArgLists("(key e)");
            this.setDoc("Returns the key of the map entry.");
            this.setExamples("(key (find {:a 1 :b 2} :b))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("key", args, 1);
            VncList entry = Coerce.toVncList(args.nth(0));
            return entry.first();
        }
    };
    public static VncFunction keys = new VncFunction("keys"){
        {
            this.setArgLists("(keys map)");
            this.setDoc("Returns a collection of the map's keys.");
            this.setExamples("(keys {:a 1 :b 2 :c 3})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keys", args, 1);
            VncMap mhm = Coerce.toVncMap(args.nth(0));
            Map<VncVal, VncVal> hm = mhm.getMap();
            VncList key_lst = new VncList(new VncVal[0]);
            for (VncVal key : hm.keySet()) {
                key_lst.addAtEnd(key);
            }
            return key_lst;
        }
    };
    public static VncFunction val = new VncFunction("val"){
        {
            this.setArgLists("(val e)");
            this.setDoc("Returns the val of the map entry.");
            this.setExamples("(val (find {:a 1 :b 2} :b))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("val", args, 1);
            VncList entry = Coerce.toVncList(args.nth(0));
            return entry.second();
        }
    };
    public static VncFunction vals = new VncFunction("vals"){
        {
            this.setArgLists("(vals map)");
            this.setDoc("Returns a collection of the map's values.");
            this.setExamples("(vals {:a 1 :b 2 :c 3})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("vals", args, 1);
            VncMap mhm = Coerce.toVncMap(args.nth(0));
            Map<VncVal, VncVal> hm = mhm.getMap();
            VncList val_lst = new VncList(new VncVal[0]);
            for (VncVal val : hm.values()) {
                val_lst.addAtEnd(val);
            }
            return val_lst;
        }
    };
    public static VncFunction update = new VncFunction("update"){
        {
            this.setArgLists("(update m k f)");
            this.setDoc("Updates a value in an associative structure, where k is a key and f is a function that will take the old value return the new value. Returns a new structure.");
            this.setExamples("(update [] 0 (fn [x] 5))", "(update [0 1 2] 0 (fn [x] 5))", "(update [0 1 2] 0 (fn [x] (+ x 1)))", "(update {} :a (fn [x] 5))", "(update {:a 0} :b (fn [x] 5))", "(update {:a 0 :b 1} :a (fn [x] 5))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("update", args, 3);
            if (Types.isVncList(args.first())) {
                VncList list = ((VncList)args.first()).copy();
                int idx = Coerce.toVncLong(args.second()).getValue().intValue();
                VncFunction fn = Coerce.toVncFunction(args.nth(2));
                if (idx < 0 || idx > list.size()) {
                    throw new VncException(String.format("Function 'update' index %d out of bounds. %s", idx, ErrorMessage.buildErrLocation(args)));
                }
                if (idx < list.size()) {
                    list.getList().set(idx, (VncVal)fn.apply(new VncList(list.nth(idx))));
                } else {
                    list.addAtEnd((VncVal)fn.apply(new VncList(Constants.Nil)));
                }
                return list;
            }
            if (Types.isVncMap(args.first())) {
                VncMap map = ((VncMap)args.first()).copy();
                VncVal key = args.second();
                VncFunction fn = Coerce.toVncFunction(args.nth(2));
                map.assoc(key, (VncVal)fn.apply(new VncList(map.get(key))));
                return map;
            }
            throw new VncException(String.format("'update' does not allow %s as associative structure. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction update_BANG = new VncFunction("update!"){
        {
            this.setArgLists("(update! m k f)");
            this.setDoc("Updates a value in an associative structure, where k is a key and f is a function that will take the old value return the new value.");
            this.setExamples("(update! [] 0 (fn [x] 5))", "(update! [0 1 2] 0 (fn [x] 5))", "(update! [0 1 2] 0 (fn [x] (+ x 1)))", "(update! {} :a (fn [x] 5))", "(update! {:a 0} :b (fn [x] 5))", "(update! {:a 0 :b 1} :a (fn [x] 5))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("update!", args, 3);
            if (Types.isVncList(args.first())) {
                VncList list = (VncList)args.first();
                int idx = Coerce.toVncLong(args.second()).getValue().intValue();
                VncFunction fn = Coerce.toVncFunction(args.nth(2));
                if (idx < 0 || idx > list.size()) {
                    throw new VncException(String.format("Function 'update' index %d out of bounds. %s", idx, ErrorMessage.buildErrLocation(args)));
                }
                if (idx < list.size()) {
                    list.getList().set(idx, (VncVal)fn.apply(new VncList(list.nth(idx))));
                } else {
                    list.addAtEnd((VncVal)fn.apply(new VncList(Constants.Nil)));
                }
                return list;
            }
            if (Types.isVncMap(args.first())) {
                VncMap map = (VncMap)args.first();
                VncVal key = args.second();
                VncFunction fn = Coerce.toVncFunction(args.nth(2));
                map.assoc(key, (VncVal)fn.apply(new VncList(map.get(key))));
                return map;
            }
            throw new VncException(String.format("'update' does not allow %s as associative structure. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction split_with = new VncFunction("split-with"){
        {
            this.setArgLists("(split-with pred coll)");
            this.setDoc("Splits the collection at the first false/nil predicate result in a vector with two lists");
            this.setExamples("(split-with odd? [1 3 5 6 7 9])", "(split-with odd? [1 3 5])", "(split-with odd? [2 4 6])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("split-with", args, 2);
            if (args.second() == Constants.Nil) {
                return new VncVector(new VncList(new VncVal[0]), new VncList(new VncVal[0]));
            }
            VncFunction pred = Coerce.toVncFunction(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            List<VncVal> items = coll.getList();
            int splitPos = items.size();
            for (int ii = 0; ii < items.size(); ++ii) {
                VncVal val = coll.nth(ii);
                VncVal match = (VncVal)pred.apply(new VncList(val));
                if (match != Constants.False && match != Constants.Nil) continue;
                splitPos = ii;
                break;
            }
            if (splitPos == 0) {
                return new VncVector(new VncList(new VncVal[0]), new VncList(items));
            }
            if (splitPos < items.size()) {
                return new VncVector(new VncList(items.subList(0, splitPos)), new VncList(items.subList(splitPos, items.size())));
            }
            return new VncVector(new VncList(items), new VncList(new VncVal[0]));
        }
    };
    public static VncFunction into = new VncFunction("into"){
        {
            this.setArgLists("(into to-coll from-coll)");
            this.setDoc("Returns a new coll consisting of to-coll with all of the items offrom-coll conjoined.");
            this.setExamples("(into (sorted-map) [ [:a 1] [:c 3] [:b 2] ] )", "(into (sorted-map) [ {:a 1} {:c 3} {:b 2} ] )", "(into [] {1 2, 3 4})", "(into '() '(1 2 3))", "(into [1 2 3] '(4 5 6))", "(into '() (bytebuf [0 1 2]))", "(into [] (bytebuf [0 1 2]))", "(into '() \"abc\")", "(into [] \"abc\")", "(into (sorted-map) {:b 2 :c 3 :a 1})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("into", args, 2);
            if (args.second() == Constants.Nil) {
                return args.first();
            }
            VncCollection to = Coerce.toVncCollection(args.first()).copy();
            if (Types.isVncByteBuffer(args.second())) {
                VncList byteList = ((VncByteBuffer)args.second()).toVncList();
                if (Types.isVncVector(to)) {
                    byteList.forEach(v -> ((VncVector)to).addAtEnd((VncVal)v));
                } else if (Types.isVncList(to)) {
                    byteList.forEach(v -> ((VncList)to).addAtEnd((VncVal)v));
                } else {
                    throw new VncException(String.format("Function 'into' does only allow list and vector as to-coll if from-coll is a bytebuf. %s", ErrorMessage.buildErrLocation(args)));
                }
                return to;
            }
            if (Types.isVncString(args.second())) {
                VncList charList = ((VncString)args.second()).toVncList();
                if (Types.isVncVector(to)) {
                    charList.forEach(v -> ((VncVector)to).addAtEnd((VncVal)v));
                } else if (Types.isVncList(to)) {
                    charList.forEach(v -> ((VncList)to).addAtEnd((VncVal)v));
                } else if (Types.isVncSet(to)) {
                    charList.forEach(v -> ((VncSet)to).add((VncVal)v));
                } else {
                    throw new VncException(String.format("Function 'into' does only allow list, vector, and set as to-coll if from-coll is a string. %s", ErrorMessage.buildErrLocation(args)));
                }
                return to;
            }
            VncCollection from = Coerce.toVncCollection(args.second());
            if (Types.isVncVector(to)) {
                from.toVncList().getList().forEach(v -> ((VncVector)to).addAtEnd((VncVal)v));
            } else if (Types.isVncList(to)) {
                from.toVncList().getList().forEach(v -> ((VncList)to).addAtStart((VncVal)v));
            } else if (Types.isVncSet(to)) {
                from.toVncList().getList().forEach(v -> ((VncSet)to).add((VncVal)v));
            } else if (Types.isVncMap(to)) {
                if (Types.isVncSequence(from)) {
                    ((VncList)from).getList().forEach(it -> {
                        if (Types.isVncSequence(it)) {
                            ((VncMap)to).assoc(((VncSequence)it).toVncList());
                        } else if (Types.isVncMap(it)) {
                            ((VncMap)to).getMap().putAll(((VncMap)it).getMap());
                        }
                    });
                } else if (Types.isVncMap(from)) {
                    ((VncMap)to).getMap().putAll(((VncMap)from).getMap());
                }
            } else {
                throw new VncException(String.format("Function 'into' does not allow %s as to-coll. %s", Types.getClassName(args.first()), ErrorMessage.buildErrLocation(args)));
            }
            return to;
        }
    };
    public static VncFunction sequential_Q = new VncFunction("sequential?"){
        {
            this.setArgLists("(sequential? obj)");
            this.setDoc("Returns true if obj is a sequential collection");
            this.setExamples("(sequential? '(1))", "(sequential? [1])", "(sequential? {:a 1})", "(sequential? nil)", "(sequential? \"abc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sequential?", args, 1);
            return Types.isVncSequence(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction coll_Q = new VncFunction("coll?"){
        {
            this.setArgLists("(coll? obj)");
            this.setDoc("Returns true if obj is a collection");
            this.setExamples("(coll? {:a 1})", "(coll? [1 2])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("coll?", args, 1);
            return Types.isVncCollection(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction every_Q = new VncFunction("every?"){
        {
            this.setArgLists("(every? pred coll)");
            this.setDoc("Returns true if the predicate is true for all collection items, false otherwise");
            this.setExamples("(every? (fn [x] (number? x)) nil)", "(every? (fn [x] (number? x)) [])", "(every? (fn [x] (number? x)) [1 2 3 4])", "(every? (fn [x] (number? x)) [1 2 3 :a])", "(every? (fn [x] (>= x 10)) [10 11 12])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("every?", args, 2);
            if (args.second() == Constants.Nil) {
                return Constants.False;
            }
            VncFunction pred = Coerce.toVncFunction(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            if (coll.isEmpty()) {
                return Constants.False;
            }
            return coll.getList().stream().allMatch(v -> pred.apply(new VncList((VncVal)v)) == Constants.True) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction any_Q = new VncFunction("any?"){
        {
            this.setArgLists("(any? pred coll)");
            this.setDoc("Returns true if the predicate is true for at least one collection item, false otherwise");
            this.setExamples("(any? (fn [x] (number? x)) nil)", "(any? (fn [x] (number? x)) [])", "(any? (fn [x] (number? x)) [1 :a :b])", "(any? (fn [x] (number? x)) [1 2 3])", "(any? (fn [x] (>= x 10)) [1 5 10])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("any?", args, 2);
            if (args.second() == Constants.Nil) {
                return Constants.False;
            }
            VncFunction pred = Coerce.toVncFunction(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            if (coll.isEmpty()) {
                return Constants.False;
            }
            return coll.getList().stream().anyMatch(v -> pred.apply(new VncList((VncVal)v)) == Constants.True) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction count = new VncFunction("count"){
        {
            this.setArgLists("(count coll)");
            this.setDoc("Returns the number of items in the collection. (count nil) returns 0. Also works on strings, and Java Collections");
            this.setExamples("(count {:a 1 :b 2})", "(count [1 2])", "(count \"abc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("count", args, 1);
            VncVal arg = args.nth(0);
            if (arg == Constants.Nil) {
                return new VncLong(0L);
            }
            if (Types.isVncString(arg)) {
                return new VncLong(((VncString)arg).getValue().length());
            }
            if (Types.isVncByteBuffer(arg)) {
                return new VncLong(((VncByteBuffer)arg).size());
            }
            if (Types.isVncList(arg)) {
                return new VncLong(((VncList)arg).size());
            }
            if (Types.isVncSet(arg)) {
                return new VncLong(((VncSet)arg).size());
            }
            if (Types.isVncMap(arg)) {
                return new VncLong(((VncMap)arg).size());
            }
            if (Types.isVncJavaList(arg)) {
                return new VncLong(((VncJavaList)arg).size());
            }
            if (Types.isVncJavaSet(arg)) {
                return new VncLong(((VncJavaSet)arg).size());
            }
            if (Types.isVncJavaMap(arg)) {
                return new VncLong(((VncJavaMap)arg).size());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'count'. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction empty = new VncFunction("empty"){
        {
            this.setArgLists("(empty coll)");
            this.setDoc("Returns an empty collection of the same category as coll, or nil");
            this.setExamples("(empty {:a 1})", "(empty [1 2])", "(empty '(1 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("empty", args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (coll instanceof VncVector) {
                return ((VncVector)coll).empty();
            }
            if (coll instanceof VncList) {
                return ((VncList)coll).empty();
            }
            if (coll instanceof VncMap) {
                return ((VncMap)coll).empty();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'empty'. %s", Types.getClassName(coll), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction empty_Q = new VncFunction("empty?"){
        {
            this.setArgLists("(empty? x)");
            this.setDoc("Returns true if x is empty");
            this.setExamples("(empty? {})", "(empty? [])", "(empty? '())");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("empty?", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return Constants.True;
            }
            if (exp instanceof VncString && ((VncString)exp).getValue().isEmpty()) {
                return Constants.True;
            }
            if (exp instanceof VncCollection && ((VncCollection)exp).isEmpty()) {
                return Constants.True;
            }
            if (exp instanceof VncByteBuffer && ((VncByteBuffer)exp).size() == 0) {
                return Constants.True;
            }
            return Constants.False;
        }
    };
    public static VncFunction not_empty_Q = new VncFunction("not-empty?"){
        {
            this.setArgLists("(not-empty? x)");
            this.setDoc("Returns true if x is not empty");
            this.setExamples("(empty? {:a 1})", "(empty? [1 2])", "(empty? '(1 2))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("not-empty?", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return Constants.False;
            }
            if (exp instanceof VncString && ((VncString)exp).getValue().isEmpty()) {
                return Constants.False;
            }
            if (exp instanceof VncCollection && ((VncCollection)exp).isEmpty()) {
                return Constants.False;
            }
            if (exp instanceof VncByteBuffer && ((VncByteBuffer)exp).size() != 0) {
                return Constants.True;
            }
            return Constants.True;
        }
    };
    public static VncFunction cons = new VncFunction("cons"){
        {
            this.setArgLists("(cons x coll)");
            this.setDoc("Returns a new collection where x is the first element and coll is\nthe rest");
            this.setExamples("(cons 1 '(2 3 4 5 6))", "(cons [1 2] [4 5 6])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("cons", args, 2);
            if (Types.isVncList(args.nth(1))) {
                VncList list = new VncList(new VncVal[0]);
                list.addAtStart(args.nth(0));
                list.addAtEnd((VncList)args.nth(1));
                return list;
            }
            if (Types.isVncMap(args.nth(1)) && Types.isVncMap(args.nth(0))) {
                VncMap map = ((VncMap)args.nth(1)).copy();
                map.getMap().putAll(((VncMap)args.nth(0)).getMap());
                return map;
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'cons'. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction concat = new VncFunction("concat"){
        {
            this.setArgLists("(concat coll)", "(concat coll & colls)");
            this.setDoc("Returns a collection of the concatenation of the elements in the supplied colls.");
            this.setExamples("(concat [1 2])", "(concat [1 2] [4 5 6])", "(concat '(1 2))", "(concat '(1 2) [4 5 6])", "(concat {:a 1})", "(concat {:a 1} {:b 2 c: 3})", "(concat \"abc\")", "(concat \"abc\" \"def\")");
        }

        @Override
        public VncVal apply(VncList args) {
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            args.getList().forEach(val -> {
                if (val != Constants.Nil) {
                    if (Types.isVncString(val)) {
                        String str = ((VncString)val).getValue();
                        for (char ch : str.toCharArray()) {
                            result.add(new VncString(String.valueOf(ch)));
                        }
                    } else if (Types.isVncList(val)) {
                        result.addAll(((VncList)val).getList());
                    } else if (Types.isVncSet(val)) {
                        result.addAll(((VncSet)val).getList());
                    } else if (Types.isVncMap(val)) {
                        result.addAll(((VncMap)val).toVncList().getList());
                    } else if (Types.isVncJavaList(val)) {
                        result.addAll(((VncJavaList)val).toVncList().getList());
                    } else if (Types.isVncJavaSet(val)) {
                        result.addAll(((VncJavaSet)val).toVncList().getList());
                    } else if (Types.isVncJavaMap(val)) {
                        result.addAll(((VncJavaMap)val).toVncList().getList());
                    } else {
                        throw new VncException(String.format("Invalid argument type %s while calling function 'concat'. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(args)));
                    }
                }
            });
            return new VncList(result);
        }
    };
    public static VncFunction interleave = new VncFunction("interleave"){
        {
            this.setArgLists("(interleave c1 c2)", "(interleave c1 c2 & colls)");
            this.setDoc("Returns a collection of the first item in each coll, then the second etc.");
            this.setExamples("(interleave [:a :b :c] [1 2])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("interleave", args, 2);
            int len = Coerce.toVncList(args.first()).size();
            ArrayList<VncList> lists = new ArrayList<VncList>();
            for (int ii = 0; ii < args.size(); ++ii) {
                VncList l = Coerce.toVncList(args.nth(ii));
                lists.add(l);
                len = Math.min(len, l.size());
            }
            VncList result = new VncList(new VncVal[0]);
            for (int nn = 0; nn < len; ++nn) {
                VncList item = new VncList(new VncVal[0]);
                for (int ii = 0; ii < lists.size(); ++ii) {
                    item.addAtEnd(((VncList)lists.get(ii)).nth(nn));
                }
                result.addAtEnd(item);
            }
            return result;
        }
    };
    public static VncFunction interpose = new VncFunction("interpose"){
        {
            this.setArgLists("(interpose sep coll)");
            this.setDoc("Returns a collection of the elements of coll separated by sep.");
            this.setExamples("(interpose \", \" [1 2 3])", "(apply str (interpose \", \" [1 2 3]))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("interpose", args, 2);
            VncVal sep = args.first();
            VncList coll = Coerce.toVncList(args.second());
            VncList result = new VncList(new VncVal[0]);
            if (!coll.isEmpty()) {
                result.addAtEnd(coll.first());
                coll.rest().forEach(v -> {
                    result.addAtEnd(sep);
                    result.addAtEnd((VncVal)v);
                });
            }
            return result;
        }
    };
    public static VncFunction first = new VncFunction("first"){
        {
            this.setArgLists("(first coll)");
            this.setDoc("Returns the first element of coll.");
            this.setExamples("(first nil)", "(first [])", "(first [1 2 3])", "(first '())", "(first '(1 2 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("first", args, 1);
            VncVal val = args.nth(0);
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).first();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).first();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'first'. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction second = new VncFunction("second"){
        {
            this.setArgLists("(second coll)");
            this.setDoc("Returns the second element of coll.");
            this.setExamples("(second nil)", "(second [])", "(second [1 2 3])", "(second '())", "(second '(1 2 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("second", args, 1);
            VncVal val = args.nth(0);
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).second();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).second();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'second'. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction nth = new VncFunction("nth"){
        {
            this.setArgLists("(nth coll idx)");
            this.setDoc("Returns the nth element of coll.");
            this.setExamples("(nth nil 1)", "(nth [1 2 3] 1)", "(nth '(1 2 3) 1)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nth", args, 2);
            int idx = Coerce.toVncLong(args.nth(1)).getValue().intValue();
            VncVal val = args.nth(0);
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).nth(idx);
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).nth(idx);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'nth'. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction last = new VncFunction("last"){
        {
            this.setArgLists("(last coll)");
            this.setDoc("Returns the last element of coll.");
            this.setExamples("(last nil)", "(last [])", "(last [1 2 3])", "(last '())", "(last '(1 2 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("last", args, 1);
            VncVal val = args.nth(0);
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).last();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).last();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'last'. %s", Types.getClassName(val), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction rest = new VncFunction("rest"){
        {
            this.setArgLists("(rest coll)");
            this.setDoc("Returns a collection with second to list element");
            this.setExamples("(rest nil)", "(rest [])", "(rest [1])", "(rest [1 2 3])", "(rest '())", "(rest '(1))", "(rest '(1 2 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rest", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            if (Types.isVncList(exp)) {
                return ((VncList)exp).rest();
            }
            return ((VncVector)exp).rest();
        }
    };
    public static VncFunction nfirst = new VncFunction("nfirst"){
        {
            this.setArgLists("(nfirst coll n)");
            this.setDoc("Returns a collection of the first n items");
            this.setExamples("(nfirst nil 2)", "(nfirst [] 2)", "(nfirst [1] 2)", "(nfirst [1 2 3] 2)", "(nfirst '() 2)", "(nfirst '(1) 2)", "(nfirst '(1 2 3) 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nfirst", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            if (Types.isVncVector(args.nth(0))) {
                VncVector vec = Coerce.toVncVector(args.nth(0));
                int n = Math.max(0, Math.min(vec.size(), Coerce.toVncLong(args.nth(1)).getValue().intValue()));
                return vec.isEmpty() ? new VncVector(new VncVal[0]) : new VncVector(vec.getList().subList(0, n));
            }
            if (Types.isVncList(args.nth(0))) {
                VncList list = Coerce.toVncList(args.nth(0));
                int n = Math.max(0, Math.min(list.size(), Coerce.toVncLong(args.nth(1)).getValue().intValue()));
                return list.isEmpty() ? new VncList(new VncVal[0]) : new VncList(list.getList().subList(0, n));
            }
            throw new VncException(String.format("nfirst: type %s not supported. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args.nth(0))));
        }
    };
    public static VncFunction nlast = new VncFunction("nlast"){
        {
            this.setArgLists("(nlast coll n)");
            this.setDoc("Returns a collection of the last n items");
            this.setExamples("(nlast nil 2)", "(nlast [] 2)", "(nlast [1] 2)", "(nlast [1 2 3] 2)", "(nlast '() 2)", "(nlast '(1) 2)", "(nlast '(1 2 3) 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nlast", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            if (Types.isVncVector(args.nth(0))) {
                VncVector vec = Coerce.toVncVector(args.nth(0));
                int n = Math.max(0, Math.min(vec.size(), Coerce.toVncLong(args.nth(1)).getValue().intValue()));
                return vec.isEmpty() ? new VncVector(new VncVal[0]) : new VncVector(vec.getList().subList(vec.size() - n, vec.size()));
            }
            if (Types.isVncList(args.nth(0))) {
                VncList list = Coerce.toVncList(args.nth(0));
                int n = Math.max(0, Math.min(list.size(), Coerce.toVncLong(args.nth(1)).getValue().intValue()));
                return list.isEmpty() ? new VncList(new VncVal[0]) : new VncList(list.getList().subList(list.size() - n, list.size()));
            }
            throw new VncException(String.format("nlast: type %s not supported. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args.nth(0))));
        }
    };
    public static VncFunction distinct = new VncFunction("distinct"){
        {
            this.setArgLists("(distinct coll)");
            this.setDoc("Returns a collection with all duplicates removed");
            this.setExamples("(distinct [1 2 3 4 2 3 4])", "(distinct '(1 2 3 4 2 3 4))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("distinct", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            VncList result = ((VncList)args.nth(0)).empty();
            result.getList().addAll(Coerce.toVncList(args.nth(0)).getList().stream().distinct().collect(Collectors.toList()));
            return result;
        }
    };
    public static VncFunction dedupe = new VncFunction("dedupe"){
        {
            this.setArgLists("(dedupe coll)");
            this.setDoc("Returns a collection with all consecutive duplicates removed");
            this.setExamples("(dedupe [1 2 2 2 3 4 4 2 3])", "(dedupe '(1 2 2 2 3 4 4 2 3))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dedupe", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            VncList result = ((VncList)args.nth(0)).empty();
            VncVal seen = null;
            for (VncVal val : Coerce.toVncList(args.nth(0)).getList()) {
                if (seen != null && val.equals(seen)) continue;
                result.addAtEnd(val);
                seen = val;
            }
            return result;
        }
    };
    public static VncFunction partition = new VncFunction("partition"){
        {
            this.setArgLists("(partition n coll)", "(partition n step coll)", "(partition n step padcoll coll)");
            this.setDoc("Returns a collection of lists of n items each, at offsets step apart. If step is not supplied, defaults to n, i.e. the partitions do not overlap. If a padcoll collection is supplied, use its elements as necessary to complete last partition upto n items. In case there are not enough padding elements, return a partition with less than n items.");
            this.setExamples("(partition 4 (range 20))", "(partition 4 6 (range 20))", "(partition 3 6 [\"a\"] (range 20))", "(partition 4 6 [\"a\" \"b\" \"c\" \"d\"] (range 20))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("partition", args, 2, 3, 4);
            int n = Coerce.toVncLong(args.nth(0)).getValue().intValue();
            int step = args.size() > 2 ? Coerce.toVncLong(args.nth(1)).getValue().intValue() : n;
            ArrayList padcoll = args.size() > 3 ? Coerce.toVncList(args.nth(2)).getList() : new ArrayList();
            List<VncVal> coll = Coerce.toVncList(args.nth(args.size() - 1)).getList();
            if (n <= 0) {
                throw new VncException(String.format("partition: n must be a positive number. %s", ErrorMessage.buildErrLocation(args.nth(0))));
            }
            if (step <= 0) {
                throw new VncException(String.format("partition: step must be a positive number. %s", ErrorMessage.buildErrLocation(args.nth(0))));
            }
            ArrayList<List<VncVal>> splits = new ArrayList<List<VncVal>>();
            for (int ii = 0; ii < coll.size(); ii += step) {
                splits.add(coll.subList(ii, Math.min(ii + step, coll.size())));
            }
            VncList result = new VncList(new VncVal[0]);
            for (List list : splits) {
                if (n == list.size()) {
                    result.addList(new VncList(list));
                    continue;
                }
                if (n < list.size()) {
                    result.addList(new VncList(list.subList(0, n)));
                    continue;
                }
                ArrayList<VncVal> split_ = new ArrayList<VncVal>(list);
                for (int ii = 0; ii < n - list.size() && ii < padcoll.size(); ++ii) {
                    split_.add((VncVal)padcoll.get(ii));
                }
                result.addList(new VncList(split_));
            }
            return result;
        }
    };
    public static VncFunction coalesce = new VncFunction("coalesce"){
        {
            this.setArgLists("(coalesce args*)");
            this.setDoc("Returns the first non nil arg");
            this.setExamples("(coalesce )", "(coalesce 1 2)", "(coalesce nil)", "(coalesce nil 1 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            return args.stream().filter(v -> v != Constants.Nil).findFirst().orElse(Constants.Nil);
        }
    };
    public static VncFunction emptyToNil = new VncFunction("empty-to-nil"){
        {
            this.setArgLists("(empty-to-nil x)");
            this.setDoc("Returns nil if x is empty");
            this.setExamples("(empty-to-nil \"\")", "(empty-to-nil [])", "(empty-to-nil '())", "(empty-to-nil {})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("empty-to-nil", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncString(arg)) {
                return ((VncString)arg).getValue().isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncVector(arg)) {
                return ((VncVector)arg).isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncList(arg)) {
                return ((VncList)arg).isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncMap(arg)) {
                return ((VncMap)arg).isEmpty() ? Constants.Nil : arg;
            }
            return arg;
        }
    };
    public static VncFunction className = new VncFunction("class"){
        {
            this.setArgLists("(class x)");
            this.setDoc("Returns the class of x");
            this.setExamples("(. :java.lang.Long :class)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("class", args, 1);
            return Types.getClassName(args.nth(0));
        }
    };
    public static VncFunction pop = new VncFunction("pop"){
        {
            this.setArgLists("(pop coll)");
            this.setDoc("For a list, returns a new list without the first item, for a vector, returns a new vector without the last item.");
            this.setExamples("(pop '(1 2 3 4))", "(pop [1 2 3 4])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("pop", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return new VncList(new VncVal[0]);
            }
            VncList ml = Coerce.toVncList(exp);
            if (Types.isVncVector(ml)) {
                return ml.size() < 2 ? new VncVector(new VncVal[0]) : ((VncVector)ml).slice(0, ml.size() - 1);
            }
            return ml.isEmpty() ? new VncList(new VncVal[0]) : ml.slice(1);
        }
    };
    public static VncFunction peek = new VncFunction("peek"){
        {
            this.setArgLists("(peek coll)");
            this.setDoc("For a list, same as first, for a vector, same as last");
            this.setExamples("(peek '(1 2 3 4))", "(peek [1 2 3 4])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("peek", args, 1);
            VncVal exp = args.nth(0);
            if (exp == Constants.Nil) {
                return Constants.Nil;
            }
            VncList ml = Coerce.toVncList(exp);
            if (Types.isVncVector(ml)) {
                return ml.isEmpty() ? Constants.Nil : ((VncVector)ml).nth(ml.size() - 1);
            }
            return ml.isEmpty() ? Constants.Nil : ml.nth(0);
        }
    };
    public static VncFunction take_while = new VncFunction("take-while"){
        {
            this.setArgLists("(take-while predicate coll)");
            this.setDoc("Returns a list of successive items from coll while (predicate item) returns logical true.");
            this.setExamples("(take-while neg? [-2 -1 0 1 2 3])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("take-while", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            for (int i = 0; i < coll.size(); ++i) {
                VncVal take = (VncVal)predicate.apply(new VncList(coll.nth(i)));
                if (take != Constants.False) continue;
                return coll.slice(0, i);
            }
            return coll;
        }
    };
    public static VncFunction take = new VncFunction("take"){
        {
            this.setArgLists("(take n coll)");
            this.setDoc("Returns a collection of the first n items in coll, or all items if there are fewer than n.");
            this.setExamples("(take 3 [1 2 3 4 5])", "(take 10 [1 2 3 4 5])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("take", args, 2);
            VncLong n = Coerce.toVncLong(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            return coll.slice(0, (int)Math.min(n.getValue(), (long)coll.size()));
        }
    };
    public static VncFunction drop_while = new VncFunction("drop-while"){
        {
            this.setArgLists("(drop-while predicate coll)");
            this.setDoc("Returns a list of the items in coll starting from the first item for which (predicate item) returns logical false.");
            this.setExamples("(drop-while neg? [-2 -1 0 1 2 3])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("drop-while", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            for (int i = 0; i < coll.size(); ++i) {
                VncVal take = (VncVal)predicate.apply(new VncList(coll.nth(i)));
                if (take != Constants.False) continue;
                return coll.slice(i);
            }
            return coll.empty();
        }
    };
    public static VncFunction drop = new VncFunction("drop"){
        {
            this.setArgLists("(drop n coll)");
            this.setDoc("Returns a collection of all but the first n items in coll");
            this.setExamples("(drop 3 [1 2 3 4 5])", "(drop 10 [1 2 3 4 5])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("drop", args, 2);
            VncLong n = Coerce.toVncLong(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            return coll.slice((int)Math.min(n.getValue() + 1L, (long)coll.size()));
        }
    };
    public static VncFunction flatten = new VncFunction("flatten"){
        {
            this.setArgLists("(flatten coll)");
            this.setDoc("Takes any nested combination of collections (lists, vectors, etc.) and returns their contents as a single, flat sequence. (flatten nil) returns an empty list.");
            this.setExamples("(flatten [])", "(flatten [[1 2 3] [4 5 6] [7 8 9]])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("flatten", args, 1);
            VncList coll = Coerce.toVncList(args.nth(0));
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            CoreFunctions.flatten(coll, result);
            return Types.isVncVector(coll) ? new VncVector(result) : new VncList(result);
        }
    };
    public static VncFunction reverse = new VncFunction("reverse"){
        {
            this.setArgLists("(reverse coll)");
            this.setDoc("Returns a collection of the items in coll in reverse order");
            this.setExamples("(reverse [1 2 3 4 5 6])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reverse", args, 1);
            VncList coll = Coerce.toVncList(args.nth(0));
            VncList result = coll.empty();
            for (int ii = coll.size() - 1; ii >= 0; --ii) {
                result.addAtEnd(coll.nth(ii));
            }
            return result;
        }
    };
    public static VncFunction sort = new VncFunction("sort"){
        {
            this.setArgLists("(sort coll)", "(sort compfn coll)");
            this.setDoc("Returns a sorted list of the items in coll. If no compare function compfn is supplied, uses the natural compare. The compare function takes two arguments and returns -1, 0, or 1");
            this.setExamples("(sort [3 2 5 4 1 6])", "(sort {:c 3 :a 1 :b 2})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sort", args, 1, 2);
            if (args.size() == 1) {
                VncVal coll = args.nth(0);
                if (Types.isVncVector(coll)) {
                    return new VncVector(((VncVector)coll).getList().stream().sorted().collect(Collectors.toList()));
                }
                if (Types.isVncList(coll)) {
                    return new VncList(((VncList)coll).getList().stream().sorted().collect(Collectors.toList()));
                }
                if (Types.isVncSet(coll)) {
                    return new VncList(((VncSet)coll).getList().stream().sorted().collect(Collectors.toList()));
                }
                if (Types.isVncMap(coll)) {
                    return new VncList(((VncMap)coll).toVncList().getList().stream().sorted().collect(Collectors.toList()));
                }
                throw new VncException(String.format("sort: collection type not supported. %s", ErrorMessage.buildErrLocation(args)));
            }
            if (args.size() == 2) {
                VncFunction compfn = Coerce.toVncFunction(args.nth(0));
                VncVal coll = args.nth(1);
                if (Types.isVncVector(coll)) {
                    return new VncVector(((VncVector)coll).getList().stream().sorted((x, y) -> ((VncLong)compfn.apply(new VncList((VncVal)x, (VncVal)y))).getValue().intValue()).collect(Collectors.toList()));
                }
                if (Types.isVncList(coll)) {
                    return new VncList(((VncList)coll).getList().stream().sorted((x, y) -> ((VncLong)compfn.apply(new VncList((VncVal)x, (VncVal)y))).getValue().intValue()).collect(Collectors.toList()));
                }
                if (Types.isVncSet(coll)) {
                    return new VncList(((VncSet)coll).getList().stream().sorted((x, y) -> ((VncLong)compfn.apply(new VncList((VncVal)x, (VncVal)y))).getValue().intValue()).collect(Collectors.toList()));
                }
                if (Types.isVncMap(coll)) {
                    return new VncList(((VncMap)coll).toVncList().getList().stream().sorted((x, y) -> ((VncLong)compfn.apply(new VncList((VncVal)x, (VncVal)y))).getValue().intValue()).collect(Collectors.toList()));
                }
                throw new VncException(String.format("sort: collection type not supported. %s", ErrorMessage.buildErrLocation(args)));
            }
            throw new VncException(String.format("sort: args not supported. %s", ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction sort_by = new VncFunction("sort-by"){
        {
            this.setArgLists("(sort-by keyfn coll)", "(sort-by keyfn compfn coll)");
            this.setDoc("Returns a sorted sequence of the items in coll, where the sort order is determined by comparing (keyfn item).  If no comparator is supplied, uses compare.");
            this.setExamples("(sort-by count [\"aaa\" \"bb\" \"c\"])", "(sort-by first [[1 2] [3 4] [2 3]])", "(sort-by (fn [x] (get x :rank)) [{:rank 2} {:rank 3} {:rank 1}])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sort-by", args, 2, 3);
            if (args.size() == 2) {
                VncFunction keyfn = Coerce.toVncFunction(args.nth(0));
                VncVal coll = args.nth(1);
                if (Types.isVncVector(coll)) {
                    return new VncVector(((VncVector)coll).getList().stream().sorted((x, y) -> ((VncVal)keyfn.apply(new VncList((VncVal)x))).compareTo((VncVal)keyfn.apply(new VncList((VncVal)y)))).collect(Collectors.toList()));
                }
                if (Types.isVncList(coll)) {
                    return new VncList(((VncList)coll).getList().stream().sorted((x, y) -> ((VncVal)keyfn.apply(new VncList((VncVal)x))).compareTo((VncVal)keyfn.apply(new VncList((VncVal)y)))).collect(Collectors.toList()));
                }
                if (Types.isVncMap(coll)) {
                    return new VncList(((VncMap)coll).toVncList().getList().stream().sorted((x, y) -> ((VncVal)keyfn.apply(new VncList((VncVal)x))).compareTo((VncVal)keyfn.apply(new VncList((VncVal)y)))).collect(Collectors.toList()));
                }
                throw new VncException(String.format("sort-by: collection type not supported. %s", ErrorMessage.buildErrLocation(args)));
            }
            if (args.size() == 3) {
                VncFunction keyfn = Coerce.toVncFunction(args.nth(0));
                VncFunction compfn = Coerce.toVncFunction(args.nth(1));
                VncVal coll = args.nth(2);
                if (Types.isVncVector(coll)) {
                    return new VncVector(((VncVector)coll).getList().stream().sorted((x, y) -> Coerce.toVncLong((VncVal)compfn.apply(new VncList((VncVal)keyfn.apply(new VncList((VncVal)x)), (VncVal)keyfn.apply(new VncList((VncVal)y))))).getValue().intValue()).collect(Collectors.toList()));
                }
                if (Types.isVncList(coll)) {
                    return new VncList(((VncList)coll).getList().stream().sorted((x, y) -> Coerce.toVncLong((VncVal)compfn.apply(new VncList((VncVal)keyfn.apply(new VncList((VncVal)x)), (VncVal)keyfn.apply(new VncList((VncVal)y))))).getValue().intValue()).collect(Collectors.toList()));
                }
                if (Types.isVncMap(coll)) {
                    return new VncList(((VncMap)coll).toVncList().getList().stream().sorted((x, y) -> Coerce.toVncLong((VncVal)compfn.apply(new VncList((VncVal)keyfn.apply(new VncList((VncVal)x)), (VncVal)keyfn.apply(new VncList((VncVal)y))))).getValue().intValue()).collect(Collectors.toList()));
                }
                throw new VncException(String.format("sort-by: collection type not supported. %s", ErrorMessage.buildErrLocation(args)));
            }
            throw new VncException(String.format("sort-by: args not supported. %s", ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction group_by = new VncFunction("group-by"){
        {
            this.setArgLists("(group-by f coll)");
            this.setDoc("Returns a map of the elements of coll keyed by the result of f on each element. The value at each key will be a vector of the corresponding elements, in the order they appeared in coll.");
            this.setExamples("(group-by count [\"a\" \"as\" \"asd\" \"aa\" \"asdf\" \"qwer\"])", "(group-by odd? (range 10))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("group-by", args, 2);
            VncFunction fn = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            VncOrderedMap map = new VncOrderedMap(new VncVal[0]);
            coll.getList().stream().forEach(v -> {
                VncVal key = (VncVal)fn.apply(new VncList((VncVal)v));
                VncList val = Coerce.toVncList(map.getMap().get(key));
                if (val == null) {
                    map.getMap().put(key, new VncVector((VncVal)v));
                } else {
                    map.getMap().put(key, val.addAtEnd((VncVal)v));
                }
            });
            return map;
        }
    };
    public static VncFunction apply = new VncFunction("apply"){
        {
            this.setArgLists("(apply f args* coll)");
            this.setDoc("Applies f to all arguments composed of args and coll");
            this.setExamples("(apply str [1 2 3 4 5])");
        }

        @Override
        public VncVal apply(VncList args) {
            VncFunction fn = Coerce.toVncFunction(args.nth(0));
            VncList fn_args = args.slice(1, args.size() - 1);
            VncVal coll = args.last();
            if (coll == Constants.Nil) {
                fn_args.getList().add(Constants.Nil);
            } else {
                List<VncVal> tailArgs = Coerce.toVncList(args.last()).getList();
                fn_args.getList().addAll(tailArgs);
            }
            return (VncVal)fn.apply(fn_args);
        }
    };
    public static VncFunction comp = new VncFunction("comp"){
        {
            this.setArgLists("(comp f*)");
            this.setDoc("Takes a set of functions and returns a fn that is the composition of those fns. The returned fn takes a variable number of args, applies the rightmost of fns to the args, the next fn (right-to-left) to the result, etc. ");
            this.setExamples("(filter (comp not zero?) [0 1 0 2 0 3 0 4])", "(do \n   (def fifth (comp first rest rest rest rest)) \n   (fifth [1 2 3 4 5]))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("comp", args, 1);
            final List fns = args.getList().stream().map(v -> Coerce.toVncFunction(v)).collect(Collectors.toList());
            return new VncFunction(){

                @Override
                public VncVal apply(VncList args) {
                    VncList args_ = args;
                    VncVal result = Constants.Nil;
                    for (int ii = fns.size() - 1; ii >= 0; --ii) {
                        VncFunction fn = (VncFunction)fns.get(ii);
                        result = (VncVal)fn.apply(args_);
                        args_ = new VncList(result);
                    }
                    return result;
                }
            };
        }
    };
    public static VncFunction partial = new VncFunction("partial"){
        {
            this.setArgLists("(partial f args*)");
            this.setDoc("Takes a function f and fewer than the normal arguments to f, and returns a fn that takes a variable number of additional args. When called, the returned function calls f with args + additional args.");
            this.setExamples("(do \n   (def hundred-times (partial * 100)) \n   (hundred-times 5))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("partial", args, 2);
            final VncFunction fn = Coerce.toVncFunction(args.first());
            final VncList fnArgs = args.slice(1);
            return new VncFunction(){

                @Override
                public VncVal apply(VncList args) {
                    return (VncVal)fn.apply(fnArgs.addAtEnd(args));
                }
            };
        }
    };
    public static VncFunction map = new VncFunction("map"){
        {
            this.setArgLists("(map f coll colls*)");
            this.setDoc("Applys f to the set of first items of each coll, followed by applying f to the set of second items in each coll, until any one of the colls is exhausted.  Any remaining items in other colls are ignored. ");
            this.setExamples("(map inc [1 2 3 4])");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() < 2) {
                return Constants.Nil;
            }
            VncFunction fn = Coerce.toVncFunction(args.nth(0));
            VncList lists = FunctionsUtil.removeNilValues(args.slice(1));
            VncList result = new VncList(new VncVal[0]);
            if (lists.isEmpty()) {
                return Constants.Nil;
            }
            int index = 0;
            boolean hasMore = true;
            while (hasMore) {
                VncList fnArgs = new VncList(new VncVal[0]);
                for (int ii = 0; ii < lists.size(); ++ii) {
                    VncList nthList = Coerce.toVncList(lists.nth(ii));
                    if (nthList.size() <= index) {
                        hasMore = false;
                        break;
                    }
                    fnArgs.addAtEnd(nthList.nth(index));
                }
                if (!hasMore) continue;
                result.getList().add((VncVal)fn.apply(fnArgs));
                ++index;
            }
            return result;
        }
    };
    public static VncFunction mapv = new VncFunction("mapv"){
        {
            this.setArgLists("(mapv f coll colls*)");
            this.setDoc("Returns a vector consisting of the result of applying f to the set of first items of each coll, followed by applying f to the set of second items in each coll, until any one of the colls is exhausted.  Any remaining items in other colls are ignored. ");
            this.setExamples("(mapv inc [1 2 3 4])");
        }

        @Override
        public VncVal apply(VncList args) {
            VncFunction fn = Coerce.toVncFunction(args.nth(0));
            VncList lists = FunctionsUtil.removeNilValues(args.slice(1));
            VncVector result = new VncVector(new VncVal[0]);
            if (lists.isEmpty()) {
                return Constants.Nil;
            }
            int index = 0;
            boolean hasMore = true;
            while (hasMore) {
                VncList fnArgs = new VncList(new VncVal[0]);
                for (int ii = 0; ii < lists.size(); ++ii) {
                    VncList nthList = Coerce.toVncList(lists.nth(ii));
                    if (nthList.size() <= index) {
                        hasMore = false;
                        break;
                    }
                    fnArgs.addAtEnd(nthList.nth(index));
                }
                if (!hasMore) continue;
                result.getList().add((VncVal)fn.apply(fnArgs));
                ++index;
            }
            return result;
        }
    };
    public static VncFunction keep = new VncFunction("keep"){
        {
            this.setArgLists("(keep f coll)");
            this.setDoc("Returns a sequence of the non-nil results of (f item). Note, this means false return values will be included. f must be free of side-effects.");
            this.setExamples("(keep even? (range 1 4))", "(keep (fn [x] (if (odd? x) x)) (range 4))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keep", args, 2);
            VncVal result = (VncVal)map.apply(args);
            return result == Constants.Nil ? Constants.Nil : FunctionsUtil.removeNilValues(Coerce.toVncList(result));
        }
    };
    public static VncFunction docoll = new VncFunction("docoll"){
        {
            this.setArgLists("(docoll f coll)");
            this.setDoc("Applies f to the items of the collection presumably for side effects. Returns nil. ");
            this.setExamples("(docoll \n   (fn [x] (println x)) \n   [1 2 3 4])", "(docoll \n    (fn [[k v]] (println (pr-str k v)))  \n    {:a 1 :b 2 :c 3 :d 4})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("docoll", args, 2);
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncVal coll = args.second();
            if (coll != Constants.Nil) {
                if (Types.isVncList(coll)) {
                    ((VncList)coll).forEach(v -> {
                        VncVal cfr_ignored_0 = (VncVal)fn.apply(new VncList((VncVal)v));
                    });
                } else if (Types.isVncJavaList(coll)) {
                    ((VncJavaList)coll).forEach(v -> {
                        VncVal cfr_ignored_0 = (VncVal)fn.apply(new VncList((VncVal)v));
                    });
                } else if (Types.isVncMap(coll)) {
                    ((VncMap)coll).entries().forEach(v -> {
                        VncVal cfr_ignored_0 = (VncVal)fn.apply(new VncList(new VncVector((VncVal)v.getKey(), (VncVal)v.getValue())));
                    });
                } else {
                    throw new VncException(String.format("docoll: collection type %s not supported. %s", Types.getClassName(coll), ErrorMessage.buildErrLocation(args)));
                }
            }
            return Constants.Nil;
        }
    };
    public static VncFunction mapcat = new VncFunction("mapcat"){
        {
            this.setArgLists("(mapcat fn & colls)");
            this.setDoc("Returns the result of applying concat to the result of applying map to fn and colls. Thus function fn should return a collection.");
            this.setExamples("(mapcat reverse [[3 2 1 0] [6 5 4] [9 8 7]])");
        }

        @Override
        public VncVal apply(VncList args) {
            return (VncVal)concat.apply(Coerce.toVncList((VncVal)map.apply(args)));
        }
    };
    public static VncFunction filter = new VncFunction("filter"){
        {
            this.setArgLists("(filter predicate coll)");
            this.setDoc("Returns a collection of the items in coll for which (predicate item) returns logical true. ");
            this.setExamples("(filter even? [1 2 3 4 5 6 7])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("filter", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            VncList result = coll.empty();
            for (int i = 0; i < coll.size(); ++i) {
                VncVal val = coll.nth(i);
                VncVal keep = (VncVal)predicate.apply(new VncList(val));
                if (keep == Constants.False || keep == Constants.Nil) continue;
                result.getList().add(val);
            }
            return result;
        }
    };
    public static VncFunction remove = new VncFunction("remove"){
        {
            this.setArgLists("(remove predicate coll)");
            this.setDoc("Returns a collection of the items in coll for which (predicate item) returns logical false. ");
            this.setExamples("(filter even? [1 2 3 4 5 6 7])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("remove", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.nth(0));
            VncList coll = Coerce.toVncList(args.nth(1));
            VncList result = coll.empty();
            for (int i = 0; i < coll.size(); ++i) {
                VncVal val = coll.nth(i);
                VncVal keep = (VncVal)predicate.apply(new VncList(val));
                if (keep != Constants.False) continue;
                result.getList().add(val);
            }
            return result;
        }
    };
    public static VncFunction reduce = new VncFunction("reduce"){
        {
            this.setArgLists("(reduce f coll)", "(reduce f val coll)");
            this.setDoc("f should be a function of 2 arguments. If val is not supplied, returns the result of applying f to the first 2 items in coll, then applying f to that result and the 3rd item, etc. If coll contains no items, f must accept no arguments as well, and reduce returns the result of calling f with no arguments.  If coll has only 1 item, it is returned and f is not called.  If val is supplied, returns the result of applying f to val and the first item in coll, then applying f to that result and the 2nd item, etc. If coll contains no items, returns val and f is not called.");
            this.setExamples("(reduce (fn [x y] (+ x y)) [1 2 3 4 5 6 7])", "(reduce (fn [x y] (+ x y)) 10 [1 2 3 4 5 6 7])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reduce", args, 2, 3);
            boolean twoArguments = args.size() < 3;
            VncFunction reduceFn = Coerce.toVncFunction(args.nth(0));
            if (twoArguments) {
                List<VncVal> coll = Coerce.toVncList(args.nth(1)).getList();
                if (coll.isEmpty()) {
                    return (VncVal)reduceFn.apply(new VncList(new VncVal[0]));
                }
                VncVal value = coll.get(0);
                for (int ii = 1; ii < coll.size(); ++ii) {
                    value = (VncVal)reduceFn.apply(new VncList(value, coll.get(ii)));
                }
                return value;
            }
            List<VncVal> coll = Coerce.toVncList(args.nth(2)).getList();
            if (coll.isEmpty()) {
                return args.nth(1);
            }
            if (coll.size() == 1) {
                return (VncVal)reduceFn.apply(new VncList(args.nth(1), coll.get(0)));
            }
            VncVal value = args.nth(1);
            for (int ii = 0; ii < coll.size(); ++ii) {
                value = (VncVal)reduceFn.apply(new VncList(value, coll.get(ii)));
            }
            return value;
        }
    };
    public static VncFunction reduce_kv = new VncFunction("reduce-kv"){
        {
            this.setArgLists("(reduce-kv f init coll))");
            this.setDoc("Reduces an associative collection. f should be a function of 3 arguments. Returns the result of applying f to init, the first key and the first value in coll, then applying f to that result and the 2nd key and value, etc. If coll contains no entries, returns init and f is not called. Note that reduce-kv is supported on vectors, where the keys will be the ordinals.");
            this.setExamples("(reduce-kv (fn [x y z] (assoc x z y)) {} {:a 1 :b 2 :c 3})");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reduce-kv", args, 3);
            VncFunction reduceFn = Coerce.toVncFunction(args.nth(0));
            Set<Map.Entry<VncVal, VncVal>> values = Coerce.toVncHashMap(args.nth(2)).entries();
            VncMap value = (VncMap)args.nth(1);
            if (values.isEmpty()) {
                return value;
            }
            for (Map.Entry<VncVal, VncVal> entry : values) {
                VncVal key = entry.getKey();
                VncVal val = entry.getValue();
                value = Coerce.toVncMap((VncVal)reduceFn.apply(new VncList(value, key, val)));
            }
            return value;
        }
    };
    public static VncFunction merge = new VncFunction("merge"){
        {
            this.setArgLists("(merge & maps)");
            this.setDoc("Returns a map that consists of the rest of the maps conj-ed onto the first.  If a key occurs in more than one map, the mapping from the latter (left-to-right) will be the mapping in the result.");
            this.setExamples("(merge {:a 1 :b 2 :c 3} {:b 9 :d 4})", "(merge {:a 1} nil)", "(merge nil {:a 1})", "(merge nil nil)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("merge", args, 1);
            List maps = args.stream().filter(v -> v != Constants.Nil).collect(Collectors.toList());
            if (maps.isEmpty()) {
                return Constants.Nil;
            }
            HashMap<VncVal, VncVal> map = new HashMap<VncVal, VncVal>();
            maps.stream().forEach(v -> map.putAll(Coerce.toVncMap(v).getMap()));
            return new VncHashMap(map);
        }
    };
    public static VncFunction conj = new VncFunction("conj"){
        {
            this.setArgLists("(conj coll x)", "(conj coll x & xs)");
            this.setDoc("Returns a new collection with the x, xs 'added'. (conj nil item) returns (item).  The 'addition' may happen at different 'places' depending on the concrete type.");
            this.setExamples("(conj [1 2 3] 4)", "(conj '(1 2 3) 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.nth(0) instanceof VncVector) {
                VncVector new_seq = new VncVector(new VncVal[0]);
                VncList src_seq = (VncList)args.nth(0);
                new_seq.getList().addAll(src_seq.getList());
                for (int i = 1; i < args.size(); ++i) {
                    new_seq.addAtEnd(args.nth(i));
                }
                return new_seq;
            }
            if (args.nth(0) instanceof VncList) {
                VncList new_seq = new VncList(new VncVal[0]);
                VncList src_seq = (VncList)args.nth(0);
                new_seq.getList().addAll(src_seq.getList());
                for (int i = 1; i < args.size(); ++i) {
                    new_seq.addAtStart(args.nth(i));
                }
                return new_seq;
            }
            if (args.nth(0) instanceof VncMap) {
                VncMap src_map = (VncMap)args.nth(0);
                VncMap new_map = src_map.copy();
                if (Types.isVncVector(args.nth(1)) && ((VncVector)args.nth(1)).size() == 2) {
                    return new_map.assoc(new VncList(((VncVector)args.nth(1)).nth(0), ((VncVector)args.nth(1)).nth(1)));
                }
                if (Types.isVncMap(args.nth(1))) {
                    new_map.getMap().putAll(((VncMap)args.nth(1)).getMap());
                    return new_map;
                }
                throw new VncException(String.format("Invalid x %s while calling function 'conj'. %s", Types.getClassName(args.nth(1)), ErrorMessage.buildErrLocation(args)));
            }
            throw new VncException(String.format("Invalid coll %s while calling function 'conj'. %s", Types.getClassName(args.nth(0)), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction seq = new VncFunction("seq"){
        {
            this.setArgLists("(seq coll)");
            this.setDoc("Returns a seq on the collection. If the collection is empty, returns nil.  (seq nil) returns nil. seq also works on Strings.");
            this.setExamples("(seq nil)", "(seq [1 2 3])", "(seq '(1 2 3))", "(seq {:a 1 :b 2})", "(seq \"abcd\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("seq", args, 1);
            VncVal val = args.nth(0);
            if (Types.isVncMap(val)) {
                if (((VncMap)val).isEmpty()) {
                    return Constants.Nil;
                }
                return new VncList(((VncMap)val).entries().stream().map(e -> new VncVector((VncVal)e.getKey(), (VncVal)e.getValue())).collect(Collectors.toList()));
            }
            if (Types.isVncVector(val)) {
                if (((VncVector)val).isEmpty()) {
                    return Constants.Nil;
                }
                return new VncList(((VncVector)val).getList());
            }
            if (Types.isVncList(val)) {
                if (((VncList)val).isEmpty()) {
                    return Constants.Nil;
                }
                return val;
            }
            if (Types.isVncString(val)) {
                String s = ((VncString)val).getValue();
                if (s.length() == 0) {
                    return Constants.Nil;
                }
                ArrayList<VncVal> lst = new ArrayList<VncVal>();
                for (char c : s.toCharArray()) {
                    lst.add(new VncString(String.valueOf(c)));
                }
                return new VncList(lst);
            }
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            throw new VncException(String.format("seq: called on non-sequence. %s", ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction range = new VncFunction("range"){
        {
            this.setArgLists("(range end)", "(range start end)", "(range start end step)");
            this.setDoc("Returns a collection of numbers from start (inclusive) to end (exclusive), by step, where start defaults to 0 and step defaults to 1. When start is equal to end, returns empty list.");
            this.setExamples("(range 10)", "(range 10 20)", "(range 10 20 3)", "(range 10 15 0.5)", "(range 1.1M 2.2M 0.1M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("range", args, 1, 2, 3);
            VncVal start = new VncLong(0);
            VncVal end = new VncLong(0);
            VncVal step = new VncLong(1);
            switch (args.size()) {
                case 1: {
                    end = args.nth(0);
                    break;
                }
                case 2: {
                    start = args.nth(0);
                    end = args.nth(1);
                    break;
                }
                case 3: {
                    start = args.nth(0);
                    end = args.nth(1);
                    step = args.nth(2);
                }
            }
            if (!Types.isVncNumber(start)) {
                throw new VncException(String.format("range: start value must be a number. %s", ErrorMessage.buildErrLocation(args)));
            }
            if (!Types.isVncNumber(end)) {
                throw new VncException(String.format("range: end value must be a number. %s", ErrorMessage.buildErrLocation(args)));
            }
            if (!Types.isVncNumber(step)) {
                throw new VncException(String.format("range: step value must be a number. %s", ErrorMessage.buildErrLocation(args)));
            }
            ArrayList<VncVal> values = new ArrayList<VncVal>();
            if (zero_Q.apply(new VncList(step)) == Constants.True) {
                throw new VncException(String.format("range: a step value must not be 0. %s", ErrorMessage.buildErrLocation(args)));
            }
            if (pos_Q.apply(new VncList(step)) == Constants.True) {
                if (lt.apply(new VncList(end, start)) == Constants.True) {
                    throw new VncException(String.format("range positive step: end must not be lower than start. %s", ErrorMessage.buildErrLocation(args)));
                }
                VncVal val = start;
                while (lt.apply(new VncList(val, end)) == Constants.True) {
                    values.add(val);
                    val = (VncVal)add.apply(new VncList(val, step));
                }
            } else {
                if (gt.apply(new VncList(end, start)) == Constants.True) {
                    throw new VncException(String.format("range negative step: end must not be greater than start. %s", ErrorMessage.buildErrLocation(args)));
                }
                VncVal val = start;
                while (gt.apply(new VncList(val, end)) == Constants.True) {
                    values.add(val);
                    val = (VncVal)add.apply(new VncList(val, step));
                }
            }
            return new VncList(values);
        }
    };
    public static VncFunction repeat = new VncFunction("repeat"){
        {
            this.setArgLists("(repeat n x)");
            this.setDoc("Returns a collection with the value x repeated n times");
            this.setExamples("(repeat 5 [1 2])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("repeat", args, 2);
            if (!Types.isVncLong(args.nth(0))) {
                throw new VncException("repeat: the count must be a long");
            }
            long repeat = ((VncLong)args.nth(0)).getValue();
            if (repeat < 0L) {
                throw new VncException(String.format("repeat: a count n must be grater or equal to 0. %s", ErrorMessage.buildErrLocation(args)));
            }
            VncVal val = args.nth(1);
            ArrayList<VncVal> values = new ArrayList<VncVal>();
            int ii = 0;
            while ((long)ii < repeat) {
                values.add(val.copy());
                ++ii;
            }
            return new VncList(values);
        }
    };
    public static VncFunction meta = new VncFunction("meta"){
        {
            this.setArgLists("(meta obj)");
            this.setDoc("Returns the metadata of obj, returns nil if there is no metadata.");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("meta", args, 1);
            return args.nth(0).getMeta();
        }
    };
    public static VncFunction with_meta = new VncFunction("with-meta"){
        {
            this.setArgLists("(with-meta obj m)");
            this.setDoc("Returns a copy of the object obj, with a map m as its metadata.");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("meta", args, 2);
            if (!Types.isVncMap(args.nth(1))) {
                throw new VncException(String.format("with-meta: the meta data for the object must be a map. %s", ErrorMessage.buildErrLocation(args)));
            }
            VncVal new_obj = args.nth(0).copy();
            new_obj.setMeta(args.nth(1));
            return new_obj;
        }
    };
    public static VncFunction vary_meta = new VncFunction("vary-meta"){
        {
            this.setArgLists("(vary-meta obj f & args)");
            this.setDoc("Returns a copy of the object obj, with (apply f (meta obj) args) as its metadata.");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("vary-meta", args, 2);
            if (!Types.isVncFunction(args.nth(1))) {
                throw new VncException(String.format("var-meta requires a function as second argument. %s", ErrorMessage.buildErrLocation(args)));
            }
            VncVal meta = args.nth(0).getMeta();
            VncFunction fn = (VncFunction)args.nth(1);
            VncList fnArgs = args.slice(2);
            fnArgs.addAtStart(meta == Constants.Nil ? new VncHashMap(new VncVal[0]) : meta);
            VncVal new_obj = args.nth(0).copy();
            new_obj.setMeta((VncVal)fn.apply(fnArgs));
            return new_obj;
        }
    };
    public static VncFunction new_atom = new VncFunction("atom"){
        {
            this.setArgLists("(atom x)");
            this.setDoc("Creates an atom with the initial value x");
            this.setExamples("(do\n   (def counter (atom 0))\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("atom", args, 1);
            return new VncAtom(args.nth(0));
        }
    };
    public static VncFunction atom_Q = new VncFunction("atom?"){
        {
            this.setArgLists("(atom? x)");
            this.setDoc("Returns true if x is an atom, otherwise false");
            this.setExamples("(do\n   (def counter (atom 0))\n   (atom? counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("atom?", args, 1);
            return Types.isVncAtom(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction deref = new VncFunction("deref"){
        {
            this.setArgLists("(deref atom)");
            this.setDoc("Dereferences an atom, returns its value");
            this.setExamples("(do\n   (def counter (atom 0))\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("deref", args, 1);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            return atm.deref();
        }
    };
    public static VncFunction reset_BANG = new VncFunction("reset!"){
        {
            this.setArgLists("(reset! atom newval)");
            this.setDoc("Sets the value of atom to newval without regard for the current value. Returns newval.");
            this.setExamples("(do\n   (def counter (atom 0))\n   (reset! counter 99)\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reset!", args, 2);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            return atm.reset(args.nth(1));
        }
    };
    public static VncFunction swap_BANG = new VncFunction("swap!"){
        {
            this.setArgLists("(swap! atom f & args)");
            this.setDoc("Atomically swaps the value of atom to be: (apply f current-value-of-atom args). Note that f may be called multiple times, and thus should be free of side effects.  Returns the value that was swapped in.");
            this.setExamples("(do\n   (def counter (atom 0))\n   (swap! counter inc)\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("swap!", args, 2);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            VncFunction fn = Coerce.toVncFunction(args.nth(1));
            VncList swapArgs = args.slice(2);
            return atm.swap(fn, swapArgs);
        }
    };
    public static VncFunction compare_and_set_BANG = new VncFunction("compare-and-set!"){
        {
            this.setArgLists("(compare-and-set! atom oldval newval)");
            this.setDoc("Atomically sets the value of atom to newval if and only if the current value of the atom is identical to oldval. Returns true if set happened, else false");
            this.setExamples("(do\n   (def counter (atom 2))\n   (compare-and-set! counter 2 4)\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("compare-and-set!", args, 3);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            return atm.compare_and_set(args.nth(1), args.nth(2));
        }
    };
    public static VncFunction str_blank = new VncFunction("str/blank?"){
        {
            this.setArgLists("(str/blank? s)");
            this.setDoc("True if s is blank.");
            this.setExamples("(str/blank? nil)", "(str/blank? \"\")", "(str/blank? \"  \")", "(str/blank? \"abc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/blank?", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.True;
            }
            String s = Coerce.toVncString(args.nth(0)).getValue();
            return StringUtil.isBlank(s) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction str_starts_with = new VncFunction("str/starts-with?"){
        {
            this.setArgLists("(str/starts-with? s substr)");
            this.setDoc("True if s starts with substr.");
            this.setExamples("(str/starts-with? \"abc\"  \"ab\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/starts-with?", args, 2);
            if (args.nth(0) == Constants.Nil || args.nth(1) == Constants.Nil) {
                return Constants.False;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            VncString prefix = Coerce.toVncString(args.nth(1));
            return string.getValue().startsWith(prefix.getValue()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction str_ends_with = new VncFunction("str/ends-with?"){
        {
            this.setArgLists("(str/ends-with? s substr)");
            this.setDoc("True if s ends with substr.");
            this.setExamples("(str/starts-with? \"abc\"  \"bc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/ends-with?", args, 2);
            if (args.nth(0) == Constants.Nil || args.nth(1) == Constants.Nil) {
                return Constants.False;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            VncString suffix = Coerce.toVncString(args.nth(1));
            return string.getValue().endsWith(suffix.getValue()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction str_contains = new VncFunction("str/contains?"){
        {
            this.setArgLists("(str/contains? s substr)");
            this.setDoc("True if s contains with substr.");
            this.setExamples("(str/contains? \"abc\"  \"ab\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/contains?", args, 2);
            if (args.nth(0) == Constants.Nil || args.nth(1) == Constants.Nil) {
                return Constants.False;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            VncString text = Coerce.toVncString(args.nth(1));
            return string.getValue().contains(text.getValue()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction str_trim = new VncFunction("str/trim"){
        {
            this.setArgLists("(str/trim s substr)");
            this.setDoc("Trims leading and trailing spaces from s.");
            this.setExamples("(str/trim \" abc  \")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/trim", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(Coerce.toVncString(args.nth(0)).getValue().trim());
        }
    };
    public static VncFunction str_trim_to_nil = new VncFunction("str/trim-to-nil"){
        {
            this.setArgLists("(str/trim-to-nil s substr)");
            this.setDoc("Trims leading and trailing spaces from s. Returns nil if the rewsulting string is empry");
            this.setExamples("(str/trim \"\")", "(str/trim \"    \")", "(str/trim nil)", "(str/trim \" abc   \")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/trim-to-nil", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String str = Coerce.toVncString(args.nth(0)).getValue().trim();
            return str.isEmpty() ? Constants.Nil : new VncString(str);
        }
    };
    public static VncFunction str_index_of = new VncFunction("str/index-of"){
        {
            this.setArgLists("(str/index-of s value)", "(str/index-of s value from-index)");
            this.setDoc("Return index of value (string or char) in s, optionally searching forward from from-index. Return nil if value not found.");
            this.setExamples("(str/index-of \"abcdefabc\" \"ab\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/index-of", args, 2, 3);
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            if (args.size() == 3) {
                int startPos = Coerce.toVncLong(args.nth(2)).getValue().intValue();
                int pos = text.indexOf(searchString, startPos);
                return pos < 0 ? Constants.Nil : new VncLong(pos);
            }
            int pos = text.indexOf(searchString);
            return pos < 0 ? Constants.Nil : new VncLong(pos);
        }
    };
    public static VncFunction str_last_index_of = new VncFunction("str/last-index-of"){
        {
            this.setArgLists("(str/last-index-of s value)", "(str/last-index-of s value from-index)");
            this.setDoc("Return last index of value (string or char) in s, optionally\nsearching backward from from-index. Return nil if value not found.");
            this.setExamples("(str/last-index-of \"abcdefabc\" \"ab\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/last-index-of", args, 2, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            if (args.size() > 2) {
                int startPos = Coerce.toVncLong(args.nth(2)).getValue().intValue();
                int pos = text.lastIndexOf(searchString, startPos);
                return pos < 0 ? Constants.Nil : new VncLong(pos);
            }
            int pos = text.lastIndexOf(searchString);
            return pos < 0 ? Constants.Nil : new VncLong(pos);
        }
    };
    public static VncFunction str_replace_first = new VncFunction("str/replace-first"){
        {
            this.setArgLists("(str/replace-first s search replacement)");
            this.setDoc("Replaces the first occurrance of search in s");
            this.setExamples("(str/replace-first \"abcdefabc\" \"ab\" \"XYZ\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/replace-first", args, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            String replacement = Coerce.toVncString(args.nth(2)).getValue();
            if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null) {
                return args.nth(0);
            }
            int pos = text.indexOf(searchString);
            return pos >= 0 ? new VncString(text.substring(0, pos) + replacement + text.substring(pos + replacement.length())) : args.nth(0);
        }
    };
    public static VncFunction str_replace_last = new VncFunction("str/replace-last"){
        {
            this.setArgLists("(str/replace-last s search replacement)");
            this.setDoc("Replaces the last occurrance of search in s");
            this.setExamples("(str/replace-last \"abcdefabc\" \"ab\" \"XYZ\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/replace-last", args, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            String replacement = Coerce.toVncString(args.nth(2)).getValue();
            if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null) {
                return args.nth(0);
            }
            int pos = text.lastIndexOf(searchString);
            return pos >= 0 ? new VncString(text.substring(0, pos) + replacement + text.substring(pos + replacement.length())) : args.nth(0);
        }
    };
    public static VncFunction str_replace_all = new VncFunction("str/replace-all"){
        {
            this.setArgLists("(str/replace-all s search replacement)");
            this.setDoc("Replaces the all occurrances of search in s");
            this.setExamples("(str/replace-all \"abcdefabc\" \"ab\" \"XYZ\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/replace-all", args, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.nth(0)).getValue();
            String searchString = Coerce.toVncString(args.nth(1)).getValue();
            String replacement = Coerce.toVncString(args.nth(2)).getValue();
            if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null) {
                return args.nth(0);
            }
            String searchText = text;
            int start = 0;
            int end = searchText.indexOf(searchString, start);
            if (end == -1) {
                return args.nth(0);
            }
            int replLength = searchString.length();
            StringBuilder buf = new StringBuilder();
            while (end != -1) {
                buf.append(text, start, end).append(replacement);
                start = end + replLength;
                end = searchText.indexOf(searchString, start);
            }
            buf.append(text, start, text.length());
            return new VncString(buf.toString());
        }
    };
    public static VncFunction str_lower_case = new VncFunction("str/lower-case"){
        {
            this.setArgLists("(str/lower-case s)");
            this.setDoc("Converts s to lowercase");
            this.setExamples("(str/lower-case \"aBcDeF\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/lower-case", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            return new VncString(string.getValue().toLowerCase());
        }
    };
    public static VncFunction str_upper_case = new VncFunction("str/upper-case"){
        {
            this.setArgLists("(str/upper-case s)");
            this.setDoc("Converts s to uppercase");
            this.setExamples("(str/upper-case \"aBcDeF\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/upper-case", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            VncString string = Coerce.toVncString(args.nth(0));
            return new VncString(string.getValue().toUpperCase());
        }
    };
    public static VncFunction str_join = new VncFunction("str/join"){
        {
            this.setArgLists("(str/join coll)", "(str/join separator coll)");
            this.setDoc("Joins all elements in coll separated by an optional separator.");
            this.setExamples("(str/join [1 2 3])", "(str/join \"-\" [1 2 3])");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/join", args, 1, 2);
            VncList coll = Coerce.toVncList(args.last());
            VncString delim = args.size() == 2 ? Coerce.toVncString(args.nth(0)) : new VncString("");
            return new VncString(coll.size() > 0 ? coll.getList().stream().map(v -> Types.isVncString(v) ? ((VncString)v).getValue() : v.toString()).collect(Collectors.joining(delim.getValue())) : "");
        }
    };
    public static VncFunction str_subs = new VncFunction("str/subs"){
        {
            this.setArgLists("(str/subs s start)", "(str/subs s start end)");
            this.setDoc("Returns the substring of s beginning at start inclusive, and ending at end (defaults to length of string), exclusive.");
            this.setExamples("(str/subs \"abcdef\" 2)", "(str/subs \"abcdef\" 2 5)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/subs", args, 2, 3);
            VncString string = Coerce.toVncString(args.nth(0));
            VncLong from = Coerce.toVncLong(args.nth(1));
            VncLong to = args.size() > 2 ? (VncLong)args.nth(2) : null;
            return new VncString(to == null ? string.getValue().substring(from.getValue().intValue()) : string.getValue().substring(from.getValue().intValue(), to.getValue().intValue()));
        }
    };
    public static VncFunction str_split = new VncFunction("str/split"){
        {
            this.setArgLists("(str/split s regex)");
            this.setDoc("Splits string on a regular expression.");
            this.setExamples("(str/split \"abc , def , ghi\" \"[ *],[ *]\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/split", args, 2);
            VncString string = Coerce.toVncString(args.nth(0));
            VncString regex = Coerce.toVncString(args.nth(1));
            return new VncList(Arrays.asList(string.getValue().split(regex.getValue())).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
        }
    };
    public static VncFunction str_split_lines = new VncFunction("str/split-lines"){
        {
            this.setArgLists("(str/split-lines s)");
            this.setDoc("Splits s into lines.");
            this.setExamples("(str/split-lines \"line1\nline2\nline3\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/split-lines", args, 1);
            return args.nth(0) == Constants.Nil ? new VncList(new VncVal[0]) : new VncList(StringUtil.splitIntoLines(Coerce.toVncString(args.nth(0)).getValue()).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
        }
    };
    public static VncFunction str_format = new VncFunction("str/format"){
        {
            this.setArgLists("(str/format format args*)");
            this.setDoc("Returns a formatted string using the specified format string and arguments.");
            this.setExamples("(str/format \"%s: %d\" \"abc\" 100)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncString fmt = (VncString)args.nth(0);
            List fmtArgs = args.slice(1).getList().stream().map(v -> JavaInteropUtil.convertToJavaObject(v)).collect(Collectors.toList());
            return new VncString(String.format(fmt.getValue(), fmtArgs.toArray()));
        }
    };
    public static VncFunction str_quote = new VncFunction("str/quote"){
        {
            this.setArgLists("(str/quote str q)", "(str/quote str start end)");
            this.setDoc("Quotes a string.");
            this.setExamples("(str/quote \"abc\" \"-\")", "(str/quote \"abc\" \"<\" \">\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/quote", args, 2, 3);
            String s = Coerce.toVncString(args.nth(0)).getValue();
            String start = Coerce.toVncString(args.nth(1)).getValue();
            String end = args.size() == 2 ? start : Coerce.toVncString(args.nth(2)).getValue();
            return new VncString(start + s + end);
        }
    };
    public static VncFunction str_truncate = new VncFunction("str/truncate"){
        {
            this.setArgLists("(str/truncate s maxlen marker)");
            this.setDoc("Truncates a string to the max lenght maxlen and adds the marker to the end if the string needs to be truncated");
            this.setExamples("(str/truncate \"abcdefghij\" 20 \"...\")", "(str/truncate \"abcdefghij\" 9 \"...\")", "(str/truncate \"abcdefghij\" 4 \"...\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/truncate", args, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.truncate(Coerce.toVncString(args.nth(0)).getValue(), Coerce.toVncLong(args.nth(1)).getValue().intValue(), Coerce.toVncString(args.nth(2)).getValue()));
        }
    };
    public static VncFunction str_strip_start = new VncFunction("str/strip-start"){
        {
            this.setArgLists("(str/strip-start s substr)");
            this.setDoc("Removes a substr only if it is at the beginning of a s, otherwise returns s.");
            this.setExamples("(str/strip-start \"abcdef\" \"abc\")", "(str/strip-start \"abcdef\" \"def\")");
        }

        @Override
        public VncVal apply(VncList args) {
            String substr;
            FunctionsUtil.assertArity("str/strip-start", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.nth(0)).getValue();
            return new VncString(s.startsWith(substr = Coerce.toVncString(args.nth(1)).getValue()) ? s.substring(substr.length()) : s);
        }
    };
    public static VncFunction str_strip_end = new VncFunction("str/strip-end"){
        {
            this.setArgLists("(str/strip-end s substr)");
            this.setDoc("Removes a substr only if it is at the end of a s, otherwise returns s.");
            this.setExamples("(str/strip-end \"abcdef\" \"def\")", "(str/strip-end \"abcdef\" \"abc\")");
        }

        @Override
        public VncVal apply(VncList args) {
            String substr;
            FunctionsUtil.assertArity("str/strip-end", args, 2);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.nth(0)).getValue();
            return new VncString(s.endsWith(substr = Coerce.toVncString(args.nth(1)).getValue()) ? s.substring(0, s.length() - substr.length()) : s);
        }
    };
    public static VncFunction str_strip_indent = new VncFunction("str/strip-indent"){
        {
            this.setArgLists("(str/strip-indent s)");
            this.setDoc("Strip the indent of a multi-line string. The first line's leading whitespaces define the indent.");
            this.setExamples("(str/strip-indent \"  line1\n    line2\n    line3\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/strip-indent", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.stripIndent(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction str_strip_margin = new VncFunction("str/strip-margin"){
        {
            this.setArgLists("(str/strip-margin s)");
            this.setDoc("Strips leading whitespaces upto and including the margin '|' from each line in a multi-line string.");
            this.setExamples("(str/strip-margin \"line1\n  |  line2\n  |  line3\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/strip-margin", args, 1);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.stripMargin(Coerce.toVncString(args.first()).getValue(), '|'));
        }
    };
    public static VncFunction str_repeat = new VncFunction("str/repeat"){
        {
            this.setArgLists("(str/repeat s n)", "(str/repeat s n sep)");
            this.setDoc("Repeats s n times with an optional separator.");
            this.setExamples("(str/repeat \"abc\" 0)", "(str/repeat \"abc\" 3)", "(str/repeat \"abc\" 3 \"-\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/repeat", args, 2, 3);
            if (args.nth(0) == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.nth(0)).getValue();
            int times = Coerce.toVncLong(args.nth(1)).getValue().intValue();
            String sep = args.size() == 3 ? Coerce.toVncString(args.nth(2)).getValue() : "";
            StringBuilder sb = new StringBuilder();
            for (int ii = 0; ii < times; ++ii) {
                if (ii > 0) {
                    sb.append(sep);
                }
                sb.append(s);
            }
            return new VncString(sb.toString());
        }
    };
    public static VncFunction version = new VncFunction("version"){
        {
            this.setArgLists("(version)");
            this.setDoc("Returns the version.");
            this.setExamples("(version )");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("version", args, 0);
            return new VncString("0.9.1");
        }
    };
    public static VncFunction gensym = new VncFunction("gensym"){
        {
            this.setArgLists("(gensym)", "(gensym prefix)");
            this.setDoc("Generates a symbol.");
            this.setExamples("(gensym )", "(gensym \"prefix_\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("gensym", args, 0, 1);
            String prefix = args.isEmpty() ? "G__" : (Types.isVncSymbol(args.nth(0)) ? Coerce.toVncSymbol(args.nth(0)).getName() : Coerce.toVncString(args.nth(0)).getValue());
            return new VncSymbol(prefix + String.valueOf(gensymValue.incrementAndGet()));
        }
    };
    public static VncFunction uuid = new VncFunction("uuid"){
        {
            this.setArgLists("(uuid)");
            this.setDoc("Generates a UUID.");
            this.setExamples("(uuid )");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("uuid", args, 0);
            return new VncString(UUID.randomUUID().toString());
        }
    };
    public static VncFunction current_time_millis = new VncFunction("current-time-millis"){
        {
            this.setArgLists("(current-time-millis)");
            this.setDoc("Returns the current time in milliseconds.");
            this.setExamples("(current-time-millis)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("current-time-millis", args, 0);
            return new VncLong(System.currentTimeMillis());
        }
    };
    public static VncFunction nano_time = new VncFunction("nano-time"){
        {
            this.setArgLists("(nano-time)");
            this.setDoc("Returns the current value of the running Java Virtual Machine's high-resolution time source, in nanoseconds.");
            this.setExamples("(nano-time)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nano-time", args, 0);
            return new VncLong(System.nanoTime());
        }
    };
    public static VncFunction name = new VncFunction("name"){
        {
            this.setArgLists("(name x)");
            this.setDoc("Returns the name String of a string, symbol or keyword.");
            this.setExamples("(name :x)", "(name 'x)", "(name \"x\")");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("name", args, 1);
            VncVal arg = args.first();
            if (Types.isVncKeyword(arg)) {
                return new VncString(((VncKeyword)arg).getValue());
            }
            if (Types.isVncSymbol(arg)) {
                return new VncString(((VncSymbol)arg).getName());
            }
            if (Types.isVncString(arg)) {
                return arg;
            }
            throw new VncException(String.format("Function 'name' does not allow %s as parameter. %s", Types.getClassName(arg), ErrorMessage.buildErrLocation(args)));
        }
    };
    public static VncFunction type = new VncFunction("type"){
        {
            this.setArgLists("(type x)");
            this.setDoc("Returns the type of x.");
            this.setExamples("(type 5)", "(type (. :java.time.ZonedDateTime :now))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("type", args, 1);
            return Types.getClassName(args.first());
        }
    };
    public static VncFunction sleep = new VncFunction("sleep"){
        {
            this.setArgLists("(sleep n)");
            this.setDoc("Sleep for n milliseconds.");
            this.setExamples("(sleep 30)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sleep", args, 1);
            try {
                Thread.sleep(Coerce.toVncLong(args.first()).getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Constants.Nil;
        }
    };
    public static VncFunction os_Q = new VncFunction("os?"){
        {
            this.setArgLists("(os? type)");
            this.setDoc("Returns true if the OS id of the type otherwise false. Type is one of :windows, :macosx, or :linux");
            this.setExamples("(os? :mac-osx)", "(os? :windows)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("os?", args, 1);
            String type = Coerce.toVncKeyword(args.first()).getValue();
            String osName = System.getProperty("os.name");
            switch (type) {
                case "windows": {
                    return osName.startsWith("Windows") ? Constants.True : Constants.False;
                }
                case "mac-osx": {
                    return osName.startsWith("Mac OS X") ? Constants.True : Constants.False;
                }
                case "linux": {
                    return osName.startsWith("LINUX") ? Constants.True : Constants.False;
                }
            }
            return Constants.False;
        }
    };
    public static VncFunction new_thread_local = new VncFunction("thread-local"){
        {
            this.setArgLists("(thread-local)");
            this.setDoc("Creates a new thread-local accessor");
            this.setExamples("(thread-local :a 1 :b 2)", "(thread-local { :a 1 :b 2 })", "(do \n   (thread-local-clear) \n   (assoc (thread-local) :a 1 :b 2) \n   (dissoc (thread-local) :a) \n   (get (thread-local) :b 100) \n)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.nth(0))) {
                return new VncThreadLocal(((VncMap)args.nth(0)).getMap());
            }
            return new VncThreadLocal(args);
        }
    };
    public static VncFunction thread_local_Q = new VncFunction("thread-local?"){
        {
            this.setArgLists("(thread-local? x)");
            this.setDoc("Returns true if x is a thread-local, otherwise false");
            this.setExamples("(do\n   (def x (thread-local))\n   (thread-local? x))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-local?", args, 1);
            return Types.isVncThreadLocal(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction thread_local_clear = new VncFunction("thread-local-clear"){
        {
            this.setArgLists("(thread-local-clear)");
            this.setDoc("Removes all thread local vars");
            this.setExamples("(thread-local-clear)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-local-clear", args, 0);
            new VncThreadLocal().clear();
            return this;
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("doc", (VncVal)doc).put("throw", (VncVal)throw_ex).put("nil?", (VncVal)nil_Q).put("some?", (VncVal)some_Q).put("true?", (VncVal)true_Q).put("false?", (VncVal)false_Q).put("boolean?", (VncVal)boolean_Q).put("long?", (VncVal)long_Q).put("double?", (VncVal)double_Q).put("decimal?", (VncVal)decimal_Q).put("number?", (VncVal)number_Q).put("bytebuf?", (VncVal)bytebuf_Q).put("string?", (VncVal)string_Q).put("symbol", (VncVal)symbol).put("symbol?", (VncVal)symbol_Q).put("keyword", (VncVal)keyword).put("keyword?", (VncVal)keyword_Q).put("fn?", (VncVal)fn_Q).put("macro?", (VncVal)macro_Q).put("pr-str", (VncVal)pr_str).put("str", (VncVal)str).put("readline", (VncVal)readline).put("read-string", (VncVal)read_string).put("==", (VncVal)equal_Q).put("!=", (VncVal)not_equal_Q).put("<", (VncVal)lt).put("<=", (VncVal)lte).put(">", (VncVal)gt).put(">=", (VncVal)gte).put("match", (VncVal)match_Q).put("match-not", (VncVal)match_not_Q).put("dec/scale", (VncVal)decimalScale).put("dec/add", (VncVal)decimalAdd).put("dec/sub", (VncVal)decimalSubtract).put("dec/mul", (VncVal)decimalMultiply).put("dec/div", (VncVal)decimalDivide).put("+", (VncVal)add).put("-", (VncVal)subtract).put("*", (VncVal)multiply).put("/", (VncVal)divide).put("mod", (VncVal)modulo).put("inc", (VncVal)inc).put("dec", (VncVal)dec).put("abs", (VncVal)abs).put("min", (VncVal)min).put("max", (VncVal)max).put("boolean", (VncVal)boolean_cast).put("long", (VncVal)long_cast).put("double", (VncVal)double_cast).put("decimal", (VncVal)decimal_cast).put("bytebuf", (VncVal)bytebuf_cast).put("bytebuf-to-string", (VncVal)bytebuf_to_string).put("bytebuf-from-string", (VncVal)bytebuf_from_string).put("zero?", (VncVal)zero_Q).put("pos?", (VncVal)pos_Q).put("neg?", (VncVal)neg_Q).put("even?", (VncVal)even_Q).put("odd?", (VncVal)odd_Q).put("rand-long", (VncVal)rand_long).put("rand-double", (VncVal)rand_double).put("rand-gaussian", (VncVal)rand_gaussian).put("list", (VncVal)new_list).put("list?", (VncVal)list_Q).put("vector", (VncVal)new_vector).put("vector?", (VncVal)vector_Q).put("map?", (VncVal)map_Q).put("hash-map?", (VncVal)hash_map_Q).put("ordered-map?", (VncVal)ordered_map_Q).put("sorted-map?", (VncVal)sorted_map_Q).put("hash-map", (VncVal)new_hash_map).put("ordered-map", (VncVal)new_ordered_map).put("sorted-map", (VncVal)new_sorted_map).put("assoc", (VncVal)assoc).put("assoc-in", (VncVal)assoc_in).put("dissoc", (VncVal)dissoc).put("contains?", (VncVal)contains_Q).put("find", (VncVal)find).put("get", (VncVal)get).put("get-in", (VncVal)get_in).put("key", (VncVal)key).put("keys", (VncVal)keys).put("val", (VncVal)val).put("vals", (VncVal)vals).put("update", (VncVal)update).put("update!", (VncVal)update_BANG).put("subvec", (VncVal)subvec).put("bytebuf-sub", (VncVal)bytebuf_sub).put("empty", (VncVal)empty).put("set?", (VncVal)set_Q).put("set", (VncVal)new_set).put("difference", (VncVal)difference).put("union", (VncVal)union).put("intersection", (VncVal)intersection).put("split-with", (VncVal)split_with).put("into", (VncVal)into).put("sequential?", (VncVal)sequential_Q).put("coll?", (VncVal)coll_Q).put("cons", (VncVal)cons).put("co", (VncVal)cons).put("concat", (VncVal)concat).put("interpose", (VncVal)interpose).put("interleave", (VncVal)interleave).put("mapcat", (VncVal)mapcat).put("keep", (VncVal)keep).put("docoll", (VncVal)docoll).put("nth", (VncVal)nth).put("first", (VncVal)first).put("second", (VncVal)second).put("last", (VncVal)last).put("rest", (VncVal)rest).put("nfirst", (VncVal)nfirst).put("nlast", (VncVal)nlast).put("empty-to-nil", (VncVal)emptyToNil).put("pop", (VncVal)pop).put("peek", (VncVal)peek).put("empty?", (VncVal)empty_Q).put("not-empty?", (VncVal)not_empty_Q).put("every?", (VncVal)every_Q).put("any?", (VncVal)any_Q).put("count", (VncVal)count).put("apply", (VncVal)apply).put("comp", (VncVal)comp).put("partial", (VncVal)partial).put("map", (VncVal)map).put("mapv", (VncVal)mapv).put("filter", (VncVal)filter).put("distinct", (VncVal)distinct).put("dedupe", (VncVal)dedupe).put("partition", (VncVal)partition).put("remove", (VncVal)remove).put("reduce", (VncVal)reduce).put("reduce-kv", (VncVal)reduce_kv).put("take", (VncVal)take).put("take-while", (VncVal)take_while).put("drop", (VncVal)drop).put("drop-while", (VncVal)drop_while).put("flatten", (VncVal)flatten).put("reverse", (VncVal)reverse).put("group-by", (VncVal)group_by).put("sort", (VncVal)sort).put("sort-by", (VncVal)sort_by).put("merge", (VncVal)merge).put("conj", (VncVal)conj).put("seq", (VncVal)seq).put("range", (VncVal)range).put("repeat", (VncVal)repeat).put("meta", (VncVal)meta).put("with-meta", (VncVal)with_meta).put("vary-meta", (VncVal)vary_meta).put("atom", (VncVal)new_atom).put("atom?", (VncVal)atom_Q).put("deref", (VncVal)deref).put("reset!", (VncVal)reset_BANG).put("swap!", (VncVal)swap_BANG).put("compare-and-set!", (VncVal)compare_and_set_BANG).put("coalesce", (VncVal)coalesce).put("gensym", (VncVal)gensym).put("uuid", (VncVal)uuid).put("current-time-millis", (VncVal)current_time_millis).put("nano-time", (VncVal)nano_time).put("sleep", (VncVal)sleep).put("os?", (VncVal)os_Q).put("version", (VncVal)version).put("name", (VncVal)name).put("type", (VncVal)type).put("thread-local", (VncVal)new_thread_local).put("thread-local?", (VncVal)thread_local_Q).put("thread-local-clear", (VncVal)thread_local_clear).put("str/blank?", (VncVal)str_blank).put("str/starts-with?", (VncVal)str_starts_with).put("str/ends-with?", (VncVal)str_ends_with).put("str/contains?", (VncVal)str_contains).put("str/trim", (VncVal)str_trim).put("str/trim-to-nil", (VncVal)str_trim_to_nil).put("str/index-of", (VncVal)str_index_of).put("str/last-index-of", (VncVal)str_last_index_of).put("str/replace-first", (VncVal)str_replace_first).put("str/replace-last", (VncVal)str_replace_last).put("str/replace-all", (VncVal)str_replace_all).put("str/lower-case", (VncVal)str_lower_case).put("str/upper-case", (VncVal)str_upper_case).put("str/join", (VncVal)str_join).put("str/subs", (VncVal)str_subs).put("str/split", (VncVal)str_split).put("str/split-lines", (VncVal)str_split_lines).put("str/format", (VncVal)str_format).put("str/quote", (VncVal)str_quote).put("str/truncate", (VncVal)str_truncate).put("str/strip-start", (VncVal)str_strip_start).put("str/strip-end", (VncVal)str_strip_end).put("str/strip-indent", (VncVal)str_strip_indent).put("str/strip-margin", (VncVal)str_strip_margin).put("str/repeat", (VncVal)str_repeat).put("class", (VncVal)className).put("load-core-module", (VncVal)loadCoreModule).put("load-classpath-venice", (VncVal)loadClasspathVenice).toMap();
    private static final AtomicLong gensymValue = new AtomicLong(0L);
    private static final Random random = new Random();

    public static boolean list_Q(VncVal mv) {
        return mv.getClass().equals(VncList.class);
    }

    public static boolean vector_Q(VncVal mv) {
        return mv.getClass().equals(VncVector.class);
    }

    private static void flatten(VncVal value, List<VncVal> result) {
        if (Types.isVncList(value)) {
            ((VncList)value).getList().forEach(v -> CoreFunctions.flatten(v, result));
        } else if (Types.isVncHashMap(value)) {
            ((VncHashMap)value).entries().forEach(e -> {
                result.add((VncVal)e.getKey());
                CoreFunctions.flatten((VncVal)e.getValue(), result);
            });
        } else {
            result.add(value);
        }
    }
}

