/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.impl.functions.CoreMacroDefs;
import com.github.jlangch.venice.impl.functions.Functions;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.MacroDef;
import java.util.stream.Collectors;

public class Doc {
    public static String getDoc(String name) {
        VncFunction func = Functions.getFunction(name);
        if (func != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(func.getArgLists().getList().stream().map(s -> Doc.toString(s)).collect(Collectors.joining(", ")));
            sb.append("\n");
            sb.append(Doc.toString(func.getDoc()));
            return sb.toString();
        }
        MacroDef macro = CoreMacroDefs.getMacroDef(name);
        if (macro != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(macro.getSignatures().stream().collect(Collectors.joining(", ")));
            sb.append("\n");
            sb.append(macro.getDescription());
            return sb.toString();
        }
        return "<no documentation available>";
    }

    private static String toString(VncVal val) {
        return val == Constants.Nil ? "" : ((VncString)val).getValue();
    }
}

