/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaObject;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.StreamUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class ShellFunctions {
    public static VncFunction sh = new VncFunction("sh"){
        {
            this.setArgLists("(sh & args)");
            this.setDoc("Passes the given strings to Runtime.exec() to launch a sub-process.\n\n Options are\n  :in      may be given followed by input source as InputStream, Reader, \n           File, ByteBuf, or String, to be fed to the sub-process's stdin.\n  :in-enc  option may be given followed by a String, used as a character\n           encoding name (for example \"UTF-8\" or \"ISO-8859-1\") to\n           convert the input string specified by the :in option to the\n           sub-process's stdin.  Defaults to UTF-8.\n           If the :in option provides a byte array, then the bytes are passed\n           unencoded, and this option is ignored.\n  :out-enc option may be given followed by :bytes or a String. If a\n           String is given, it will be used as a character encoding\n           name (for example \"UTF-8\" or \"ISO-8859-1\") to convert\n           the sub-process's stdout to a String which is returned.\n           If :bytes is given, the sub-process's stdout will be stored\n           in a Bytebuf and returned.  Defaults to UTF-8.\n  :env     override the process env with a map.\n  :dir     override the process dir with a String or java.io.File.\n\nYou can bind :env or :dir for multiple operations using with-sh-env\nand with-sh-dir.\n\n sh returns a map of\n  :exit => sub-process's exit code\n  :out  => sub-process's stdout (as Bytebuf or String)\n  :err  => sub-process's stderr (String via platform default encoding)");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().checkBlackListedVeniceFunction("sh", args);
            FunctionsUtil.assertMinArity("sh", args, 1);
            VncVector v = ShellFunctions.parseArgs(args);
            VncList cmd = Coerce.toVncList(v.first());
            VncMap opts = Coerce.toVncMap(v.second());
            ExecutorService executor = Executors.newFixedThreadPool(3);
            try {
                VncVal vncVal = ShellFunctions.apply_(cmd, opts, executor);
                return vncVal;
            }
            finally {
                executor.shutdownNow();
            }
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("sh", (VncVal)sh).toMap();

    /*
     * Exception decompiling
     */
    private static VncVal apply_(VncList cmd, VncMap opts, ExecutorService executor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File toFile(VncVal dir) {
        Object delegate;
        if (dir == Constants.Nil) {
            return null;
        }
        if (Types.isVncString(dir)) {
            return new File(((VncString)dir).getValue());
        }
        if (Types.isVncJavaObject(dir) && (delegate = ((VncJavaObject)dir).getDelegate()) instanceof File) {
            return (File)delegate;
        }
        return null;
    }

    private static String[] toStringArray(VncList list) {
        return list.getList().stream().map(it -> (VncVal)CoreFunctions.name.apply(new VncList((VncVal)it))).map(it -> ((VncString)it).getValue()).collect(Collectors.toList()).toArray(new String[0]);
    }

    private static String[] toEnvStrings(VncVal envMap) {
        if (envMap == Constants.Nil) {
            return null;
        }
        return ((VncMap)envMap).entries().stream().map(e -> String.format("%s=%s", CoreFunctions.name.apply(new VncList((VncVal)e.getKey())), ((VncVal)e.getValue()).toString())).collect(Collectors.toList()).toArray(new String[0]);
    }

    private static VncVector parseArgs(VncList args) {
        VncThreadLocal th = new VncThreadLocal();
        VncHashMap defaultOptions = new VncHashMap(new VncKeyword(":out-enc"), new VncString("UTF-8"), new VncKeyword(":in-enc"), new VncString("UTF-8"), new VncKeyword(":dir"), th.get(":*sh-dir*"));
        VncMap defaultEnv = (VncMap)th.get(":*sh-env*", (VncVal)new VncHashMap(new VncVal[0]));
        VncVector v = Coerce.toVncVector((VncVal)CoreFunctions.split_with.apply(new VncList(CoreFunctions.string_Q, args)));
        VncList cmd = Coerce.toVncList(v.first());
        VncHashMap sh_opts = new VncHashMap((VncList)v.second());
        VncMap opts = (VncMap)CoreFunctions.merge.apply(new VncList(defaultOptions, sh_opts));
        opts = opts.assoc(new VncKeyword(":env"), (VncVal)CoreFunctions.merge.apply(new VncList(defaultEnv, ((VncMap)sh_opts).get(new VncKeyword(":env")))));
        return new VncVector(cmd, opts);
    }

    private static String getEncoding(VncVal enc) {
        if (enc == Constants.Nil) {
            return Charset.defaultCharset().name();
        }
        return ((VncString)CoreFunctions.name.apply(new VncList(enc))).getValue();
    }

    private static /* synthetic */ VncVal lambda$apply_$4(InputStream stderr) throws Exception {
        return new VncString(StreamUtil.copyIStoString(stderr, null));
    }

    private static /* synthetic */ VncVal lambda$apply_$3(String enc, InputStream stdout) throws Exception {
        return "byte".equals(enc) ? new VncByteBuffer(StreamUtil.copyIStoByteArray(stdout)) : new VncString(StreamUtil.copyIStoString(stdout, enc));
    }

    private static /* synthetic */ Object lambda$apply_$2(VncVal in, Process proc) throws Exception {
        StreamUtil.copyFileToOS((File)((VncJavaObject)in).getDelegate(), proc.getOutputStream());
        return null;
    }

    private static /* synthetic */ Object lambda$apply_$1(VncVal in, Process proc) throws Exception {
        StreamUtil.copyByteArrayToOS(((VncByteBuffer)in).getValue().array(), proc.getOutputStream());
        return null;
    }

    private static /* synthetic */ Object lambda$apply_$0(VncVal in, Process proc, VncVal inEnc) throws Exception {
        StreamUtil.copyStringToOS(((VncString)in).getValue(), proc.getOutputStream(), ShellFunctions.getEncoding(inEnc));
        return null;
    }
}

