/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.impl.functions.IOFnBlacklisted;
import com.github.jlangch.venice.impl.javainterop.SandboxRuleCompiler;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.Tuple2;
import com.github.jlangch.venice.javainterop.SandboxRules;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CompiledSandboxRules {
    private final ConcurrentHashMap<Class<?>, String> whiteListedClasses = new ConcurrentHashMap();
    private final ConcurrentHashMap<Tuple2<Class<?>, String>, String> whiteListedMethods = new ConcurrentHashMap();
    private final List<Pattern> whiteListClassPatterns;
    private final List<Pattern> whiteListMethodPatterns;
    private final Set<String> blackListVeniceFunctions;

    private CompiledSandboxRules(List<Pattern> whiteListClassPatterns, List<Pattern> whiteListMethodPatterns, Set<String> blackListVeniceFunctions) {
        this.whiteListClassPatterns = whiteListClassPatterns == null ? Collections.emptyList() : whiteListClassPatterns;
        this.whiteListMethodPatterns = whiteListMethodPatterns == null ? Collections.emptyList() : whiteListMethodPatterns;
        this.blackListVeniceFunctions = blackListVeniceFunctions == null ? Collections.emptySet() : blackListVeniceFunctions;
    }

    public static CompiledSandboxRules compile(SandboxRules whiteList) {
        if (whiteList == null) {
            return new CompiledSandboxRules(null, null, null);
        }
        List filtered = whiteList.getRules().stream().filter(s -> s != null).map(s -> s.trim()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        return new CompiledSandboxRules(filtered.stream().filter(s -> !s.startsWith("blacklist:venice:")).map(s -> {
            int pos = s.indexOf(58);
            return pos < 0 ? s : s.substring(0, pos);
        }).map(s -> SandboxRuleCompiler.compile(s)).collect(Collectors.toList()), filtered.stream().filter(s -> !s.startsWith("blacklist:venice:")).filter(s -> s.indexOf(58) >= 0).map(s -> SandboxRuleCompiler.compile(s)).collect(Collectors.toList()), filtered.stream().filter(s -> s.startsWith("blacklist:venice:")).map(s -> s.substring("blacklist:venice:".length())).map(s -> s.equals("*io*") ? IOFnBlacklisted.getAllIoFunctions() : CompiledSandboxRules.toSet(s)).flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    public boolean isWhiteListed(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isArray() || clazz.isPrimitive()) {
            return true;
        }
        if (this.whiteListedClasses.containsKey(clazz)) {
            return true;
        }
        String className = clazz.getName();
        boolean matches = this.whiteListClassPatterns.stream().anyMatch(p -> p.matcher(className).matches());
        if (matches) {
            this.whiteListedClasses.put(clazz, "");
            return true;
        }
        return false;
    }

    public boolean isWhiteListed(Class<?> clazz, String accessor) {
        if (clazz == null || accessor == null) {
            return false;
        }
        if (!this.isWhiteListed(clazz)) {
            return false;
        }
        if (clazz.isArray()) {
            return this.isWhiteListed(clazz.getComponentType());
        }
        Tuple2 tuple = new Tuple2(clazz, accessor);
        if (this.whiteListedMethods.containsKey(tuple)) {
            return true;
        }
        String path = clazz.getName() + ":" + accessor;
        boolean matches = this.whiteListMethodPatterns.stream().anyMatch(p -> p.matcher(path).matches());
        if (matches) {
            this.whiteListedMethods.put(tuple, "");
            return true;
        }
        return false;
    }

    public boolean isBlackListedVeniceFunction(String funcName, VncList args) {
        return this.blackListVeniceFunctions.contains(funcName);
    }

    private static Set<String> toSet(String ... args) {
        return new HashSet<String>(Arrays.asList(args));
    }
}

