/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import java.math.BigDecimal;

public class VncDouble
extends VncVal {
    private final Double value;

    public VncDouble(Double v) {
        this.value = v;
    }

    public VncDouble(Float v) {
        this.value = v.doubleValue();
    }

    @Override
    public VncDouble copy() {
        VncDouble v = new VncDouble(this.value);
        v.setMeta(this.getMeta());
        return v;
    }

    public Double getValue() {
        return this.value;
    }

    public VncDouble inc() {
        return new VncDouble(this.value + 1.0);
    }

    public VncDouble dec() {
        return new VncDouble(this.value - 1.0);
    }

    public VncConstant lt(VncVal other) {
        if (other instanceof VncLong) {
            return this.value < (double)((VncLong)other).getValue().longValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncDouble) {
            return this.value < ((VncDouble)other).getValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncBigDecimal) {
            return new BigDecimal(this.value).compareTo(((VncBigDecimal)other).getValue()) < 0 ? Constants.True : Constants.False;
        }
        throw new VncException(String.format("Function '<' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncConstant lte(VncVal other) {
        if (other instanceof VncLong) {
            return this.value <= (double)((VncLong)other).getValue().longValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncDouble) {
            return this.value <= ((VncDouble)other).getValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncBigDecimal) {
            return new BigDecimal(this.value).compareTo(((VncBigDecimal)other).getValue()) <= 0 ? Constants.True : Constants.False;
        }
        throw new VncException(String.format("Function '<=' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncConstant gt(VncVal other) {
        if (other instanceof VncLong) {
            return this.value > (double)((VncLong)other).getValue().longValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncDouble) {
            return this.value > ((VncDouble)other).getValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncBigDecimal) {
            return new BigDecimal(this.value).compareTo(((VncBigDecimal)other).getValue()) > 0 ? Constants.True : Constants.False;
        }
        throw new VncException(String.format("Function '>' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncConstant gte(VncVal other) {
        if (other instanceof VncLong) {
            return this.value >= (double)((VncLong)other).getValue().longValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncDouble) {
            return this.value >= ((VncDouble)other).getValue() ? Constants.True : Constants.False;
        }
        if (other instanceof VncBigDecimal) {
            return new BigDecimal(this.value).compareTo(((VncBigDecimal)other).getValue()) >= 0 ? Constants.True : Constants.False;
        }
        throw new VncException(String.format("Function '>=' with operand 1 of type %s does not allow %s as operand 2", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
    }

    public VncLong toLong() {
        return new VncLong(this.value.longValue());
    }

    public VncBigDecimal toDecimal() {
        return new VncBigDecimal(new BigDecimal(this.value));
    }

    @Override
    public int compareTo(VncVal o) {
        return Types.isVncDouble(o) ? this.getValue().compareTo(((VncDouble)o).getValue()) : 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncDouble other = (VncDouble)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString();
    }
}

